# 
# The Sculpt (Voxels) room toolset definition.
# 
# Insert commands and conditions within the main(){...} function
# use 
#   tools_item("IdentifierOfTheTool");
# to add new item into the toolset.
# use 
#   tools_section("Section name");
# to add tools section.
# The command
#   default_tool("IdentifierOfTheTool");
# defines the tool used by default in the room.
# 
# 
import coat
from cTemplates.Structs import *

proxy = False
vox = False

def SetType(Proxy, Vox):
    global proxy
    global vox
    proxy = Proxy
    vox = Vox

@d_template
def InstallCurvesExtensions():
   coat.tools_item("[extension]VoxLayer") # Vox Layer
   coat.tools_item("[extension]CurvesLayer") # Coat
   coat.tools_item("[extension]TubeOnCurve") # Tube/Array
   coat.tools_item("[extension]BendVolume") # Bend Volume
   coat.tools_item("[extension]SweptSurface") # Swep along Guide
   coat.tools_item("[extension]RotateSurface") # Rotate Surface
   coat.tools_item("[extension]SurfacePrism") # Polyhedron
   coat.tools_item("[extension]SurfaceSwept2") # Swept 2 Guide
   coat.tools_item("[extension]SurfaceSwept2Gener") # Swept 2 Gener
   coat.tools_item("[extension]SurfaceSweptNGener") # Swept N Gener


@d_tools_section("Layers")
def Layers():
      coat.tools_item("[extension]MagnifyLayers")
      coat.tools_item("[extension]EraseLayers")

@d_tools_section("Clay/Draw")
def BaseSurfaceTools():
   coat.tools_item("[extension]SCULP_SCLAY") # Clay
   coat.tools_item("[extension]SCULPT_DRAW")
   coat.tools_item("{FLT}[extension]SCULP_PLANE") # Flatten
   coat.tools_item("{FLT}[extension]SCULP_PLANE2") # Chisel
   coat.tools_item("{FLT}[extension]FlatPolish")
   coat.tools_item("{FLT}[extension]trim_adaptive")
   coat.tools_item("{FILL}[extension]SCULP_SFILL") # Fill
   coat.tools_item("{FILL}[extension]SCULP_SFILL2") # Lute
   coat.tools_item("[extension]BUILDUP") # Buildup
   coat.tools_item("[extension]SCULP_SFEXTRUDE0") # Extrude
   coat.tools_item("[extension]PickVDM")
   coat.tools_item("[extension]SCULP_INFLATE") # Expand
   # tools_item("[VOX_SCULPT_TOOL]SCULP_SFEXTRUDE");Gum
   coat.tools_item("[extension]SCULP_SFEXTRUDEA") # Absolute
   coat.tools_item("{RAPID}[extension]SCULPT_RAPID") # Rapid
   coat.tools_item("{RAPID}[extension]RAPID2") # Rapid2
   coat.tools_item("{RAPID}[extension]SCULPT_CLAWS") # Scratches
   # tools_item("{RAPID}[VOX_SCULPT_TOOL]CLAWS2");Scratches2
   coat.tools_item("{RAPID}[extension]SCULPT_MUD") # Mud
   # tools_item("{RAPID}[VOX_SCULPT_TOOL]MUD2");Mud2
   coat.tools_item("{PINCH}[extension]SCULPT_PINCH") # Pinch
   coat.tools_item("{PINCH}[extension]RoofPinch")
   coat.tools_item("{PINCH}[extension]SmartPinch")
   coat.tools_item("[extension]SCULP_FOLLOW")
   if vox:
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_SMOOTH1") # Smooth
   else: 
      coat.tools_item("{RELAX}[VOX_SCULPT_TOOL]SCULPT_SMOOTH") # Smooth
   coat.tools_item("{RELAX}[extension]SuperRelax")
   coat.tools_item("{RELAX}[extension]smooth_convex")
   coat.tools_item("{RELAX}[extension]smooth_concave")
   coat.tools_item("{RELAX}[extension]TangentRelax")
   coat.tools_item("[extension]Sharpen")
   coat.tools_item("{MASK}[VOX_SCULPT_TOOL]SCULP_SFREEZE") # Freeze
   coat.tools_item("{MASK}[VOX_SCULPT_TOOL]SurfHide") # Surface Hide
   if not proxy:
      coat.tools_item("[extension]SnakeClay") # Snake Clay
      coat.tools_item("[extension]CopyClay") # Copy Clay


@d_tools_section("Paint")
def PaintTools():
   coat.tools_item("[StdPen]StdPen")
   coat.tools_item("[Airbrush]Airbrush")
   coat.tools_item("[ChangeColor]ChangeColor")
   coat.tools_item("[SmudgeTool]SmudgeTool")
   coat.tools_item("[POWRELAX]POWRELAX")
   coat.tools_item("[CloneTool]CloneTool")
   coat.tools_item("[CurveTool]CurveTool")
   coat.tools_item("[TextTool]TextTool")
   coat.tools_item("[EraserTool]EraserTool")
   coat.tools_item("[FillTool]FillTool")


@d_tools_section("Adjust")
def AdjustProxy():
      coat.tools_item("[extension]Noise") # Noise
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_PICK") # Quick Pick
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_TRANSPOSE") # Pose
      coat.tools_item("[extension]FitTool") # Fit
      coat.tools_item("[extension]Reproject")
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_MOVE") # Move
      coat.tools_item("[extension]Measure") # Measure
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_TRANSFORM") # Transform
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_INST") # Instancer
      # tools_item("[extension]SCULPT_AXIAL");Axial


@d_tools_section("Adjust")
def AdjustVoxel():
      coat.tools_item("[extension]CutOff") # Cut Off
      coat.tools_item("[extension]Measure") # Measure
      coat.tools_item("[extension]Supports") # Supports
      coat.tools_item("[extension]VoXRay") # VoXRay
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_PICK") # Quick Pick
      coat.tools_item("[extension]FitTool") # Fit
      coat.tools_item("[extension]Reproject")
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_HIDE") # Vox Hide
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_CLHIDE") # Cell
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_COPY") # Copy
      coat.tools_item("[extension]SCULPT_BARELIEF") # Bas-Relief
      coat.tools_item("[extension]Undercuts") # Undercuts
      coat.tools_item("[extension]Molding")


@d_tools_section("Adjust")
def AdjustSurface():
      coat.tools_item("[extension]SculptBevel")
      coat.tools_item("[extension]CutOff") # Cut Off
      coat.tools_item("[extension]Noise") # Noise
      coat.tools_item("{HEAL}[extension]CloseHole") # Close Hole
      coat.tools_item("{HEAL}[extension]Reconstruct") # Reconstruct
      coat.tools_item("{HEAL}[extension]MeshDoctor") # MeshDoctor
      coat.tools_item("{HEAL}[extension]CleanClay") # MeshDoctor
      coat.tools_item("[extension]FillHoles") # Fill Holes
      coat.tools_item("[extension]PaintHole") # Poly Remove
      if not coat.is_proxy():
         coat.tools_item("[extension]SuperPinch") # Angulator
         coat.tools_item("[extension]InfSmooth") # Smoother
         coat.tools_item("[extension]Subdivide") # Subdivide
   
      coat.tools_item("[extension]Measure") # Measure
      coat.tools_item("[extension]Supports") # Supports
      coat.tools_item("[extension]VoXRay") # VoXRay
      coat.tools_item("[extension]ExtrudeFaces") # ExtrudeFaces
      # tools_item("[extension]QuickPose");Quick Pose		
      coat.tools_item("[extension]Bridge") # Bridge
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_PICK") # Quick Pick
      coat.tools_item("[extension]SCULPT_BARELIEF") # Bas-Relief
      coat.tools_item("[extension]Undercuts") # Undercuts
      coat.tools_item("[extension]Molding")


@d_tools_section("Objects")
def SurfaceObjects():
      coat.tools_item("[extension]SCULP_PRIM") # Primitives
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_MERGE") # Import
      coat.tools_item("[extension]TreesGenerator")
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_LOGO") # Logo
      coat.tools_item("{CREATESIMP}[extension]SCULP_SKETCH") # Sketch
      coat.tools_item("[extension]SplitNJoint") # Split & Joints
      coat.tools_item("[extension]SCULPT_RECTSPLIT") # Split
      coat.tools_item("{clone}[extension]SCULPT_CLONE") # Clone
      coat.tools_item("{clone}[extension]SCULPT_CUTNCLONE") # Cut & Clone
      coat.tools_item("[extension]VoxExtrude") # Vox Extrude
      coat.tools_item("[extension]VoxLayer") # Vox Layer
      coat.tools_item("[RetopoTool]TopToolAddPoints") # Quads
      coat.tools_item("{snake}[extension]SCULP_SPSTROKE") # Snake
      coat.tools_item("{snake}[extension]SCULP_FREESP") # Spikes
      coat.tools_item("{snake}[extension]SCULP_TUBE") # ToothPaste
      coat.tools_item("{snake}[extension]SCULP_MUSCLE") # Muscle
      coat.tools_item("{snake}[extension]SCULP_CLOTH") # Cloth
      coat.tools_item("[extension]JointsTool")


@d_tools_section("Custom")
def Custom():
      coat.tools_item("[extension]BaseBrush")
      coat.tools_item("AddNewBrush")      

@d_tools_section("ClayEngine")
def ClayEngine():
      coat.tools_item("[extension]BaseVoxBrush") # Vox brush constructor
      coat.tools_item("[extension]WetClay")
      coat.tools_item("[extension]Extruder")
      coat.tools_item("[extension]VoxBuildup")
      coat.tools_item("[extension]LayerClay")


@d_tools_section("VoxelTools")
def Voxel():
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_CLAY") # Clay
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_GROW") # Grow
      coat.tools_item("{LEGACYVOX}[extension]SCULPT_BUILD") # Build
      coat.tools_item("{LEGACYVOX}[VOX_SCULPT_TOOL]SCULPT_ALPGROW") # Airbrush
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_SMOOTH") # Smooth
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_FILL") # Fill
      coat.tools_item("[extension]SCULPT_CARVE") # Carve
      coat.tools_item("[extension]Blob") # Blob
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_SPHERE") # Sphere
      coat.tools_item("[extension]SCULPT_BRANCH") # 2D-Paint
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_RASPFILE") # Plane
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_VXPLANE") # Scrape
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_VXPINCH") # Pinch
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_VXFOLLOW") # Smudge


@d_tools_section("Pose")
def Pose():
      coat.tools_item("{transform}[VOX_SCULPT_TOOL]SCULPT_TRANSFORM") # Transform
      coat.tools_item("{transform}[VOX_SCULPT_TOOL]SCULP_INST") # Instancer
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_MOVE") # Move                
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_TRANSPOSE") # Pose
      coat.tools_item("[extension]FitTool") # Fit
      coat.tools_item("[extension]Reproject")

      coat.tools_item("[extension]SCULP_BEND") # Bend
      coat.tools_item("[extension]SCULP_TWIST") # Twist
      coat.tools_item("[extension]SCULP_WRAP") # Warp
      # 		tools_item("[extension]SCULPT_AXIAL");Axial
      coat.tools_item("[extension]Sculpt_Array") # Axial	
      coat.tools_item("[extension]MultiObject") # Surface Array


@d_tools_section("Objects")
def Objects():
      coat.tools_item("[extension]SCULP_PRIM") # Primitives
      coat.tools_item("[VOX_SCULPT_TOOL]SCULP_MERGE") # Import
      coat.tools_item("[extension]TreesGenerator")
      coat.tools_item("[extension]lasPointCloud")
      coat.tools_item("[VOX_SCULPT_TOOL]SCULPT_LOGO") # Logo
      coat.tools_item("[extension]PixelArt") # Constructor
      coat.tools_item("[extension]SCULP_SKETCH") # Sketch
      coat.tools_item("[extension]SCULPT_RECTSPLIT") # Split
      coat.tools_item("[extension]SCULPT_CLONE") # Clone
      coat.tools_item("[extension]SCULPT_CUTNCLONE") # Cut & Clone
      coat.tools_item("[extension]VoxExtrude") # Vox Extrude
      coat.tools_item("[extension]VoxLayer") # Vox Layer
      coat.tools_item("[extension]CurvesLayer") # Coat
      coat.tools_item("[RetopoTool]TopToolAddPoints") # Quads
      coat.tools_item("[extension]SCULP_SPSTROKE") # Snake
      coat.tools_item("[extension]SCULP_FREESP") # Spikes
      coat.tools_item("[extension]SCULP_TUBE") # ToothPaste
      coat.tools_item("[extension]SCULP_MUSCLE") # Muscle
      coat.tools_item("[extension]SCULP_CLOTH") # Cloth
      coat.tools_item("[extension]MultiObject") # Multiple objects


@d_tools_section("Curves")
def Curves():
      coat.tools_item("[extension]SCULP_CURVES") # Curves
      coat.tools_item("[extension]SCULP_TEXT") # Text		
      InstallCurvesExtensions()

@d_tools_section("Commands")
def Commands():
      coat.tools_item("[VOX_SCULPT_TOOL]IncRes") # Res+
      coat.tools_item("[VOX_SCULPT_TOOL]Resample") # Resample
      coat.tools_item("[VOX_SCULPT_TOOL]Clear") # Clear
      coat.tools_item("[VOX_SCULPT_TOOL]SmAll") # Smooth All
      # tools_item("[extension]StemTool");Stem Cell Checker
      if coat.is_surface(): 
         coat.tools_item("[VOX_SCULPT_TOOL]SmEdges")
         coat.tools_item("[VOX_SCULPT_TOOL]LevelUP")
         coat.tools_item("[VOX_SCULPT_TOOL]LevelDN")


@d_tools_section("Commands")
def ProxyCommands():
      coat.tools_item("[VOX_SCULPT_TOOL]SmAll") # Smooth All
      if coat.is_multires():
         coat.tools_item("[VOX_SCULPT_TOOL]LevelUP")
         coat.tools_item("[VOX_SCULPT_TOOL]LevelDN")


############################
#### ProxyTools
@d_template
def ProxyTools():
      coat.page_suffix("[P]")
      coat.default_tool("[extension]SCULP_SCLAY")
      SetType(True, False)
      ProxyTools.IncludeContent()

ProxyTools.Content.append(BaseSurfaceTools)
ProxyTools.Content.append(AdjustProxy)
ProxyTools.Content.append(ProxyCommands) 

@d_child(ProxyTools)
def ProxyToolsPaint():
      if coat.is_multires():
            PaintTools()


############################
#### SurfaceTools
@d_template
def SurfaceTools():
      coat.page_suffix("[S]")
      coat.default_tool("[extension]SCULP_SCLAY")
      SetType(False, False)
      SurfaceTools.IncludeContent()

SurfaceTools.Content.append(BaseSurfaceTools)
SurfaceTools.Content.append(Custom)
SurfaceTools.Content.append(Layers)   
SurfaceTools.Content.append(PaintTools)
SurfaceTools.Content.append(AdjustSurface)
SurfaceTools.Content.append(Pose)
SurfaceTools.Content.append(SurfaceObjects)
SurfaceTools.Content.append(Curves)
SurfaceTools.Content.append(Commands)

############################
#### VoxelTools
@d_template
def VoxelTools():
      coat.page_suffix("[V]")
      coat.default_tool("[extension]BaseVoxBrush")
      SetType(False, True)
      VoxelTools.IncludeContent()
      
VoxelTools.Content.append(ClayEngine)
VoxelTools.Content.append(Voxel)
VoxelTools.Content.append(BaseSurfaceTools)
VoxelTools.Content.append(AdjustVoxel)
VoxelTools.Content.append(PaintTools)
VoxelTools.Content.append(Pose)
VoxelTools.Content.append(Objects)
VoxelTools.Content.append(Curves)
VoxelTools.Content.append(Commands)

###############################

@d_template
def SculptTools():
   if(coat.is_proxy()):
      ProxyTools()   
   elif coat.is_surface():
      SurfaceTools()
   else:
      VoxelTools()
      
   coat.insert_extensions()