# 
# The Retopo room toolset definition.
# 
# Insert commands and conditions within the main(){...} function
# use 
#   tools_item("IdentifierOfTheTool");
# to add new item into the toolset.
# use 
#   tools_section("Section name");
# to add tools section.
# The command
#   default_tool("IdentifierOfTheTool");
# defines the tool used by default in the room.
# 
import coat
from cTemplates.Structs import *

@d_template
def RetopoTools():
   coat.tools_comment("TheRetopoRoom")
   RetopoTools.IncludeContent()

@d_tools_section("Basic", RetopoTools)
def Basic():
   coat.default_tool("[RetopoTool]TopToolAddPolygones")
   coat.tools_item("[RetopoTool]TopToolAddPolygones") # Add/Split
   coat.tools_item("[RetopoTool]TopToolSelectAndOperate") # Select
   coat.tools_item("[RetopoTool]TopToolSelTransform") # Transform
   coat.tools_item("[RetopoTool]SelPath") # Select Path
   coat.tools_item("[RetopoTool]TopToolAddQuads") # Quads
   coat.tools_item("[RetopoTool]TopToolAddPoints") # Points/Faces
   coat.tools_item("[extension]CapRetopo") # Cap
   coat.tools_item("[RetopoTool]TopToolDrawStrokes") # Strokes
   coat.tools_item("[extension]CurveAsStroke") # Strokes
   coat.tools_item("[extension]RTP_PRIM") # 3DPrimitives
   coat.tools_item("[extension]RTP_PRIM2") # 2DPrimitives
   coat.tools_item("[extension]RFill") # RFill
   coat.tools_item("[extension]RtKnife") # RtKnife
   coat.tools_item("[extension]SmartRetopo") # SmartRetopo
   coat.tools_item("{EXTRD}[extension]RtExtrudeFreeSl") # Smart Extrude
   coat.tools_item("{EXTRD}[extension]InSet") # ExtrudeFreeSl
   coat.tools_item("{EXTRD}[extension]SpineTool") # SpineTool
   coat.tools_item("{TRFM}[extension]RtFreeMoving") # Free Moving
   coat.tools_item("{TRFM}[extension]RtFreeRotating") # Free Rotating
   coat.tools_item("{TRFM}[extension]RtFreeScaling") # Free Scaling
   coat.tools_item("[extension]MakeJoints")

@d_tools_section("Tweak", RetopoTools)
def Tweak():
   coat.tools_item("[RetopoTool]TopToolSharp")
   coat.tools_item("[RetopoTool]TopToolTweakWithBrush") # Brush
   # 	tools_item("[RetopoTool]TopToolDeletePolygones");Del. Polygons
   # 	tools_item("[RetopoTool]TopToolDeleteEdges");Del. Edges
   coat.tools_item("[extension]DeleteFaceOrEdge") # Delete Face/Edge
   coat.tools_item("[RetopoTool]TopToolCollapseEdges") # Collapse
   coat.tools_item("[extension]SplitRings") # Split Rings
   coat.tools_item("[RetopoTool]TopToolTweakVerts") # Move
   coat.tools_item("[extension]SlideEdgesOrVertex") # Slide Edges or Vertex
   coat.tools_item("[extension]Measure") # Measure
   coat.tools_item("[extension]MdlShowOpenEdge") # Show Open Edge

@d_tools_section("UV", RetopoTools)
def UV():
   coat.tools_item("[RetopoTool]MARK_CLUSTERS") # Add Clusters
   coat.tools_item("[RetopoTool]TopToolMarkSeams") # Mark Seams
   coat.tools_item("[RetopoTool]TopToolMarkEdgeLoops") # Edge Loops
   coat.tools_item("[RetopoTool]UV_Path") # UV Path
   coat.tools_item("[extension]JoinUVCL")
   if coat.IsInTool("[RetopoTool]TopToolAddPoints"):
       TopToolAddPoints_Special()
 
   if coat.IsInTool("[RetopoTool]TopToolDrawStrokes"):
       TopToolDrawStrokes_Special()

 
   if coat.IsInTool("[RetopoTool]TopToolMarkSeams") or coat.IsInTool("[RetopoTool]TopToolMarkEdgeLoops") or coat.IsInTool("[extension]JoinUVCL") or coat.IsInTool("[RetopoTool]MARK_CLUSTERS") or coat.IsInTool("[RetopoTool]UV_Path") or coat.doc_mode():
       selected_uv()
       UV_Commands()
 
   selm: int = coat.GetCurrentToolSubmode("selected")
   if coat.IsInTool("[RetopoTool]TopToolSelectAndOperate") or coat.IsInTool("[RetopoTool]TopToolSelTransform") or coat.IsInTool("[RetopoTool]SelPath") or selm != 0:
       if coat.GetCurrentToolSubmode("retopo") == 2 or coat.IsInTool("[RetopoTool]SelPath") or coat.doc_mode() or selm == 2: # edges
           Selected_Edges()
     
       if coat.GetCurrentToolSubmode("retopo") == 1 or coat.doc_mode() or selm == 1: # verts
           Selected_Verts()
     
       if coat.GetCurrentToolSubmode("retopo") == 3 or coat.doc_mode() or selm == 3: # faces
           Selected_Faces()
     
       WholeMesh()
   else:
       Commands()

@d_tools_section("Special")
def TopToolDrawStrokes_Special():
       coat.tools_item("[RetopoTool]ClearLines") # Clear
       coat.tools_item("[RetopoTool]SmoothLines") # Smooth
       coat.tools_item("[RetopoTool]DelStroke") # Delete

@d_tools_section("Special")
def TopToolAddPoints_Special():
       coat.tools_item("[RetopoTool]rtClearPoints") # Clear points

@d_tools_section("Commands")
def UV_Commands():
       coat.tools_item("[RetopoTool]UV_Settings") # UV Settings
       coat.tools_item("[RetopoTool]ClearClusters") # Clear Clusters
       coat.tools_item("[RetopoTool]ClearEdges") # Clear Seams
       coat.tools_item("[RetopoTool]AutoEdges") # Auto Seams
       coat.tools_item("[RetopoTool]SharpSeams") # Sharp Seams
       coat.tools_item("[RetopoTool]UnifyUV") # Unify UV
       coat.tools_item("[RetopoTool]Unwrap") # Unwrap
       coat.tools_item("[RetopoTool]AutoMap") # AutoMap
       coat.tools_item("[RetopoTool]PackUV") # Pack UV
       coat.tools_item("[RetopoTool]ShuffleUV") # Shuffle/Pack
       coat.tools_item("[RetopoTool]PackUnf") # PackUV2
       coat.tools_item("[RetopoTool]AutoSc") # Auto Scale
       coat.tools_item("[RetopoTool]RemoveUVIntr")
       coat.tools_item("[RetopoTool]UpdateIsl") # Upd. Islands
       coat.tools_item("[RetopoTool]RestoreUV") # Restore UV
       coat.tools_item("[RetopoTool]ApplyUV") # Apply UV-set
       coat.tools_item("[RetopoTool]STORE_UV") # Save
       coat.tools_item("[RetopoTool]RESTORE_UV") # Load
       coat.tools_item("[RetopoTool]rLazerCut") # Save contour
       coat.tools_item("[extension]StemTool") # Stem Cell Checker

@d_tools_section("Selected")
def Selected_Edges():
           coat.tools_comment("EdgesModeComment")
           coat.tools_item("[RetopoTool]sfExpand") # Expand
           coat.tools_item("[RetopoTool]sfContract") # Contract
           coat.tools_item("[RetopoTool]sfTransform") # Transform
           coat.tools_item("[extension]RtExtrudeFreeSl") # Smart Extrude
           coat.tools_item("[RetopoTool]sfCutEdges") # Cut edges
           coat.tools_item("[RetopoTool]SnapRT") # Snap
           coat.tools_item("[RetopoTool]ScaleCL") # Scale
           coat.tools_item("[RetopoTool]ApplyTSm") # Relax
           coat.tools_item("[RetopoTool]seSpin") # Rotate CW
           coat.tools_item("[RetopoTool]seSpinBack") # Rotate CCW
           coat.tools_item("[RetopoTool]seSplit") # Split
           coat.tools_item("[RetopoTool]seCollapse") # Collapse
           coat.tools_item("[RetopoTool]seDelete") # Delete
           coat.tools_item("[RetopoTool]seEdgeLoop") # Edge Loop
           coat.tools_item("[RetopoTool]seEdgeRing") # Edge Ring
           coat.tools_item("[RetopoTool]seSelSharp") # Sel.Sharp
           coat.tools_item("[extension]Bevel") # Bevel
           coat.tools_item("[RetopoTool]uvSeams") # Set Seams
           coat.tools_item("[RetopoTool]uvClrSeams") # Del. Seams
           coat.tools_item("[RetopoTool]uvSharp")
           coat.tools_item("[RetopoTool]uvClrSharp")
           coat.tools_item("[RetopoTool]rtStoreSel") # Store Sel.
           coat.tools_item("[RetopoTool]rtRecallSel") # Load Sel.
           coat.tools_item("[RetopoTool]rtClearSel") # Clear Sel.
           coat.tools_item("[RetopoTool]rtSpliteEdge") # Splite Edge
           coat.tools_item("[extension]MdlBridgeTool") # Bridge
           coat.tools_item("[extension]RtAlignmentVertexs") # Alignment edges
           coat.tools_item("[extension]MdlEdgeFlow") # Edge Flow
           coat.tools_item("[extension]UnifArrangementVertex") # Equalize Edges


@d_tools_section("Selected")
def Selected_Verts():
           coat.tools_comment("VertsModeComment")
           coat.tools_item("[RetopoTool]sfExpand") # Expand
           coat.tools_item("[RetopoTool]sfContract") # Contract
           coat.tools_item("[RetopoTool]sfTransform") # Transform
           coat.tools_item("[RetopoTool]sfConnect") # Connect
           coat.tools_item("[RetopoTool]SnapRT") # Snap
           coat.tools_item("[RetopoTool]ScaleCL") # Scale
           coat.tools_item("[RetopoTool]rtStoreSel") # Store Sel.
           coat.tools_item("[RetopoTool]rtRecallSel") # Load Sel.
           coat.tools_item("[RetopoTool]rtClearSel") # Clear Sel.
           coat.tools_item("[extension]Bevel") # Bevel
           coat.tools_item("[extension]RtWeldingVertexs") # Welding Vertexs
           coat.tools_item("[extension]RtAlignmentVertexs") # Alignment Vertexs
           coat.tools_item("[RetopoTool]ApplyTSm") # Relax

@d_tools_section("Selected")
def Selected_Faces():
           coat.tools_comment("FacesModeComment")
           coat.tools_item("[RetopoTool]sfExpand") # Expand
           coat.tools_item("[RetopoTool]sfContract") # Contract
           coat.tools_item("[RetopoTool]sfTransform") # Transform
           coat.tools_item("[extension]RtExtrudeFreeSl") # Smart Extrude
           coat.tools_item("[RetopoTool]sfIntrude") # Intrude
           coat.tools_item("[extension]InSet") # InSet
           coat.tools_item("[RetopoTool]sfShell") # Shell
           coat.tools_item("[RetopoTool]SnapRT") # Snap
           coat.tools_item("[RetopoTool]ScaleCL") # Scale
           coat.tools_item("[RetopoTool]ApplyTSm") # Relax
           coat.tools_item("[RetopoTool]sfSmooth")
           coat.tools_item("[RetopoTool]sfDelete") # Delete
           coat.tools_item("[RetopoTool]sfClone") # Clone
           coat.tools_item("[RetopoTool]sfCutnClone") # Separate
           coat.tools_item("[RetopoTool]sfSubdiv") # Subdivide
           coat.tools_item("[RetopoTool]sfHide") # Hide
           coat.tools_item("[RetopoTool]rtFlipFaces") # Flip faces
           coat.tools_item("[RetopoTool]sfInvHidden") # Invert Hidden
           coat.tools_item("[RetopoTool]sfUnhide") # Unhide
           coat.tools_item("[RetopoTool]rtPoke") # Poke face
           coat.tools_item("[extension]Bevel") # Bevel
           coat.tools_item("[extension]MdlBridgeTool") # Bridge faces
           coat.tools_item("[extension]RtAlignmentVertexs") # Alignment faces
           coat.tools_item("[RetopoTool]rtClearSel")

@d_tools_section("WholeMesh")
def WholeMesh():
       coat.tools_item("[RetopoTool]sfTransform") # Transform
       coat.tools_item("[RetopoTool]SnapRT") # Snap
       coat.tools_item("[RetopoTool]ScaleCL") # Scale
       coat.tools_item("[RetopoTool]ApplyTSm") # Relax
       coat.tools_item("[RetopoTool]ImportRM") # Import
       coat.tools_item("[RetopoTool]ExportRM") # Export
       coat.tools_item("[RetopoTool]ApplyTS") # Subdivide
       coat.tools_item("[RetopoTool]ApplyTSmooth")
       coat.tools_item("[RetopoTool]ClearTM") # Clear
       coat.tools_item("[RetopoTool]ApplyTSym") # Symmetry
       coat.tools_item("[RetopoTool]Unwrap") # Unwrap
       coat.tools_item("[RetopoTool]rtStoreSel") # Store Sel.
       coat.tools_item("[RetopoTool]rtRecallSel") # Load Sel.
       coat.tools_item("[RetopoTool]rtClearSel") # Clear Sel.
       coat.tools_item("[RetopoTool]rLazerCut") # Save contour
       coat.tools_item("[extension]StemTool") # Stem Cell Checker	


@d_tools_section("Commands")
def Commands():
       coat.tools_item("[extension]AutoRetopo")
       coat.tools_item("[RetopoTool]sfTransform") # Transform
       coat.tools_item("[RetopoTool]SnapRT") # Snap
       coat.tools_item("[RetopoTool]ScaleCL") # Scale
       coat.tools_item("[RetopoTool]ApplyTSm") # Relax
       coat.tools_item("[RetopoTool]ImportRM") # Import
       coat.tools_item("[RetopoTool]ExportRM") # Export
       coat.tools_item("[RetopoTool]ApplyTS") # Subdivide
       coat.tools_item("[RetopoTool]ApplyTSmooth")
       coat.tools_item("[RetopoTool]ClearTM") # Clear
       coat.tools_item("[RetopoTool]ApplyTSym") # Symmetry
       coat.tools_item("[RetopoTool]Unwrap") # Unwrap
       coat.tools_item("[RetopoTool]AutoMap") # AutoMap
       coat.tools_item("[RetopoTool]rtStoreSel") # Store Sel.
       coat.tools_item("[RetopoTool]rtRecallSel") # Load Sel.
       coat.tools_item("[RetopoTool]rtClearSel") # Clear Sel.
       coat.tools_item("[RetopoTool]rLazerCut") # Save contour
       coat.tools_item("[extension]StemTool") # Stem Cell Checker



@d_template
def selected_uv():
    coat.tools_section("Selected")
    if coat.GetCurrentToolSubmode("uv") == 1: # verts
       coat.tools_comment("uv_VertsComment")
       coat.tools_item("[RetopoTool]ClearSel") # Clear
       coat.tools_item("[RetopoTool]uvInvSel") # Invert
       coat.tools_item("[RetopoTool]RotateCW") # Rotate CW
       coat.tools_item("[RetopoTool]RotateCCW") # Rotate CCW
       coat.tools_item("[RetopoTool]FlipU") # Flip U
       coat.tools_item("[RetopoTool]FlipV") # Flip V
       coat.tools_item("[RetopoTool]uvRelax") # Relax
       coat.tools_item("[RetopoTool]Relax2") # Cloth Relax
    elif coat.GetCurrentToolSubmode("uv") == 2: # edges
       coat.tools_comment("uv_EdgesComment")
       coat.tools_item("[RetopoTool]ClearSel") # Clear
       coat.tools_item("[RetopoTool]uvInvSel") # Invert
       coat.tools_item("[RetopoTool]RotateCW") # Rotate CW
       coat.tools_item("[RetopoTool]RotateCCW") # Rotate CCW
       coat.tools_item("[RetopoTool]FlipU") # Flip U
       coat.tools_item("[RetopoTool]FlipV") # Flip V
       coat.tools_item("[RetopoTool]uvToLine") # To Line
       coat.tools_item("[RetopoTool]uvEquidist") # Equidistant
       coat.tools_item("[RetopoTool]uvHorizontal") # Horizontal
       coat.tools_item("[RetopoTool]uvVertical") # Vertical
       coat.tools_item("[RetopoTool]uvLoop") # Edge Loop
       coat.tools_item("[RetopoTool]uvRing") # Edge Ring
       coat.tools_item("[RetopoTool]uvSeams") # Set Seams
       coat.tools_item("[RetopoTool]uvClrSeams") # Del. Seams
    elif coat.GetCurrentToolSubmode("uv") == 3: # faces
       coat.tools_comment("uv_FacesComment")
       coat.tools_item("[RetopoTool]ClearSel") # Clear
       coat.tools_item("[RetopoTool]uvInvSel") # Invert
       coat.tools_item("[RetopoTool]RotateCW") # Rotate CW
       coat.tools_item("[RetopoTool]RotateCCW") # Rotate CCW
       coat.tools_item("[RetopoTool]FlipU") # Flip U
       coat.tools_item("[RetopoTool]FlipV") # Flip V
       coat.tools_item("[RetopoTool]Strict") # Relax
       coat.tools_item("[RetopoTool]Relax2") # Cloth Relax
       coat.tools_item("[RetopoTool]uvHide") # Hide
       coat.tools_item("[RetopoTool]uvInvHide") # Inv. Hidden
       coat.tools_item("[RetopoTool]uvUnhide") # Unhide
       coat.tools_item("[RetopoTool]uvUnhideAll") # Unhide All
       coat.tools_item("[RetopoTool]hdExpand") # HD Expand
       coat.tools_item("[RetopoTool]hdContract") # HD Contract
    elif coat.GetCurrentToolSubmode("uv") == 4: # islands
       coat.tools_comment("uv_IslandsComment")
       coat.tools_item("[RetopoTool]ClearSel") # Clear
       coat.tools_item("[RetopoTool]uvInvSel") # Invert
       coat.tools_item("[RetopoTool]RotateCW") # Rotate CW
       coat.tools_item("[RetopoTool]RotateCCW") # Rotate CCW
       coat.tools_item("[RetopoTool]FlipU") # Flip U
       coat.tools_item("[RetopoTool]FlipV") # Flip V
       coat.tools_item("[RetopoTool]Strict") # Relax
       coat.tools_item("[RetopoTool]Relax2") # Cloth Relax
       coat.tools_item("[RetopoTool]toABF") # To ABF
       coat.tools_item("[RetopoTool]toGU") # To GU
       coat.tools_item("[RetopoTool]toLSCM") # To LSCM
       coat.tools_item("[RetopoTool]toPlanar") # To Planar
       coat.tools_item("[RetopoTool]toStripe")
       coat.tools_item("[RetopoTool]uvHide") # Hide
       coat.tools_item("[RetopoTool]uvInvHide") # Inv. Hidden
       coat.tools_item("[RetopoTool]uvUnhide") # Unhide
       coat.tools_item("[RetopoTool]uvUnhideAll") # Unhide All
       coat.tools_item("[RetopoTool]hdExpand") # HD Expand
       coat.tools_item("[RetopoTool]hdContract") # HD Contract
       coat.tools_item("[RetopoTool]CopyUV") # Copy UV
       coat.tools_item("[RetopoTool]PasteUV") # Paste UV
    else:
       coat.tools_item("[RetopoTool]ClearSel")
       coat.tools_item("[RetopoTool]uvInvSel")
 

@d_tools_section("SmartHybrid")
def SmartHybrid():
	coat.tools_item("[extension]MdlSelectTool") # SelectTool
	coat.tools_item("[extension]SmartHybridCreate") # SelectTool
	coat.tools_item("[extension]SmartHybridTool") # Smart Hybrid Tool
	coat.tools_item("[extension]SmartHybridExtrude") # Extrude
	coat.tools_item("[extension]SmartHybridTransform") # Transform
	coat.tools_item("[extension]SmartHybridOffset") # Offset
	coat.tools_item("[extension]SmartHybridAlignment") # Alignment
	coat.tools_item("[extension]SmartHybridSubDivide") # SubDivide