import os
import coat
import cPy.cUI
import cPy.cCore
import pathlib
import inspect
import cTemplates.Structs

from cTemplates.menu import DefaultMenu
from cTemplates.voxTreeRmb import VoxTreeRmb
from cTemplates.curves import CurvesRMB
from cTemplates.navigation import NavigationBar
from cTemplates.sculptTools import SculptTools

def pathToRoomName(file_path: str):
    path = pathlib.PurePath(file_path)
    return path.parent.name

rooms_history = list()
rooms = dict()

rmb = dict()
toolset = dict()
start_page = dict()
curves_rmb = dict()
main_menu = dict()
navigation_bar = dict()

class RoomBehavior(cPy.cUI.RoomBehavior):
    def __init__(self):
        cPy.cUI.RoomBehavior.__init__(self)
        room_folder_name = ""

    def UpdateToolsList(self):
            if self.room_folder_name in toolset:# and self.UseScriptsForToolset():
                toolset[self.room_folder_name]()
            else:
                SculptTools()

    def OnStartPageToolsList(self):
        if self.room_folder_name in start_page:
            start_page[self.room_folder_name]()

    def UpdateNavigationControls(self):
        if self.room_folder_name in navigation_bar and self.UseScriptsForNavigation():
            navigation_bar[self.room_folder_name]()
        else:
            NavigationBar()

    def UpdateMainMenu(self):
        if self.room_folder_name in main_menu and self.UseScriptsForMenu():
            main_menu[self.room_folder_name]()
        else:
            DefaultMenu()

    def ShowPopupMenu(self, propertytype):
        if propertytype == "curves":
            if self.room_folder_name in curves_rmb:# and self.UseScriptsForCurves():
                curves_rmb[self.room_folder_name]()
            else:
                CurvesRMB()
        else:
            if self.room_folder_name in rmb and self.UseScriptsForRmb():
                rmb[self.room_folder_name]()
            else:
                VoxTreeRmb()

def reg_toolset(ref):
    n_action = cTemplates.Structs.cTemplate()
    n_action_content = cTemplates.Structs.cTemplate()
    n_action.Content.append(n_action_content)
    n_action_content.Implementation = ref
    room_folder_name = pathToRoomName(inspect.getsourcefile(ref))
    toolset[room_folder_name] = n_action
    return n_action

def reg_main_menu(ref):
    n_action = cTemplates.Structs.cTemplate()
    n_action_content = cTemplates.Structs.cTemplate()
    n_action.Content.append(n_action_content)
    n_action_content.Implementation = ref
    room_folder_name = pathToRoomName(inspect.getsourcefile(ref))
    main_menu[room_folder_name] = n_action
    return n_action

def reg_rmb(ref):
    n_action = cTemplates.Structs.cTemplate()
    n_action_content = cTemplates.Structs.cTemplate()
    n_action.Content.append(n_action_content)
    n_action_content.Implementation = ref
    room_folder_name = pathToRoomName(inspect.getsourcefile(ref))
    rmb[room_folder_name] = n_action
    return n_action

def reg_curves_rmb(ref):
    n_action = cTemplates.Structs.cTemplate()
    n_action_content = cTemplates.Structs.cTemplate()
    n_action.Content.append(n_action_content)
    n_action_content.Implementation = ref
    room_folder_name = pathToRoomName(inspect.getsourcefile(ref))
    curves_rmb[room_folder_name] = n_action
    return n_action

def reg_navigation_bar(ref):
    n_action = cTemplates.Structs.cTemplate()
    n_action_content = cTemplates.Structs.cTemplate()
    n_action.Content.append(n_action_content)
    n_action_content.Implementation = ref
    room_folder_name = pathToRoomName(inspect.getsourcefile(ref))
    navigation_bar[room_folder_name] = n_action
    return n_action


def reg_room(room_beh):
    behavior = room_beh()
    source_path = inspect.getsourcefile(room_beh)
    behavior.room_folder_name = pathToRoomName(source_path)

    if pathlib.Path(pathlib.PurePath(source_path).parent.joinpath("Tools.py")).exists():
        exec("import CustomRooms." + behavior.room_folder_name + ".Tools")

    if pathlib.Path(pathlib.PurePath(source_path).parent.joinpath("CurvesMenu.py")).exists():
        exec("import CustomRooms." + behavior.room_folder_name + ".CurvesMenu")

    if pathlib.Path(pathlib.PurePath(source_path).parent.joinpath("RMBMenu.py")).exists():
        exec("import CustomRooms." + behavior.room_folder_name + ".RMBMenu")

    if pathlib.Path(pathlib.PurePath(source_path).parent.joinpath("MainMenu.py")).exists():
        exec("import CustomRooms." + behavior.room_folder_name + ".MainMenu")

    if pathlib.Path(pathlib.PurePath(source_path).parent.joinpath("NavigationBar.py")).exists():
        exec("import CustomRooms." + behavior.room_folder_name + ".NavigationBar")

    behavior.SetRoomName(behavior.room_folder_name)
    rooms_history.append(behavior)
    rooms[behavior.room_folder_name] = behavior
    behavior.Apply()
    return room_beh



