import coat
from cTemplates.Structs import *

WindowsMenu = MainMenu("Windows")

Popups = Submenu("Popups", WindowsMenu)

@d_menu_section(Popups)
def Popups_S1():
    if coat.IsInRoom("Retopo"):
        coat.menu_item("UV_PREV") # UV Preview
    
    if coat.IsInRoom("UV"):
        coat.menu_item("UV_PREV") # UV Preview
    
    coat.menu_item("StartMenu") # Start Menu
    coat.menu_item("SHOW_PRESETS") # Tool Presets
    coat.menu_item("SHOW_TOOLS_PALETTE") # Tools Palette
    coat.menu_hotkey("SPACE", 0, 0, 0) # SPACE
    # menu_item("SHOW_SUBOBJ");/Paint Objects
    # menu_item("SHOW_MATERIALS");/Surface Materials

@d_menu_section(Popups)
def Popups_S_ProxySlider():
    coat.menu_item("ProxySlider") # ProxySlider

@d_menu_section(Popups)
def Popups_paint():
    coat.menu_item("ID_BUMP_HDR") # Depth Channel
    coat.menu_hotkey("D", 0, 0, 0) # D
    coat.menu_item("ID_COLOR_HDR") # Color Channel
    coat.menu_hotkey("C", 0, 0, 0) # C
    coat.menu_item("ID_SPECULAR_HDR") # Glossiness Channel
    coat.menu_hotkey("R", 0, 0, 0) # R
    coat.menu_item("ID_PENOPS") # Stroke Mode
    coat.menu_hotkey("E", 0, 0, 0) # E
    coat.menu_item("QuickPanel") # Quick Panel
    coat.menu_hotkey("T", 0, 0, 0) # T



@d_menu_section(Popups)
def Popups_Extensions():
    coat.menu_insert_extensions("Windows.Popups")
    coat.menu_sort()
    # menu_item("VoxTreeRMB");/Trigger Volume Properties Window


Sliders = Submenu("Sliders", WindowsMenu)
@d_menu_section(Sliders)
def Sliders_S1():
    coat.menu_item("DEC_OPACITY") # Decrease Opacity
    coat.menu_item("INC_OPACITY") # Increase Opacity
    coat.menu_item("DEC_ANGLE") # Decrease Angle
    coat.menu_item("INC_ANGLE") # Increase Angle
    coat.menu_item("DEC_RADIUS") # Decrease Radius
    coat.menu_item("INC_RADIUS") # Increase Radius
    coat.menu_item("DEC_DEGREE") # Decrease Degree
    coat.menu_item("INC_DEGREE") # Increase Degree
@d_menu_section(Sliders)
def Sliders_S2():
    coat.menu_item("DEC_SM_DEGREE") # Decrease Smooth Degree
    coat.menu_item("INC_SM_DEGREE") # Increase Smooth Degree
    coat.menu_item("DEC_SPEC_OPACITY") # Decrease Glossiness Opacity
    coat.menu_item("INC_SPEC_OPACITY") # Increase Glossiness Opacity
    coat.menu_item("DEC_SPEC_DEGREE") # Decrease Glossiness Degree
    coat.menu_item("INC_SPEC_DEGREE") # Increase Glossiness Degree
    coat.menu_item("SWAP_COLORS") # Swap Colors
    coat.menu_insert_extensions("Windows.Sliders")

@d_menu_section(Sliders)
def Sliders_S3():
    coat.menu_item("PEN_DEPTH") # Depth
    coat.menu_item("PEN_RADIUS") # Radius
    coat.menu_item("PEN_ROTSN") # Rotation
    coat.menu_item("SMOOTH_DEG") # Smoothing
@d_menu_section(Sliders)
def Sliders_S4():
    coat.menu_item("PEN_MASK") # Opacity
    coat.menu_item("PEN_SPEC") # Glossiness Intensity
    coat.menu_item("DebugLayers") # Debug Layers

@d_menu_section(Sliders)
def Sliders_S_ToggleUI():
    coat.menu_item("ToggleUI")
    coat.menu_hotkey("Tab", 0, 0, 0)

@d_menu_section(Sliders)
def Sliders_S_Pick():
    coat.menu_item("Pick_color") # Pick Color/Depth/Glossiness
    coat.menu_hotkey("V", 0, 0, 0) # V
    coat.menu_item("Pick_layer") # Pick Current Layer/Volume
    coat.menu_hotkey("H", 0, 0, 0) # H
    coat.menu_item("Pick_layer_add") # Pick layer add
    coat.menu_hotkey("H", 1, 0, 0) # SHIFT+H
    coat.menu_item("Pick_layer_sub") # Pick layer sub
    coat.menu_hotkey("H", 0, 1, 0) # CTRL+H


@d_menu_section(WindowsMenu) 
def Windows_S_UIColorThemesList():
   coat.menu_item("UIColorThemesList")

@d_menu_section(WindowsMenu) 
def Windows_S_Default():
   coat.menu_item("ResetThisPageToDefault") # Reset This Page to Default
   coat.menu_item("ResetAllPagesToDefault") # Reset all Pages to Default

@d_menu_section(WindowsMenu) 
def Windows_S_Restore():
   coat.menu_item("StoreThisPageLayout") # Store This Page Layout
   coat.menu_item("RestoreThisPageLayout") # Restore This Page Lyout

@d_menu_section(WindowsMenu) 
def Windows_S_RestoreAll():
   coat.menu_item("StoreAllPagesLayout") # Store Workspace
   coat.menu_item("RestoreAllPagesLayout") # Restore Workspace

@d_menu_section(WindowsMenu) 
def Windows_S_Reset():
   coat.menu_item("ResetDefaultPagesVisibility") # Make all default rooms visible
   coat.menu_item("ResetAllPagesVisibility") # Make all rooms visible
   coat.menu_item("HideCurrentRoom") # Hide the current room
   coat.menu_item("AddNewRoom") # Add new room

@d_menu_section(WindowsMenu) 
def Windows_S_ToggleUI():
   coat.menu_item("ToggleUI") # Toggle Popup/Docked Windows
   if coat.menu_hotkey("TAB", 0, 0, 0):
        if not coat.lock_ui_changes():
            coat.menu_separator()
            coat.menu_item("CustomizeUI") # Customize UI
 
   coat.menu_insert_extensions("Windows")
