import coat
from cTemplates.Structs import *

GeometryMenu = MainMenu("VoxelsMenu")

@d_menu_section(GeometryMenu)
def S_base():
   coat.menu_item("ShowStatistics") # Show Statistics
   coat.menu_item("DefineUnits") # Define Measurement Units
   coat.menu_item("IncreaseResolution") # Res+
   coat.menu_item("Resample") # Resample
   coat.menu_item("RESAMPLE4SCREEN_TOOL") # Subdivide for screen
   coat.menu_item("MakeSymm") # Symm Copy

@d_menu_section(GeometryMenu)
def S_rooms():
   coat.menu_item("GetObjectFromRetopoRoom") # Retopo mesh -> Sculpt mesh
   coat.menu_item("GetObjectFromPaintRoom") # Paint mesh->Sculpt mesh
   coat.menu_item("GetTexturedObjectFromPaintRoom")
   coat.menu_item("GetSubdObjectFromPaintRoom") # Paint mesh->Subdivide->Sculpt mesh

@d_submenu("AUTOPO", GeometryMenu)
def AUTOPO():
       coat.menu_item("Quadrangulate")
       coat.menu_item("QuadrangulateAndMergePtex")
       coat.menu_item("QuadrangulateAndMerge")
       coat.menu_item("QuadrangulateAndMergeDP")
       coat.menu_separator()
       coat.menu_item("OldStyleQuads")
       coat.menu_separator()
       coat.menu_item("CustomRetopers")
 
@d_menu_section(GeometryMenu)
def S_Extensions():
   coat.menu_insert_extensions("Voxels")
   coat.menu_insert_extensions("Geometry")

@d_menu_section(GeometryMenu)
def S_Surface_Tools():
   if coat.is_surface():
       coat.menu_separator()
       coat.menu_item("Shell") # Shell
       coat.menu_item("CleanSurface") # Clean Surface
       coat.menu_item("CloseSurfHoles") # Close Holes
       coat.menu_item("LegacyFix") # Weld Vertices
       coat.menu_item("Decimate") # Decimate
       coat.menu_item("CleanupMemory") # Cleanup Memory
       coat.menu_item("Decompose") # Object-ify (separate)
 
@d_menu_section(GeometryMenu)
def S_edit():
   coat.menu_item("ClearScene") # Clear
   coat.menu_item("SmoothObject") # Smooth All
   coat.menu_item("UnhideAll") # Unhide All
   coat.menu_item("ToUniformSpaceAll")
   coat.menu_hotkey("X", 0, 1, 0) # CTRL+X
   coat.menu_item("InvertHide") # Invert Hidden
   coat.menu_hotkey("X", 1, 1, 0) # CTRL+SHIFT+X
   coat.menu_item("DeleteHidden") # Delete Hidden
   coat.menu_item("SeparateHidden") # Object-ify Hidden

@d_submenu("VisGhost", GeometryMenu)
def VisGhost():
       coat.menu_item("HideButCurrent") # Isolate
       coat.menu_item("Toggle_vox_visibility") # Toggle Visibility
       coat.menu_hotkey("V", 1, 0, 0) # SHIFT+V
       coat.menu_item("Isolate_ghosting") # Isolate Ghosting
       coat.menu_hotkey("G", 1, 0, 0) # SHIFT+G
       coat.menu_item("Toggle_ghosting") # Toggle Ghosting
       coat.menu_hotkey("G", 0, 0, 0) # G
       coat.menu_item("Invert_vox_visibility")
       coat.menu_hotkey("I", 1, 0, 0)
       coat.menu_separator()
 
@d_submenu("Caching", GeometryMenu)
def Caching():
       coat.menu_item("ToggleCachingVolume") # Toggle Proxy Mode
       coat.menu_item("UnCacheVisible") # Uncache Visible Objects
       coat.menu_item("CacheVisible") # Cache Visible Objects
       coat.menu_item("ClearAllCache") # Clear All Caches
 
@d_submenu("CacheMethod", GeometryMenu)
def CacheMethod():
       coat.menu_item("Reduce2X") # Reduce 2X
       coat.menu_item("Reduce4X") # Reduce 4X
       coat.menu_item("Reduce8X") # Reduce 8X
       coat.menu_separator()
       coat.menu_item("Decimate2X") # Decimate 2X
       coat.menu_item("Decimate4X") # Decimate 4X
       coat.menu_item("Decimate8X") # Decimate 8X
       coat.menu_item("Decimate16X") # Decimate 16X
 
@d_submenu("Highlight", GeometryMenu)
def Highlight():
       coat.menu_item("Highlight")
       coat.menu_item("HighlightSettings") # Highlight settings
       coat.menu_item("HighlightSelected") # Highlight selected
       coat.menu_hotkey("F11", 0, 0, 0) # F11
 
@d_menu_section(GeometryMenu)
def S_Sculpt():
   coat.menu_item("SculptSelParams")
   coat.menu_item("RenderSculptSelection")
@d_menu_section(GeometryMenu)
def S_GPU():
   coat.menu_item("UseCUDA") # Use CUDA
   coat.menu_item("CudaSmoothBoost") # Cuda Smooth Boost
@d_menu_section(GeometryMenu)
def S_Render():
   coat.menu_item("CastShadows") # Cast Shadows
   coat.menu_item("IncrementalRender") # Incremental Render
   coat.menu_item("AccurateSmoothing") # Accurate Smoothing
   coat.menu_item("MoveBasedGrowth") # Stroke Expansion
