import coat
from cTemplates.Structs import *

CurvesMenu = MainMenu("Curves")
@d_menu_section(CurvesMenu)
def S_Edit():
   coat.menu_item("ActivateCurvesEditor") # Activate curves editor
   coat.menu_item("CurvParamsPopup")
   coat.menu_hotkey("Q", 0, 0, 0)
   coat.menu_item("StopEditCurves") # Stop edit curves
   coat.menu_item("StopEditCurvesAndHide")
   coat.menu_item("HideSelectedCurves")
   coat.menu_item("SplineUsageHint") # Curves usage hint
   coat.menu_item("CurvesTree") # Curves tree
   coat.menu_item("RecordStrokes") # Record strokes

@d_menu_section(CurvesMenu)
def S_File():
   coat.menu_item("SaveCurve") # Save curve...
   coat.menu_item("SaveSeparateCurves") # Save curves separately...
   coat.menu_item("LoadCurve") # Load curve...
   coat.menu_item("LoadCurveAsImage") # Load curve from image...

@d_menu_section(CurvesMenu)
def S_Snap():
   coat.menu_item("cuSnapToSurface") # Snap to surface
   coat.menu_item("cuSnapToPoints") # Snap to curve points
   coat.menu_item("cuSnapToCurve") # Snap to curve
   coat.menu_item("cuSnapToCurveCenter") # Snap to center
   coat.menu_item("cuSnapToDistance") # Quantize length
   coat.menu_item("cuSnapToHorizontalVertical") # Snap to horizontals/verticals
   coat.menu_item("cuSnapSettings") # Snapping settings

@d_menu_section(CurvesMenu)
def S_Render():
   coat.menu_item("RenderCurvesOnBackFaces") # Render curves on back side

@d_submenu("PutOnPlane", CurvesMenu)
def PutOnPlane():
       coat.menu_item("AveragePlane") # Average plane
       coat.menu_item("CmPlaneYZ") # Center mass + YZ - plane
       coat.menu_item("CmPlaneZX") # Center masss + ZX - plane
       coat.menu_item("CmPlaneXY") # Center mass + XY - plane
       coat.menu_item("PlaneYZ") # YZ - plane
       coat.menu_item("PlaneZX") # ZX - plane
       coat.menu_item("PlaneXY") # XY - plane
 
@d_submenu("SM_CurvesOperations", CurvesMenu)
def SM_CurvesOperations():
       coat.menu_item("SeparateDisconnectedCurves")
       coat.menu_item("SM_SplitSelfIntersections") # Split Self Intersections
       coat.menu_item("SM_BooleanOperations") # Boolean Operations
       coat.menu_item("SM_SimplifyCurve") # Simplify Curve
       coat.menu_item("SM_SmoothingCurve") # Smoothing Curve
       coat.menu_item("SM_RemoveSharp") # Remove sharp corners
       coat.menu_item("SM_SubdivideCurve") # Subdivide Curve
       coat.menu_item("SM_ReverseCurveDirection") # Reverse Curve Direction
       coat.menu_item("ToogleDisplayLength") # Toggle length displaying
 
@d_submenu("Modifiers", CurvesMenu)
def Modifiers():
       coat.menu_item("DetachCurvModifierSel") # Detach curve modifiers (selected)
       coat.menu_item("DetachCurvAndRemoveSel") # Detach and delete meshes (selected)
       coat.menu_item("EditCurvModifierPropertiesSel") # Edit curve modifier (selected)
       coat.menu_item("HideCurvModifier") # Hide selected modifiers
       coat.menu_item("HideAllCurvModifiers") # Hide all modifiers
       coat.menu_item("ShowAllCurvModifiers") # Show all modifiers
 
@d_menu_section(CurvesMenu)
def S_Apply():
   coat.menu_item("ApplyCurves") # Apply Curves
   coat.menu_item("StartNewCurve") # Start new curve
   coat.menu_item("RunBrushAlongCurve") # Brush Along Curve
   coat.menu_item("RunBrushAlongProjection") # Run brush along projection
   coat.menu_item("EditPressuerProfile") # Edit Pressure Profile

@d_menu_section(CurvesMenu)
def S_Select():
   coat.menu_item("SelectInProjection") # Select/Freeze projection area
   if coat.IsInRoom("Voxels"):
        coat.menu_item("SelectIn3D") # Select/freeze in 3D space.
        # menu_item("FillByVoxels");/Fill by voxels
        coat.menu_item("CreateFromSelectionEdge") # Freeze/Selection to curve
 
   if coat.IsInRoom("Retopo"):
       coat.menu_item("FillByQuads")
       coat.menu_item("FillByTriangles")
       coat.menu_item("CreateFromSelectedEdges")
       coat.menu_item("CreateFromOpenEdges")
 
   coat.menu_item("AttachToSurface") # Snap to surface
   coat.menu_item("SameRadius") # Assign radius
   coat.menu_item("SetCoordinate")
   coat.menu_item("DelSplines") # Delete all curves
