/*---------------------------------------------------------------------*/
// Mission 1
// Purpose: The simple navigation.
// File: Navigation.as
/*--------------------------------------------------------------------*/

Debug     dbg;
DebugLog  log = dbg.log();


string mission_Explain_ID = "Navigation_Explain_Highlighting";
string mission_Complete_ID = "Mission_Is_Complete";
string mission_Not_Complete_ID = "Mission_Not_Complete";
string Navigation_Explain_Highlighting_Rotate = "Navigation_Explain_Highlighting_1";
string Navigation_Explain_Highlighting_Move = "Navigation_Explain_Highlighting_2";
string Navigation_Explain_Highlighting_Scale = "Navigation_Explain_Highlighting_3";
string mission_Abort = "Mission_Abort";
string orange_Color = "4292730333";

int FontID = 0;
  
string GetCommandMessage(string explainMessage) {
  int X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int Y0 = 8 * GetWorkAreaHeight() / 100;
  string MSG = "";
  MSG += X0;
  MSG += ";";
  MSG += Y0;
  MSG += ";";
  MSG += explainMessage;
  MSG += ";1";
  MSG += ";";
  MSG += orange_Color;
  MSG += ";0";
  MSG += ";0,0,0,";
  MSG += GetTextID("EXIT");
  MSG += ",1,";
  MSG += orange_Color;
  MSG += ",0";
  return MSG;
}

void PreinitMission(){
}

void GoToStartMission() {
	SetShowModalDlg(false);
	cmd("$SETPAGE_Sculpt");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
	SetShowModalDlg(true);
}

void main() {

log.clear();
log += "Start Mission";

// Create the new scene
UI ui;
SculptLayer sl;
SculptRoom  room;
Builder  builder;

ui.enableWindow("STARTMENU", false);

room.clear();

cmd ("$SETPAGE_Sculpt");
cmd ("$StopEditCurves");

Mesh  b =  builder.cuboid().side( 150 ).build();
room += b;
  
sl.rename( "Cube" );
sl.select("Cube").toVoxel();

FontID = GetFontFileID("Fira_Sans_Condensed_16");
cmd ("$SCULP_GROW");
cmd ("$PENOP0");

int X = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
int Y = GetWorkAreaHeight() / 2;
int istatus = 1;
bool noExit = true;
 
string mission_Explain = GetTextID(mission_Explain_ID);
string Msg = GetCommandMessage(mission_Explain);
while (noExit) {
	Step( 1 ); //Rendering cycle
	if(istatus == 0 || istatus == 6) { noExit = false; break; }
	
	// LBM processing (without ALT) ...
	if(istatus == 1)istatus = LBMObject(false);
	
	// RBM processing (without ALT) ...
	if(istatus == 2) istatus = RMBObject(false);
	
	// MMB processing (without ALT) ...
	if(istatus == 3) istatus = MMBObject(false);

	// LBM processing (with ALT) ...
	if(istatus == 4) istatus = LBMObject(true);
	
	// RBM processing (with ALT) ...
	if(istatus == 5) istatus = RMBObject(true);
	
}

if ( istatus > 0 ){
	int iret = 1;
	int istatus = 0;
	bool quit = false;
    while (!quit) {
		Step(1);
		if (iret == 0 || istatus == 7 || iret == 8) { quit == true; break;}
		if (iret == 1) iret = DoHighlightItems(Navigation_Explain_Highlighting_Rotate,0);
		if (iret == 5) { istatus |= 0x1; iret = 2;}
		if (iret == 2) iret = DoHighlightItems(Navigation_Explain_Highlighting_Move,1);
		if (iret == 2) iret = 3;
		if (iret == 5) { istatus |= 0x2; iret = 3;}
		if (iret == 3) { 
			iret = DoHighlightItems(Navigation_Explain_Highlighting_Scale,2);
			if (iret == 2) iret = 8;
			if (iret == 1) iret = 2;
		}
		if (iret == 5) { istatus |= 0x4; iret = 1;}
	}
	if ( iret == 0) {
		log += "Abort Mission";
		Wait( 1000 );
		SetFloatingMessageBoxTime(X, Y, mission_Abort, orange_Color,0,3000);
		SetScriptMessage("reset","");
		GoToStartMission();
		room.clear();
	} else {
		Wait( 500 );
		if ((istatus & 0x07)==0x07) {
			SetFloatingMessageBoxTime(X, Y, mission_Complete_ID, orange_Color,0,5000);
		} else {
			SetFloatingMessageBoxTime(X, Y, mission_Not_Complete_ID, orange_Color,0,5000);
		}
		log += "End Mission";
		GoToStartMission();
		room.clear();
	}
} else {
	log += "Abort Mission";
	Wait( 1000 );
	SetFloatingMessageBoxTime(X, Y, mission_Abort, orange_Color,0,3000);
	SetScriptMessage("reset","");
	SetShowModalDlg(false);
    GoToStartMission();
	SetShowModalDlg(true);
}
}

int DoHighlightItems(string str, int i){
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	int iret = (i + 3); // 3,4,5 
	bool noExit = true;
	bool bFirst = true;
	float xStart;
    float yStart;
	SetFloatingMessageBox(XX, YY, str, orange_Color,(i==0)?3:((i==1)?4:4));
	string IDCmd;
	if ( i==0 ) IDCmd = "$NAVIROTATE";
	else if( i==1 ) IDCmd = "$NAVIMOVE";
	else IDCmd = "$NAVISCALE";
	
    while (noExit) {
		Step(10);
		float X = GetMouseX();
        float Y = GetMouseY();
		HighlightUIElement(IDCmd, 0.5);
	    if(LMBPressed()){
			int Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status == 0) { noExit = false; iret = 0; } //abort
			else if (Status == 1) { noExit = false; iret=1;} //back
			else if (Status == 2) { noExit = false; iret=2; } //next	
		}
        while (LMBPressed()&& noExit) { 
            Step( 10 ); //Rendering cycle
            if(bFirst && WasRecentlyPressed(IDCmd, 1)){
                xStart=GetMouseX();
                yStart=GetMouseY();
				bFirst=false;
            }
            float x=GetMouseX();
            float y=GetMouseY();
           	if (!WasRecentlyPressed(IDCmd, 3) && (bFirst==false)) {
				if (abs(x-xStart) > 1 || abs(y-yStart) > 1) {
					SetScriptMessage("reset","");
					SetFloatingMessage(XX,YY,"Well_Done",orange_Color);
					Wait( 2000 );
					iret = 5;
					noExit = false;
					break;
				}
			}
	    } // while LMBPressed()
        bFirst = true;
    } // while noExit
	SetScriptMessage("reset","");
    return iret;
}
// Left mouse
int LBMObject(bool inSide) {

    bool bFirst = true;
    bool noExit = true;
	float xStart;
    float yStart;
    string explain;
    if (inSide) {
        explain = "Set_LBM_Inside_Move_Object";
    } else {
        explain = "Set_LBM_Outside_Move_Object";
    }
	int iret = (inSide)?5:2;
	
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	
	SetFloatingMessageBox(XX, YY, explain, orange_Color,(inSide)?4:3);
	log += "\n start while noExit";
    while(noExit) {
        Step( 10 ); //Rendering cycle
        float X = GetMouseX();
        float Y = GetMouseY();
	    log += "  X Y " + X + " " + Y;
        bool bAlt = (inSide)? Alt():true;
		bool bObj = true;
        log += "  bAlt " + (bAlt ? "true" : "false");
        log += "  start while LMBPressed()";
		if(LMBPressed()){
			int Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status == 0) { noExit = false; iret = 0; } //abort
			else if (Status == 1) { noExit = false; iret=3;} //back
			else if (Status == 2) { noExit = false; iret=(inSide)?5:2; } //next
			if(bFirst){
                xStart=GetMouseX();
                yStart=GetMouseY();
			    log += "    bFirst xStart yStart " + xStart + " " + yStart;
                bFirst=false;
				bObj = ScreenRayPicksObject(xStart,yStart);
				log += "  bObj " + (bObj ? "true" : "false");
				if (!inSide) {
					bObj = !bObj;
				}
			}
		}
        while (LMBPressed() && bAlt && noExit) { //ALT
            Step( 10 ); //Rendering cycle
			float x=GetMouseX();
            float y=GetMouseY();
            log += "    x y " + x + " " + y;
			if ( bObj ) {
				if (abs(x-xStart) > 50) {
					SetScriptMessage("reset","");
					if ( inSide ) SetFloatingMessage(XX,YY,"Well_Done",orange_Color);
					else SetFloatingMessage(XX,YY,"Cool",orange_Color);
					Wait( 2000 );
					noExit = false;
					break;
				}
			}
            bAlt = (inSide)? Alt():true;
        } // while LMBPressed()
        log += "  stop while LMBPressed()";

        if (IsPressKeyID(0x1B)) {
            noExit = false;
	    }
        bFirst = true;
    } // while noExit
    log += "stop while noExit\n";

    SetScriptMessage("reset","");
    
    return iret;
}

// Right mouse
int RMBObject(bool inSide) {
bool bFirst = true;
bool noExit=true;
float xStart;
float yStart;
string explain;
if (inSide) {
	explain = "Set_RBM_Inside_Move_Object";
} else {
	explain = "Set_RBM_Outside_Move_Object";
}
int iret = (inSide)?6:3;

int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
int YY = 8 * GetWorkAreaHeight() / 100;

SetFloatingMessageBox(XX, YY, explain, orange_Color,4);
while(noExit) {
    Step(10); //Rendering cycle
	float X = GetMouseX();
	float Y = GetMouseY();
	bool bAlt = (inSide)? Alt():true;
	bool bObj = true;
	if (LMBPressed())
	{
		int Status = ScriptMessagePressButton(X,Y);
		// check status (<-,stop,->)
		if (Status == 0) { noExit = false; iret = 0; } //abort
		else if (Status == 1) { noExit = false; iret=(inSide)?4:1;} //back
		else if (Status == 2) { noExit = false; iret=(inSide)?6:3; } //next	
	}
	if (RMBPressed()){
		if(bFirst){
		    xStart = GetMouseX(); 
            yStart = GetMouseY();
			bObj = ScreenRayPicksObject(xStart,yStart);
			if (!inSide) bObj = !bObj; 
			bFirst = false;
		}
	}
	while (RMBPressed() && bAlt){
		Step( 10 ); //Rendering cycle
	    float x=GetMouseX(); 
        float y=GetMouseY();
		if ( bObj )
		{
		    float r = sqrt( (x-xStart)*(x-xStart) + (y-yStart)*(y-yStart) );
			if (r > 50) {
				SetScriptMessage("reset","");
				if( inSide) SetFloatingMessage(XX,YY,"Super",orange_Color);
				else SetFloatingMessage(XX,YY,"Very_Good",orange_Color);
				Wait( 2000 );
				noExit = false;
				break;
			}
	    }
		bAlt = (inSide)? Alt():true;
	}
	if (IsPressKeyID(0x1B)) {
	    noExit = false;
	}
    bFirst=true;
}
	SetScriptMessage("reset","");
	return iret;
}

// Medium mouse
int MMBObject(bool inSide) {
bool bFirst = true;
bool noExit=true;
float xStart;
float yStart;
string explain;
if (inSide) {
	explain = "Set_WMB_Inside_Move_Object";
} else {
	explain = "Set_WMB_Outside_Move_Object";
}
int iret = (inSide)?7:4;

int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
int YY = 8 * GetWorkAreaHeight() / 100;

SetFloatingMessageBox(XX, YY, explain, orange_Color,4);
while(noExit) {
    Step(10); //Rendering cycle
	float X = GetMouseX();
	float Y = GetMouseY();
	bool bAlt = (inSide)? Alt():true;
	bool bObj = true;
	if ( LMBPressed())
	{
		int Status = ScriptMessagePressButton(X,Y);
		// check status (<-,stop,->)
		if (Status == 0) { noExit = false; iret = 0; } //abort
		else if (Status == 1) { noExit = false; iret=(inSide)?5:2;} //back
		else if (Status == 2) { noExit = false; iret=(inSide)?7:4;} //next	
	}
	if ( MMBPressed() )
	{
		if(bFirst){
            xStart = GetMouseX(); 
            yStart = GetMouseY();
			bObj = ScreenRayPicksObject(xStart,yStart);
			if (!inSide) bObj = !bObj;
            bFirst = false;
		}
	}
	while (MMBPressed() && bAlt){
		Step( 10 ); //Rendering cycle
        float x=GetMouseX(); 
        float y=GetMouseY();
		if ( bObj )
		{
			float r = sqrt( (x-xStart)*(x-xStart) + (y-yStart)*(y-yStart) );
			if (r > 50) {
				SetScriptMessage("reset","");
				if ( inSide ) SetFloatingMessage(XX,YY,"Excellent",orange_Color);
				else SetFloatingMessage(XX,YY,"Kudos",orange_Color);
				Wait( 2000 );
				noExit = false;
				break;
			}   
		}
    }
	if (IsPressKeyID(0x1B)) {
	    noExit = false;
	}
    bFirst=true;
}
SetScriptMessage("reset","");
return iret;
}











