/*-----------------------------------------------*/
// Mission 3
// Purpose: Drawing modes (Select from E-panel) 
// File: DrawModes.as
/*-----------------------------------------------*/
Debug     dbg;
DebugLog  log = dbg.log();

string cmd_press_e_key = "Press_E_key";
string cmd_press_e_next_key = "Press_E_key_next";
string cmd_select_e_mode = "Select_E_mode";
string mission_Explain = "Pen_Drawing";
string mission_Complete = "Mission_Complete";
string mission_Abort = "Mission_Abort";
string orange_Color = "4292730333";
string cmd_strings = "$PENOP0,$PENOP1,$PENOP2,$PENOP3,$PENOP4,$PENOP5,$PENOP6,$PENOP7,$PENOP8,$PENOP9,$PENOP10,$PENOP11,$PENOP12,$PENOP13,$PENOP14,$PENOP15,$PENOP16,$PENOP17,$PENOP18,$PENOP19";

int status_OK = 0;
int X0 = 0;
int Y0 = 0;
int CODE_START = 5;
int CMD_Code = 0;

enum PENMODE {
 OP_None = -1,
 OP_RD=0,
 OP_DO=1,
 OP_RDO=2,
 OP_Droplet=3,
 OP_Constant=4,
 OP_DotStroke=5,
 OP_VertexLine=6,
 OP_VertexCurve=7,
 OP_CurveStroke=8,
 OP_StampMode=9,
 OP_StampDragMode=10,
 OP_SquareLasso=11,
 OP_RectangleLasso=12,
 OP_VertexLasso=13,
 OP_StrokeLasso=14,
 OP_CircleLasso=15,
 OP_EllipseLasso=16,
 OP_ClosedSpline=17,
 OP_3DClosedSpline=18,
 OP_SinglePolygon=19,
 OP_ALL=20
 }
 
 void GoToStartMission() {
	cmd("$SETPAGE_Paint");
	cmd("$StopEditCurves");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
	cmd("$StopEditCurves");
}

void main() {
    
	UI  ui;
    SculptLayer sl;
    SculptRoom  room;
   
    int missionDone = 0;
	bool inSculptRoom = false;
	bool bAbort = false;
	
	ui.enableWindow("STARTMENU",false);
	
    room.clear();
	
	ui.enableWindow("Layers_SINGLE",false);
   
    cmd ("$SETPAGE_Paint");
	cmd ("$PENOP0");
   
    int FontID = GetFontFileID("Fira_Sans_Condensed_16");
	 
	X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	Y0 = 8 * GetWorkAreaHeight() / 100;
	
	//ShowMessageWhilePressKey(X0, Y0, mission_Explain, orange_Color, 0x0D, "HighlightingItem");
	
	SetFloatingMessageBox(X0, Y0, mission_Explain, orange_Color, 1);
	
	int istatus = 1;
	bool noExit = true;
  
	while(noExit) {
		Step(1);
		HighlightUIElement("$ID_PENOPS",0.1);
		float X = GetMouseX();
		float Y = GetMouseY();
		if(LMBPressed()){
			istatus = ScriptMessagePressButton(X,Y);
			if (istatus == 0) { noExit = false; } //abort
		}
		if (IsPressKeyID(0x0D)) {
			noExit = false;
			istatus = 1;
		}
	}
		
	SetScriptMessage("reset","");
	
	if ( istatus == 0) {
		SetShowModalDlg(false);
		GoToStartMission();
		SetShowModalDlg(true);
		return;
	}	
	
	SetShowModalDlg(false);
	
	ppp("Samples/sphere.obj");
  
	SetShowModalDlg(true);
	
	sl.rename( "Sphere" );
	
	cmd ("$SETPAGE_Paint");
	
	EnablePenChannel(0,true);
	EnablePenChannel(1,true);
	EnablePenChannel(3,true);
	
	SetSliderValue("$PEN_RADIUS",20);
	
	for( int i = OP_RD; i < OP_ALL; i++) missionDone |= (1 << i);

	
	noExit = true;
	int mission_codes = 0;
	
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
    int YY = 8 * GetWorkAreaHeight() / 100;
  
    SetFloatingMessageBox(XX, YY, cmd_press_e_key, orange_Color,1);
	
	while ( noExit) {
		Step(1);
		if (IsPressKeyID(0x45)) { // 'e'
			SetScriptMessage("reset","");
			Wait( 1000 );
			SetFloatingMessageBox(XX, YY, cmd_select_e_mode, orange_Color,1);
		    noExit = false;
		}
		if(LMBPressed()){
			float X = GetMouseX();
			float Y = GetMouseY();
			int Status = ScriptMessagePressButton(X,Y);
			if (Status == 0) { 
				noExit = false; 
				bAbort = true;
				break;
			}
		}
	}
	if ( bAbort) {
		SetScriptMessage("reset","");
		Wait( 1000 );
		SetFloatingMessage(XX, YY, mission_Abort, orange_Color);
		log += "Abort Mission";
		Wait( 2000 );
		SetScriptMessage("reset","");
		room.clear();
		SetShowModalDlg(false);
		GoToStartMission();
		SetShowModalDlg(true);
		return;
	}
	
	noExit = true;
    while ( noExit) {
	int cmd_Code = OP_None;
	
	Step(10); //Rendering cycle
	
	inSculptRoom = IsInRoom( "Sculpt" );
  	if( !inSculptRoom ) missionDone &= (~( 1 << OP_3DClosedSpline));
	else missionDone = missionDone | ( 1 << OP_3DClosedSpline);
	
	float X = GetMouseX();
    float Y = GetMouseY();
	if(LMBPressed()){
		int Status = ScriptMessagePressButton(X,Y);
		if (Status == 0) { 
			noExit = false; 
			bAbort = true;
			break;
		}
	}
	
	if (IsPressKeyID(0x45)) { // 'e'
		SetScriptMessage("reset","");
		Wait( 500 );
		//SetFloatingMessageBox(XX, YY, cmd_press_e_next_key, orange_Color,1);
	}
	cmd_Code = FindRecentlyPressed(cmd_strings,3);
	log += cmd_Code;
	if ( cmd_Code == OP_3DClosedSpline) {
		if (!inSculptRoom) {
			cmd_Code = OP_None;
		}
	}
	
	if ( cmd_Code >= 0) {
	   CMD_Code = cmd_Code; 
	   SetScriptMessage("reset","");
	   Wait( 1000 );
	   log += "cmd_Code";
	   if(CommandIsDone(cmd_Code)) {
		  mission_codes |= (1 << cmd_Code);
		  string str_msg;
		  switch(cmd_Code) {
			case OP_RD:
				 str_msg = "Radius_Depth";//"Radius and Depth";
				 break;
			case OP_RDO:
				 str_msg = "Radius_Depth_Opacity";//"Radius, Depth and Opacity";
				 break;
			case OP_DO:
				 str_msg = "Depth_Opacity";//"Depth and Opacity";
				 break;
			case OP_Droplet:
				 str_msg = "Droplet";
				 break;
			case OP_Constant:
				 str_msg = "Constant";
				 break;				
			case OP_DotStroke:
				 str_msg = "Dot_Stroke"; //"Dot Stroke.";
				 break;
			case OP_VertexLine:
				 str_msg = "Vertex_Line";//"Vertex line.";
				 break;
			case OP_VertexCurve:
				 str_msg = "Vertex_Curve";//"Vertex Curve.";
				 break;
			case OP_CurveStroke:
				 str_msg = "Curve_Stroke";//"Curve Stroke.";
				 break;
			case OP_StampMode:
				 str_msg = "Stamp_Mode";//"Stamp Mode.";
				 break;
			case OP_StampDragMode:
				 str_msg = "Stamp_Drag_Mode";//"Stamp Drag Mode.";
				 break;
			case OP_SquareLasso:
				 str_msg = "Square_Lasso"; //"Square Lasso.";
				 break;
			case OP_RectangleLasso:
				 str_msg = "Rectangle_Lasso"; //"Rectangle Lasso.";
				 break;
			case OP_VertexLasso:
				 str_msg = "Vertex_Lasso"; //"Vertex Lasso.";
				 break;
			case OP_StrokeLasso:
				 str_msg = "Stroke_Lasso"; //"Stroke Lasso.";
				 break;
			case OP_CircleLasso:
				 str_msg = "Circle_Lasso"; //"Circle Lasso.";
				 break;
			case OP_EllipseLasso:
				 str_msg = "Ellipse_Lasso"; //"Ellipse Lasso.";
				 break;
			case OP_ClosedSpline:
				 str_msg = "Closed_Spline"; //"Closed Spline.";
				 break;
			case OP_3DClosedSpline:
				 str_msg = "Closed_3D_Spline"; //"Closed 3D Spline.";
				 break;
			case OP_SinglePolygon:
				 str_msg = "Single_Polygon"; //"Single Polygon";
				 break;
		  }
		  SetScriptMessage("reset","");
 		  SetFloatingMessage(XX,YY,str_msg,orange_Color);
		  Wait( 3000 );
		  SetScriptMessage("reset","");
		  SetFloatingMessageBox(XX, YY, cmd_press_e_next_key, orange_Color,1);
		  
		  cmd_Code = -1;
		  log += "cmd_Code";
		  if (IsPressKeyID(0x1b)) {
			 noExit = false;
			 SetScriptMessage("reset","");
		  }
	   }
	   if ( mission_codes == missionDone ) {
	        noExit = false;
	   }
	 }// code >=0
	}
	if ( mission_codes == missionDone) {
		SetScriptMessage("reset","");
		SetFloatingMessageBoxTime(XX, YY, mission_Complete, orange_Color,0,3000);
		log += "End Mission";
		room.clear();
		ui.enableWindow("Layers_SINGLE",false);
		SetShowModalDlg(false);
		GoToStartMission();
		SetShowModalDlg(true);
	} else {
		 int nPenDraws = 0;
		 SetScriptMessage("reset","");
		 for( int i = OP_RD; i < OP_ALL; i++) {
			if ( (mission_codes & (1 << i)) == (1 << i)) nPenDraws++;
		 }
		 string rmsg = GetTextID("You_Done");
		 rmsg += " ";
		 rmsg += nPenDraws;
		 rmsg += " ";
		 rmsg += GetTextID("Items"); 
		 if (bAbort ) {
			SetFloatingMessage(XX, YY, mission_Abort, orange_Color);
			log += "Abort Mission";
			Wait( 2000 );
			SetScriptMessage("reset","");
		 }
		 SetFloatingMessageBoxTime(XX, YY, rmsg, orange_Color,0,3000);
		 if(!bAbort ){ 
		 } else {
		 	log += "Abort Mission";
			Wait( 2000 );
			SetScriptMessage("reset","");
		} 
		room.clear();
		ui.enableWindow("Layers_SINGLE",false);
		SetShowModalDlg(false);
		GoToStartMission();
		SetShowModalDlg(true);
	} 
	log.clear();
}

void HighlightingItem(){
	Step(1);
	HighlightUIElement("$ID_PENOPS",0.1);
}

void WhileLMBPressed() {
	 while (LMBPressed()) {  
	 Step(10);  
	}
}
 int PEN_DrawPressed(int i){
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
    int YY = 8 * GetWorkAreaHeight() / 100;
	if ( i == 1) {
	 SetScriptMessage("reset","");
	 SetFloatingMessage(XX,YY,"Closed_Spline",orange_Color);
	 Wait( 2000 );
	}
	SetScriptMessage("reset","");
	SetFloatingMessage(XX,YY,"Press_Curve_Exit_Draw",orange_Color);
	return 1;
 }
 
 int PEN_DrawVertex(int icode){
 	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
    int YY = 8 * GetWorkAreaHeight() / 100;
	if ( icode == OP_VertexLasso || icode == OP_CurveStroke ) {
		SetScriptMessage("reset","");
		if( icode == OP_VertexLasso) 
			SetFloatingMessage(XX,YY,"Press_DBL_Exit_Draw",orange_Color);
		else 
			SetFloatingMessage(XX,YY,"Press_DBL_Enter_Exit_Draw",orange_Color);
		Wait( 2000 );
	}
	return 1;
 }

bool CommandIsDone(int code) 
{
 bool noExit = true;
 bool bDone = false;
 
 int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
 int YY = 8 * GetWorkAreaHeight() / 100;
 int drawCount = 0;
 bool bExitDraws = false;
 bool wasPressed = false;
 	if (code == OP_DotStroke) {
	 	log += code;
		while (!bDone) {
			Step(1);
			float X=GetMouseX(); 
			float Y=GetMouseY(); 
			bool bObj = ScreenRayPicksObject(X,Y);
			while (LMBPressed() && bObj ) {
				Step(1);
				wasPressed = true;
			} 
			if( wasPressed ) {
				drawCount++; 
				wasPressed = false;
			}
			if( drawCount > 3 ) {
				bDone = true;
				drawCount = 0;
			}
	  }
	} else if ( code == OP_VertexLine || 
	            code == OP_VertexCurve  ) {

		drawCount = 0;
		bExitDraws = false;
		bool bFirst = true;
		bool isDraw = false;
		float xStart,yStart;
		while (!bDone) {
			Step(1);
			float X=GetMouseX(); 
			float Y=GetMouseY(); 
			bool bObj = ScreenRayPicksObject(X,Y);
	
			if (IsPressKeyID(0x1b)) {
				bExitDraws = true;
				SetScriptMessage("reset","");
			}
			while(LMBPressed() && bObj) {
				Step(1);
				wasPressed = true;
				if (IsPressKeyID(0x1b)) {
					bExitDraws = true;
					SetScriptMessage("reset","");
				}
				if(bFirst){
					xStart=GetMouseX(); 
					yStart=GetMouseY();
					bFirst=false;
				}
				float x=GetMouseX(); 
				float y=GetMouseY();
				float r = sqrt( (x-xStart)*(x-xStart) + (y-yStart)*(y-yStart) );
				if (r > 10 && (!isDraw)) {
					SetScriptMessage("reset","");
					SetFloatingMessage(XX,YY,"Press_Esc_Exit_Draw",orange_Color);
					isDraw = true;
				}
			}
			bFirst=true;			
			if( wasPressed ) {
				drawCount++; 
				wasPressed = false;
			}
			if(( drawCount > 0 ) && bExitDraws) {
				bDone = true;
			}
		} 
	} else if (code == OP_ClosedSpline) {
			bExitDraws = false;
			drawCount = 0;
			SetScriptMessage("reset","");
			SetFloatingMessage(XX,YY,"Press_Curve_Exit_Draw",orange_Color);
			while (!bDone) {
				Step(1);
				int count = PenDrawLines("PEN_DrawPressed");
				if ( count > 0 ) {
					bDone = true;
				}
			}
	} else if (code == OP_CurveStroke || code == OP_VertexLasso ){
			bExitDraws = false;
			int drawCount = PenDrawVertex(code,"PEN_DrawVertex");
			if ( drawCount > 0 ) {
				 bDone = true;
			}
	}
	else if (code == OP_StampMode ||
			   code == OP_StampDragMode ||
			   code == OP_SquareLasso ||
			   code == OP_RectangleLasso ||
			   code == OP_CircleLasso ||
			   code == OP_EllipseLasso ||
			   code == OP_StrokeLasso ||
			   code == OP_3DClosedSpline ||
			   code == OP_SinglePolygon ) {
		float xStart = 0;
		float yStart = 0;
		while (!bDone) {
			Step(1);
			bool bFirst = true;
			bool bAlt = Alt();
			float X=GetMouseX(); 
			float Y=GetMouseY(); 
			bool bObj = ScreenRayPicksObject(X,Y);
			while (LMBPressed() && bObj ) {
				Step(1);
				wasPressed = true;
				if(bFirst){
					xStart=GetMouseX(); 
					yStart=GetMouseY();
					bFirst=false;
				}
				if((!bAlt) && 
					code != OP_StampMode && 
				    code != OP_StampDragMode &&
					code != OP_SinglePolygon) { 
					float x=GetMouseX(); 
					float y=GetMouseY();
					float r = sqrt( (x-xStart)*(x-xStart) + (y-yStart)*(y-yStart) );
					if (r > 10) {
						bExitDraws = true;
					}
				}
			} 
			bFirst = true;
			if( wasPressed ) {
				if(false==bAlt) drawCount++; 
				wasPressed = false;
			}
			bExitDraws = (code == OP_StampMode || code == OP_StampDragMode || code == OP_SinglePolygon) ? (drawCount > 2):(bExitDraws&&(drawCount>1));
			if( bExitDraws ) {
				bDone = true;
				drawCount = 0;
			}
		}
	} else if ( code == OP_RD ||
				code == OP_DO ||
				code == OP_RDO ||
				code == OP_Droplet ||
				code == OP_Constant) {
				bool bFirst = true;
				float xStart = 0;
				float yStart = 0;
				log += code;
				while (!bDone) {
					Step(10);
					bool bAlt = Alt();
					float X=GetMouseX(); 
					float Y=GetMouseY(); 
					bool bObj = ScreenRayPicksObject(X,Y);
					while (LMBPressed() && bObj ) {
						Step(10);
						if(bFirst){
							xStart=GetMouseX(); 
							yStart=GetMouseY();
							bFirst=false;
						}
						if (!bAlt) {
							float x=GetMouseX(); 
							float y=GetMouseY();
							float r = sqrt( (x-xStart)*(x-xStart) + (y-yStart)*(y-yStart) );
							if (r > 20) {
								bDone = true;
								bObj = false;
								drawCount = 0;
								log += "code 0-4";
								break;
							}
						}
					}
				}
			}
  return bDone;
}