/*------------------------------------------------------------------------------*/ 
// Mission 4
// Purpouse: Sculpting draw (cut off mode)
// File: CutOff.as
/*-----------------------------------------------------------------------------*/

Debug     dbg;
DebugLog  log = dbg.log();
string mission_Abort = "Mission_Abort";
string mission_Explain = "CutOff_Eplain";
string mission_Complete_ID = "Mission_Complete";
string cmd_CutOFF = "$[Page4]Cut Off";
string orange_Color = "4292730333";

void GoToStartMission() {
	cmd("$SETPAGE_Sculpt");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
}

 void main() {
  UI  ui;
  SculptLayer sl;
  SculptRoom  room;
  Builder  builder;
 
  ui.enableWindow("STARTMENU", false);
  
  log.clear();
  log += "Start CLEARSCENE";
  
  room.clear();
  
  cmd ("$SETPAGE_Sculpt");
  cmd("$PENOP0");
  cmd (cmd_CutOFF);
  
 
  Mesh  b =  builder.sphere().radius( 150 ).build();
  room += b;
  
  sl.rename( "Sphere" );
  sl.select("Sphere").toVoxel();
  
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
  
  int FontID = GetFontFileID("Fira_Sans_Condensed_16");

  SetFloatingMessageBox(XX, YY, mission_Explain, orange_Color,1);
  
  cmd (cmd_CutOFF);
  
  int ret = 0;
  for (int i = 0; i < 2; i++) {
   ret = CutOff();
   if(ret != 0)  break;
  }
  SetScriptMessage("reset","");
  if ( ret != -1) {
	SetFloatingMessageBoxTime(XX, YY, mission_Complete_ID, orange_Color,0,5000);
	log += "End Mission";
	SetShowModalDlg(false);
	GoToStartMission();
	SetShowModalDlg(true);
	room.clear();
  } else {
 	SetFloatingMessage(XX, YY, mission_Abort, orange_Color); 
    Wait( 3000 );
    SetScriptMessage("reset","");
	SetShowModalDlg(false);
	GoToStartMission();
	SetShowModalDlg(true);
	room.clear();
  } 
}

int CutOff() {
bool bFirst = true;
bool bCutOK = false;
bool noExit = true;
float xStart;
float yStart;
cmd (cmd_CutOFF);
while(noExit) {
    Step(1); //Rendering cycle
	if (IsPressKeyID(0x1B)) {
		noExit = false;
		if ( bCutOK ) return 1;
		return -1;
    }
	float X = GetMouseX();
	float Y = GetMouseY();
	while (LMBPressed()) { 
		Step(1);
        if(bFirst){
            xStart=GetMouseX(); 
            yStart=GetMouseY();
            bFirst=false;
        }
        float x=GetMouseX(); 
        float y=GetMouseY();
		int Status = ScriptMessagePressButton(x,y);
		if (Status == 0) { noExit = false; return -1;}
        bool bObj = ScreenRayPicksObject(X,Y);
		if (bObj) {
            bCutOK = true;
        }   
   }
   if (bCutOK) noExit = false;
} return 0;
}
