void CreateFileMenu() {
	start_main_menu("FILE");
	menu_item("CLEARSCENE");///New
	menu_hotkey("N", 0, 1, 0);///CTRL+N
	menu_item("OPEN_FILE");///Open
	menu_hotkey("O", 0, 1, 0);///CTRL+O
	menu_item("RecentFiles");///Open Recent
	menu_item("Autosave");///Autosave
	if (!is_new_scene())menu_item("Applinks");///Applinks
	menu_submenu("Install");
	{
		menu_item("InstallExtension");///Install Extension
		menu_item("InstallQuixelAssetAsMaterial");///Install Quixel asset as Smart Material
		menu_item("InstallQuixelAssetAsShader");///Install Quixel asset as Shader
		menu_item("InstallQuixelAssetAsFacture");///Install Quixel asset as VerTexture
		menu_exit();
	}
	menu_item("CreateExtension");///Create Extension

	menu_submenu("Browse");
	{
		menu_item("InstFolder");///Installation Folder
		menu_item("PensFolder");///Alphas
		menu_item("StripsFolder");///Strips
		menu_item("MasksFolder");///Stencils
		menu_item("MaterialsFolder");///Smart Materials
		menu_item("UserDataFolder");///User Data
		menu_item("ObjSamplesFolder");///Sample Objects
		menu_item("ObjPensSamplesFolder");///Sample 3D Alphas
		menu_item("StoredStatesFolder");///Stored States
		menu_item("PaletteFolder");///Color Swatches
		menu_item("ShadersFolder");///Shaders
		menu_item("TempFolder");///Temporary Folder
		menu_exit();
	}
	menu_separator();

	menu_item("SAVE_FILEFAST");///Save
	menu_hotkey("S", 0, 1, 0);///CTRL+S
	menu_item("SAVE_FILE");///Save As
	menu_hotkey("S", 0, 1, 1);///CTRL+ALT+S
	menu_item("SAVE_INC");///Save Incrementally
	menu_hotkey("S", 1, 1, 0);///SHIFT+CTRL+S
	menu_separator();
	menu_insert_extensions("File");
	menu_submenu("Import");
	{
		menu_item("ImportDPMesh");///{CY}Model for Per Pixel Painting
		menu_separator();		
		menu_item("OPENOBJ");///Model for Microvertex Painting
		menu_hotkey("O", 1, 1, 0);///SHIFT+CTRL+O
		menu_item("OPENOBJ_PTEX");///Model for PTEX
		menu_separator();		
		if (is_ppp()) {
			menu_separator();		
			menu_item("ImportPositions");///Import Vertex Positions
			menu_item("ReplaceGeometry");///Replace Geometry
			menu_item("ImportLockedNormals");
		}
		menu_exit();
	}
	menu_item("EXPORTOBJECT");///{CY}Export Objects & Textures
	if (is_mv()) {
		menu_submenu("Export");
		{
			menu_item("EXPORTOBJECT");///{CY}Export Objects & Textures
			menu_item("SAVEHIPOLYX4");///High-poly Mesh
			menu_item("SAVEHIPOLYX16");///High-poly Mesh
			menu_item("SAVEHIPOLYX64");///High-poly Mesh
			menu_exit();
		}
	}
	menu_item("EXIT");///Exit
}
void CreateEditMenu() {
	start_main_menu("COMMANDS");
	menu_item("UNDO");///Undo
	menu_hotkey("Z", 0, 1, 0);///CTRL+Z
	menu_item("REDO");///Redo
	menu_hotkey("Y", 0, 1, 0);///CTRL+Y
	menu_separator();
	if (!is_new_scene()) {
		//menu_item("PSProjectionCommands");///PSProjectionCommands
		menu_item("EDIT_CURR_LAYER");///Sync Layer w/ Ext. Editor
		menu_item("EDIT_ALL_LAYERS");///Edit All Layers in Ext. Editor
		menu_item("EDIT_ALL_ROUGH_LAYERS");///Edit All Roughness Layers
		menu_item("EDIT_ALL_METAL_LAYERS");///Edit All Metal Layers
		menu_item("EDIT_PROJECTION");///Edit Projections in Ext. Editor
		menu_separator();
		menu_item("ProjectThrough");///Project Through
		menu_item("Project_scale");///External Editor Projection Scale
	}
	menu_separator();
	menu_item("LoadHotkeys");///Load Hotkeys
	menu_item("SaveHotkeys");///Save Hotkeys
	menu_item("CustomizeUI");///Customize UI
	menu_item("OPTIONS");///Preferences
	menu_item("ResetSettings");///Reset settings
	menu_item("EditDataPlacement");///Relocate 3DCoat's data
	menu_insert_extensions("Edit");
}
void CreateViewMenu() {
	start_main_menu("VIEW");
	menu_item("ShadingOptions");///ShadingOptions
	menu_separator();
	menu_item("GreyscaleLight");///Greyscale Panorama
	menu_item("VIEW_SHADED");///Smooth Shade
	menu_hotkey("5", 0, 0, 0);///5
	menu_item("VIEW_RELIEF_ONLY");///Relief Only
	menu_hotkey("1", 0, 0, 0);///1
	menu_item("VIEW_NON_SHADED");///Flat Shade
	menu_hotkey("2", 0, 0, 0);///2
	menu_item("VIEW_GLOSS_ONLY");///Gloss/Roughness Only
	menu_hotkey("3", 0, 0, 0);///3
	menu_item("VIEW_SPECULAR_COLOR_ONLY");///Specular Color
	menu_hotkey("7", 0, 0, 0);///7
	menu_item("VIEW_METALNESS_ONLY");///Metalness
	menu_hotkey("8", 0, 0, 0);///8
	menu_separator();
	menu_item("BackfaceCulling");///Backface Culling
	menu_item("VIEW_TEXTURE_FILTERING");///Linear Texture Filtering
	menu_item("VIEW_WIREFRAME");///Wireframe
	menu_hotkey("W", 0, 0, 0);///W
	menu_item("CorrectAlphaOrdering");///Correct alpha ordering
	menu_item("VIEW_SEAMS");///Seams
	menu_hotkey("W", 1, 0, 0);///SHIFT+W
	menu_item("VIEW_LOWPOLY");///Low-Poly
	menu_hotkey("6", 0, 0, 0);///6
	menu_separator();
	menu_item("showMeasureGuides");
	menu_item("snapToMeasureGuides");
	menu_item("cuSnapToCurve");
	menu_item("cuSnapToPoints");
	menu_item("cuSnapToCurveCenter");
	menu_separator();
	menu_item("SHOW_GRID_3D");///Show 3D Grid
	menu_item("SNAP_TO_3DGRID");///Snap to 3D Grid

	menu_submenu("GridPlacement");
	{
		menu_item("Grid_ZX");///ZX Plane
		menu_item("Grid_XY");///XY Plane
		menu_item("Grid_YZ");///YZ Plane
		menu_item("AutoGrid");///Auto Placement
		menu_exit();
	}

	menu_submenu("GRID_DENSITY");
	{
		menu_item("RARE_GRID");///Small
		menu_item("NORMAL_GRID");///Medium
		menu_item("DENSE_GRID");///Large
		menu_item("CUSTOM_GRID");///Custom
		menu_item("CUSTOMIZE_GRID");///Customize Grid
		menu_exit();
	}
	
	menu_separator();
	menu_item("SHOW_AXIS");///Axis
	menu_submenu("Separate_axis");
	{
		menu_item("showaxX");///X
		menu_item("showaxY");///Y
		menu_item("showaxZ");///Z
		menu_exit();
	}
	
	menu_separator();
	menu_item("SHOW_GRID");///Show 2D Grid
	menu_hotkey("'", 0, 1, 0);///CTRL+'
	menu_item("SNAP_TO_GRID");///Snap to 2D Grid
	menu_item("SNAP_TO_ORIG_VERTS");///Snap to Low-Poly Vertices
	menu_separator();
	if (IsInRoom("Paint")) {
		menu_item("ShowVoxelsInPaintRoom");///Show Voxels in Paint Room
		menu_separator();
	}
	if (IsInRoom("Voxels")) {
		menu_item("ShowPolyObjectsInVoxelRoom");///Show Poly Objects in Sculpt room
		menu_item("ShowRetopoObjectsInVoxelRoom");///Show Retopo Objects in Sculpt room
		menu_separator();
	}
	menu_item("VIEW_ORTHO");///Orthographic Projection
	menu_hotkey("NUM5", 0, 0, 0);///NUM5
	menu_item("PROJECTOR");///Projector
	menu_item("ToggleFullscreen");///Toggle Full Screen
	menu_hotkey("ENTER", 0, 0, 1);///ALT+ENTER
	menu_separator();
	if (is_ppp()) {
		menu_item("VIEW_DISP");///Show Displaced Mesh
	}
	menu_item("AdjustSubpatching");///Adjust tesselation
	menu_insert_extensions("View");
}
void ImportMenu() {
	menu_submenu("Import");
	{
		menu_item("LOADTEX");///Color/albedo Map
		menu_item("IMPORT_LAYERS_FROM_FILE");///Layers Color
		menu_separator();
		menu_item("ExternalAO");///External AO
		menu_item("ExternalCavity");///External Curvature
		menu_separator();
		if (tex_approach() != 2) {
			menu_item("LOADSPEC");///Glossiness Map
			menu_item("IMPORT_SPEC_LAYERS_FROM_FILE");///Import Glossiness Layer
		}
		else {
			menu_item("LOADROUGHNESS");///Roughness
		}
		menu_separator();
		menu_item("LOADMETAL");///Metalness Map
		if (tex_approach() == 0) {
			menu_item("LOADSPECCOL");///Specular Color
		}
		menu_separator();
		menu_item("LOADEMISSIVE");///Emissive
		menu_item("LOADEMISSIVE_BW");///Emissive Intensity
		menu_separator();
		menu_item("LOADLOPOLYTANG");///Normal Map
		menu_item("ImportOSNormal");///World Space Normal Map
		menu_separator();
		menu_item("LOAD_LAYER_DISP");///Displacement Map
		if (is_mv()) {
			menu_item("LOAD_LAYER_VDISP");///Vector Displacement Map
		}
		menu_item("IMPORT_DEPTH_LAYERS_FROM_FILE");///Import Depth Layer
		menu_separator();
		menu_item("IMPORT_ALL_LAYERS_FROM_FILES");///Import Layer w/ Depth, Color & Glossiness
		if (is_ptex()) {
			menu_separator();
			menu_item("FlipPtexQuads");///Flip PTEX Quads
			menu_item("IMPORT_PTEX_COLOR");///Color From PTEX
			menu_item("IMPORT_PTEX_SPECULAR");///Glossiness From PTEX
			menu_item("IMPORT_PTEX_DISP");///Displacement From PTEX
			menu_item("IMPORT_PTEX_VDISP");///Vector Displacement From PTEX
			menu_item("IMPORT_PTEX_ABSPOS");///Absolute Positions From PTEX
		}
		menu_insert_extensions("Textures.Import");
	}
	menu_exit();
}
void ExportMenu() {
	menu_submenu("Export");
	{
		menu_item("SAVETEX");///Color/albedo Map
		menu_item("EXPORT_LAYERS_TO_FILE");///All Layers Color
		menu_separator();
		if (tex_approach() != 2) {
			menu_item("SAVESPECL");///Glossiness Map
		}
		else {
			menu_item("SAVEROUGH");///Roughness
		}
		menu_separator();
		menu_item("SAVEMETAL");///Metalness Map
		menu_item("UseMetAlpha");///Store gloss/roughness in metal alpha
		if (tex_approach() == 0) {
			menu_item("SAVECOLSPECL");///Specular Color
		}
		//menu_separator();
		//menu_item("SAVEEMISS");///Emissive
		//menu_item("SAVEEMISSPOWR");///Emissive Intensity
		menu_separator();
		menu_item("SAVENM");///Normal Map (World-Space)
		menu_item("SAVELOPOLYTANG");///Normal Map (TS, Low-Poly Mesh)
		if (!is_ppp()) {
			menu_item("SAVELOPOLYTANGLAYER0");///Normal Map (TS, Layer0 Based)
			menu_item("SAVEMIDPOLYTANG");///Normal Map (TS, Mid-poly Mesh)
		}
		menu_separator();
		menu_item("SAVE_LAYER_DISP");///Displacement Map Current Layer
		menu_item("SAVE_LAYERS_DISP");///Displacement Map of Visible Layers
		menu_item("EXPORT_DEPTH_LAYERS_TO_FILE");///Export Depth Layer
		if (is_mv()) {
			menu_item("SAVE_LAYERS_VDISP");///Vector Displacement Map
			menu_item("EXPORT_ALL_LAYERS_TO_FILES");///Export Layers w/ Depth, Color & Glossiness
		}
		if (is_ptex()) {
			menu_separator();
			menu_item("FlipPtexQuads");///Flip PTEX Quads
			menu_item("EXPORT_PTEX_COLOR_TO_FILE");///Color to PTEX
			menu_item("EXPORT_PTEX_SPECULAR_TO_FILE");///Glossiness to PTEX
			menu_item("Export_ptex_specular_color");///Specular Color for PTEX
			menu_item("Export_ptex_emissive_degree");///Emissive Degree to PTEX
			menu_item("EXPORT_PTEX_DISP_TO_FILE");///Displacement to PTEX
			menu_item("EXPORT_PTEX_VDISP_TO_FILE");///Vector Displacement to PTEX
			menu_item("EXPORT_PTEX_ABSPOS_TO_FILE");///Absolute Positions to PTEX
		}
		menu_separator();
		menu_item("EXPORT_ALL_LAYERS_TO_FILES");///Export Layers w/ Depth, Color & Glossiness
		menu_insert_extensions("Textures.Export");
	}
	menu_exit();
}
void TexturesMenu() {
	start_main_menu("Textures");
	menu_submenu("TexApproach");
	{
		menu_item("GlossSpecular");///Gloss/Color Specular
		menu_item("GlossMetallness");///Gloss/Metalness
		menu_item("RoughnessMetallness");///Roughness/Metalness
	}
	menu_exit();
	ImportMenu();
	ExportMenu();
	if (!is_ppp()) {
		menu_item("UV_SOURCE");///Use Original UV
	}
	menu_separator();
	menu_item("SAVESPECINNM");///Save Glossiness as Normal Map Alpha Channel
	menu_item("SAVEDISPINNM");///Save Displacement Map to Alpha
	menu_item("DontUseAlphaInNM");///Don't Use Alpha in Normal Map
	menu_item("DontUseAnphaAtAll");///Don't Use Alpha in Color Map
	menu_separator();
	menu_submenu("Adjust");
	{
		menu_item("COLOR2SPECULAR");///Color to Glossiness
		menu_item("INVERTCOLOR");///Invert Color
		menu_item("INVERTSPECULAR");///Invert Glossiness
		menu_separator();
		menu_item("SETZEROHEIGHT");///Set Height to Zero
		menu_item("SETZEROCOLOR");///Make Transparent
		menu_item("SETZEROSPECULAR");///Remove Glossiness
		menu_separator();
		menu_item("SMOOTH_LAYER");///Smooth Current Layer
		menu_item("SHARPEN_LAYER");///Sharpen Current Layer
		menu_item("HSV_LAYER");///Hue/Saturation/Lightness
		menu_item("CMYK_LAYER");///CMYK
		menu_item("TRANSCOLOR_LAYER");///Transform Color Space
		menu_item("BC_LAYER");///Brightness/Contrast
		menu_item("RGB_LAYER");///RGB
		menu_item("GAMMA_LAYER");///Gamma Correction
		menu_insert_extensions("Textures.Adjust");
	}
	menu_exit();
	menu_item("IMPORTUV");///Import UV
	menu_item("EXPORTUV");///Export UV
	menu_item("SAVE_SL_PAINTMAP");///Export SL Sculpt Map
	menu_separator();
	menu_item("VIEWEDIT_TEXTURES");///Texture UV Editor
	if (is_mv()) {
		menu_item("UVSET_MANAGER");///UV Manager
	}
	menu_item("RESIZE_TOOL");///Mesh & Texture Resolution
	menu_separator();
	menu_item("BAKE_TOOL");///Texture Baking Tool
	menu_item("OCCLUSION_TOOL");///Calculate Occlusion
	menu_item("CAVITY_TOOL");///Calculate Curvature
	menu_item("WRAP_TOOL");///Offset Tool
	menu_item("LIGHTBAKING_TOOL");///Light Baking Tool
	menu_insert_extensions("Textures");
}
void SymmetryMenu() {
	start_main_menu("Symmetry");
	menu_item("SYMMETRY_NONE");///No Symmetry
	menu_item("ToggleSymmetry");///Toggle Symmetry
	menu_item("SYMMETRY");///Symmetry
	menu_hotkey("S", 0, 0, 0);///S
	menu_separator();
	menu_item("SYMMETRY_RESET");///Reset Symmetry Planes
	menu_item("SHOW_SYMM_PLANE");///Show Symmetry Plane
	menu_insert_extensions("Symmetry");
}
void LayersMenu() {
	start_main_menu("LAYERS");
	menu_item("SHOW_LAYERS_LIST");///Layers
	menu_hotkey("L", 0, 0, 0);///L
	menu_item("SHOW_LAYER_BLENDING_LIST");///Layer Blending
	menu_separator();
	menu_item("ADD_NEW_LAYER");///New
	menu_hotkey("N", 1, 1, 0);///SHIFT+CTRL+N
	menu_item("ADD_LAYER_WITH_NM");///Add Layer w/ Normal Map
	menu_item("DUPLICATE_LAYER");///Duplicate
	menu_hotkey("D", 1, 1, 0);///SHIFT+CTRL+D
	menu_item("DELETE_LAYER");///Delete
	menu_hotkey("DELETE", 1, 1, 0);///SHIFT+CTRL+DELETE
	menu_separator();
	menu_item("MERGE_VISIBLE");///Merge Visible
	menu_item("MERGE_DOWN");///Merge Down
	menu_item("MERGE_UP");///Merge Up
	menu_separator();
	menu_item("Copy_channels");///Copy Channels
	menu_item("ApplyBlending");///Apply Layer Blending
	menu_item("APPLY_LMASK");///Discard Clip Masked Pixels
	menu_item("DEL_UNFROZEN_PARTS");///Erase Unfrozen
	menu_hotkey("DELETE", 0, 0, 0);///DELETE
	menu_item("FILLLAYER1");///Fill Entire Layer
	menu_hotkey("INS", 0, 0, 0);///INS
	menu_item("FILLLAYERTR1");///Refill Material
	menu_hotkey("INS", 0, 1, 0);///CTRL+INS
	menu_item("Remove_spikes");///Clamp Min. Depth
	menu_item("Clamp_layer_depth");///Clamp Layer Depth
	menu_separator();
	menu_submenu("SYMM_OP");
	{
		menu_item("DUPLICATE_WITH_FLIP");///Flip Layer and Duplicate
		menu_item("FLIP_LAYER");///Flip Layer
		menu_item("COPY_BLUE_TO_RED");///Copy Blue to Red
		menu_item("COPY_RED_TO_BLUE");///Copy Red to Blue
	}
	menu_exit();
	menu_insert_extensions("Layers");
	menu_separator();
	menu_submenu("Import");
	{
		menu_item("IMPORT_LAYERS_FROM_FILE");///Layers Color
		if (tex_approach() != 2) {
			menu_item("LOADSPEC");///Glossiness Map
			menu_item("IMPORT_SPEC_LAYERS_FROM_FILE");///Import Glossiness Layer
		}
		else {
			menu_item("LOADROUGHNESS");///Roughness
		}
		menu_item("IMPORT_METAL_FROM_FILE");///Metalness
		menu_item("IMPORT_DEPTH_FROM_FILE");///Depth
		menu_insert_extensions("Layers.Import");
	}
	menu_exit();
	menu_submenu("Export");
	{
		menu_item("EXPORT_IMAGE_TO_FILE");///Color
		menu_item("EXPORT_LAYERS_TO_FILE");///All Layers Color
		if (tex_approach() != 2) {
			menu_item("SAVESPECL");///Glossiness Map
			menu_item("IMPORT_SPEC_LAYERS_FROM_FILE");///Import Glossiness Layer
		}
		else {
			menu_item("SAVEROUGH");///Roughness
		}
		menu_item("EXPORT_METAL_TO_FILE");///Metalness
		menu_item("EXPORT_DEPTH_TO_FILE");///Depth
		menu_insert_extensions("Layers.Export");
	}
	menu_exit();
}
void FreezeMenu() {
	start_main_menu("Freeze");
	if (!IsInRoom("Voxels")) {
		menu_item("SWITCH_FREEZE_TOOL");///Activate Freeze Tool
		menu_item("TOGGLE_FREEZE_PATTERN");///Toggle Freeze View
		menu_hotkey("F", 0, 0, 1);///ALT+F
	}
	menu_item("MENU_TOGGLE_FREEZE_VIEW");///Show/Hide Freeze
	menu_hotkey("F", 0, 1, 0);///CTRL+F
	menu_separator();
	menu_item("FREEZE_TRANSP");///Freeze Painted Pixels
	menu_item("FREEZE_TRANSP_INV");///Freeze Transparent Pixels
	menu_item("MENU_FREEZE_CURRENT_CONDITION");///Freeze Surface
	menu_item("MENU_FREEZE_BORDER");///Freeze Border
	menu_hotkey("NUM/", 0, 1, 0);///CTRL+NUM/
	menu_item("MENU_FREEZE_OBJECT");///Freeze Paint Object
	menu_item("MENU_FREEZE_MTL");///Freeze Surface Material
	menu_separator();
	menu_item("MENU_UNFREEZE_OBJECT");///Unfreeze Paint Object
	menu_item("MENU_UNFREEZE_MTL");///Unfreeze Surface Material
	menu_item("MENU_UNFREEZE_ALL");///Unfreeze All
	menu_hotkey("D", 0, 1, 0);///CTRL+D
	menu_separator();
	menu_item("MENU_INVERT_FREEZE");///Invert Freeze/Selection
	menu_hotkey("I", 1, 1, 0);///SHIFT+CTRL+I
	menu_item("MENU_BLUR_FREEZE");///Smooth Freezing
	menu_hotkey("NUM*", 0, 1, 0);///CTRL+NUM*
	menu_item("MENU_SHARPEN_FREEZE");///Sharpen Freezing
	menu_item("FILLLAYER1");///Fill Entire Layer
	menu_item("DEL_UNFROZEN_PARTS");///Erase Unfrozen
	menu_item("HideFrozenArea");///Hide Frozen Area
	menu_separator();
	menu_item("MENU_EXPAND_FREEZE");///Expand Frozen Area
	menu_hotkey("NUM_MINUS", 0, 1, 0);///CTRL+NUM_MINUS
	menu_item("MENU_CONTRACT_FREEZE");///Contract Frozen Area
	menu_separator();
	menu_item("STORE_FREEZE_DATA");///Store Freezing State
	menu_item("RESTORE_FREEZE_DATA");///Restore Freezing State
	menu_insert_extensions("Freeze");

}
void HideMenu() {
	start_main_menu("Hide");
	menu_item("SWITCH_HIDE_TOOL");///Activate Hide Tool
	menu_item("MENU_HIDE_OBJECT");///Hide Paint Object
	menu_item("MENU_HIDE_MTL");///Hide Surface Material
	menu_separator();
	menu_item("MENU_UNHIDE_OBJECT");///Unhide Paint Object
	menu_item("MENU_UNHIDE_MTL");///Unhide Surface Material
	menu_item("MENU_UNHIDE_ALL");///Unhide All
	menu_hotkey("X", 0, 1, 0);///CTRL+X
	menu_item("HideFrozenArea");///Hide Frozen Area
	menu_separator();
	menu_item("MENU_INVERT_HIDE");///Invert Hidden Faces
	menu_item("MENU_DEL_PERMANENTLY");///Delete Hidden Faces Permanently
	menu_separator();
	menu_item("MENU_EXPAND_HIDE");///Expand Hidden Area
	menu_hotkey("NUM_MINUS", 0, 0, 0);///NUM_MINUS
	menu_item("MENU_CONTRACT_HIDE");///Contract Hidden Area
	menu_separator();
	menu_item("STORE_HIDE_DATA");///Store Hidden State
	menu_item("RESTORE_HIDE_DATA");///Restore Hidden State
	menu_insert_extensions("Hide");
}
void WindowsMenu() {
	start_main_menu("Windows");
	menu_submenu("Popups");
	{
		if (IsInRoom("Retopo")) {
			menu_item("UV_PREV");///UV Preview
		}
		menu_item("ProxySlider");			///ProxySlider
		if (IsInRoom("UV")) {
			menu_item("UV_PREV");///UV Preview
		}
		menu_item("StartMenu");///Start Menu
		menu_item("SHOW_PRESETS");///Tool Presets
		menu_item("SHOW_TOOLS_PALETTE");///Tools Palette
		menu_hotkey("SPACE", 0, 0, 0);///SPACE
		menu_item("SHOW_SUBOBJ");///Paint Objects
		menu_item("SHOW_MATERIALS");///Surface Materials
		menu_item("ID_BUMP_HDR");///Depth Channel
		menu_hotkey("D", 0, 0, 0);///D
		menu_item("ID_COLOR_HDR");///Color Channel
		menu_hotkey("C", 0, 0, 0);///C
		menu_item("ID_SPECULAR_HDR");///Glossiness Channel
		menu_hotkey("R", 0, 0, 0);///R
		menu_item("ID_PENOPS");///Stroke Mode
		menu_hotkey("E", 0, 0, 0);///E
		menu_item("QuickPanel");///Quick Panel
		menu_hotkey("T", 0, 0, 0);///T
		menu_insert_extensions("Windows.Popups");
		menu_sort();
		menu_separator();
		menu_item("PEN_DEPTH");///Depth
		menu_item("PEN_RADIUS");///Radius
		menu_item("PEN_ROTSN");///Rotation
		menu_item("SMOOTH_DEG");///Smoothing
		menu_item("PEN_MASK");///Opacity
		menu_item("PEN_SPEC");///Glossiness Intensity
		menu_item("DebugLayers");///Debug Layers
		menu_separator();
		menu_item("ToggleUI");
		menu_hotkey("Tab", 0, 0, 0);
		menu_separator();
		menu_item("Pick_color");///Pick Color/Depth/Glossiness
		menu_hotkey("V", 0, 0, 0);///V
		menu_item("Pick_layer");///Pick Current Layer/Volume
		menu_hotkey("H", 0, 0, 0);///H
		menu_item("Pick_layer_add");///Pick layer add
		menu_hotkey("H", 1, 0, 0);///SHIFT+H
		menu_item("Pick_layer_sub");///Pick layer sub
		menu_hotkey("H", 0, 1, 0);///CTRL+H
		//menu_item("VoxTreeRMB");///Trigger Volume Properties Window
	}
	menu_exit();
	menu_submenu("Sliders");
	{
		menu_item("DEC_OPACITY");///Decrease Opacity
		menu_item("INC_OPACITY");///Increase Opacity
		menu_item("DEC_ANGLE");///Decrease Angle
		menu_item("INC_ANGLE");///Increase Angle
		menu_item("DEC_RADIUS");///Decrease Radius
		menu_item("INC_RADIUS");///Increase Radius
		menu_item("DEC_DEGREE");///Decrease Degree
		menu_item("INC_DEGREE");///Increase Degree
		menu_item("DEC_SM_DEGREE");///Decrease Smooth Degree
		menu_item("INC_SM_DEGREE");///Increase Smooth Degree
		menu_item("DEC_SPEC_OPACITY");///Decrease Glossiness Opacity
		menu_item("INC_SPEC_OPACITY");///Increase Glossiness Opacity
		menu_item("DEC_SPEC_DEGREE");///Decrease Glossiness Degree
		menu_item("INC_SPEC_DEGREE");///Increase Glossiness Degree
		menu_item("SWAP_COLORS");///Swap Colors
		menu_insert_extensions("Windows.Sliders");
	}
	menu_exit();
	menu_separator();
	menu_item("ResetThisPageToDefault");///Reset This Page to Default
	menu_item("ResetAllPagesToDefault");///Reset all Pages to Default
	menu_separator();
	menu_item("StoreThisPageLayout");///Store This Page Layout
	menu_item("RestoreThisPageLayout");///Restore This Page Lyout
	menu_separator();
	menu_item("StoreAllPagesLayout");///Store Workspace
	menu_item("RestoreAllPagesLayout");///Restore Workspace
	menu_separator();
	menu_separator();
	menu_item("ToggleUI");///Toggle Popup/Docked Windows
	menu_hotkey("TAB", 0, 0, 0);
	if (!lock_ui_changes()) {
		menu_separator();
		menu_item("CustomizeUI");///Customize UI
	}
	menu_insert_extensions("Windows");
}
void ScriptsMenu() {
	start_main_menu("Scripts");
	menu_item("RunScript");///Run Script
	menu_separator();
	menu_item("CreatePythonScript");
	menu_item("ShowPyConsole");
	menu_item("PythonAPI_Docs");
	menu_item("PipInstall");	
	menu_item("PipUnInstall");
	menu_item("AttachToPytonDebugger");
	menu_separator();
	menu_item("CreateNewCoreScript");
	menu_item("CoreAPI_Docs");
	menu_separator();
	menu_item("CreateScript");///Create Your Script 
	menu_item("HowToWriteScripts");///Scripting Manual
	menu_item("ViewExecutionLog");///View Execution Log
	if(UseRecordScript()){
		if(IsRecordScript())
			menu_item("StopRecordScript");/// Stop Record Script
		else
			menu_item("RecordScript");/// Record Script
	}
	menu_insert_extensions("Scripts");
	menu_item("RecentScripts");///RecentScripts
}
void CaptureMenu(){
        start_main_menu("Capture");
        menu_item("RecordTimelapse");
        menu_item("EditTimelapseSettings");
	menu_separator();
	menu_item("UPLOAD_SCREENSHOT");///Upload Screenshot
	menu_hotkey("S", 1, 0, 1);///SHIFT+ALT+S
	menu_item("UploadToSketchFab");///Upload Mesh to sketchfab.com
	menu_hotkey("K", 1, 0, 1);///SHIFT+ALT+K
	menu_item("UPLOAD_TURNABLE");///Create turnable (MP4)
	menu_hotkey("T", 1, 0, 1);///SHIFT+ALT+T
	menu_item("Reender_turnable_screenshots");///Render Turntables w/ Post Process
}
void HelpMenu() {
	start_main_menu("Help");
	menu_item("ThisPageDoc");
	menu_item("READ_MANUAL");///3DCoat Manual
	menu_item("YotubeChannel");///YouTube Channel
	menu_separator();
	menu_item("Hotkeys_and_sticky");///Hotkeys & Sticky Keys
	menu_item("MigrationMaster20XX");
	menu_separator();
	menu_item("UNINST_LICENCE");///Uninstall License
	if (!is_medical())menu_item("ShowMyKey");///Show My Key
	menu_separator();
	menu_item("SelLanguage");///SelLanguage
	menu_item("COMMUNITY");///Community
	menu_item("Send_file_to_support");///Send File to support@3dcoat.com
	menu_separator();
	//if (!is_steam_app())menu_item("CHECK_UPDATES");///Check for Updates
	menu_item("AutoUpdater");
	menu_item("ABOUT");///About 3DCoat
	menu_insert_extensions("Help");
}
void DebugMenu() {
}
void CurvesMenu() {
	start_main_menu("Curves");
	
	menu_item("ActivateCurvesEditor");///Activate curves editor
	menu_item("CurvParamsPopup");
	menu_hotkey("Q", 0, 0, 0);
	menu_item("StopEditCurves");///Stop edit curves
	menu_item("SplineUsageHint");///Curves usage hint
	menu_item("CurvesTree");///Curves tree
	menu_item("RecordStrokes");///Record strokes

	menu_separator();

	menu_item("SaveCurve");///Save curve...
	menu_item("SaveSeparateCurves");///Save curves separately...
	menu_item("LoadCurve");///Load curve...
	menu_item("LoadCurveAsImage");///Load curve from image...
	menu_separator();

	menu_item("cuSnapToSurface");///Snap to surface
	menu_item("cuSnapToPoints");///Snap to curve points
	menu_item("cuSnapToCurve");///Snap to curve
	menu_item("cuSnapToCurveCenter");///Snap to center
	menu_item("cuSnapToDistance");///Quantize length
	menu_item("cuSnapToHorizontalVertical");///Snap to horizontals/verticals
	menu_item("cuSnapSettings");///Snapping settings

	menu_separator();

	menu_item("RenderCurvesOnBackFaces");///Render curves on back side

	menu_submenu("PutOnPlane");
	{
		menu_item("AveragePlane");///Average plane
		menu_item("CmPlaneYZ");///Center mass + YZ - plane
		menu_item("CmPlaneZX");///Center masss + ZX - plane
		menu_item("CmPlaneXY");///Center mass + XY - plane
		menu_item("PlaneYZ");///YZ - plane
		menu_item("PlaneZX");///ZX - plane
		menu_item("PlaneXY");///XY - plane
		menu_exit();
	}
	menu_submenu("SM_CurvesOperations");
	{
		menu_item("SM_SplitSelfIntersections");///Split Self Intersections
		menu_item("SM_BooleanOperations");///Boolean Operations
		menu_item("SM_SimplifyCurve");///Simplify Curve
		menu_item("SM_SmoothingCurve");///Smoothing Curve
		menu_item("SM_RemoveSharp");///Remove sharp corners
		menu_item("SM_SubdivideCurve");///Subdivide Curve
		menu_item("SM_ReverseCurveDirection");///Reverse Curve Direction
		menu_item("ToogleDisplayLength");///Toggle length displaying
		menu_exit();
	}

	menu_submenu("Modifiers");
	{
		menu_item("DetachCurvModifierSel");///Detach curve modifiers (selected)
		menu_item("DetachCurvAndRemoveSel");///Detach and delete meshes (selected)
		menu_item("EditCurvModifierPropertiesSel");///Edit curve modifier (selected)
		menu_item("HideCurvModifier");///Hide selected modifiers
		menu_item("HideAllCurvModifiers");///Hide all modifiers
		menu_item("ShowAllCurvModifiers");///Show all modifiers
		menu_exit();
	}

	menu_separator();
	
	menu_item("ApplyCurves");///Apply Curves
	menu_item("StartNewCurve");///Start new curve
	menu_item("RunBrushAlongCurve");///Brush Along Curve
	menu_item("RunBrushAlongProjection");///Run brush along projection
	menu_item("EditPressuerProfile");///Edit Pressure Profile

	menu_separator();

	menu_item("SelectInProjection");///Select/Freeze projection area
	menu_item("AttachToSurface");///Snap to surface
	menu_item("SameRadius");///Assign radius
	menu_item("SetCoordinate");
	menu_item("DelSplines");///Delete all curves
}
void main() {
	menu_item("ThisRoomSettings");
	menu_item("RoomsSelector");
	menu_item("Splitter");
	menu_item("BlankSpace");
	CreateFileMenu();
	CreateEditMenu();
	CreateViewMenu();
	if (!is_new_scene()) {
		SymmetryMenu();
		if (IsInRoom("Paint")) {
			TexturesMenu();
		}
		if (IsInRoom("Paint")) {
			LayersMenu();
		}
		if (IsInRoom("Paint")) {
			FreezeMenu();
			HideMenu();
		}
	}
	CurvesMenu();
	WindowsMenu();
	ScriptsMenu();
	CaptureMenu();
	HelpMenu();
	if(IsInRoom("Paint")){
		menu_item("PaintDependency");
		menu_item("PickMethod");
	}
}