import importlib
import os
import sys
import types

class CustomImporter:
    def __init__(self):
        self.module_timestamps = {}

    def find_spec(self, fullname, path, target=None):
        # This method is required for an importer. We'll use the default mechanism,
        # so we don't need to implement a custom spec finder.
        pass

    def load_module(self, fullname):
        if fullname in sys.modules:
            module = sys.modules[fullname]
            module_path = getattr(module, '__file__', None)

            # If the module has no __file__ attribute, it might not be reloadable (e.g., built-in modules).
            if module_path and os.path.isfile(module_path):
                last_modified = os.path.getmtime(module_path)
                if fullname not in self.module_timestamps or self.module_timestamps[fullname] != last_modified:
                    # The module has been modified; reload it.
                    self.module_timestamps[fullname] = last_modified
                    importlib.reload(module)
                    print(f"Reloaded {fullname} due to changes.")
            return module

        # If the module is not in sys.modules, let Python's normal import mechanism handle it.
        return importlib.import_module(fullname)

    def install(self):
        # Insert this class into the sys.meta_path to handle module loading.
        sys.meta_path.insert(0, self)

custom_importer = CustomImporter()
custom_importer.install()