#pragma once
class VolumeObject;
extern VolumeObject* CurVObj;
class VoxTreeBranch;
struct APICALL VORenderQueue{
	VORenderQueue() {
		AABBValid = false;
		TemporaryDisabled = false;
		OverrideGhost = false;
	}
	VoxTreeBranch* TreePos;
	VolumeObject* VO;
	Matrix4D Transform;
	Matrix4D TransformInv;
	bool OverrideGhost;
	float SortPos;
	bool NoShadowcast;
	AABoundBox GlobalAB;
	bool AABBValid;
	bool TemporaryDisabled;
	void TransformPt(Vector3D& pt);
	void TransformPtInv(Vector3D& pt);
	void TransformScalar(float& pt);
	void TransformScalarInv(float& pt);
	void TransformNrm(Vector3D& pt);
	void TransformNrmInv(Vector3D& pt);
	void TransformVec(Vector3D& pt);
	void TransformVecInv(Vector3D& pt);
    static cList<VORenderQueue> LastVisTree;
	static void RemoveDeadElements();
	static void CalcVisTreeAB();
	static void DisableExceptCurrent();
	static void EnableAll();
};
struct ClusterPoly;
class ui_menu_simple;
/**
\brief Class for tools.
*/
class APICALL VoxelExtension:public BaseClass{ 
public:
	VoxelExtension(){
		AbleToSnap = false;
		IsActive = false;
		AppearsInSmoothActions = false;
		ActivatedMandatory = false;
	}
	/**
    \brief For internal use by application.
    \details
    You can add an icon for tool when ID is defined.
    All icons located in the folder `textures/icons64`.
    \see File `ui2.xml` in the root of application.
    */
	int			ID;
	cStr		CustomName;
	cStr		SourceIcon;
	cStr		CmdID;
	///Used if tool duplicated. This is very base of the tool, it does not changes when tool duplicated. This is like "grand-grand...father"
	cStr		BaseParentTool;
	///This is ID of parent, like "father" tool
	cStr		PreviousParentTool;
	cStr		key;
	
	bool		IsActive;
	bool		AppearsInSmoothActions;
	static VoxelExtension* Current;
	static bool GeneralUsage; ///< `true` if `VoxelExtension` used outside of voxel room.
	float		PrevInterpValue;
	bool		PrevInterp;
	bool		AbleToSnap;
	bool		ActivatedMandatory;
	static bool	SomethingChanged;
	static int  ExtHash;
	static bool TemporaryDisablePresetActivation;

	const char* GetFullID(){
		if(CustomName.Length())return CustomName.ToCharPtr();
		else return GetID();
	}
	void AssignExternalIcon(const char* iconname);
	void ChooseIcon();
	void Activate();
	//installing: 

    /**
	\brief Call this function to register own extension.
	\details
    Go to VoxelExtension.cpp, include your header,
	call VoxelExtension::Register in function RegisterVoxelExtensions().
    */
	static ui_menu_simple* Register(VoxelExtension* ex);
	static VoxelExtension* GetHook();
	static VoxelExtension* find(const char* id);
	static bool CheckFieldPresence(const char* FieldName);
	/// Please use this function to activate the tool
	void SwitchTo();


	//virtual functions for overloading:

	/// \brief Define Textual ID in tools list.
	virtual const char* GetID();
	virtual bool CheckParentTool(int _Mode){return false;}

	virtual void OnActivatePreset();
	virtual bool NeedToStoreToolPreset(){return true;}
	virtual void RestoreExtensionPreset();
	virtual void StoreExtensionPreset(bool asPreset=false);
	virtual void OnPlaceInUI();
	virtual cStr GetPresetFileName();
	virtual bool AllowUVIslandsPreview() { return false; }
	virtual ClusterPoly* OverrideCluster(int cl);

	virtual int GetPlacementPriory();

	virtual const char* GetPrevTool(){return "";}
	/// \brief Returns `true` if the tool is present in voxel toolset.
	virtual bool PresentInVoxelTools(){return true;}
	virtual bool MayModifyVoxelsAsSurface();
	/// \brief Returns `true` if the tool is present in voxel surface toolset.
	virtual bool PresentInSurfaceTools();
	virtual bool PresentInRetopoTools();
	virtual bool PresentInUvTools();
	virtual bool PresentInPaintTools();
	virtual bool PresentInTweakTools();
	virtual bool PresentInPhotogrammetryTools();
	virtual bool PresentInRoom(const char* RoomName);
	/**
    \brief Create toolset on the top line.
	\see VoxelSculptTool::CreateToolset() as example
    */
	virtual bool CreateToolset();
	/// \brief Creates parameters plate of this tool.
	virtual bool CreateInterface(BaseWidget* Where){
		return false;
	}
	/// \brief Called once per frame.
	virtual void Process            (){}    
	virtual void Render				(){}
	virtual void RenderPreviewAsVolume(int Sh){}

	//Next functions are obvious, return true if action handled and should be removed from queue
	virtual bool OnLMB_Down			(){return false;}
	virtual bool OnLMB_Up			(){return false;}
	virtual bool OnDBL				(){return false;}
	virtual bool OnMMB_Down			(){return false;}
	virtual bool OnMMB_Up			(){return false;}
	virtual bool OnRMB_Down			(){return false;}	
	virtual bool OnRMB_Up			(){return false;}
	virtual bool OnUndo				(){return true;}
	virtual bool OnRedo				(){return true;}
	virtual bool DisableRedo()		{ return false; }
	///step in 1 or -1 in dependence on direction
	virtual bool OnWheel			(int step);
	virtual bool AllowIncrementalRender(){return true;}
	/// \brief `KeyCode` is Windows virtual keyboard codes like `VK_xxxx`.
	virtual bool OnKey(char KeyCode){return false;}
	//next functions may prohibit using of different navigation methods for 3DCoat
	virtual bool AllowMMBNavigation(){return true;}
	virtual bool AllowRMBNavigation(){return true;}
	virtual bool AllowRadisRMBControl(){return true;}
	/// \warning Don't allow to navigate with LMB, do own action instead.
	virtual bool CanDrawInFreeSpace(){return false;}	
	/// \brief Called when user activates tool.
	virtual void OnActivate(){}
	/// \brief Called when user chooses other tool but this.
	virtual void OnDeActivate(){}
	///For tool actions! Return false if it is the tool, return true if it is just button without the need of the tool activation. In this case only OnActivate() will be called when user presses the button.
	virtual bool IsToolsAction() { return false; }
	/// \brief Called when user selects "New scene".
	virtual void OnClear(){}
	///call it in Clear() if New should reset tool to the default state
	virtual void ClearMyToolPreset();
	virtual void OnClearVolume(){}
	virtual bool OnIncRes(){return true;}
	virtual bool OnResample(){return true;}
	virtual bool OnSmoothAll(){return true;}
	virtual void OnChangeCurVolume(VoxTreeBranch* newCur) {}
	virtual void OnChangeCurVolumeManually(VoxTreeBranch* newCur) {}
	virtual void OnVoxelize() {}
	virtual void OnMakeSurface() {}
	/// \brief Returns `true` if you don't want radius to be dependent on pen pressure.
	virtual bool DisableRadiusVariation(){return false;}
	/// \brief Returns `true` if you want to draw starting from initial pick point in free space.
	virtual bool DrawOnPlane(){return false;}
	virtual bool AbleToDrawOnPlane(){return false;}
	/// \brief Called when user ends rectagular/curve selection, returns true if don't need further handling.
	virtual bool OnRectSelectionEnd(Rct R){return false;}
	static bool SafeRectSelection(Rct R);
	virtual bool ApplyEnterInCurves() { return false; }
	/// \brief Returns `false` if don't need rect selection capability.
	virtual bool AllowRectSelection(){return true;}
	/// \brief Returns `true` if need only rect selection capability.
	virtual bool AllowOnlyRectSelection(){return false;}
	virtual bool ApplyCurvesAsRectSelection() { return AllowOnlyRectSelection(); }
	virtual bool AllowStamp(){return true;}
	virtual bool AllowLinesDrawing(){return true;}
	virtual bool AllowRectDrawing(){ return true; }
	virtual bool AllowLassoDrawing(){ return true; }
	virtual bool AllowCircleDrawing(){ return true; }
	virtual bool NeedToClearPointsOnDBLClick(){ return true; }
	virtual bool Use3DLasso(){return false;}
	virtual bool Snap3DLasso(){ return false; }
	virtual bool AllowRemoveStretching(){ return false; }
	/// \brief Acts like Move tool.
	virtual bool AllowDrag(){return false;}
	/// \brief Called when you are trying to draw by some brush.
	virtual void OnDraw(){};
	/**
    \details Returns `1` if you need to construct brush trajectory with `TMaster` including end points
	and `2` if you need to include start point in trajectory,
    `0` if you don't need `TMaster` at all.
    */
	virtual int NeedTrajectory(){return 0;}
	virtual bool NeedConstructTrajectory() { return true; }
	virtual bool AutoFadeOnEdge() { return false; }
	virtual bool UseBezierTrajectorySmoothing() { return false; }
	/// \brief Returns `true` if need at least one point per trajectoty chunk.
	virtual bool NeedFirstPoint(){return false;}
	virtual float OverrideSpacing(bool& Spots) { return 0; }
	/**
    \deprecated
    \brief Returns `true` if you need to use `VolumeCell::LocalMeshPtr`.
    */
	virtual bool NeedGlobalIndexing(){return true;}
	virtual bool NeedFacesAdjacensy(){return false;}
	virtual bool NeedBrushMipmaps(){return true;}
	virtual bool PickAveragePos(){return false;}
	virtual bool PickCurrentPos(){return false;}
	virtual bool NeedAutoCellsSubdivision(){return PresentInSurfaceTools();}
	virtual bool CheckIfToolIsBeta(){return false;}
	virtual bool MayActThroughVolumes(){return false;}
	virtual bool NeedPenControls(){return true;}
	virtual bool SkipFaloffControls() { return false; }
	virtual bool OverridesBrushRotationJitterSpacing() { return false; }
	virtual bool NeedDepthControls(){return true;}
	virtual bool SupportRectSurfDistortion();
	virtual bool NeedBorderShape(){return false;}
	virtual bool AllowGrowOnPenMotion(){return false;} //!!!!false
	virtual bool PickOnlyFirstPoint(){return false;}
	virtual bool PickEmptySpace(){return false;}
	virtual bool MayChangeTopology(){return true;}
	virtual bool UseInterpolationByDefault(float& _val){return false;}
	virtual void OnEndOfStroke(VolumeObject* ob){};
	virtual bool SnapMidPoints(){return false;}
	virtual int  GetMimickTool(){return -1;}
	virtual bool SkipSurfWarning(){return true;}
	virtual bool AllowInvertAction(){return false;}
	virtual bool NeedFlatternCurve(float& v0,float& v1){return false;}
	virtual bool NeedSplinesMenu() { return false; }
	virtual bool RequiresPresetActivation() { return true; }
	virtual void ControlRenderQueue(cList<VORenderQueue>& rq){};
	virtual float GetTrackingSpacing();
	/// \brief 0 - disable, 1 - allow, 2 - in 2D mode
	virtual int AllowSplineStroke(){return 1;}
	virtual float GetRadiusMod(){return 1.0;}
	virtual bool SupportsSelCentering(){return false;}
    /// \brief 1 - Auto pick, 2 - pick by click, 0 - don't pick
	virtual int AllowAutoPick(){return 1;}
	virtual BasePrim* GetPrim(){return NULL;}
	virtual bool AllowSamplingRadius(){return false;}
	///return 0 if you don't need sampling radius
	virtual float OverridePositionalSamplingRadius() { return 0.0; }
	virtual bool AllowBuildup(){return false;}
	virtual bool AllowStrightHandler(){return false;}
	virtual bool AllowCubeHandler(){return false;}
	virtual bool AllowMixedPicking(){return false;}
	virtual bool NeedCubicTrajectory(){return false;}
	virtual bool NeedsDepthLimitInEPanel(){ return true; }
	virtual bool IgnoreNaviEvent(NaviEvent* Event) { return false; }
	/// \brief Returns nonzero if top line with params required similar to Primitives set.
	virtual int RequiresExtraTopLine(){ return 0; }
	virtual void OnCreateTopToolPanel(){};
	/// \brief You may disable smoothing with shift.
	virtual bool AllowShiftSmooth(){ return true; }
	/// \brief Called when preset activated regardless if tool active or not.
	virtual void OnPresetActivation(OnePreset* PS);
	/// \brief Called when preset created manually by user.
	virtual void OnCreatePreset(OnePreset* PS);
	///called to add transformed proxy objects into scene
	virtual void OnProcessNode(VoxTreeBranch* tb, cList<VORenderQueue>& RQ) {}
	// \brief Called in Retopo room to preserve the selection.
	virtual bool AllowAdditiveSelection(){ return false; }
	/// called when geometry transformed in retopo room
	virtual void TransformInRetopo(const Matrix4D& m) {};
	/// \brief Called when user chosen model in models palette, return `true` if model used and action captured.
	virtual bool OnSelectModelInPalette(const char* ModelName, const char* RootPath, bool InCurrentTool){ return false; }
	//Load/Save to 3B-file routines

	/// \brief Returns number of save chunks for 3B file, the chunk index will be passed to each load/save related function.
	/// See the BIG example of data serialization in the examplary class ExampleOfLoadSaveDataTo3BFileExtension (in VoxelExtension.cpp)
	virtual int GetNumSaveChunks(){return 0;}
	/// \brief Returns unique ID of the save chunk, idx is the chunk index.
	virtual DWORD GetSaveMagic(int ChunkIdx){return 0;}
	/**
    \brief Load data from 3D-file.
    \details
    Data will be in the same order as it was saved, no additional headers.
    */
	virtual void LoadData(int ChunkIdx,BinStream& BS){};
	/**
	\brief Store data to the 3B file using Bin stream.
	\details
	This function will be called 2 times during saving -
	once for size calculation, second - actually for saving.
	*/
	virtual void SaveData(int ChunkIdx, BinStream& BS){};
	/**
	\brief BeforeSave called each time before saving scene.
	*/
	virtual void BeforeSave(const char* filename){};
    /**
    \brief Perform action by ENTER key and return `true` if tool does not allow default ENTER action.
    */
	virtual bool onApply(){
		return false;
	}
    /// \brief For supports tool.
	virtual float GetBottomOffset(){return 0;}
	virtual bool NeedPutPointOnSurfaceInSoftStrokeMode(){return true;}
	virtual void RenderGuides(){};
	virtual bool GetClipPlane(comms::cPlane& pl){return false;}
	virtual bool SupportsMultithreadedePicking() { return false; }
	virtual void OnPick(float x,float y, PickInfo& pic);
	virtual const char* GetCmdID(){return CmdID.ToCharPtr();}
	virtual bool SnapIsActive(){ return false; }
	virtual bool SnapPoint(snap3dinfo& pt){ return false; }
#ifndef PY_PARSER
	virtual bool CheckDirectCasting() const override {
		return true;
	}
#endif // !PY_PARSER
	virtual bool NeedToClearLeakyPosDuringUndo() { return true; }
	virtual bool ZeroPressureOutsideTheObject() { return true; }
	virtual bool ZeroRadiusOutsideTheObject() { return true; }
	///Possible fields: Buildup, NrmSampling, NormalsSampling, 
	virtual bool IgnoreFieldInTopPanel(const char* FieldName) { return false; }
	static bool IgnoreFieldInUI(const char* FieldName);
	virtual bool SmoothAllSelectedOnly() { return false; }
	virtual bool SupportsAutoRetopoMeshUpdate() { return false; }
	virtual bool TopologyNeverChanges() { return false; }
	virtual bool HasOwnStampModeHandler() { return false; }
	/// called in curve editor to correct the curve alias and placement
	virtual void OnCreateNewCurve(OneCurveObject* cu){};
	virtual bool BeforeGizmolessTransform(bool dropUndo, Vector3D& resPivot) { return false; };
	virtual bool TransformSelected(const Matrix4D& OVR, Vector3D InitialCapPoint) { return false; }
	/// notify when pen/strip/material/Shader etc selected. Set breakpoint and select to get valid category.
	/// Currently available: Pen, MASK, Shaders, STRIPS, Materials
	virtual void OnSelectItem(const char* Category) {};
#ifndef PY_PARSER
	virtual bool OnCustomPick(VolumeObject* vo, cArray<tri_DWORD>& picked) { return false; }
#endif // !PY_PARSER

	/// the asking mechanism
	/// override the function if you know the answer on the question with the data
	/// return the priority of the answer, 0 - the answer is unknown, anything above means higher priority
	virtual int AnswerQuestion(const char* question, BaseClass* data, cStr& answer) { return 0; }
	virtual void OnTransformEverything(const Matrix4D& m_visual, const Matrix4D& m_export) {};
};
#define __CALLEXT(x) if(VoxelExtension::Current)VoxelExtension::Current->x;
///Derive from the CommandButton if you need command in toolset, not tool! class MyButton : public CommandButton { ... };
///Register as usual VoxelExtension::Register(new MyButton);
class APICALL CommandButton:public VoxelExtension {
public:
	virtual bool IsToolsAction() { return true; }
	///Functions you need to overload:
	virtual const char* GetID() { return "CommandIdThere"; }
	///RMB+MMB over section or tool, paste there, "*Selected" is just example
	virtual const char* GetPrevTool() {
		return "*Selected";
	}
	///What room? "Retopo" is just example
	virtual bool PresentInRoom(const char* RoomName) {
		return !strcmp(RoomName, "Retopo");
	}
	///place action there
	virtual void OnActivate() {
		///Action
	}	
};
class APICALL MainMenuExtension:public BaseClass{
public:
	//call this function to register own extension
	static void Register(MainMenuExtension* ex);
	//number of lines in Voxels RMB menu
	virtual int GetNumLines(){return 0;}
	//get text ID of the command
	virtual const char* GetID(int Line){return "???";}
	//get text Hint ID of the command
	virtual const char* GetHint(int Line){return "???";}
	//is it submenu?
	virtual const char* GetSubmenuID(){return NULL;}
	//get Host menu, works now only for Voxels
	virtual const char* GetHostMenu(){return "Voxels";}		
	//return true if it is in RMB Menu
	virtual bool IsInRMBMenu(){return false;}
	//return true if it is in Voxels Menu
	virtual bool IsInMainMenu(){return false;}
	//where is it located?
	virtual const char* GetPrevItemID(){return NULL;}
	//do the action
	virtual void Perform(int idx){};
};
#ifndef PY_PARSER
class APICALL SculptGenerator : public VoxelExtension {
private:
	VoxTreeBranch* _Object;
//	HashSummator hash;
//	bool ObjectGenerated;
//	bool Changed;
	void SetActiveObject(VoxTreeBranch* tb);
public:
	SculptGenerator();

	bool TransformObject;
	RegularGizmo Transform;
	HashSummator hash;
	bool ObjectGenerated;
	bool Changed;

	// Those 3 functions should be overriden:

	/**
	 * \brief provide the default name in objects tree
	 * \return the alias - name
	 */
	virtual const char* getDefaultObjectName() = 0;

	/**
	 * \brief You should implement the generating the object in good, final quality routine there.
	 */
	virtual void GeneratePreview() = 0;

	/**
	 * \brief Generate the object in "draft" quality, but quickly
	 */
	virtual void GenerateFinalObject() = 0;

	void CreateNewObject();
	/**
	 * \brief returns the object in the tree
	 * \return the object pointer. You may easily convert it to Volume or SceneElement using the corresponding constructor 
	 */
	VoxTreeBranch* getObject();

	/**
	 * \brief call this function from your implementation of the generator as soon as you need to re-generate the preview 
	 */
	void NotifyChanges();

	/**
	 * \brief Call this functon if you need to generate the final-quality-object from the user request
	 */
	void Generate();

	// just default overrides

	virtual void OnActivate() override;
	virtual void OnDeActivate() override;
	virtual void Process() override;

	const char* GetID() override {
		return GetClassName();
	}
	virtual bool AllowRectSelection() override {
		return false;
	}
	virtual bool OnChangeMember(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName) override;
	virtual void OnChangeCurVolumeManually(VoxTreeBranch* newCur) override;
	virtual bool OnUndo() override;
};
#endif //!PY_PARSER

#ifndef PY_PARSER
class APICALL SimpleMenuExtension:public MainMenuExtension{
public:
	virtual int GetNumLines(){return 1;}
	//return true if it is in Voxels Menu
	virtual bool IsInMainMenu(){return true;}
};
#endif  //!PY_PARSER
#define CorrectRange(x) if(Detail<0)Detail=0;if(Detail>x)Detail=x;if(Smoothing<0)Smoothing=0;if(Smoothing>1)Smoothing=1;
//#ifndef PY_PARSER
ClassArray<VoxelExtension>& VoxelExts();
ClassArray<MainMenuExtension>& VoxelMenuExts();
VoxelExtension* VoxelExt(int idx);

VoxelExtension* GetExtByID(int id);
//#endif

static int basedetail = 15;