#pragma once

#include "../../CoreAPI/cExAction.h"

class LinkedObject;


namespace SG {
	class SG_Vox;
}

class APICALL VoxMethadata :public VoxelExtension{
	static VoxTreeBranch* curr;
public:
	static void ProcessMethadata();
	static void SetZeroCur();
	VoxTreeBranch* Parent;
	virtual void OnActivateVolume(VoxTreeBranch* T){}
	virtual void OnDeactivateVolume(VoxTreeBranch* T){}
};
struct VoxKeeper{
	VoxKeeper(){
		T = NULL;
	}
	VoxTreeBranch* T;
	cList<VoxTreeBranch*> Child;
};

class APICALL CutsCollector {
public:
	cList<std::pair<Vector3D, Vector3D>> edges;
	cStr preferred_name;
	void transform(const Matrix4D& m);
	void fromVolumesIntersection(VoxTreeBranch* volume1, VoxTreeBranch* volume2);
	void functional(VoxTreeBranch* volume, std::function<float(const Vector3D&)>);
	void fromVolumeMeshIntersection(VoxTreeBranch* volume, comms::cMeshContainer* mesh);
	void toSequentialSelPoints(cList<OneSelPoint>& curve);
	void makeCurves();
	void relaxInTube(VoxTreeBranch* volume, float radius, bool symm = true);
	void createWeightsVolume(VolumeObject* dest, float radius, Matrix4D edges_transform);
	void mergeTubeTo(VoxTreeBranch* dest, float radius);
};

class NGObject;

/**
\brief Hierarchical layers (voxel and surface) which you see in the SculptRoom.
\details
Every item in this object contains transform matrix and reference to the item in `VTree`.
It refers `VolumeObject`. There may be multiple references on same `VolumeObject` from separate `VoxTreeBranch`-es.
Root of all `VoxTreeBranches` kept in `RootVTree`.
\see VolumeObject
*/
class APICALL VoxTreeBranch:public ItemsTree{
public:	
	VoxTreeBranch();
	~VoxTreeBranch();
	VoxTreeBranch* Parent;
	VolumeObject* Obj;
	//cStr Name; ///< name in tree
	static bool StoreMode;
	/// Attributes visible for user in `VoxTree`.
	//bool Visible; ///< visibility
	bool Ghost; ///< ghosting
	bool pVoxSurf; ///< was in surface on previous frame?
	bool VoxSurf; ///< in surface mode?
	bool HideInViewport;///< Hidden in viewport, but pickable
	bool Procesed;
	//bool OpenState; ///< branch is open
	bool IsRef;
	bool IsActive;
	bool IsInTransform;
	bool ToDestroy; ///< shoul be destroyed. Don't delete leafs manually, just set this flag!
	bool InCache; ///< is in cache
	bool Instance; ///< is Instance. It does not mean that it was actually instanced. Current selected object is never instance! It gives instance flag to other non-current leaf.
	bool SkipPick;
	bool Inverse; ///< indicates tat transform matrix 3x3 part determinanant is negative, normals/polygons should be flipped for rendering
	//bool Selected;
	int  SelectionTime;
	cStr CacheName; ///< reference to cache
	cStr ExData; ///< methadata
	cStr SymmetryData; ///< symmetry data kept to be stored in undo routine
	int SpaceID; ///< unique ID of the volume, it is not unique for leafs, just for volumes itself!
	//int Level; ///< deph in VoxTree structure
	float ProxyScale;
	Matrix4D Transform; ///< transform for local to global scale
	Matrix4D InvTransform; ///< transform from global to local space
    /// \todo ???
    Matrix4D LocalTransform;
	/// Last used transform gizmo parameters.
	Vector3D GizmoCenter;
	bool GizmoCenrtified;
	bool GizmoDirected;
	Vector3D GizmoX;
	Vector3D GizmoY;
	Vector3D GizmoZ;
	ClassPtr<VoxMethadata> Methadata;
	static VoxTreeBranch* LockedVolumeChanged;
	static StringsList StoredIsolatedObjects;
	static StringsList StroredIsolatedGhostObjs;
	std::function<float(Vector3D)> volumetrical;

	ClassArray<LinkedObject>* tmpLinkedObjects = nullptr;
	ClassArray<LinkedObject>& GetLinkedObjects();

	static ClassArray<NGObject> SceneNGObjects;
	int NGObjectIdx = -1;
	NGObject& GetNodeSystem();

	static float MergeDisplacement;

	/// child leafs
	//ClassArray<VoxTreeBranch> ChildObjects;
	VoxTreeBranch*& ChildObjects(int i);
	int ChildObjectsCount() const;
	int GetObjectsCountRecursive();
	void ChildObjectsAdd(VoxTreeBranch* tb);
	void ChildObjectsInsert(int Pos, VoxTreeBranch* tb);
	void ChildObjectsClear();
	void ChildObjectsDel(int idx, int count);
	void ChildObjectsDelElement(int idx);
	

	/// primitives usage history
	ClassArray<OnePreset> PrimPresets;

	//methods

    /// \see Del()
	void Delete();

	void _Add();

	///overrides from ItemsTree
	ItemsTree* Add(bool AddToSubtree = true) override;
	virtual void CreateRmbMenu(BaseWidget* Prop) override;
	virtual void DropTreeStructureToUndo() override;
	virtual void OnDuplicate(ItemsTree* CopyPtr) override;
	virtual void AdditionalElementRenderingInUI(BaseWidget* BaseBox);
	virtual bool IgnoreAltIsolate() { return true; }
	virtual void ApplyBooleans(ItemsTree* Source, bool shift, bool ctrl, bool Keep) override;
	virtual void ChangeParentItem(ItemsTree* NewParent);
	virtual void NotifyParentChange(ItemsTree* NewParent);

	///ond of ovverrides from ItemsTree
	void ProcessItem();
	
	
	VoxTreeBranch* Add(const Matrix4D& T, const char* Name, bool undo = true, bool ToSubtree=true);
	VoxTreeBranch* Add(const char* name,bool CheckExisting,const Matrix4D* T=NULL);
	void StoreChildStructure(cList<VoxKeeper>& keep);
	void RestoreChildStructure(cList<VoxKeeper>& keep);
	bool CheckPresenceInSubTree(VoxTreeBranch* Element);
	void InstanceToParentInstances();
	void Insert(int idx);
	bool EditShader();
	bool ApplyNodes();
	static void CreateNewShader(const char* BaseShader, const char* NewShaderName = nullptr, bool Activate = true);
	void Rename() override;
	bool _Save3B(cPtrDiff subtree);
	void Save3B(bool subtree,const char* name, bool sel=false);
	bool _Merge3B();
	void Merge3B(const char* name);
	void CheckInstanceRemoving();
	bool Add1();
	void Decompose();
	void _Resample();
	void Resample(float scale,int Q);
	bool TransformIt();
	bool Del(bool onlythis);
	bool DelSelected();
	bool DelNoUndo();
	static void validate_cur();
	bool ImportPointsCloud();
	bool ImportModel();
	bool ExportScene();
	bool ExportObject();
	bool ExportPatternForMerge(cPtrDiff idx);
	bool ExportPatternAsPen();
	bool ExportCurveProfile();
	void MergeInstance(comms::cMeshContainer* mc,const Matrix4D m);
	void MergeInstanceSymm(comms::cMeshContainer* mc,const Matrix4D m);
	VoxTreeBranch* Approve(cPtrDiff p);
	VoxTreeBranch* Approve(VoxTreeBranch* p);
	bool CheckMultiselectionCancel();
	Vector4D GetSelHighlight();
	void HighlightIt(bool IfPassive);
	bool Highlighted();

	bool MergeObj(VoxTreeBranch* p);
	bool PlainMergeObj(VoxTreeBranch* p);
	void Flip(cPtrDiff x,cPtrDiff y,cPtrDiff z);
	void FlipSel(cPtrDiff x, cPtrDiff y, cPtrDiff z);
	void CollectBranches(cList<VoxTreeBranch*>& list);
	void CollectInstances(VolumeObject* vo,cList<VoxTreeBranch*>& List);
	static void ApplyTransformToInstances(const Matrix4D& M,VolumeObject* vo,bool InstOnly=false,bool R=false, bool applyNGScale = true);
	void CombineChildren();
	void FlipNormals();
	void MakeUniform(bool global, cList<VoxTreeBranch*> tbList);
	void MakeUniform();
	void MakeUniform2();
	void AllUniform();
	bool isUniform();
	bool MoveObj(VoxTreeBranch* p, bool KeepSource);
	bool PlainMoveObj(VoxTreeBranch* p);
	bool SubObj(VoxTreeBranch* p, bool KeepSource);
	bool IntrsObj(VoxTreeBranch* p, bool KeepSource);
	bool RemIntrsObj(VoxTreeBranch* p);
	bool SplitObj(VoxTreeBranch* p);
	bool MakeHull();
	bool MakeHull2();
	bool CloseHoles();
	bool CloseTunnels();
	bool Extrude();
	void SetDirty();
	bool SetVoxShader(cPtrDiff obj,cPtrDiff id);
	bool ApplyAxialSymmetry();
	bool ChangeParent(VoxTreeBranch* p);
	void ShowHideButThis();
	void GhostButThis();
	void UnghostWithSubtree();
	void GhostWithSubtree();
	void InvertGhostWithSubtree();
	void InvertVisibleWithSubtree();
	void BakeColorsThere();
	bool ShowAll();
	bool ShowSubtree();
	void PutOnGroundEx(Vector3D& minvt,Vector3D& cm);
	void PutOnGround();
	void LayOnGround();
	void InvertHiddenFaces();
	void DeleteHiddenFaces(bool invert);
	DWORD CalcHash(int d=1);
	static bool valid(VoxTreeBranch* tb);
	static bool valid(cPtrDiff ctb);
	VoxTreeBranch* GetRoot();
	bool DeselectAll(VoxTreeBranch* R=NULL);
	void StoreSymm();
	void RestoreSymm();
	cStr GetUniqueName(bool takethisname, const char* suffix);
	VoxTreeBranch* CreateUniqSpace(bool safe,const char* suffix);
	VoxTreeBranch* Clone(bool Recursive=false,VoxTreeBranch* dest=NULL,bool Inst=false,bool Subtree=false,const Matrix4D& T=Matrix4D::Identity,bool ChangeTool=true,bool CopyData=true,bool SetCurr=true, bool ForceReplaceDest=false, bool SelectedOnly=false);	
	void Clone2();
	void CloneInst2();
	bool CloneDegrade(bool Undo);
	void CloneAndDegradeCur();
	void SeparateHidden();
	void MergeVisible();
	void PlainMergeVisible();

	void MergeSelected();
	void PlainMergeSelected();

	void MergeDown();
	void MergeSubtree();
	void PlainMergeSubtree();
	void MergeTo(VoxTreeBranch* Dest,int sub,bool ClearThis,bool NoUndo);
	void PlainMergeTo(VoxTreeBranch* Dest, bool NoUndo);
	void MergeModel(comms::cMeshContainer& mc,int Subtract,bool FirstLast=false,bool InvFaces=false,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	void MergeModel(comms::cMeshContainer& mc,Matrix4D& M,bool Subtract,bool FirstLast=false,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	VoxTreeBranch* find(VolumeObject* vo);
	VoxTreeBranch* find(DWORD gu, bool NonInstance = true);
	VoxTreeBranch* GetParent(VoxTreeBranch* tb);
	VoxTreeBranch* CloneSpaceVT(bool changetool=true,bool subtree=false);
	static VoxTreeBranch* Current();
	VoxTreeBranch* SeekByUserInt(int val);
	void SetupNewNodeSystem();
	bool CloneSpace();
	bool IncDencity2X();
	bool DecDencity2X();
	bool CloneSymm(bool Recursive = false, VoxTreeBranch* dest = NULL, VoxTreeBranch* root = NULL, bool Inst = false, cList<VoxTreeBranch*>* result = NULL);
	void CloneSymm2();
	void CloneInstSymm2();
	void SelectCurrent();
	void SelectCurrentOnScreen();
	void SimpleSelect();
	bool QuadrangulateAndMerge(cPtrDiff);
	bool QuadrangulateAndMerge2(cPtrDiff);
	bool QuadrangulateAndMergeDP();
	bool Quadrangulate(cPtrDiff);
	bool Quadrangulate2(cPtrDiff);
	void DecToRetopo();
	void DecToRetopoAll();
	void PushMatrix();
	void PopMatrix();
	void UnIstance(bool copy=true);
	void ListInstancesLikeThis(cList<VoxTreeBranch*>& List);
	void SaveTransforms(const char* name);
	void LoadTransforms(const char* name);
	void BlendTransforms(const char* name1,const char* name2,float blend);
	void SaveTransforms();
	void LoadTransforms();
	void SetTransform(const Matrix4D& m);

	void CollectSelected(cList<VoxTreeBranch*>& list, bool IncludeCur = true, bool OnlyVisible = true, bool include_bool = false);
	void SmartCollectSelected(cList<VoxTreeBranch*>& list);
	static VoxTreeBranch* BestCurentCandidate();
	void SelectVisibleSubtree();
	void ChooseRefColor();
	bool TopologyLocked();

	//virtual bool CanBeDragged(const char* MemberID,int& dx,int& dy);
	//virtual bool CanAcceptDrag(const char* MemberID);
	//virtual bool OnStartDrag(const char* MemberID);
	//virtual bool OnEndDrag(const char* MemberID);
	//virtual bool OnAcceptDrag(BaseClass* DraggedItemParent,const char* DraggedMemberID,const char* AcceptorMemberID,iRct MyRect);
    /// Class registration.
    /// \see `implement_class` in cpp-file
	SERIALIZE_LATER();
	bool OnChangeMember(BaseClass* mc,void* mp,void* me,const char* mn);
	virtual bool OnScriptRecorder(BaseClass* mc, void* mp, void* me, const char* mn);
	bool ApproveThis();
	virtual void OnModifyControl(const char* Name,BaseWidget* BW, ClassEditorContext& Context) override;
	virtual bool RMBHotkeysActiveForThisItem() override;
	DWORD GetClassMask() override;
	virtual int GetElementLevel(const char* name);
	int ProcessNode(cList<VORenderQueue>& RQ,bool OnlyVisible=true,bool Safe=false,bool EvenHidden=true, bool subtree=true, bool check_duplicates = false);
	void ProcessNodeCleanup();
	void ProcessNodeVisibility(bool MakeInvisible=false);
	void UpdateHash(HashSummator& H,void* data = nullptr, void* extra = nullptr) override;

	void CollectChildVO( cList<VoxTreeBranch*>* );
	bool IsNameUniq(const char* name);
	void StoreVOTree(BinStream& B, bool bin);
	bool CheckIfParent(VoxTreeBranch* child);
	VoxTreeBranch* FindParent(VoxTreeBranch* root, int& index);
	void RefreshLevels();
	void SetupLevels(int L);
	void SetupVOMat();
	void RestoreVOTree(BinStream& B, bool Clear = true);
	void SetDestroyState();
	void SetVIDS();
	void SetInvM();
	void FindVOBS();
	Vector3D GetMainAxis(Vector3D& X, Vector3D& Y, Vector3D& Z,bool SelectedOnly);
	void ScrollTo();
	bool CheckLockedVolume();
	SG::SG_Vox* InitVox();

	virtual void removeThis() override;
	virtual ItemsTree* duplicate() override;
	virtual void setTransform(const Matrix4D& m) override;
	virtual ItemsTree* duplicateAsInstance() override;
	virtual bool instancingSupported() override;
	virtual Matrix4D getTransform() override;

	void SemiBoolean(VoxTreeBranch* other, int op_type);
	void CutMesh(const std::function<float(Vector3D)>& cutter, cList<bi_int>* edges);
	void FindCutEdges(const std::function<float(Vector3D)>& cutter, cList<std::pair<Vector3D, Vector3D>>& edges);

	void GetCutRecursive(cVec2& minmax, const Vector3D& p, VolumeObject* except, float* unitlen);
	static float GetCut(cVec2& minmax, const Vector3D& p, VolumeObject* except, float* unitlen);
	static void ApplySurfaceChangesToVoxelsVolumes();
	void getIntersectionCurveWith(VoxTreeBranch* with, cList<OneSelPoint>& curve);
	void createIntersectionCurveWith(VoxTreeBranch* with);
};

class sel_keeper
{
	cList<VoxTreeBranch*> sel;
	VoxTreeBranch* cur;
public:
	sel_keeper();
	~sel_keeper();	
};

inline void VoxTreeBranch::ChildObjectsDelElement(int idx) {
	Child.DelElement(idx);
}

class APICALL HullParams :public BaseClass{
public:
    HullParams(){
        EdgeThickness = 4;
    }
    float EdgeThickness;
    SERIALIZE() {
        REG_FSLIDER_EX2( EdgeThickness, 0, 10, 4, "%#Thickness" );
    } 
};
class APICALL VoxVisualTree :public VoxTreeBranch {
public:
	VoxVisualTree();

	void AddNewVolume();
	void DeleteSelectedVolumes();
	void DuplicateSelectedVolumes();
	void CloneSpaceDencity();
	void SymmCopy();
	void EditShader();
	void IncRes();
	void ClearCurrLayer();
	
	SERIALIZE_LATER();
};
extern VoxVisualTree RootVTree;
class VoxTreeWindowPlacer :public PopupWindow {
public:
	virtual BaseClass* GetClass();
	virtual const char* GetWindowID();
	virtual double GetWindowSortValue() { return 6; }
};
extern VoxTreeWindowPlacer* VoxTreeWindow;

APICALL void start_VolumePicker(std::function<void(VoxTreeBranch*)> callback);
APICALL void start_VolumePicker(std::function<void(VoxTreeBranch*)> callback, std::function<bool(VoxTreeBranch*)> Checker);