#pragma once

//There are bricks for constructing gizmos like sphere, line, cube, arrow, rotators et in this file

struct mlEdge{
	Vector3D p1;
	Vector3D p2;
	Vector3D n1;
	Vector3D n2;
};

struct APICALL MeshLib{
	~MeshLib();

	MeshLib();
	cStr Name;
	StaticMesh* Mesh;
	comms::cMeshContainer* mc;
	cList<mlEdge> Edges;
	void Render(const Matrix4D& Transform, DWORD Color,float Bias);
};

APICALL MeshLib* GetPrim(const char* Name, bool Sharp);

struct APICALL PrimPickResult {
	PrimPickResult() {
		PtOnRay = Vector3D::Zero;
		PtOnPrim = Vector3D::Zero;
		Dist = FLT_MAX;
		Depth = FLT_MAX;
		ExtraDepthForPriory = 0;
	}
	Vector3D PtOnRay;
	Vector3D PtOnPrim;
	float Dist;
	float Depth;
	float ExtraDepthForPriory;
};

class APICALL BaseDrawingPrim:public BaseClass{
public:
	BaseDrawingPrim();
	Vector3D Pos;	
	Vector3D StartPos;
	Vector3D CapturePos;
	Vector3D NewPos;
	Vector3D PrefDir;
	int WasCaptured;
	int  Captured;
	bool Highlighted;
	bool Passive;
	bool Visible;
	bool Hidden;
	bool Excited;
	bool LowPriory;
	bool Active;
	bool Selected;
	bool TabValueChanged;
	bool Snappable;
	bool  AllowTab;
	bool OnlyExactPick;
	bool Moved;
	bool Rendered;
	float PrevTabEditValue;
	float TabEditValue;
	float TabValueDestination;
	float TabValueStep;

	int Constraints;//bits: 0,1,2,3,4-x,y,z,vec,plane
	int SubstArrow;
	Vector3D ConstraintVector;
	Vector3D ConstraintPlane;
	DWORD Color;
	virtual void Render(DWORD _Color);
	virtual float Pick(comms::cSeg Seg);
	virtual PrimPickResult PickDist(comms::cSeg Seg);
	virtual float getGradualSpeed() { return 0.0f; }
	void OnStdMove(cVec2 end);
	virtual void OnMove(cVec2 start,cVec2 end);
	bool Pointed();
	bool hasValueDestination();
	void stopValueDestination();
};

class APICALL ObjectBasedPrim:public BaseDrawingPrim{
public:
	ObjectBasedPrim();
	~ObjectBasedPrim();

	void AssignObject(const char* Name,bool Sharp);
	comms::cMeshContainer* mc;
	MeshLib* ML;
	StaticMesh* Mesh;
	Matrix4D Transform;
	bool IsSpherical;
	void RenderObject(DWORD _Color);
	virtual void Render(DWORD _Color) override {
		RenderObject(_Color);
	}
	virtual float Pick(comms::cSeg Seg) override;
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};

class APICALL BoundSpherePrim:public ObjectBasedPrim{
public:	
	BoundSpherePrim();
	float Radius;
	float ActiveRadius;
	float VisualRadius;
	virtual float Pick(comms::cSeg Seg) override;
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};

class APICALL PassiveLineConnector:public ObjectBasedPrim{
public:
	PassiveLineConnector();
	BaseDrawingPrim* Start;
	BaseDrawingPrim* End;
	virtual void Render(DWORD _Color);
};

class APICALL ActiveLineConnector:public ObjectBasedPrim{
public:
	ActiveLineConnector();
	BaseDrawingPrim* Start;
	BaseDrawingPrim* End;
	float Ethalon;
	float Cumulanta;
	bool NoActive;
	bool Thick;
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};

class APICALL ActiveFaceConnector:public ObjectBasedPrim{
public:
	ActiveFaceConnector();
	cList<BaseDrawingPrim*> Points;	
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
};

class APICALL RingRadiusPrim:public ObjectBasedPrim{
public:
	RingRadiusPrim();
	BaseDrawingPrim* Start;
	BaseDrawingPrim* End;
	float RingPos;
	float Radius;
	float RadiusMod;
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
};

class APICALL ArrowPrim:public ObjectBasedPrim{
public:
	ArrowPrim();
	Vector3D Dir;
	float Length;
	float Ethalon;
	float Cumulanta;
	float ScreenSize;
	BaseDrawingPrim* Start;	
	BaseDrawingPrim* Start2;
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
};

class APICALL RotorPrim:public ObjectBasedPrim{
public:
	RotorPrim();
	Vector3D Dir;
	float Length;
	Matrix4D RTransform;
	float Angle;
	float OverallAngle;
	float OverallAngle2;
	BaseDrawingPrim* Start;		
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
};

class APICALL RotatorPrim:public ObjectBasedPrim{
public:
	RotatorPrim();
	Vector3D Dir;
	Vector3D Dir2;
	float Length;	
	Matrix4D RTransform;
	float Angle;
	float OverallAngle;
	float OverallAngle2;
	BaseDrawingPrim* Start;		
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
	virtual float getGradualSpeed() { return 6.0f; }
};

class APICALL CircleRotatorPrim:public ObjectBasedPrim{
public:
	CircleRotatorPrim();	
	float Radius;	
	Matrix4D RTransform;
	Vector3D AverageAxisDir;
	float Angle;
	float OverallAngle;
	float OverallAngle2;
	BaseDrawingPrim* Start;		
	virtual void Render(DWORD _Color) override;
	virtual void OnMove(cVec2 start,cVec2 end) override;
	virtual float Pick(comms::cSeg Seg) override;
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};
class APICALL RingScalePrim :public ObjectBasedPrim{
public:
	RingScalePrim();
	float Radius;
	float InnerRadiusRelation;
	Matrix4D RTransform;
	float Scale;
	float dScale;
	Vector3D Right;
	BaseDrawingPrim* Start;
	virtual void Render(DWORD _Color);
	virtual void OnMove(cVec2 start, cVec2 end);
	virtual float Pick(comms::cSeg Seg);
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};

class APICALL CircleBoundPrim:public ObjectBasedPrim{
public:
	CircleBoundPrim();	
	float Radius;	
	BaseDrawingPrim* Start;		
	virtual void Render(DWORD _Color);	
	virtual void OnMove(cVec2 start,cVec2 end);
	virtual float Pick(comms::cSeg Seg);
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};

class APICALL PlaneBoundPrim:public ObjectBasedPrim{
public:
	PlaneBoundPrim(){
		DrawExterior=true;
		DrawHole=true;
		PlaneOpacity=0.1;
	}

	Vector3D	AxisX;
	Vector3D	AxisY;
	float		SizeX;
	float		SizeY;
	float		HoleSizeX;
	float		HoleSizeY;
	bool		DrawExterior;
	bool		DrawHole;
	float		PlaneOpacity;

	virtual void  Render(DWORD _Color);	
	virtual void OnMove(cVec2 start,cVec2 end);
	virtual float Pick(comms::cSeg Seg);
	virtual PrimPickResult PickDist(comms::cSeg Seg) override;
};

class APICALL CubePrim:public ObjectBasedPrim{
public:
	CubePrim();
	Vector3D Dir1;
	Vector3D Dir2;
	float Length;
	Vector3D Dv;
	float ScrSize;
	float ExMod;
	BaseDrawingPrim* Start;	
	virtual void Render(DWORD _Color);	
	virtual void OnMove(cVec2 start,cVec2 end);
};

APICALL bool swYZ();
inline DWORD XCLR(){
	return swYZ() ? 0xFF00FF00 : 0xFFFF0000;
}
inline DWORD YCLR(){
	return swYZ() ? 0xFF0000FF : 0xFF00FF00;
}
inline DWORD ZCLR(){
	return swYZ() ? 0xFFFF0000 : 0xFF0000FF;
}
APICALL Matrix4D GetLTransform(Vector3D P1, Vector3D P2, float t, float r, float Aspect, int FromView = 0, Vector3D* Dir1 = NULL, Vector3D* Dir2 = NULL);
APICALL float PickSphere(comms::cSeg& Ray, Vector3D Pos, float R);
APICALL void PickSphere4D(comms::cSeg& Ray, Vector3D Pos, float R, Vector3D& RayPt, Vector3D& ObjPt);
