#pragma once
#include "BasePrim.h"
#include "ObjectsPlacers.h"

//Cube primitive and Cube-like gizmo used everywhere as regular gizmo

//How to use reguar gizmo?
//Declare variable
//RegularGizmo G;
//....
//When need to show gizmo, call each render cycle
//G.MakeVisible();
//and just stop calling MakeVisible each cycle when it is no longer need
//If ou need to edit parameters  of gizmo in UI, just register the gizmo in your UI class as 
//REG_AUTO(G);


class APICALL RegularGizmo :public BasePrim{
	bool		_ResetAxisViewSpace;
	bool		_MainAxisCenterMass;
	bool		_MoveOnlyGizmo;
	bool		_LocalSpace;
	bool		_BoundCenterViewSpace;
	bool		_PickPivot;
	bool		_AlignXYZ;
	bool		_ShowScaleButtons;
	bool		_ShowRotationButtons;
	std::function<void(RegularGizmo*)> _AutoAlign;
	void		AutoAlign() {
		if (_AutoAlign)_AutoAlign(this);
	}
public:
	RegularGizmo();
	~RegularGizmo();
	void reset_class(void* ptr);

	CubePlacer	CP;
	int			SimpleLook;//set 1 if you need just Y axis, set 2 if scaling constrols should be missed, set 3 if need to skip MoveOnlyGizmo, MainAxis/CenterMass
	bool		IsInMerge;//Used for Merge/Import tool
	bool		ResetLocalSpace;//Indicates that ToLocalCenter (1), ToCenterMass (2), ToBoundCenter (3), ToMainAxis (4) button(s) was pressed
	int			toLocalCenter;//Indicates that ToLocalCenter buttom was pressed
	bool		_ResetAxis;//Indicates that ResetAxis buttom was pressed
	bool		ShowAxis;//jut for UI - open or close coordintes set

	Vector3D PCPos;
	
	//to be called from UI

	virtual bool AllowRectSelection();
	virtual WidgetsScheme* GetScheme();
	void EditGizmoElements();
	void DropUndoIfNeed();
	virtual void ResetAxis();
	virtual void ResetSize();
	virtual void ResetPosition();
	virtual void GetPosition(comms::cVec3& pos) { pos = Position(); }
	void ResetSpace();
	void ToLocalCenter();
	void ToCenterMass();
	void ToBoundCenter();
	void ToMainAxis();
	float EnterScale();
	float EnterAngle();
	void ApplyCPTransform(Matrix4D M);
	void ApplyCPTransform2(Matrix4D M);
	void Scale();
	void ScaleX();
	void ScaleY();
	void ScaleZ();
	void Rotate();
	void RotateX();
	void RotateY();
	void RotateZ();
	void X();
	void ViewSpace();
	void ViewSpaceZ();

	void AlignAxisY(Vector3D ax, Vector3D ay, Vector3D az);
	void AlignX();
	void AlignY();
	void AlignZ();
	
	void ShowAxisDirection();
	void HideAxisDirection();
	void PickPivot();

	//to be called by programmer
	void MakeVisible();//call it once per frame if need gizmo
	void MakeAlwaysVisible();//gizmo will be visible till destructor will be called
	void HideGizmo();//hide gizmo without destruction, unhide ony using MakeAlwaysVisible
	
	Vector3D& Position();//gizmo center position, to read/write
	Vector3D& AxisX();//Axis X of the gizmo
	Vector3D& AxisY();
	Vector3D& AxisZ();
	Matrix4D& OverallGizmoTransform();//returns accumulated transform of gizmo, may be read/written

	///partial show/hide of gizmo parts, obvious from names
	void ShowAxisScaleControls(bool X, bool Y, bool Z);
	void ShowAxisRotationControls(bool AllowX, bool AllowY, bool AllowZ);
	void ShowScreenSpaceRotationControls(bool Show);
	void ShowAxisControls(bool X, bool Y, bool Z);
	void ShowOverallScaleControls(bool Show);
	void ShowScreenSpaceMovementControls(bool Show);
	void ShowPlaneScaleControls(bool Show);
	
	///Show/hide particular gizmo dialog elements
	void ShowMainAxisCenterMass(bool Show);
	void ShowResetAxisViewSpace(bool Show);
	void ShowMoveOnlyGizmo(bool Show);
	void ShowLocalSpace(bool Show);
	void ShowScaleButtons(bool Show);
	void ShowRotationButtons(bool Show);
	void ShowBoundCenterViewSpace(bool Show);
	void ShowPickPivot(bool Show);
	void ShowAlignXYZ(bool Show);
	void ShowAutoAlign(std::function<void(RegularGizmo*)> fn);
	void ToVerySimpleLook();

	SERIALIZE_LATER();//class registration, see implement_class in cpp file
	DWORD GetClassMask() override;
	virtual bool OnChangeMember(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName) override;
	virtual void Transform(const Matrix4D& m) override;
private:
	comms::cMeshContainer mc;
	int previewHash;
	StaticMesh* preview;
};

class APICALL CubPrim :public RegularGizmo{
	StaticMesh* Mesh;
	float		MHash;
public:
	bool		UseChamfer;
	float		ChamferRadius;
	float		ChamferRadiusRelation;
	int			ChamferSegments;
	bool		KeepChamferRadius;

	CubPrim();
	~CubPrim();
	virtual void AfterLoad() override;
	virtual void Render();
	virtual void CreateObject(VolumeObject* VO, int Subtract);
	bool OnChangeMember(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName);
	bool OnScriptRecorder(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName);	
	SERIALIZE_LATER();//class registration, see implement_class in cpp file
	DWORD GetClassMask() override;
	bool GetCoreAPICommand(cStr* result) override;
};

