#pragma once
//Look "3D-Coat\MC\Voxel Structure.jpg" to understand general structure of voxel mesh.

class VolumeCell;

struct MeshHelper{
	MeshHelper(){
		MaxIndex=0;
	}
	void Clear(){
		MaxIndex = 0;
		FreeIndices.Clear();
	}
	//this array is used if some index is no longer used in whole mesh
	cList<int> FreeIndices;
	//if FreeIndices is empty then you may get new index using this field
	int MaxIndex;
	int GetNewIndex(){
		if(FreeIndices.GetAmount()>0)return FreeIndices.pop_back();
		else return ++MaxIndex;
	}
	void ReleaseIndex(int idx){
		FreeIndices.Add(idx);
	}
}; 