#pragma once
#pragma warning(disable : 4996)

#include "AALines.h"
/**
macro to assign callbacks to widlges using lambda syntax
///Usage:
BaseWidget* w=...create in some way...;
w->Methadata = ...some conext, for example this...;
ui_callback(WM_....,w){
....do something... Context may be taken from BaseWidget::CurrentWidget, for example from BaseWidget::CurrentWidget->Methadata. You can't use context from the current function
}ui_end;
*/
#define UI_callback(msg, w)w->AddCallback(msg, new_callback([=]() -> void
#define UI_end ))

class BaseWidget;

//#define ALLOWTRY

#define WM_BEFORECHANGE	 0x12340000
#define WM_CHANGE		 0x12340001
#define WM_MOUSEOVER	 0x12340002
#define WM_RESIZE		 0x12340003
#define WM_SKIPPROP		 0x12340004
#define WM_STARTMOVE	 0x12340005
#define WM_ENDMOVE		 0x12340006
#define WM_CLOSEWINDOW	 0x12340007
#define WM_ONDROP		 0x12340008
#define WM_ONDROPFILE	 0x12340009
#define WM_CREATECONTENT 0x1234000A
#define WM_CHECKHOTKEY   0x1234000B
#define WM_CUSTOMPROP    0x12340100

#define WM_PRESS_BTN WM_LBUTTONDOWN
 
#define StdIconSize 64
#define UI_IconsColorMask 0xB0FFFFFF

typedef bool fnAction(BaseWidget* Widget);
class BaseWidget;

/**
 * \brief Returns DWORD value placed by the pointer. Used to calculate hash value dependent on function parameters.\n
 * It is a bit dirty hack, but it allows to determine if two sets of function parameters are identical.
 * \param d
 * \return
 */
DWORD PtrToHash(void* d);

//#define IKC comms::cInput::Codes

class APICALL WBaseCallback{
public:
	WBaseCallback(){
		Dep=NULL;
		MustDie=0;
		ExitIfTrue=0;
		Checker = 0x12345678;
		Hotkey = 0;
	}
	DWORD Hotkey;
	virtual ~WBaseCallback() {

	}
	void operator delete(void* ptr, size_t size);
    int Message;
	int Checker;
	short MustDie;
	short ExitIfTrue;
	BaseWidget* Dep;	
    virtual bool call(){return false;}
	virtual bool equals(WBaseCallback* other) { return false; }
	virtual bool equals_strictly(WBaseCallback* other) { return false; }
	virtual bool same_hash(DWORD d) { return false; }
	virtual void AlterHash(int value) {}
	template <class F>
	bool same_function(F&& f) {
	    return same_hash(PtrToHash((void*)&f));
    }
};
class APICALL TextItem:public BaseClass{
public:
	cStr time;
    cStr ID;
	cStr Text;
	SERIALIZE() {
		REG_AUTO(ID);
		REG_AUTO(Text);
		REG_AUTO(time);
	}
	virtual void Save(TagsList& xml, void* ClassPtr, void* Extra) override;
};
class APICALL TextManager{
	struct idt {
		cStr id;
		cStr text;
	};
	static cList<idt*> reverse;
	static uni_hash<int, int> reverse_hash;
	static void ReplaceAll(ClonesArray<TextItem>& itm);
public:
	static ClonesArray<TextItem> Text;
	static uni_hash<int,int> TextIndex;
	static ClonesArray<TextItem> Text2;
	static uni_hash<int,int> TextIndex2;
	static void Init();
	static void Reload();
    static cStr GetCurrentLang();
	static int GetTextHash(const char* s);
	static void CreateTextIndex();
    static const char* GetText(const char* ID);
	static const char* GetEngText(const char* ID);
	static const char* GetID(const char* ID);

	static TextItem* GetTextTag(const char* ID);
	static TextItem* GetEngTextTag(const char* ID);

	static const char* eq(const char* ID){return ID;}
	static void GetIdsByText(const char* text, cList<const char*>& ids);
};

class VideoHintManager{
	static StringsList IDList;
	static uni_hash<bi_int, int> Index;
	static cList<cStr> Urls;
	static bool Updated;
	static cStr LiveUpdate;
public:
	static bool CheckID(const char* s);
	static const char* GetUrl(const char* s);
	static void Load();
	static bool Assign(const char* IDS);
	static void UpdateHintsList();
	static void AssignUpdate(const char* upd);
};
enum wAlignType{
    wa_None  ,
	wa_Top   ,
	wa_Bottom,
	wa_Left  ,
	wa_Right ,
	wa_Center
};
enum ParentAlignTypeX{
    pa_None,
	pa_RightToLeft,
	pa_LeftToLeft,
	pa_LeftToRight,
	pa_RightToRight
};
class TextWidget;
class VScroller;
class TextMenu;
class DockSpace;
class DockableHeader;
class FrameWidget;

extern std_OnePoolType wpc_Pool;
extern std_OnePoolType FrameWidget_Pool;
extern std_OnePoolType TextWidget_Pool;
void InitWpcPool();
void InitTWPool();

#define CL_LVL1 8
#define CL_LVL2 16
#define CL_LVL3 24

#define CLASSID_BaseWidget		123
#define CLASSID_TextWidget		(CLASSID_BaseWidget  + (1<<CL_LVL1))
#define CLASSID_ComboBox		(CLASSID_BaseWidget  + (2<<CL_LVL1))
#define CLASSID_PanelWidget		(CLASSID_BaseWidget  + (3<<CL_LVL1))
#define CLASSID_DrawTexRect		(CLASSID_BaseWidget  + (4<<CL_LVL1))
#define CLASSID_DockSpace		(CLASSID_BaseWidget  + (5<<CL_LVL1))
#define CLASSID_SimpleSlider	(CLASSID_BaseWidget  + (6<<CL_LVL1))
#define CLASSID_VScroller	    (CLASSID_BaseWidget  + (7<<CL_LVL1))
#define CLASSID_PictMenu	    (CLASSID_BaseWidget  + (8<<CL_LVL1))
#define CLASSID_TextMenu		(CLASSID_BaseWidget  + (9<<CL_LVL1))
#define CLASSID_SimpleSliderH	(CLASSID_BaseWidget  + (10<<CL_LVL1))//for proxy slider
#define CLASSID_FrameWidget		(CLASSID_TextWidget  + (1<<CL_LVL2))
#define CLASSID_WidgetsFolder	(CLASSID_TextWidget  + (3<<CL_LVL2))
#define CLASSID_DockableHeader	(CLASSID_FrameWidget + (1<<CL_LVL3))


class APICALL BaseWidget : public BaseClass{
public:
    __constructor(BaseWidget);
    virtual ~BaseWidget();

	void operator delete(void *ptr, size_t size){
		BaseWidget* w=(BaseWidget*)ptr;
		if(w->PoolSize==FrameWidget_Pool.GetQuantSize())FrameWidget_Pool.Free((BYTE*)ptr);
		else if(w->PoolSize==TextWidget_Pool.GetQuantSize())TextWidget_Pool.Free((BYTE*)ptr);
		else _ExFree(ptr);
	}

	cStr			Name;
	cStr			Name2;
	cStr			FieldName;
	cStr			FullXmlID;

	char			frame_dx;
	char			frame_dy;
	char			frame_dw;
	char			frame_dh;

	bool    		Visible;	
	bool			Destroyed;
	
    bool    		Enabled:1;	
    bool    		ClipSubWidgets:1;
    bool    		MouseOver:1;
    bool    		HaveFocus:1;
	bool			AcceptMouse:1;
	bool			AbsorbMouseOver:1;
	bool			ClickAccepted:1;
	bool			PreserveColors:1;
	bool			SkipClip:1;
	bool			Moveable:1;
	bool			SkipScroller : 1;
	bool			NaviSkipper:1;
	bool			HideHotkey:1;
	bool			SkipBound:1;
	bool			Special:1;
	bool			LockSize : 1;
	bool			HiddenStateChecked : 1;
	bool			HiddenState : 1;
	bool			CheckMouseOverInSubwidgets : 1;
	bool			DrawTopmost : 1;
	bool    		AutoSetWidth : 1;
	bool			AutoSetHeight : 1;
	bool			Modal : 1;
	bool            PermanentTopmost : 1;
	bool            PermanentVisibility : 1;
	bool			HotShift : 1;
	bool			HotAlt : 1;
	bool			HotCtrl : 1;
	bool			Virtual : 1;
	bool			Resizable : 1;
	bool			AutoSetSizeNextTime : 1;
	bool			useHotkeyWM : 1;
	bool			Central : 1;//set true if you want this element to be central in popup dialog
	bool			MetadataAllocated : 1;
	bool			DropDownItem : 1;
	bool			AllowColorMods : 1;
	bool			Upper : 1;
	bool			First : 1;
	bool			fill_TL : 1;
	bool			fill_TR : 1;
	bool			fill_BL : 1;
	bool			fill_BR : 1;

	void			UpdateHiddenState();
	bool			HighlightHidden();
	
    int             LastMouseOverTime;
	int             LastNoMouseOverTime;
	int				ActiveMoveTopZone;
    /// \brief Use it for personalization a widget.
	union {
		int			UserInt;
		double		UserDouble;
		cPtrDiff	UserPtr;
		float		UserFloat;
	};
	int				PoolSize;
	int				Level;
	int				ExtraLevel;
	int				RefsCount;
    Rct     		Rect;
	static bool		GlobalClickAccepted;

	float   		lMargin;
	float   		rMargin;
	float   		tMargin;
	float   		bMargin;


	int				HotKey;
	

	int				MinWidth;
	int				MaxWidth;
	int				MinHeight;
	int				MaxHeight;

	wAlignType		NeibAttachType;//relative to current-level elements
    wAlignType		WhatAttachToParent;
	wAlignType		WhereAttachToParent;	

	//DWORD			Color2;

	float			lAttachMargin;
	float			rAttachMargin;
	float			tAttachMargin;
	float			bAttachMargin;

	int				CursorType;
	//-1 - any type, 
	//0 - std, 
	//1 - move, 
	//2 - resize X, 3 - resize Y, 4 - resize LT<->RB 5 - resize LB<->RT 
	//6 - No
	//7 - Wait
	//8 - Hand

    cVec2 CurrentPos;
    DWORD   Color;
    cStr    Hint;
	cStr	HintID;
	cStr	TextID;
	Rct GetScreenRect(){
		Rct R(CurrentPos.x, CurrentPos.y, Rect.w, Rect.h);
		return R;
	}
	Rct GetAdjustedRect() {
		Rct R(CurrentPos.x + frame_dx, CurrentPos.y + frame_dy, Rect.w - frame_dw, Rect.h - frame_dh);
		return R;
	}

	bool EnablePopup;
	cVec2 PopupPos;
	BaseClass* Metadata;

	void	SetHint(const char* s);

	static comms::cArray<BaseWidget**> ImportantWidgets;
	static void	AddImportantWidget(BaseWidget** W);
	static void	AddImportantWidget(FrameWidget** W);
    static  BaseWidget* CurrentWidget;	
	static  BaseWidget* DroppedWidget;	
	static int ExtraUpdates;
	static cStr LastLMB_ID;
	static int LastLMB_ID_Time;
	static cStr LastRMB_ID;
	static int LastRMB_ID_Time;
	static cStr ActiveWidgetForWheel;
	comms::cArray<WBaseCallback*> Callbacks;
    void    AddCallback(DWORD Message,WBaseCallback* cb,bool Uniq=true);
	void    AddDependentCallback(BaseWidget* Dep,DWORD Message,WBaseCallback* cb,bool Uniq=true);
	void    KillCallback(DWORD Message);
	void    AddFirstCallback(DWORD Message,WBaseCallback* cb,bool Uniq=true);
    bool    CallCallbacks(DWORD Message);
	bool    CallPaintCallbacks();
	bool    CallRmbCustomize(BaseWidget* rmbPanel);
	/**
   \brief assign callback for specific message.
   \details
   If you need to assign some callback to message, just pass the finction pointer and function parameter to this template.\n
   Examples:\n
   \code
   bool foo1(int x, float y){
		...
   }
   void foo2(){
		...
   }
   bool myclass::foo3(int x){
		...
   }
   myclass elem;
   ...
   w->callback(WM_LBUTTONDOWN,foo1,1,2.0f);
   w->callback(WM_LBUTTONDOWN,foo2);
   w->callback(WM_LBUTTONDOWN,&myclass::foo3,&elem,1);
   \encode
   if function returns true the message captured and will no longer be handled. If it is void function - message is not captured and well be handled with other connected functions as well.
   By default, function will not be included in queue if handlerwith the same message already exists. If you need to inserd it anyway, use w->callback<false>(...) in this case
   */
	///assign callback for specific message
	template< bool unique = false, class F, class... Args >
	void    connect(DWORD Message, F&& f, Args&& ... args);
	///assign callback for specific message, set handler to be the first in the list
	template< bool unique = false, class F, class... Args >
	void    connect_as_first(DWORD Message, F&& f, Args&& ... args);
	///assign callback for specific message, set handler to be the first in the list
	template< bool unique = false, class F, class... Args >
	void    connect_dependent(DWORD Message, BaseWidget* Dep, F&& f, Args&& ... args);
	void	NeverRemoveLastCallback();
	void    _draw();
	void    _drawTopmost();
	virtual void _setup_positions();
	virtual void _bestfit(bool horizontal, bool vertical);
    bool    skip_lclick();
    bool    skip_rclick(); 
	bool	_tmp_AssignPopup(cPtrDiff F,cPtrDiff Key,cPtrDiff Shift,cPtrDiff Ctrl,cPtrDiff Alt);
	bool	_tmp_PropRClick(BaseWidget* W,int dx, int dy);
	bool	_tmp_AssignSize();
	bool	_tmp_PrpPanelDraw();
    bool    _tmp_StartMove(cPtrDiff Root);
    bool    _tmp_AssignMotion(cPtrDiff Root);
	bool    _tmp_MotionLMBUP(cPtrDiff Root);
	bool	fw_skip_lclick();

	bool    _tmp_StartResize(cPtrDiff Root);
	bool    _tmp_AssignResize(cPtrDiff Root);
	bool	_tmp_AssignScrollParams(BaseWidget* PW, int ExtraDX);
	bool	_tmp_ChangeScrollParams(cPtrDiff Sptr);
	bool	_tmp_AssignSizeX(cPtrDiff Dest,cPtrDiff Dx);
	bool	_tmp_AssignSizeY(cPtrDiff Dest,cPtrDiff Dy);
	bool	_tmp_AssignChildDockSize(cPtrDiff Dx,cPtrDiff Dy);
	bool	_tmp_TestEnshort(cPtrDiff v);
	bool    _tmp_AlignSub(cPtrDiff p);
	bool    _tmp_PlaceDockProp();

    bool    _tmp_DrawPermanentTopmost(cPtrDiff Par,cPtrDiff dx,cPtrDiff dy);
	bool    _tmp_DrawWhiteRect();
    bool    _tmp_ClickPermanentTopmost(cPtrDiff Par);
	bool    _tmp_Highlight(cPtrDiff Size,cPtrDiff Side);
	bool    _tmp_ClickClose(cPtrDiff Ptr);
	bool	_tmp_ColorHighlight(cPtrDiff MouseOverColor,cPtrDiff PassiveColor);

	void    AssignMouseHighlight(DWORD OverColor,DWORD PassiveColor);
	bool	HideSubmenu(cPtrDiff);
	bool	HideSubmenuSimple(cPtrDiff);
	bool	HideSubmenuDeep(cPtrDiff);
	bool	CloseOnClick();
	Rct     CalcBoundary();
	Rct     CalcActiveBoundary();
	Rct     CalcActiveBoundary(int StartLevel);
    void    PushCurrentWidget();
	static void    PopCurrentWidget();
	void	MoveOnTop();
	void	StoreParams();
	bool	CheckIfInDock();
	DockableHeader* CheckIfInDockableHeader();

	virtual void AssignPopup(BaseWidget* RootWidget,int Key,bool Shift,bool Ctrl,bool Alt);
	void    Destroy();
	void    DestroySubWidgets();
	void	RemoveGarbage();
	void	AddSubWidget(BaseWidget* W, bool first = false);
    const ClassArray< BaseWidget >& GetSubWidgets() const { return SubWidgets; }
    ClassArray< BaseWidget >& GetSubWidgets() { return SubWidgets; }
    const BaseWidget* GetSubWidget( int i ) const { return SubWidgets[ i ]; }
    BaseWidget* GetSubWidget( int i ) { return SubWidgets[ i ]; }
    void    AllowMotion(BaseWidget* Root,bool KillLB=true);
	bool	MovedNow();
	void    AllowDragNDrop(BaseWidget* Root);
	void    AllowResize(int MinW,int MaxW,int minH,int MaxH);
    void    AllowPermanentTopmost(int dx,int dy,bool Enshort=false,bool pin=true);
	void    AddCloseHighlight(int Size);
	void	SkipMouseClicks();
	bool    RemoveFromParent();
	void	SetPositions();
	
    /**
    \brief Returns this and all parents for this widget.
    \param limitDepth  Max count of parents which will return.\n
           When `0` then return only current widget.
    */
    cList< BaseWidget* >  GetChainWidgets( int limitDepth = -1 ) const;
    cList< cStr >  GetChainClassNames( int limitDepth = -1 ) const;

    BaseWidget* GetParentWidget();
    bool HasParentWidget( const cStr& pclass ) const { return GetNearestParentWidget( pclass ) != nullptr; }
    BaseWidget* GetNearestParentWidget( const cStr& pclass ) const;

	virtual BaseWidget* OnStartMove(int x,int y){return this;}
	virtual void OnEndMove(){};	
	DockSpace* FindHeader(DockableHeader* H);

	VScroller* AssignScroller(const char* ID="",bool Hidden=false, int ExtraDX = 0);

	/**
	 *\brief Use AssignPropPanel, AssignDockPropPanel to make RMB menu over any item
	 *\details Add elements to the property panel using AddRmbSubmenu, AddRmbElement, AddSeparator\n
	 *Usual pattern of usage:\n
	 *\code
	 *BaseWidget* W = MyControl-> AssignPropPanel();
	 *W->connect(WM_CREATECONTENT, [&]{//create rmb menu only when RMB actually clicked
	 *	BaseWidget* B=BaseWidget::CurrentWidget;
	 *	B->AddRmbElement("Item1");
	 *	BaseWidget* sub = B->AddRmbSubmenu("submenu");
	 *	sub->AddRmbElement("SubItem1");
	 *});
	 *\endcode
	 */
	BaseWidget* AssignPropPanel(bool Active = false, int dx = 0, int dy = 0, bool Temporary = false, bool NoModal = false);
	BaseWidget* AssignDockPropPanel();
	
	virtual void AddSeparator();
	BaseWidget* AddRmbSubmenu(const char* text);
	BaseWidget* AddRmbElement(const char* text, bool* boolptr = nullptr, const char* icon = nullptr, const char* hint = nullptr);

	///deprecated RMB properties commands, don't use it, it will be deleted ASAP
	
	virtual TextWidget*	AddPropPanelElement(const char* Text,const char* Hint,bool DefKey=false, bool* boolptr = nullptr, int extraWidth = 0);	
	virtual TextWidget*	AddLine(const char* Text,const char* Hint=NULL,bool Key=false, int extraWidth = 0);
	virtual TextMenu*	AddPropPanelSubmenu(TextWidget* TM);

    /// \see Look(), FindByName()
	BaseWidget* Find(const char* Name,bool Recursive);
	template<class X>
	X* Find(std::function<bool(X*)> stop);
	BaseWidget* Find(std::function<bool(BaseWidget*)> stop, bool onlyVisible = false);

    /// \see Look()
    typedef std::function< void( BaseWidget* ) >  lookFnW_t;
    /// \see Look()
    typedef std::function< bool() >               lookFnBool_t;
    /// \see Look()
    typedef struct {
        lookFnW_t     onRoot;
        lookFnW_t     onChild;
        lookFnBool_t  stop;
    } look_t;
    /**
    \brief Advanced function for work with widgets.
    \details
    Visits by all widgets and do some operations with its.
    \see Example in coat::scripto::UI::all()
    \see FindByName()
    \todo Rename to Find().
    */
    static void Look( const look_t& fns, BaseWidget* w = nullptr );

	virtual void info(cStr& s){s="BaseWidget";}
	virtual int ClassID(){
		return CLASSID_BaseWidget;
	}

    virtual cStr GetNameInUI() const {
        //assert( false && "An UI's name doesn't support for this widget." );
        return "";
    }
	/// used in ClassEditorUI, called if [] is set in the UI_LAYOUT(...) for the control
	virtual bool AutoSize() { return false; }

    /**
    \brief Inherites this function when widget stores some values.
    \see TextWidget
    */
    virtual bool HasValueBool() const { return false; }
    virtual bool GetValueBool() const { return false; }
    virtual void SetValueBool( bool ) { /* do nothing */  }
    virtual bool HasValueFloat() const { return false; }
    virtual float GetValueFloat() const { return FLT_MAX; }
    virtual void SetValueFloat( float ) { /* do nothing */ }
    virtual bool HasValueInt() const { return false; }
    virtual int GetValueInt() const { return INT_MAX; }
    virtual void SetValueInt( int ) { /* do nothing */ }

    SERIALIZE() {
    } 

private:
    /// \see AddSubWidget(), GetSubWidgets()
    ClassArray< BaseWidget >  SubWidgets;
};




class APICALL ScrollParam:public BaseClass{
public:
	cStr ID;
	int ScrPos;
	int MaxScrPos;
};
struct MousePoint{
	int  Time;
	cVec2 pt;
	bool lmb;
	bool rmb;
	bool mmb;
};
class OneCurveObject;
class snap3dinfo {
public:
	snap3dinfo() {
		clear();
	}
	void clear() {
		snapped = false;
		snapped3D = false;
		pos = Vector3D::Zero;
		pt2D = cVec2::Zero;
		cu = nullptr;
		cuPoint = -1;
	}
	cVec2 pt2D;
	Vector3D pos;
	bool snapped;
	bool snapped3D;
	OneCurveObject* cu;
	int cuPoint;
};
/**
 * \brief Summary over UI.
 */
class APICALL Widgets{
public:
    static ClassArray<BaseWidget> ActiveWidgets;
	static void CreateWidgetsListUnderPoint(BaseWidget* W, int x, int y, comms::cArray<BaseWidget*>& List, int Topmost, int Level = 0, bool SetMouseOver = true);
	static void CreateWidgetsListUnderPoint(BaseWidget* W, int x, int y, comms::cArray<BaseWidget*>& List, int Topmost, int Level, Rct R, bool SetMouseOver = true);
	static void CreateWidgetsListUnderPoint(BaseWidget* W, int x, int y, comms::cArray<BaseWidget*>& List, bool SetMouseOver = true);
	static void CreateWidgetsList(BaseWidget* W, comms::cArray<BaseWidget*>& List);

	static comms::qword lastInputActiveTime;
	static unsigned int InputActiveDeltaTime;

	static snap3dinfo LastSnap;
    // \brief Previous mouse position, on previous tick.
	static float  PMouseX;
	static float  PMouseY;
    // \brief Mouse position with snapping.
	static float  MouseX;
	static float  MouseY;
    // \brief Not affected by snapping.
	static float  aMouseX;
	static float  aMouseY;
    // \brief Last RMB click position.
	static float  LastRmbX;
	static float  LastRmbY;

	// \brief Last LMB click position.
	static float  LastLmbX;
	static float  LastLmbY;

	static float  LastCapMX;
	static float  LastCapMY;

	static int NoClickTime;
	static int exTabMarginY;
	static int exTabMarginX;

	static Rct WholeScreen;
	static Rct WorkArea;
    // \brief Zone within navigation rectangle.
	static Rct NavigationInnerZone;
	static Vector3D PivotCenter;

	static comms::cArray<MousePoint> MouseTrack;
	static cVec2 GetMouseSpeed(int depth);

    static bool lPressed;
	static bool lUnPressCommanded;
    static bool rPressed;
	static int CtrlTime;
	static int AltTime;
	static int ShiftTime;
	static bool DontKillLP;
    static bool mPressed;
	static bool SkipInterfaceMode;
	static float FullscreenModePercent;//0 for no fullscreen, >0, <100 - left part of the screen is viewport
    static int  lastKey;
    static int  lastWheel;
	static float deltaWheel;
	static int  CurrentTime;
	static int  CurrentTick;
	static int  LastLMBTime;
	static int  LastLMBUPTime;
	static int  LastScrollTime;
	static int ShowSubmTime;
	static int HideSubmTime;
	static int _3DMouseLastNaviTime;
	static cStr CurrentHint;
	static cStr LastDroppedFile;
	static bool SomethingDropped;
	static Rct  MoveLimitations;
	static Rct  DeadZone;
	static bool TriggeredByHotkey;
	static cStr LastExecutedScriptPath;
	static bool WithinTheScript;
	static bool IgnoreShift;
	static bool IgnoreCtrl;
	static ClassArray<ScrollParam> Scrollers;
	static bool RecentlyScrolled();
	static bool AllowWheelForSliders(BaseWidget* w);

	static ScrollParam* GetScroller(const char* ID);
	static void OnDrop(BaseWidget* What);
    static void AddActiveWidget(BaseWidget* W);
    static void RemoveActiveWidget(BaseWidget* W);
    static void RemoveAll();
    static bool ProcessWindowsMessages(MSG& msg);
    static void DrawWidgets();
    static void ClearMouseOver(BaseWidget* bw=NULL);
    static void KillFocus(BaseWidget* bw=NULL);	
	static void DestroyDeadWidgets();
	static cPtrDiff SomethingMoved();
	static cPtrDiff SomethingResized();
	static bool SomethingMovedOrResized();
	static BaseWidget* GetModalWidget(BaseWidget* root=NULL);
	static BaseWidget* GetTopmost(BaseWidget* root=NULL);
	static cVec2 GetAsyncCursorPos();
	static void DisableIncrementalTemporary();
	static bool CheckIfWidgetWithHotkeyHovered();

	//layouts management
	static void GetCurrentLayout(cStr& Layout);
	static void SaveLayoutTo(const char* Filename);
	static void StoreCurrentLayout();
	static void SetCurrentLayout(const cStr& Layout);
	static void LoadLayoutFrom(const char* Filename);
	static void RestoreCurrentLayout();
	static void WaitAndCall(std::function<void(void)> fn, int steps = 4);

	static bool MouseOverTheViewport();
	static void resetScrollers();
};


/**
 * \brief The functional callback that uses std::function to handle all messages in 3D-Coat.
 * \tparam ret It may be bool or void.
 */
template<class ret>
class _tcallback : public WBaseCallback {
public:
	void* operator new(size_t size) {
		InitWpcPool();
		void* ptr = wpc_Pool.Allocate();
		return ptr;
	}
	std::function<ret()> fn;
	///depends only on function pointer
	DWORD PtrHashValue;
	///depends on pointer and all arguments
	DWORD FullHashValue;
	///pointers to functions are same
	virtual bool equals(WBaseCallback* other);
	///pointers and arguments are same
	virtual bool equals_strictly(WBaseCallback* other);
	///callback points to that function
	virtual bool same_hash(DWORD);
	virtual void AlterHash(int value) { FullHashValue += value; }
	_tcallback() {
	}
	virtual ~_tcallback() {		
	}
	///basic template to trigger callback action. Used if ret is not bool or void.
	template<typename tp>
	bool raw() {
		fn();
		return false;
	}
	///callback specialization for bool
	template<>
	bool raw<bool>() {
		return fn();
	}
	///callback specialization for void
	template<>
	bool raw<int>() {
		return fn() != 0;
	}
	///Trigegr callback action. Returns true if message captured and you don't need to call same type callbacks.
	virtual bool call() {
		///check dependence - call it only if child widget Dep is still live, not destroyed.
		if (Dep) {
			bool fnd = false;
			int N = BaseWidget::CurrentWidget->GetSubWidgets().GetAmount();
			for (int i = 0; i < N; i++) {
				if (Dep == BaseWidget::CurrentWidget->GetSubWidget(i)) {
					fnd = true;
					break;
				}
			}
			if (!fnd) {
				MustDie = true;
				return false;
			}
		}
		bool doit = true;
		if (Hotkey) {
			///trigger only if hotkey pressed
			if (Widgets::lastKey == (Hotkey & 0xFF)) {
				doit &= _CTRL() == ((Hotkey & 256) != 0);
				doit &= _ALT() == ((Hotkey & 512) != 0);
				doit &= _SHIFT() == ((Hotkey & 1024) != 0);
			}
			else doit = false;
		}
		if (doit) {
			///trigger the action.
			return raw<ret>();
		}
		return false;
	}
};
/**
 * \brief Iterate over variadic macro parameters and do some action over them.
 * \tparam Fun No need to specify.
 * \tparam Ts 
 * \param f Fun Function to call for each item of variadic parameters.
 * \param args Variadic parameters.
 */
template<typename Fun, typename...Ts>
void sequential_foreach(Fun f, const Ts& ... args) {
	(void)std::initializer_list<int>{
		((void)f(args), 0)...
	};
}
/**
 * \brief The function adds to hash values dependent on bound function parameters.\n
 * It iterates over bound parameters using std::initializer_list.\n
 * It is used in new_callback to create checksumm. Later it will be used to compare if two callbacks are identical.
 * \tparam Ts Don't specify it.
 * \param hash The DWORD to be dependent on function and params
 * \param args Function parameters.
 */
template<typename...Ts>
void hash_all(DWORD& hash, const Ts& ... args) {
	sequential_foreach([&](const auto& arg) {hash += PtrToHash((void*)(&arg)); }, args...);
}
/**
 * \brief Use new_callback to create callback, use BaseWidget::AddCallback to add it. Usually you don't nned  it, just use BaseWidget::connect
 * \tparam F You don't need to set template arguments manually
 * \tparam Args ...
 * \param f Pointer to the function to binds
 * \param args Function arguments
 * \return The callback object to be passed into the BaseWidget::AddCallback
 */
template< class F, class... Args >
WBaseCallback* new_callback(F&& f, Args&& ... args) {
	using result = typename std::invoke_result<F &&, Args...>::type;
	_tcallback<result>* rt = new _tcallback<result>;
	rt->PtrHashValue = rt->FullHashValue = PtrToHash((void*)&f);
	hash_all(rt->FullHashValue, args...);
	rt->fn = std::bind(f, args...);
	return rt;
}

class APICALL PanelWidget : public BaseWidget{
public:

	bool draw();
	bool DisableFlush;
	virtual void info(cStr& s){s="PlaneWidget";}
	DWORD ModColor[4];
	__constructor(PanelWidget);

	SERIALIZE() {
	} 
	virtual int ClassID(){
		return CLASSID_PanelWidget;
	}
};

class APICALL DrawTexRect : public BaseWidget{
public:
	virtual void info(cStr& s){s="DrawTexRect";}
	cVec2 xyShift;
    Rct uv;
    int Textures[4];
	int ShadowTexture;
    int Shader;	
	DWORD ModColor[4];
	bool DisableFlush;
	bool Square;
	int MaxSize;
    bool draw();
	__constructor(DrawTexRect);
	DrawTexRect(const char* name,int idx,int nx,int ny);
	DrawTexRect(int tex,int idx,int nx,int ny);
	void SetIcon(int tex,int idx = 0,int nx = 1,int ny = 1);
	void SetIcon(const char* mat_icon_name);
	void SetIcon2(int tex,int idx,int wx,int wy);
	void AssignShadow();

    SERIALIZE() {
        REG_PARENT(BaseWidget);
        REG_AUTO(uv.x);
        REG_AUTO(uv.y);
        REG_AUTO(uv.w);
        REG_AUTO(uv.h);
        REG_AUTO(Textures[0]);
        REG_AUTO(Textures[1]);
        REG_AUTO(Textures[2]);
        REG_AUTO(Textures[3]);
        REG_AUTO(Shader);
    } 
	virtual int ClassID(){
		return CLASSID_DrawTexRect;
	}
};


class APICALL TextWidget : public BaseWidget{
public:
	virtual void info(cStr& s){s="TextWidget:";s+=Text.ToCharPtr();};
	void* operator new(size_t size);
	bool draw();
	bool click();
	bool pre_click();
	void SetText(const char* s);
	virtual bool AutoSize() override;

    cStr Text;	
	cStr exclID;
	bool Allowed;
	bool ShortBool;
	bool Script;
	float OrigH;
    int  Align;
	int  AlignY;
	int  Size;
	int MaxWidth;
	int ExLMargin;
	int ExRMargin;
	int GroupID;
    DWORD TextColor;
    DWORD ShadowColor;
	bool  Activated;
	bool  IgnoreStdColor;
	bool IgnoreStdFontColor;
	bool IconAbove;
	bool* BoolPtr;
	int* IntPtr;
	bool InvertBool;
	DWORD* DwPtr;
	int  IntEthalon;
	int TexSizeX;
	int TexSizeY;
	short IconDx;
	short IconDy;
	int ExTexture;
	int ExTextureShadow;
	DWORD TextureColor;
	Rct BorderUnderIconRect;
	int BorderUnderIcon;
	DWORD BorderUnderIconColor;

	void AssignIcon(int Tex,int SieX,int SizeY);

	__constructor(TextWidget);

	int GetRealWidth();
	int GetRealHeight();
	int CalcHeight();
	void SetFixedWidthToTheParentLayout();

    SERIALIZE() {
        REG_PARENT(BaseWidget);
        REG_AUTO(Text);
        REG_AUTO(Align);
    } 
	
    virtual int ClassID(){
		return CLASSID_TextWidget;
	}
    
    virtual cStr GetNameInUI() const override {
        return Text.ToCharPtr();
    }
    virtual bool HasValueBool() const override {
        return BoolPtr ? true : false;
    }
    virtual bool GetValueBool() const override {
        return BoolPtr ? *BoolPtr :
            BaseWidget::GetValueBool();
    }
    virtual void SetValueBool( bool v ) override {
        if ( BoolPtr ) { *BoolPtr = v; }
    }
    virtual bool HasValueInt() const override {
        return IntPtr ? true : false;
    }
    virtual int GetValueInt() const override {
        return IntPtr ? *IntPtr : BaseWidget::GetValueInt();
    }
    virtual void SetValueInt( int v ) override {
        if ( IntPtr ) { *IntPtr = v; }
    }
	virtual void _bestfit(bool horizontal, bool vertical) override;
};


class APICALL FrameWidget : public TextWidget{
public:
	void* operator new(size_t size);
	virtual void info(cStr& s){s="FrameWidget:";s+=Text.ToCharPtr();}
	virtual void _bestfit(bool horizontal, bool vertical) override;
	int FrameTexture;
	bool InvFrame:1;
	bool Selected:1;

	bool grouping : 1;
	HashSummator fill_hash;

	bool UseDefaultSettings:1;

	Rct uv;
	int Texture2;
	float u2scale;
	float v2scale;
	DWORD MouseOverColor;
	bool draw();
	bool c_skip_rclick();
	__constructor(FrameWidget);

	void discover_nearby_frames();
	static int space_between;
	void allow_groups();

	SERIALIZE() {
		REG_PARENT(BaseWidget);
		REG_AUTO(FrameTexture);
		REG_AUTO(uv.x);
		REG_AUTO(uv.y);
		REG_AUTO(uv.w);
		REG_AUTO(uv.h);
	} 
	virtual int ClassID(){
		return CLASSID_FrameWidget;
	}
};
class DockableHeader;
class APICALL DockSpace;
struct DockDest{
	DockDest();
	DockableHeader* Curr;
	DockableHeader* Dest;
	DockSpace* Space;
	int SpacePos;
	int InDockPos;
	bool CreateDock;
	Rct Rect;
};
struct DocParam {
	FrameWidget* First;
	bool		somevis;
	int			exdy;
	int			SumL;
	int			LCurr;
	int			MaxCL;
	int			MinCL;
	int			Len[32];
	int			LenCap[32];
	const char* Names[32];
	const char* tNames[32];
	int			CurPos;
	int			nnamed;
	bool		HaveCap;
};
class APICALL DockableHeader:public FrameWidget{
public:
	void* operator new(size_t size);
	virtual void info(cStr& s){s="DockableHeader:";s+=Text.ToCharPtr();s+=";";s+=CurrPage.ToCharPtr();}
	cStr CurrPage;
	Rct ItemsRects[32];
	int Num;
	int DockTemp;
	~DockableHeader();
	__constructor(DockableHeader);
	bool draw();
	bool set_correct_size(DocParam& dp,bool Preliminary);
	bool dropfile();
	bool click();
	void AddDockable(FrameWidget* Child);
	virtual BaseWidget* OnStartMove(int x,int y);
	virtual void OnEndMove();
	static DockableHeader* CreateDockable(const char* ID,bool Resize,int MinW=80,int MinH=80,int MaxW=2000,int MaxH=2000);
	static int GetFramesVerticalOffset(BaseWidget* F);
	static bool GetBestDock(DockDest& D,int x,int y);
	cVec2 GetDefaultSize();
	void Decompose();
	//SERIALIZE() {
	//} 
	virtual int ClassID(){
		return CLASSID_DockableHeader;
	}
};
class APICALL DockSpace:public BaseWidget{
public:
	virtual void info(cStr& s){s="DockSpace";}
	~DockSpace();
	int SectionType;//bit 1: horizontal/vertical, bit 2: left/top is emty or right/bottom is empty	
	int Captured;
	int CaptX;
	int CaptY;
	DockSpace* ParentDock;
	Rct Seams[32];
	int IdxP[32];
	int IdxN[32];
	int NSeams;
	static DockSpace* EmptyDock;
	bool draw();
	bool click();
	void InsertPanel(DockableHeader* H,int Pos);
	static DockableHeader* Undock(DockableHeader* H);
	DockableHeader* FindHeader(int x,int y,DockDest& D);	
	DockableHeader* FindInDockByID(const char* ID);
	bool FindPlaceInDock(DockDest* D,int x,int y);
	__constructor(DockSpace);	
	SERIALIZE() {
	} 
	virtual int ClassID(){
		return CLASSID_DockSpace;
	}
};
class APICALL SimpleSlider : public BaseWidget{
public:
	virtual void info(cStr& s){s="SimpleSlider";}
    float* VariablePtr;
	int* iVariablePtr;
    float CurrPos;
    float MinValue;
    float MaxValue;
    float VisModulator;
	bool  Inverted;
	bool  ExchangeRanges;
	cStr  Text;
	DWORD TextColor;
	int   Size;
	bool  NewTecStyle;
	int StartFocusPos;

	float ToVisibleScale(float real);
	float ToRealScale(float visible);
    
    SimpleSlider(DWORD Color,float* ptr,float minv,float maxv);
	virtual bool AutoSize();
    bool draw();
    bool on_mmove(cPtrDiff p);	
	bool on_wheel();
	void SetText(const char* s);

    __constructor(SimpleSlider);

    SERIALIZE() {
        REG_PARENT(BaseWidget);
    } 
	virtual int ClassID(){
		return CLASSID_SimpleSlider;
	}

    virtual cStr GetNameInUI() const override {
        return Text.ToCharPtr();
    }
    virtual bool HasValueFloat() const override {
        return VariablePtr ? true : false;
    }
    virtual float GetValueFloat() const override {
        return VariablePtr ? *VariablePtr : BaseWidget::GetValueFloat();
    }
    virtual void SetValueFloat( float v ) override {
        if ( VariablePtr ) { *VariablePtr = v; }
    }
    virtual bool HasValueInt() const override {
        return iVariablePtr ? true : false;
    }
    virtual int GetValueInt() const override {
        return iVariablePtr ? *iVariablePtr : BaseWidget::GetValueInt();
    }
    virtual void SetValueInt( int v ) override {
        if ( iVariablePtr ) { *iVariablePtr = v; }
    }
};


class APICALL VScroller : public BaseWidget{
public:
	virtual void info(cStr& s){s="VScroller";}
	~VScroller();
	float Pos;
	float MaxPos;
	float ScrollLen;
	float MoveStep;
	int  Captured;
	bool narrow;
	bool HideBar;

	void  GetRects(Rct& Up,Rct& Middle,Rct& Dn);	

	bool draw();
	bool on_mmove();
	bool on_mover();
	bool on_lmb();
	bool on_wheel(cPtrDiff ScrollPtr);

	int LastActTime;
	int LastActPos;

	__constructor(VScroller);

	SERIALIZE() {
		REG_PARENT(BaseWidget);
	} 
	virtual int ClassID(){
		return CLASSID_VScroller;
	}

};
class APICALL PictMenu : public BaseWidget{
	bool ShowSubmenu(cPtrDiff param,cPtrDiff x,cPtrDiff y);		
	bool OnClick(cPtrDiff idx);
	bool OnDraw();
	bool SetHdrWidth(cPtrDiff p);
public:
	virtual void info(cStr& s){s="PictMenu";}
	int Margin;
	int* VariablePtr;
	int CurrPos;
	int IconsTexture;
	int IcNx;
	int IcNy;
	bool CommandStyle;
	int HeaderPicture;
	cStr HeaderMessage;
	int ForcedWidth;
	comms::cArray<int> Icons;
	cList<const char*> Hints;
	int Align;
	FrameWidget* FW;
	DrawTexRect* BG;	

    void AssignSubPopup(int Key,bool Shift,bool Ctrl,bool Alt);

	__constructor(PictMenu);

    void Create(Rct R,int Icon,int Nx,int Ny,int* VariablePtr,int Align);//Align : 0-left 1-right 2-top 3-bottom
	void CreateDefault(Rct R,int* VariablePtr,int Align);	

	void AddPict(int Icon,const char* Hint);

	SERIALIZE() {
        REG_PARENT(BaseWidget);
	} 
	virtual int ClassID(){
		return CLASSID_PictMenu;
	}
};
class APICALL TextMenu : public BaseWidget{
    bool ShowSubmenu(cPtrDiff x,cPtrDiff y);
	bool HideSubmenu(cPtrDiff);
	bool CloseOnClick();
	bool OnClick(cPtrDiff idx);
	bool OnDraw();
    bool DrawSel(cPtrDiff ptr);    
    bool DrawSep(cPtrDiff Ptr);
    bool ShowOnClick();
	bool AlignSub(cPtrDiff p);
	void CloseMenu(cPtrDiff p);
public:	
	virtual void info(cStr& s){s="TextMenu";}
	void HideAllThisLevelMenu();
	void SetupPositions();
    int Margin;
	int Level;
    int AddLineDist;    
    int Align;
    int  ElmAlign;
	int  AutoScrollHeight;
	int CurrentlyHighlighted;
	int ExtraDx;
	int ExtraDy;
	bool HaveScroller;
    bool ShowOnlyOnClick;
    // \todo question  Why not use BaseWidget::Moveable?
	bool MoveableMenu;
	bool InTopMenu;
	bool Anisotropic;
	bool DontConvertID;
	static bool TopMenuActive;
    FrameWidget* FW;

	int SubPopupKey;
	int SubShift;
	int SubCtrl;
	int SubAlt;
    bool AutoSetRect;
	bool AutoHighlight;

    __constructor(TextMenu);

	void __tmp__onStartMove(cPtrDiff p);

    TextMenu(int align,int ealign,const char* Name=NULL);//0-left 1-right 2-top 3-bottom
	TextWidget* AddLine(const char* Text, const char* Hint = NULL, BaseWidget* SubPanel = NULL, bool AllowCustom = true);
	TextMenu* AddSubmenu(TextWidget* TM,const char* SubName=NULL);

	BaseWidget* AddPanel();
    void DelLine(cPtrDiff idx);
    virtual void AddSeparator() override;

    SERIALIZE() {
        REG_PARENT(BaseWidget);
	} 
	virtual int ClassID(){
		return CLASSID_TextMenu;
	}
};
class APICALL wCurvePoint:public BaseClass{
public:
	wCurvePoint();
	cVec2 Pos;
	DWORD Color;
	int   State;//0-bezier, 1 - beta, 2 - sharp, 3 - fixed, 4-fixed x, 5-fixed y
	float AssignedTime;
	SERIALIZE() {
		INVISIBLE REG_AUTO(Pos.x);
		INVISIBLE REG_AUTO(Pos.y);
		INVISIBLE REG_AUTO(State);
	} 
};
extern Vector3D ForwardDir;
extern Vector3D RightDir;
extern Vector3D UpDir;

typedef ClassArray<wCurvePoint> wcPoints;
struct thPoint{
	cVec2 Pos;
 	DWORD Color;
	float Thickness;
};
class APICALL One2DCurve:public BaseClass{
public:
	ClassArray<wCurvePoint> Points;
	bool Enabled;
	cStr Legend;
	bool Changed;
	bool HideYGraph;
	bool SwapXY;
	//temporary values
	comms::cArray<float> yval;
	float xMin;
	float xMax;
	comms::cArray<thPoint> tmp;
	comms::cArray<thPoint> tmp2;
	int LastX;
	int LastY;
	//-------------------
	One2DCurve();
	comms::cSplineBezier2 spl;
	DWORD spHash;
	void CheckSpline();
	void validate();
	cVec2 get(float t) const ;
	cVec2 getDerivative(float t) const;
	float getY(float x);
	float getYc(float x) const;
	float getYz(float x) const;///zero beyond 0..1
	bool CheckRanges(const Rct& r);
	virtual bool SkipHash(){return true;}
	void AddDefPoint(float x,float y,int State);//State: 0 - regular spline, 1 - B-spline point, 2 - sharp point, 3 - completely locked point, 4 - only vertical move, 5 - only horizontal move allowed
	void ClearPoints();
	void ToDefault();
	bool Trivial();
	bool Edit(const char* EditTextID, cList<cVec2>* Defaults = NULL);//ButtonsList may contain any of Ok Cancel ToDefault Laod Save
	virtual bool Load(TagsList& xml,void* ClassPtr,void* Extra=NULL) override{
		bool r = BaseClass::Load(xml,ClassPtr,Extra);
		CheckSpline();
		getY(0);
		return r;
	}
	SERIALIZE() {
		NOHASH{
			_MAKE_ONCE{
				REG_CLASS(wCurvePoint);
			}
		}
		REG_AUTO(Points);
	} 
	virtual BaseWidget* OnCreateControlFromScratch(const ClassEditorContext& Context, Rct& R);
};
class CurvesArray :public ClassArray<One2DCurve>{
public:
	virtual BaseWidget* OnCreateControlFromScratch(const ClassEditorContext& Context, Rct& R);
};
class APICALL CurvesWindow:public BaseWidget{
public:
	__constructor(CurvesWindow);
	comms::cArray<One2DCurve*> Curves;
	Rct PointsRange;
	float CapX;
	float CapY;
	int GridX;
	int GridY;
	int SubGridX;
	int SubGridY;
	int PointsRadius;
	int CapturedPoint;
	int HighlightedPoint;
	int HighlightedCurve;
	float PickedT;
	float LineWidth;
	DWORD GridColor;
	DWORD SubGridColor;
	DWORD BGColor;
	DWORD LinesColor;
	DWORD PointsColor;
	DWORD FrameColor;
	DWORD HighlightColor;
	bool  lmbTransparent;
	bool SwapXY;

	static void DrawThickCurve(comms::cArray<thPoint>& List, bool Flush = true, bool Closed = false);
	static void DrawSpot(cVec2 Center,float R,DWORD Color,bool Empty,bool flush=true);
	cVec2 GetScrPointP(int curv,int idx);
	cVec2 GetScrPointT(int curv,float t);
	cVec2 GetScrPointY(int curv,float tx);
	void _draw();
	bool _lmb();
	bool _dbl();
	bool _lmbup();
	bool _rmb();
	bool _key();
	
};
class APICALL ComboBox : public TextMenu{
public:
    bool OnDraw();
    bool OnClick(cPtrDiff idx);
    TextWidget* PW;
    //FrameWidget* PW1;
    //DrawTexRect* TR;

	int GetElmCount();
	void ClearElements();

    int CurrentLine;
	Enumerator* Enum;
    int* LinePtr;
	int TextSize;
	int MaxLine;
    cStr DefaultString;
    TextWidget* AddLine(const char* Text,const char* Hint);	
	void SetEnum(Enumerator* En);
	bool on_wheel();

    __constructor(ComboBox);

    SERIALIZE() {
        REG_PARENT(TextMenu);
	} 
	virtual int ClassID(){
		return CLASSID_ComboBox;
	}
};
class APICALL WidgetsFolder : public TextWidget{
	bool OnDraw();
	bool OnClick();
public:
	void* operator new(size_t size);

	~WidgetsFolder();

	BaseWidget* RootWidget;    
	bool		Open;
	bool		DisableWidgetsMotion;
	bool*		OpenPtr;
	int			Margin;	
	void		SetState(bool doOpen);

	__constructor(WidgetsFolder);

	SERIALIZE() {
        REG_PARENT(TextWidget);
	} 
	virtual int ClassID(){
		return CLASSID_WidgetsFolder;
	}
};
class APICALL BaseLayout:public BaseWidget {
public:
	virtual void _setup_positions();
	BaseLayout();
	
};
class APICALL HorizontalLayout : public BaseLayout {
protected:
	std::tuple<int, int> calc_distribution(bool isVertical);
	cList<int> Distribution;
public:
	static bool CheckIfDistributionString(const char* s);
	void SetDistributionFor(int idx, int value);
	int SetDistribution(const char* distro);
	int GetDistribution(int index);
	virtual void _setup_positions() override;
	virtual void _bestfit(bool horizontal, bool vertical) override;
	HorizontalLayout();
};
class APICALL VerticalLayout : public HorizontalLayout {
public:
	virtual void _setup_positions() override;
	virtual void _bestfit(bool horizontal, bool vertical) override;
	VerticalLayout();
};
#include "DrawFrame.h"

void DrawStdIcon(Rct R,int id,DWORD Color=0xFFFFFFFF);
void DrawFrame(const Rct& Rect,int Texture,const Rct& uvc,DWORD Color,int Texture2=-1,float u2scale=1.0f,float v2scale=1.0f, bool IgnoreFiller = false);
void SetCurrentCursor(int Type);
void SetCurrentCursorI(int Type);
void RefreshHotkeysAssignment(BaseWidget* Root);
int GetBaseIcons();
const char* GetBaseIconsName();
bool IsDark();
void GlobalProcessWidgets();
bool GlobalProcessWidgets( MSG& );
void CleanupInterfacePools();

/// \see BaseWidget::Look(), BaseWidet::Find()
/// \TODO Move to the class Widget near BaseWidget::Look().
BaseWidget* FindByName( const char* Name, bool subs );

template<class ret>
inline bool _tcallback<ret>::equals(WBaseCallback* other)
{
	_tcallback<ret>* cb1 = dynamic_cast<_tcallback<ret>*>(other);
	if (cb1) {
		return cb1->Message == Message && cb1->PtrHashValue == PtrHashValue;
	}
	return false;
}

template<class ret>
inline bool _tcallback<ret>::equals_strictly(WBaseCallback* other)
{
	_tcallback<ret>* cb1 = dynamic_cast<_tcallback<ret>*>(other);
	if (cb1) {
		return cb1->Message == Message && cb1->FullHashValue == FullHashValue;
	}
	return false;
}

template <class ret>
bool _tcallback<ret>::same_hash(DWORD d) {
	return PtrHashValue == d;
}

template<bool unique, class F, class ...Args>
inline void BaseWidget::connect(DWORD Message, F&& f, Args&& ...args)
{
	if(this)AddCallback(Message, new_callback(f, args...), unique);
}

template<bool unique, class F, class ...Args>
inline void BaseWidget::connect_as_first(DWORD Message, F&& f, Args&& ...args)
{
	if (this)AddFirstCallback(Message, new_callback(f, args...), unique);
}

template<bool unique, class F, class ...Args>
inline void BaseWidget::connect_dependent(DWORD Message, BaseWidget* Dep, F&& f, Args&& ...args)
{
	if (this)AddDependentCallback(Dep, Message, new_callback(f, args...), unique);
}

template <class X>
X* BaseWidget::Find(std::function<bool(X*)> stop) {
	for (int i = 0; i < GetSubWidgets().GetAmount(); i++) {
		BaseWidget* W = GetSubWidget(i);
		if (!W->Destroyed) {
			X* x = dynamic_cast<X*>(W);
			if (x && stop(x))return x;
			X* W1 = W->Find<X>(stop);
			if (W1)return W1;
		}
	}
	return nullptr;
}
APICALL int _ui_scale(int x);