#pragma once

class ItemsTree;

class APICALL GuideInTree : public BaseClass {
public:
	GuideInTree() {
		parentTree = nullptr;
	}
	ItemsTree* parentTree;
	virtual void render() {}
};

struct GuidePoint {
	GuidePoint() {
		pos = Vector3D::Zero;
		Thickness = 0.1f;
		Color = 0xffffffff;
		isLastPoint = false;
	}
	GuidePoint(const Vector3D& pos, DWORD Color, float Radius, bool isLastPoint) {
		this->pos = pos;
		this->Color = Color;
		this->Thickness = Radius;
		this->isLastPoint = isLastPoint;
	}
	Vector3D pos;
	DWORD Color;
	float Thickness;
	bool isLastPoint;
};
class LinesGuides : public GuideInTree {
public:
	cList<GuidePoint> points;
	virtual void render() override;
};


/**
 * \brief If you want to introduce the structure similar to tree (like VoxTree) derive your class from the ItemsTree.
 * \details Say you made your class
 * \code
 * class MyClassTree : public ItemsTree....
 * \endcode
 * Reload required functions in your class. Define somewhere
 * \code
 * MyClassTree MyClassVariable;
 * \endcode
 * and write somewhere in your cpp file (outside the functions scope).
 * InstallItemsTree(MyClass, MyClassVariable);
 * In this case the Item "MyClassTree" will appear in Windows->Popups and corresponding window will appear in UI.
 */

class APICALL ItemsTree :public BaseClass{
protected:
	static ItemsTree* CurrentlyDragged;
	static ItemsTree* DropOn;
	static int DropMode;	
	void Add1(){
		Add(true);
	}
	void Rename1(){
		Rename();
	}
	void Sel1();
	virtual void OnModifyControl(const char* Name, BaseWidget* BW, ClassEditorContext& Context) override;
	virtual int GetElementLevel(const char* name);
	void CreateItmPanel();

	virtual bool CanBeDragged(const char* MemberID, int& dx, int& dy);
	virtual bool CanAcceptDrag(const char* MemberID);
	virtual bool OnStartDrag(const char* MemberID);
	virtual bool OnEndDrag(const char* MemberID);
	virtual bool DropItem(ItemsTree* Dragged,bool OnlyCheck);
	virtual bool OnAcceptDrag(BaseClass* DraggedItemParent, const char* DraggedMemberID, const char* AcceptorMemberID, iRct MyRect);
	
	void ControlName();
	virtual void unsel();
	void OnVisibleClick();
	void RestoreVisibility();
	void CreateVisLists();
	static ItemsTree* StartSel;
	cList<ItemsTree*> VisList;
	cList<ItemsTree*> InvisList;
	cList<GuideInTree*> guides;
public:
	virtual void UpdateHash(HashSummator& H, void* data = nullptr, void* extra = nullptr) override;
	void operator delete(void *ptr, size_t size);
	friend class OneCurveObject;
	ItemsTree();
	~ItemsTree();

	cStr FilterString;

	void EditFilter();
	void RemoveFilter();

	int ObjectID;
	cStr Name;
	bool Visible;
	bool OpenState;
	bool Enabled;
	int Selected;
	int UIDStamp;
	int Level;
	DWORD CustomColor;

	cStr GeneratorCommand;
	cStr GeneratorData;

	ClassArray<ItemsTree> Child;
	ItemsTree* root();
	bool isroot();

	SERIALIZE_LATER();

	virtual const char* GetUniqueName(const char* Alias);
	ItemsTree* Find(const char* Name);
	/// return true in the callback to finish the seeking
	template<class type>
	bool Find(const char* Name, std::function<bool(type*)> todo);
	template<class type>
	bool FindAlias(const char* Name, std::function<bool(type*)> todo);
	template<class type>
	bool Iterate(bool onlyVisible, std::function<bool(type*)> todo);
	
	
	void CreateOpenList(cList<ItemsTree*>& List);
	int GetMaxSelIndex();
	void OrderSelection();
	///should be called from ItemsTree::CreateBottomMenu
	BaseWidget* AddBottomIcon(BaseWidget* Base, const char* hint, const char* icon);
	void UnselectAll();
	virtual void Rename();
	virtual ItemsTree* Add(bool AddToSubtree);
	virtual void SelectCurrent();
	///Create RMB menu items
	virtual void CreateRmbMenu(BaseWidget* Prop){}
	virtual void CopyItem(ItemsTree* Dest);
	virtual void Render(){};
	virtual void SimpleSelect();
	virtual void SimpleUnSelect();

	virtual bool AllowHierarchy() { return true; }
	virtual void UnifyWith(ItemsTree* Dest){};
	virtual void SubtractFrom(ItemsTree* Dest){};
	virtual void IntersectWith(ItemsTree* Dest){};
	virtual void SplitThe(ItemsTree* Dest){};
	virtual void SimpleUnifyWith(ItemsTree* Dest){};
	virtual int GetElementBaseHeight() { return 22; }
	
	virtual void ApplyBooleans(ItemsTree* Source, bool shift, bool ctrl,bool KeepSource) {}
	virtual bool AllowBooleans() { return true; }

	virtual bool AcceptsAsChild(ItemsTree* Source) { return true; }
	virtual bool AcceptsForBooleans(ItemsTree* Source) { return true; }
	virtual bool SupportsDuplication() { return true; }
	virtual void OnDuplicate(ItemsTree* CopyPtr) {}
	virtual void DropTreeStructureToUndo() {}
	virtual void AdditionalElementRenderingInUI(BaseWidget* BaseBox){}

	virtual bool IgnoreAltIsolate() { return false; }
	virtual void ChangeParentItem(ItemsTree* NewParent) {}
	virtual void NotifyParentChange(ItemsTree* NewParent) {}
	virtual bool RMBHotkeysActiveForThisItem() { return false; }

	void UpdateLevels(int start = 0);
	bool isParentOf(ItemsTree* el);
	void CollectSelectedWithoutChildren(cList<ItemsTree*>& list);
	void GroupSelectedItems();
	template <class X> X* new_guide();
	void RemoveGuide(GuideInTree* g);
	cList<GuideInTree*>& render_guides();

	bool CheckIfParent(ItemsTree* par);
	ItemsTree* GetParent(ItemsTree* tb);
	ItemsTree* FindParent(ItemsTree* root, int& index);

	virtual void removeThis() {}
	virtual ItemsTree* duplicate() { return nullptr; }
	virtual ItemsTree* duplicateAsInstance() { return duplicate(); }
	virtual bool instancingSupported() { return false; }
	virtual void setTransform(const Matrix4D& m) {}
	virtual void transform(const Matrix4D& m);
	virtual Matrix4D getTransform() { return Matrix4D::Identity; }
};

template <class type>
bool ItemsTree::Find(const char* Name, std::function<bool(type*)> todo) {
	if (Visible) {
		type* ob = dynamic_cast<type*>(this);
		if (ob && cStr::Equals(Name, ob->Name)) {
			if(!todo)return true; // if no todo, just return true
			if (todo(ob))return true;
		}
		for (int k = 0; k < Child.Count(); k++) {
			if (Child[k]->Find<type>(Name, todo))return true;
		}
	}
	return false;
}

template <class type>
bool ItemsTree::FindAlias(const char* Name, std::function<bool(type*)> todo) {
	if (Visible && BaseClass::valid<type>()) {
		type* ob = dynamic_cast<type*>(this);
		if (ob && cStr::Equals(Name, ob->Name, strlen(Name))) {
			if (todo(ob))return true;
		}
		for (int k = 0; k < Child.Count(); k++) {
			if (Child[k]->FindAlias<type>(Name, todo))return true;
		}
	}
	return false;
}

template <class type>
bool ItemsTree::Iterate(bool onlyVisible, std::function<bool(type*)> todo) {
	if((Visible || !onlyVisible) && BaseClass::valid<type>()) {
		type* ob = dynamic_cast<type*>(this);
		if (ob) {
			if (todo(ob))return true;
		}
		for (int k = 0; k < Child.Count(); k++) {
			if (Child[k]->Iterate<type>(onlyVisible, todo))return true;
		}
	}
	return false;
}

template <class X>
X* ItemsTree::new_guide() {
	X* g = new X;
	g->parentTree = this;
	guides.Add(g);
	return g;
}

#define InstallItemsTree(TreeID,ItemDeclaration)\
BaseWidget*				TreeID##Browser = NULL;\
class TreeID##WindowPlacer :public PopupWindow{\
public:\
	virtual BaseClass* GetClass(){ return &ItemDeclaration; }\
	virtual const char* GetWindowID(){ return #TreeID"Tree"; }\
};\
__onstartup(TreeID##WindowVar){\
	ItemDeclaration.Name = "Items";\
	PopupWindow::Register(new TreeID##WindowPlacer);\
}


class ClickableItem:public BaseClass
{
public:
	ClickableItem();
	ClickableItem(const char* text, std::function<void()> onClick = nullptr);
	std::function<void()> onClick;
	cStr text;
	bool selected;
	void click() {
		if(onClick)onClick();
	}
	SERIALIZE() {
		FUNCTION_CALL(click);
	}
	virtual void OnModifyControl(const char* FieldName, BaseWidget* W, ClassEditorContext& Context) override;
};