#pragma once
#include "PopupWindows.h"

/**
\brief Declares how work with UI-elements.
\see ItemsFolderUI
*/
class APICALL ItemsFolder {
public:
	ItemsFolder();

	StringsList					Folders;
	int							CurrentFolder;

	virtual const char*			GetRootPath() { return NULL; }
	virtual bool				RootIsDefaultFolder() { return true; }
	virtual const char*			GetSearchExtension(int idx) { return NULL; }
	virtual const char*			GetCopyExtension(int idx) { return NULL; }
	virtual void                InitItems() {}
	virtual void				AddDefaultItems() {}
	virtual void                AddItem(const char* path) {}
	virtual const char*			GetItemName(int idx) { return NULL; }
	virtual const char*			GetItemSearchName(int idx) { return GetItemName(idx); }
	virtual const char*			GetItemExtraName(int idx, int exidx) { return NULL; }
	virtual void		        ReplaceItemExtraName(int idx, int exidx, const char* dst) {}
	virtual const char*			GetItemExtraCopyName(int idx, int exidx) { return NULL; }
	virtual void		        ReplaceItemExtraCopyName(int idx, int exidx, const char* dst) {}
	virtual void                RemoveItem(int idx) {}
	virtual void                PostReadFolder() {};
	virtual bool				NeedFirstCloseButton() { return true; }
	virtual bool				ConsistsOfFolders() { return false; }
	virtual	void				ReorderList() {}
	virtual bool				SupportsFilter() { return true; }

	void						ReadFolderInfo();
	virtual void				DeleteFolder(int idx);
	virtual int					RenameFolder(int idx, const char* newname);
	virtual int					AddFolder(const char* name);
	virtual void				SetCurrentFolder(int idx);
	virtual void				SetCurrentFolder(const char* name);
	virtual void				MoveToFolder(int PenIdx, int FolderIdx);
	virtual bool				TestAndPrepareToPack(const char* item_name, const char* dest) { return false; }
	const char*					GetFolder(int idx);
	const char*					GetCurrFolder();
	const char*					GetFolderShortName(int idx);
};
class APICALL PensFolder :public ItemsFolder {
public:
	virtual const char*			GetRootPath();
	virtual const char*			GetSearchExtension(int idx);
	virtual const char*			GetCopyExtension(int idx);
	virtual void                InitItems();
	virtual void                AddDefaultItems();
	virtual void                AddItem(const char* path);
	virtual const char*			GetItemName(int idx);
	virtual const char*			GetItemExtraName(int idx, int exidx);
	virtual void                RemoveItem(int idx);
	virtual void                PostReadFolder();
	virtual bool				NeedFirstCloseButton() { return false; }
	virtual const char*			GetItemExtraCopyName(int idx, int exidx);
	virtual void		        ReplaceItemExtraCopyName(int idx, int exidx, const char* dst);
};
class APICALL MsFolder :public ItemsFolder {
public:
	virtual const char*			GetRootPath();
	virtual const char*			GetSearchExtension(int idx);
	virtual const char*			GetCopyExtension(int idx);
	virtual void                InitItems();
	virtual void                AddItem(const char* path);
	virtual const char*			GetItemName(int idx);
	virtual void                RemoveItem(int idx);
	virtual void                PostReadFolder();
};
class APICALL StripsFolder :public PensFolder {
public:
	virtual const char*			GetRootPath();
	virtual const char*			GetCopyExtension(int idx);
	virtual void                InitItems();
	virtual void                AddItem(const char* path);
	virtual const char*			GetItemName(int idx);
	virtual void                RemoveItem(int idx);
	virtual bool				NeedFirstCloseButton() { return true; }
};
class APICALL MtlsFolder :public ItemsFolder {
public:
	virtual const char*			GetRootPath();
	virtual const char*			GetSearchExtension(int idx);
	virtual void                InitItems();
	virtual void                AddItem(const char* path);
	virtual const char*			GetItemName(int idx);
	virtual const char*			GetItemExtraName(int idx, int exidx);
	virtual void		        ReplaceItemExtraName(int idx, int exidx, const char* dst);
	virtual const char*			GetItemExtraCopyName(int idx, int exidx);
	virtual void		        ReplaceItemExtraCopyName(int idx, int exidx, const char* dst);
	virtual void                RemoveItem(int idx);
	virtual int					RenameFolder(int idx, const char* newname);
};
class APICALL ShadersFolder :public ItemsFolder {
public:
	virtual const char*			GetRootPath();
	virtual bool				NeedFirstCloseButton() { return false; }
	virtual bool				ConsistsOfFolders() { return true; }
	virtual const char*			GetSearchExtension(int idx);
	virtual void                InitItems();
	virtual void                AddItem(const char* path);
	virtual const char*			GetItemName(int idx);
	virtual const char*			GetItemExtraName(int idx, int exidx);
	virtual void		        ReplaceItemExtraName(int idx, int exidx, const char* dst);
	virtual const char*			GetItemExtraCopyName(int idx, int exidx);
	virtual void		        ReplaceItemExtraCopyName(int idx, int exidx, const char* dst);
	virtual void                RemoveItem(int idx);
	virtual bool				TestAndPrepareToPack(const char* item_name, const char* dest);

	void						ClearShadersPreviewTextures();
	void						RefreshShadersPreviewTextures();
};
class APICALL ModelItem :public BaseClass {
public:
	int PreviewID;
	cStr Name;
};
class APICALL ModelsFolder :public ItemsFolder {
public:
	cStr root_path;
	cStr sel_path;
	ClassArray<ModelItem>		List;
	virtual	int					FindItemName(const char* name);
	virtual const char*			GetRootPath() override;
	virtual const char*			GetSearchExtension(int idx) override;
	virtual void                InitItems() override;
	virtual void                AddItem(const char* path) override;
	virtual const char*			GetItemName(int idx) override;
	virtual void                RemoveItem(int idx) override;
	virtual bool				NeedFirstCloseButton() override;
	virtual	void				ReorderList() override;
};

class APICALL ShapesFolder :public ItemsFolder {
public:
	static cList<cStr> shapes;
	static int CurrentShape;
	static cList<OneSelPoint> cur_sel_points;

	virtual const char* GetRootPath() override;
	virtual const char* GetSearchExtension(int idx) override;
	virtual void        InitItems() override;
	virtual void        AddItem(const char* path) override;
	virtual const char* GetItemName(int idx) override;
	virtual void        RemoveItem(int idx) override;
	virtual bool		NeedFirstCloseButton() override { return true; }
};

class APICALL PresetsFolder :public ItemsFolder {
public:
	virtual const char*			GetRootPath() override;
	virtual const char*			GetSearchExtension(int idx) override;
	virtual void                InitItems() override;
	virtual void                AddItem(const char* path) override;
	virtual const char*			GetItemName(int idx) override;
	virtual void                RemoveItem(int idx) override;
	virtual	void				ReorderList() override;
	void rewrite_order();


};

class APICALL PanoramasFolder :public ItemsFolder {
public:
	StringsList items;
	
	virtual const char*			GetRootPath();
	virtual const char*			GetSearchExtension(int idx);
	virtual const char*			GetCopyExtension(int idx);
	virtual void                InitItems();
	virtual void                AddItem(const char* path);
	virtual const char*			GetItemName(int idx);
	virtual void                RemoveItem(int idx);
	virtual bool				NeedFirstCloseButton();
	virtual bool				SupportsFilter() override { return false; }
};
struct APICALL ItemsFoldersElements {
	static PensFolder			PFolder;
	static StripsFolder         SFolder;
	static MtlsFolder           MFolder;
	static MsFolder				MskFolder;
	static ModelsFolder         ObjFolder;
	static ModelsFolder         SplFolder;
	static ModelsFolder         PatFolder;
	static ModelsFolder         JointsFolder;
	static ShadersFolder		ShdFolder;
	static PresetsFolder		PresetsFL;
	static PanoramasFolder		PanFL;
	static ShapesFolder			ShapesFL;
	static ItemsFolder* GetFL(int set);
};

//stencils window
class APICALL MasksWindow :public ItemsFolderUI{
public:
	virtual ItemsFolder* GetItemsFolder();
	
	virtual int					PresentInWindowsList();
	virtual const char*			GetWindowID();
	virtual int					GetItemsCount();
	virtual int*				GetIconSizeVar();
	virtual int					GetCurrentItem();
	virtual bool				MayAddExistingFolder();
	virtual void				AddExistingFolder();
	virtual void				OnRenderElement(BaseWidget* w, int elIdx);
	virtual void				OnSelect(int idx);
	virtual void				AddNewElement();
	virtual void				DeleteElement(int idx);
	virtual bool				OnDropExternalItem();
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx);
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;
};
class APICALL PresetsWindow :public ItemsFolderUI {
	HashSummator H;
public:
	virtual ItemsFolder* GetItemsFolder();

	virtual int					PresentInWindowsList();
	virtual const char*			GetWindowID();
	virtual int					GetItemsCount();
	virtual int*				GetIconSizeVar();
	virtual int					GetCurrentItem();
	virtual bool				MayAddExistingFolder();

	virtual void				CreateUI(FrameWidget* root, const Rct& R);
	virtual void				Process() override;
	static bool					DrawPresetItem(cPtrDiff idx);
	static bool					SelectPresetItem(cPtrDiff idx, cPtrDiff x, cPtrDiff y);
	static bool					DeletePresetItem(cPtrDiff idx);
	static bool					RenamePreset(cPtrDiff idx);
	static OneQAItem*			GetToQP(cPtrDiff idx, cPtrDiff slot);
	static bool					ClearAllPresets();
	static bool					StorePresets();
	static bool					ReStorePresets();
	static bool					AddPresetItem();
	static bool					RenewPreset(cPtrDiff idx);
		   void					EditPresetHint(cPtrDiff idx);
		   void					EditPresetIcon(cPtrDiff idx);
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;
};
class APICALL PrimPresetsWindow : public PopupWindow {
	HashSummator H;
public:
	virtual const char* GetWindowID();
	virtual void CreateUI(FrameWidget* root, const Rct& R) override;
	virtual BaseClass* GetClass() override {
		return nullptr;
	}
	virtual double GetWindowSortValue() { return 10; }
	virtual void Process() override;
	static bool ClearAllPrimPresets();
	static void ExecutePrims();
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
};

/**
\brief Smart materials.
*/
class APICALL SmartMatWindow :public ItemsFolderUI{
	static cList<OnePenStyle*> InEdit;
public:
	static SmartMatWindow* inst;
	virtual ItemsFolder* GetItemsFolder();

	virtual double				GetWindowSortValue() { return 2; }
	virtual int					PresentInWindowsList();
	virtual const char*			GetWindowID();
	virtual int					GetItemsCount();
	virtual int*				GetIconSizeVar();
	virtual int					GetCurrentItem();
	virtual bool				MayAddExistingFolder();
	virtual const char* AddExistingFolderTextID();
	virtual void				AddExistingFolder();
	virtual void				OnRenderElement(BaseWidget* w, int elIdx);
	virtual void				OnSelect(int idx);
	virtual void				AddNewElement();
	virtual void				DeleteElement(int idx);
	virtual bool				OnDropExternalItem();
	virtual const char*			GetExtraRmbElements(int el);
	virtual void				ExecutePropertyElement(const char* el,int idx);
	virtual int					GetMinIconSize();

	       void					AddExistMtlFolder();
	static void					SelectCurrentMtl(cPtrDiff idx);
	static bool					DeleteMtl(cPtrDiff idx);
	static bool					IsPossibleToDeleteMtl(int Idx);
	static void					DuplicateMtl(int Idx);
	static void					EditMaterialProperties(cPtrDiff Idx,cPtrDiff Guid);
	static void					UpdateMtlPreview(cPtrDiff Idx, int setmap = -1);
	static bool					MtlEditorActive();
	static void					FromBackupMtl(cPtrDiff Idx);
	static void					ResetMtl(int Idx);
	static void					ToBackupMtl(cPtrDiff Idx,cPtrDiff Skip);

	static bool					WarnMtlEditor();
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;

	virtual void				OnNewScene();
};

//panoramas
class APICALL PanoramasWindow :public ItemsFolderUI{
public:
	static int					CurrentEnvIndex;
	std::map<std::string, int>	thash;
	virtual ItemsFolder*		GetItemsFolder();
	static PanoramasWindow*		Instance();

	virtual int					PresentInWindowsList();
	virtual const char*			GetWindowID();
	virtual int					GetItemsCount();
	virtual int*				GetIconSizeVar();
	virtual int					GetCurrentItem();
	virtual bool				MayAddExistingFolder();
	virtual void				AddExistingFolder();
	virtual void				OnRenderElement(BaseWidget* w, int elIdx);
	virtual void				OnSelect(int idx);
	virtual void				AddNewElement();
	virtual void				DeleteElement(int idx);
	virtual bool				OnDropExternalItem();
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx);
	virtual const char*			GetExtraRmbElements(int el);
	virtual void				ExecutePropertyElement(const char* el, int idx);
	virtual int					GetMinIconSize();
	virtual int					PresentInNaviBar();
	virtual IconInfo			GetIcon();
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;
};

//factures
class APICALL FacturesWindow :public ItemsFolderUI {
public:
	virtual ItemsFolder* GetItemsFolder();
	static FacturesWindow* Instance();

	virtual int					PresentInWindowsList();
	virtual const char*			GetWindowID();
	virtual int					GetItemsCount();
	virtual int*				GetIconSizeVar();
	virtual int					GetCurrentItem();
	virtual bool				MayAddExistingFolder();
	virtual void				AddExistingFolder();
	virtual void				OnRenderElement(BaseWidget* w, int elIdx);
	virtual void				OnSelect(int idx);
	virtual void				AddNewElement();
	virtual void				DeleteElement(int idx);
	virtual bool				OnDropExternalItem();
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx);
	virtual const char*			GetExtraRmbElements(int el);
	virtual void				ExecutePropertyElement(const char* el, int idx);

	static void					ApplyToWholeLayer(int idx, bool NonTransparent, bool ApplyToCurrent = false);
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual int					GetMinIconSize();
	virtual bool				HandleCommand(const char* id) override;
};

class APICALL ShapesWindow :public ItemsFolderUI {
public:
	virtual ItemsFolder*		GetItemsFolder() override;
	static ShapesWindow*		Instance();
	virtual int					PresentInWindowsList() override;
	virtual const char*			GetWindowID() override;
	virtual int					GetItemsCount() override;
	virtual int*				GetIconSizeVar() override;
	virtual int					GetCurrentItem() override;
	virtual bool				MayAddExistingFolder() override;
	virtual void				AddExistingFolder() override;
	virtual void				OnRenderElement(BaseWidget* w, int elIdx) override;
	virtual void				OnSelect(int idx) override;
	virtual void				AddNewElement() override;
	virtual void				DeleteElement(int idx) override;
	virtual bool				OnDropExternalItem() override;
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx) override;
	virtual const char*			GetExtraRmbElements(int el) override;
	virtual void				ExecutePropertyElement(const char* el, int idx) override;
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual int					GetMinIconSize() override;
	virtual bool				HandleCommand(const char* id) override;
	void						AddExternalFile(const char* filename);
	virtual bool				OnDropWidget();
};

struct APICALL ShaderPreviewStrct :public BaseClass {
	ShaderPreviewStrct() {
		SmallTextureID = -1;
		BigTextureID = -1;
	}
	cStr ShaderName;
	cStr BigPreviewName;
	cStr SmallPreviewName;
	int SmallTextureID;
	int BigTextureID;
};
ShaderPreviewStrct* GenerateShaderPreview(const char* ShName, bool RenderAnyway = false);
//shaders
class APICALL ShadersWindow :public ItemsFolderUI{
public:
	
	static ClassArray<ShaderPreviewStrct> ShPrevList;
	
	virtual ItemsFolder*		GetItemsFolder();

	virtual int					PresentInWindowsList();
	virtual const char*			GetWindowID();
	virtual int					GetItemsCount();
	virtual int*				GetIconSizeVar();
	virtual int					GetCurrentItem();
	virtual bool				MayAddExistingFolder();
	virtual void				OnRenderElement(BaseWidget* w, int elIdx);
	virtual void				OnSelect(int idx);
	virtual void				AddNewElement();
	virtual void				DeleteElement(int idx);
	virtual bool				OnDropExternalItem();
	virtual const char*			GetExtraRmbElements(int el);
	virtual void				ExecutePropertyElement(const char* el, int idx);
	virtual int					GetMinIconSize();

	static bool					ActivateShader(const char* ShaderName);
	static void					ReGenerateShadersPreviews();
	static void					SelectCurObjShader(cPtrDiff p);
	static void					DeleteShader(cPtrDiff idx);
	static void					RenameShader(cPtrDiff p);
	static void					ConstructNewShader(cPtrDiff p);
	static void					RefreshShdPreview(cPtrDiff p);
	static void					SelectDefShader(cPtrDiff p);
	static void					SelectCurrentShader(cPtrDiff idx);
	static bool					DuplicateShader(cPtrDiff idx);
	static void					ConstructNewShader(int Idx);
	static void					EditShaderPermanent(cPtrDiff p);
	static void					EditShaderProperties(cPtrDiff Idx);
	static void					EditShaderParam();
	static void					UpdateShaderPreview(cPtrDiff Idx);
	void						ApplyToVisible(int p);
	void						ApplyToSubtree(int p);
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id);

	static void					MakeFactureFromShader(cPtrDiff p);
};

class APICALL ModelPalettesWindow :public ItemsFolderUI {
public:
	///should be filled in the derived class
	int FolderIndex;//< refers to ItemsFoldersElements::GetFL(FolderIndex)
	cStr WindowHeaderID;

	ModelPalettesWindow(int fidx, const char* id) {
		FolderIndex = fidx;
		WindowHeaderID = id;
	}
	virtual ItemsFolder* GetItemsFolder() {
		return ItemsFoldersElements::GetFL(FolderIndex);
	}
	ModelsFolder* GetModels();
	virtual const char* GetWindowID() {
		return WindowHeaderID.ToCharPtr();
	}
	virtual BaseClass* GetClass() override {
		return nullptr;
	}
	virtual int					GetItemsCount() override;
	virtual int					GetCurrentItem() override;
	virtual bool				MayAddExistingFolder() override;
	virtual void				AddExistingFolder() override;
	virtual void				OnRenderElement(BaseWidget* w, int elIdx) override;
	virtual void				OnSelect(int idx) override;
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx) override;
	virtual void				DeleteElement(int idx) override;
	virtual void				AddNewElement() override;
	virtual bool				OnDropExternalItem() override;
	virtual bool				OnDropWidget() override;
	virtual int					GetMinIconSize() override;
	virtual const char*			GetExtraRmbElements(int el) override;
	virtual void				ExecutePropertyElement(const char* el, int idx) override;
	virtual int*				GetIconSizeVar() override;

	void						ImportModel(const char* name);
	void						Rename(int idx);

	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;
};

class APICALL PenWindow :public ItemsFolderUI {
public:
	virtual const char* GetWindowID();
	virtual const char* GetDefaultHotkey();
	virtual BaseClass* GetClass() override {
		return nullptr;
	}
	virtual ItemsFolder* GetItemsFolder() override {
		return ItemsFoldersElements::GetFL(0);
	}
	static PatternPen*			AddNewPenShape(const char* FileName, bool active, bool falloff = false);
	static PenWindow&			inst();
	virtual int					GetItemsCount() override;
	virtual int					GetCurrentItem() override;
	virtual bool				MayAddExistingFolder() override;
	virtual void				AddExistingFolder() override;
	virtual void				OnRenderElement(BaseWidget* w, int elIdx) override;
	virtual void				OnSelect(int idx) override;
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx) override;
	virtual void				DeleteElement(int idx) override;
	virtual void				AddNewElement() override;
	virtual bool				OnDropExternalItem() override;
	virtual bool				OnDropWidget() override;
	virtual int					GetMinIconSize() override;
	virtual const char*			GetExtraRmbElements(int el) override;
	virtual const char*			GetExtraDockProperyElements() override;
	virtual void				ExecutePropertyElement(const char* el, int idx) override;
	virtual int*				GetIconSizeVar() override;
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;
};

class APICALL StripWindow :public ItemsFolderUI {
public:
	virtual const char* GetWindowID();
	virtual BaseClass* GetClass() override {
		return nullptr;
	}
	virtual ItemsFolder* GetItemsFolder() {
		return ItemsFoldersElements::GetFL(1);
	}

	static void AddNewPenStrip(const char* Filename);
	static bool DisableStrip();
	
	virtual int					GetItemsCount() override;
	virtual int					GetCurrentItem() override;
	virtual bool				MayAddExistingFolder() override;
	virtual void				AddExistingFolder() override;
	virtual void				OnRenderElement(BaseWidget* w, int elIdx) override;
	virtual void				OnSelect(int idx) override;
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx) override;
	virtual void				DeleteElement(int idx) override;
	virtual void				AddNewElement() override;
	virtual bool				OnDropExternalItem() override;
	virtual int					GetMinIconSize() override;
	virtual const char*			GetExtraRmbElements(int el) override;
	virtual const char*			GetExtraDockProperyElements() override;
	virtual void				ExecutePropertyElement(const char* el, int idx) override;
	virtual int*				GetIconSizeVar() override;
	virtual float				PresentInActivityBar() override;
	virtual IconInfo			GetIconInActivityBar() override;
	virtual bool				HandleCommand(const char* id) override;
};
class APICALL MatHistory :public PopupWindow {
public:
	OneLayerInfo* LI;
	static MatHistory* inst;
	int nmat;
	MatHistory();
	virtual BaseClass* GetClass() {
		return NULL;
	}
	virtual double GetWindowSortValue() { return 3; }
	virtual const char* GetWindowID();
	virtual int PresentInWindowsList() { return 1; }//not present
	void ClickOnMHistory(cPtrDiff p);
	static void DrawAtt();
	static void EditMtl(cPtrDiff GUID);
	virtual void CreateUI(FrameWidget* root, const Rct& R);
	virtual bool AllowWindowResize() { return true; }
	virtual int PresentInNaviBar() { return false; }
	virtual float GetDefaultHeight() { return 200; }
	virtual void Process();
};
