#pragma once

class FHistory {
	int Lx, Ly;
	cList<BaseWidget*> points;
	cVec2i conv(const cVec2& p);
	cVec2i conv(float x, float y);
public:
	FHistory();
	void frame(const Rct& r, BaseWidget* b);
	void clear();
	BaseWidget* test(const cVec2& p);
	BaseWidget* test(float x, float y);

	static FHistory* this_tick;
	static FHistory* history;

	static void add(const Rct& r, BaseWidget* b);
	static bool check(float x, float y, BaseWidget* b);
	static bool check(const cVec2& p, BaseWidget* b);
};


class APICALL FrameRef : public BaseClass {
	HashSummator H;
	int LastCheckTime;
public:
	FrameRef();
	~FrameRef();
	int  ID;
	int TextureID;
	int CheckInterval;
	cStr ElementID;
	cStr FrameName;
	int Size;
	int TextDY;
	int dx;
	int dy;
	int dlx;
	int dly;
	bool Separator;
	bool IgnoreFiller;
	bool SkipIt;
	SERIALIZE() {
		//REG_AUTO(ElementID);
		REG_AUTO(FrameName);
		REG_AUTO(Size);
		REG_AUTO(TextDY);
		REG_AUTO(dx);
		REG_AUTO(dy);
		REG_AUTO(dlx);
		REG_AUTO(dly);
		REG_AUTO(Separator);
	}
	virtual void Draw(const Rct& r, DWORD Color);
	virtual void Draw(const Rct& r, DWORD Color, BaseWidget* parent);
	virtual void DrawSharpCorner(const cVec2& center, const cVec2& p1, const cVec2& p2, DWORD Color);
	virtual void Reload();
	static void ReloadAllFrames();
};
APICALL FrameRef* FrameItem(const char* id);
APICALL FrameRef* FrameItem(int id);

APICALL FrameRef* empty_frame();
APICALL FrameRef* button_frame();
APICALL FrameRef* dialog_frame();
APICALL FrameRef* dock_frame();
APICALL FrameRef* undock_frame();
APICALL FrameRef* dock_header_frame();
APICALL FrameRef* dock_header_plain_frame();
APICALL FrameRef* input_frame();
APICALL FrameRef* menu_frame();
APICALL FrameRef* menu1_frame();
APICALL FrameRef* tool_name_in_space_panel_frame();
APICALL FrameRef* class_buttons();
APICALL FrameRef* dialog_header();
APICALL FrameRef* combo_dropdown_frame();
APICALL FrameRef* combo_arrow_frame();
APICALL FrameRef* dock_delimiter_frame();
APICALL FrameRef* top_menu_highlight_frame();
APICALL FrameRef* menu_highlight_frame();
APICALL FrameRef* vscrollbar_frame();
APICALL FrameRef* viewport_frame();
APICALL FrameRef* voxtree_item_frame();
APICALL FrameRef* voxtree_plus_frame();
APICALL FrameRef* layers_frame();
APICALL FrameRef* quickpanel_frame();
APICALL FrameRef* qpanel_button_highlight_frame();
APICALL FrameRef* qpanel_button_frame();
APICALL FrameRef* class_tab_active_frame();
APICALL FrameRef* class_tab_passive_frame();
APICALL FrameRef* hints_frame();
APICALL FrameRef* tab_frame();
APICALL FrameRef* stdbutton_frame();
APICALL FrameRef* tabbutton_line_frame();
APICALL FrameRef* tabbutton_inactive_frame();
APICALL FrameRef* vertical_separator_frame();
APICALL FrameRef* separator_frame();
APICALL FrameRef* state_button_frame();
APICALL FrameRef* start_menu_frame();
APICALL FrameRef* start_menu_active_frame();
APICALL FrameRef* rightshadow_frame();
APICALL FrameRef* layer_coloring();