#pragma once
template <class Class,class KeyClass=float,int PoolSectionSize=64>
class pqueue{	
	struct temp_s{
		KeyClass	key;
		Class		element;
		temp_s*		low;
		temp_s*		high;		
	};
	typedef temp_s _parray [PoolSectionSize];
	typedef temp_s* ptemp_s;
	ptemp_s root;
	cList<temp_s*>	pool;
	cList<temp_s*>	freeVals;	
	temp_s* _get_temp_s(){
		if(!freeVals.Count()){
			temp_s* pa=new temp_s[PoolSectionSize];
			int sz0=pool.Count()*PoolSectionSize;
			pool.Add(pa);
			for(int i=0;i<PoolSectionSize;i++){
				temp_s* ts=pa+PoolSectionSize-i-1;				
				freeVals.Add(ts);
			}
		}        
		temp_s* fv=freeVals.pop_back();				
		return fv;
	}		
	int nelm;
public:
	inline				pqueue	();	
	inline				~pqueue	();	
	inline				Class*	add(KeyClass Key, Class& C);
	inline				void	add_range(KeyClass* Keys, Class* vals,int n);
	inline				Class*	get_lowest(bool remove,KeyClass* val=NULL);
	inline				Class*	get_top(bool remove,KeyClass* val=NULL);
	inline				void	clear();
	inline				int		size();
	inline				int		valid_size();
	inline				int		_valid_size(temp_s* r);
	inline				void	cleanup();
	inline				bool    _find(Class* p,temp_s* r);
	inline				bool    find(Class* p);

};
//implementation of [ pqueue ]
template <class Class,class KeyClass,int PoolSectionSize>
inline pqueue<Class,KeyClass,PoolSectionSize>::pqueue(){
	root=NULL;
	nelm=0;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline pqueue<Class,KeyClass,PoolSectionSize>::~pqueue(){

}
template <class Class,class KeyClass,int PoolSectionSize>
inline Class* pqueue<Class,KeyClass,PoolSectionSize>::add(KeyClass K,Class& C){	
	temp_s* ptr=_get_temp_s();
	ptr->key=K;
	ptr->element=C;
	ptr->low=ptr->high=NULL;
	nelm++;
	if(root){
		temp_s* t=root;
		temp_s* pt=t;
		do{
			pt=t;
			if(t->key<K){
				t=t->high;
				if(!t)pt->high=ptr;
			}else{
				t=t->low;
				if(!t)pt->low=ptr;
			}
		}while(t);		
	}else{		
		root=ptr;
	}
	return &ptr->element;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline void pqueue<Class,KeyClass,PoolSectionSize>::add_range(KeyClass* Keys, Class* vals,int n){
	if(n>0){
		int nm=n/2;
		Class* c=add(Keys[nm],vals[nm]);
		c->validate();
		int n2=n-nm-1;
		if(nm)add_range(Keys,vals,nm);
		if(n2>0)add_range(Keys+nm+1,vals+nm+1,n2);
	}		
}
template <class Class,class KeyClass,int PoolSectionSize>
inline Class* pqueue<Class,KeyClass,PoolSectionSize>::get_lowest(bool remove,KeyClass* val){
	if(root){
		temp_s* p=root;
		temp_s* pt=NULL;
		do{			
			if(p->low){
				pt=p;
				p=p->low;
			}else{
				if(remove){
					nelm--;
					freeVals.Add(p);
					if(p->high){
						if(pt)pt->low=p->high;						
						else root=p->high;
					}else{
						if(pt)pt->low=NULL;
						else root=NULL;
					}
				}
				if(val)*val=p->key;
				return &p->element;				
			}
		}while(true);
	}
	return NULL;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline Class* pqueue<Class,KeyClass,PoolSectionSize>::get_top(bool remove,KeyClass* val){
	if(root){
		temp_s* p=root;
		temp_s* pt=NULL;
		do{			
			if(p->high){
				pt=p;
				p=p->high;
			}else{
				if(remove){
					freeVals.Add(p);
					nelm--;
					if(p->low){
						if(pt)pt->high=p->low;
						else root=p->low;
					}else{
						if(pt)pt->high=NULL;
						else root=NULL;
					}
				}
				if(val)*val=p->key;
				return &p->element;				
			}
		}while(true);
	}
	return NULL;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline void pqueue<Class,KeyClass,PoolSectionSize>::clear(){	
	freeVals.Clear();
	pool.Clear();
	root=NULL;
	nelm=0;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline int pqueue<Class,KeyClass,PoolSectionSize>::size(){
	return nelm;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline void pqueue<Class,KeyClass,PoolSectionSize>::cleanup(){
	cList<KeyClass> keys;
	cList<Class> vals;
	Class* v;
	do{
		KeyClass k;
		v=get_lowest(true,&k);
		if(v && v->valid()){
			keys.Add(k);
			vals.Add(*v);
		}		
	}while(v);
	clear();
	add_range(keys.ToPtr(),vals.ToPtr(),keys.Count());
}
template <class Class,class KeyClass,int PoolSectionSize>
inline int pqueue<Class,KeyClass,PoolSectionSize>::valid_size(){
	return root?_valid_size(root):0;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline int pqueue<Class,KeyClass,PoolSectionSize>::_valid_size(temp_s* r){
	int n=r->element.valid();
	if(r->low)n+=_valid_size(r->low);
	if(r->high)n+=_valid_size(r->high);
	return n;
}
template <class Class,class KeyClass,int PoolSectionSize>
inline bool pqueue<Class,KeyClass,PoolSectionSize>::find(Class* p){
	return _find(p,root);
}
template <class Class,class KeyClass,int PoolSectionSize>
inline bool pqueue<Class,KeyClass,PoolSectionSize>::_find(Class* p,temp_s* r){
	if(r){
		if(p==&r->element)return true;
		if(r->low && _find(p,r->low))return true;
		if(r->high && _find(p,r->high))return true;
	}return false;
}
