import coat
from PIL import Image, ImageDraw, ImageFilter, os

scale=4
R=coat.ui.scale()*6
if R>5: R=5
R0=R
R*=scale

image = Image.new("RGBA", (64*scale, 64*scale), (0, 0, 0, 0)) 
draw = ImageDraw.Draw(image)

def tup(x,y,w,h):
    return (x*scale,y*scale,(x+w)*scale-1,(y+h)*scale-1)

def newimage():
    draw.rectangle((0,0,64*scale-1,64*scale-1),fill=(0,0,0,0))

def save(name):
    os.makedirs(coat.io.documents("data/textures/Frames24"),exist_ok=True)
    im2 = image.resize((128,128),Image.BOX)
    im4 = image.resize((64,64),Image.BOX)
    im4.save(coat.io.documents("data/textures/Frames24/"+name+".tga"))
    image.save(coat.io.documents("data/textures/Frames24/"+name+"_4x.tga"))
    coat.utils.signal(name+".tga")

def roundedBox(bound,fill):
    x1,y1,x2,y2 = bound
    r=R
    if r > (x2-x1)/2: r = (x2-x1)/2
    if r > (y2-y1)/2: r = (y2-y1)/2
    draw.rectangle((x1+r,y1,x2-r,y2),fill=fill)
    draw.rectangle((x1,y1+r,x2,y2-r),fill=fill)
    draw.ellipse((x1,y1,x1+2*r,y1+2*r),fill=fill)
    draw.ellipse((x2-2*r,y1,x2,y1+2*r),fill=fill)
    draw.ellipse((x1,y2-2*r,x1+2*r,y2),fill=fill)
    draw.ellipse((x2-2*R,y2-2*r,x2,y2),fill=fill)

# draw 90deg arc, sector is 0..3, center is (x,y)
def arc(center,fill,sector) :
    rect = (center[0]-R,center[1]-R,center[0]+R,center[1]+R)
    draw.arc(rect,sector*90,sector*90+90,fill = fill)    

def line(x1,y1,x2,y2,fill):
    draw.line((x1,y1,x2,y2),fill=fill)

def shadow(bound,fill):
    global image,draw
    roundedBox(bound,fill)
    image = image.filter(ImageFilter.BoxBlur(24))
    draw = ImageDraw.Draw(image)

    

delta = 0.5
roundedBox(tup(8,8,64-16,64-16),(64,64,64,255))
roundedBox(tup(8 + delta,8 + delta,64-16-delta*2,64-16-delta*2),"grey")
save("button")
save("class_buttons")
save("input")
save("combo_inner_frame")

shadow(tup(8,8,64-16,64-16),(0,0,0,64))
roundedBox(tup(8,8,64-16,64-16),(64,64,64,255))
roundedBox(tup(8 + delta,8 + delta,64-16-delta*2,64-16-delta*2),"grey")
save("menu")
save("combo_dropdown")

newimage()

R*=1.5
filler = (128,128,128,255)
dy = 0
dy1 = 0
dx = 0
roundedBox(tup(8+dx,8+dy,64-16-2*dx,64-16),"white")
roundedBox(tup(8+dx,8+dy1+dy,64-16-2*dx,64-16-dy1),filler)
roundedBox(tup(-8,32,64+16,24+dy),filler)
roundedBox(tup(-28,0,36+dx,56+dy),(0,0,0,0))
roundedBox(tup(56-dx,0,36,56+dy),(0,0,0,0))

dark = (64,64,64,255)
ddy=dy*scale
arc((8*scale+R,8*scale+R+ddy),dark,2)
arc((8*scale+R+1,8*scale+R+ddy),dark,2)
arc((8*scale+R+1,8*scale+R+ddy+1),dark,2)

arc((56*scale-R-1,8*scale+R+ddy),dark,3)
arc((56*scale-R-1-1,8*scale+R+ddy),dark,3)
arc((56*scale-R-1-1,8*scale+R+ddy+1),dark,3)

arc((8*scale-R,56*scale-R-1+ddy),dark,0)
arc((8*scale-R+1,56*scale-R-1+ddy),dark,0)

arc((56*scale+R-1,56*scale-R-1+ddy),dark,1)
arc((56*scale+R-1-1,56*scale-R-1+ddy),dark,1)

line(8*scale+R,8*scale+ddy,56*scale-R-1,8*scale+ddy,dark)
line(8*scale+R,8*scale+ddy+1,56*scale-R-1,8*scale+ddy+1,dark)

line(8*scale,8*scale+R+ddy,8*scale,56*scale+ddy-R,dark)
line(8*scale+1,8*scale+R+ddy,8*scale+1,56*scale+ddy-R,dark)

line(56*scale-1,8*scale+R+ddy,56*scale-1,56*scale+ddy-R,dark)
line(56*scale-2,8*scale+R+ddy,56*scale-2,56*scale+ddy-R,dark)

save("tab")

