// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_ProjectionMatrix;
uniform mat4 g_TextureMatrix0;
uniform float g_TimeSec;
uniform mat4 Transform;
uniform vec3 g_ViewerPos;
uniform float ViewBias;

in vec3 Pos;
in vec4 Color;
out vec4 C;

void main() {	
	vec4 P = vec4(Pos, 1.0);
	P*=Transform;
	vec3 D=normalize(g_ViewerPos-P.xyz/P.w);
	P.xyz+=(ViewBias+0.5)*D;
	P *= g_WorldViewProjectionMatrix;
	C = Color;
	gl_Position = P;
}



// Fragment shader

in vec4 C;

uniform vec3 LDir;
uniform float LAmbient;
uniform float LDiffuse;
uniform float Opc;


out vec4 FragColor;
void main() {
	FragColor = C;
}