// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;
uniform float ShiftT;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0 = vec2(vec4(TexCoord0, 0.0, 1.0) * g_TextureMatrix0);

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif
	v_TexCoord1.x = Pos.x/20.0+ShiftT;
	v_TexCoord1.y = Pos.y/20.0-ShiftT;
	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;
uniform sampler2D s_Sampler2;
uniform float FreezeMod;

out vec4 FragColor;
void main() {
	vec4 c = texture(s_Sampler0, v_TexCoord0);
	vec4 n = texture(s_Sampler1, v_TexCoord0);
	vec4 f = texture(s_Sampler2, v_TexCoord1);
#ifdef FORDP
	float fr=1.0-n.z;
	vec3 nr=n.xyz*2.0-1.0;	
	n.z=sqrt(1.0-nr.x*nr.x-nr.y*nr.y);
#else
	vec3 nr=n.xyz*2.0-1.0;
	float  fr=length(nr);
#endif
	n.xyz=mix(n.xyz,f.xyz,(1.0-fr)*FreezeMod);
	n.w=c.w;
	FragColor = n;
}