// Vertex shader

uniform mat4 g_ViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_ViewerPos;
uniform mat4 g_NrmMatrix;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;

out vec3 v_Normal;
out vec3 VDir;

void main() {
	vec4 P=vec4(Pos,1.0);
	vec4 N=vec4(Normal,0.0);
	P=P * g_WorldMatrix;
	VDir = normalize(vec3(P)-g_ViewerPos);
	P.xyz-=VDir*0.02;
	v_Normal=vec3(N * g_NrmMatrix);
	gl_Position = P * g_ViewProjectionMatrix;
}

// Fragment shader

uniform vec3 LDir;
uniform vec4 Color;

in vec3 v_Normal;
in vec3 VDir;

out vec4 FragColor;
void main() {
	vec3 N;
	float D;
	vec4 C;
	N = normalize(v_Normal);
	D = dot(N,LDir);
	//D*=D;
	D=0.2+D*0.8;
	C.xyz = D*Color.xyz*2.0;
   	C.w   = Color.w;
	FragColor = C;
}