// Vertex shader
uniform float  ShiftT;
uniform float  ScaleX;
uniform float  ScaleY;
uniform vec3   g_ViewerPos;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec2 oUV;

// Used in included "ggx_variables" and "ggx_light_core"
out vec3 oRawNormal;
out vec3 oRawPos;

void main(){
	oUV  = TexCoord0;

#ifdef SCREEN_SPACE
	vec4 p = vec4(Pos, 1.0)/* + vec4(-0.5, 0.5, 0.0, 0.0)*/;
	gl_Position = p * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif
    oRawNormal = vec3(0.0);
    oRawPos = vec3(0.0);
}

// Fragment shader
in vec2 oUV;

out vec4 FragColor;

uniform sampler2D Panorama;
uniform sampler2D s_Sampler0;//Texture;
uniform sampler2D s_Sampler1;//Reflection
uniform sampler2D s_Sampler2;//view direction
uniform sampler2D s_Sampler3;//Colored specular
uniform vec4 Freshnel;
uniform mat3 WPanMatrix;
uniform float PanoramaShift;
uniform vec4   LightColor;

uniform mat4   g_NormalViewMatrix;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform vec3   VDir;
uniform float  LDiffuseC;
uniform float  LDiffuse22C;
uniform float  LAmbient;
uniform vec4 mip_ref;

#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"

void main()
{
	vec4  color;
	vec4  nrm = texture(s_Sampler1, oUV);   
	vec4  vds = texture(s_Sampler2, oUV);   
	vec4  sfColor  = texture(s_Sampler0, oUV);
	vec4  sfSpecular  = texture(s_Sampler3, oUV).zyxw;

	if (sfColor.w < 0.01)
		discard;
	vec3  GlobalNormal = normalize(vec3(nrm.x * 2.0 - 1.0, nrm.y * 2.0 - 1.0, nrm.z * 2.0 - 1.0));
	vec3  vd = -normalize(vec3(vds.x * 2.0 - 1.0, vds.y * 2.0 - 1.0, vds.z * 2.0 - 1.0));
	
	vec3  Normal    = normalize(GlobalNormal);	
	vec3  ReflectionDir = normalize(vd - 2.0 * Normal * dot(vd, Normal));

	ReflectionDir = normalize(ReflectionDir * WPanMatrix);
	Normal    = normalize(Normal * WPanMatrix);
	vec3 ViewDir = normalize(vd * WPanMatrix);
	float Freeze = 0.0;
	vec4 Checker = vec4(1.0);
	float Gloss = sfSpecular.w;
	float Emissive = 0.5;
	vec3 LightDir = LDir;
	vec3 objcolor = vec3(LDiffuse22C);

#include "/Templates/ggx_light_core.glsl"
	FragColor = color;
}
