// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform float ShiftT;
uniform float ScaleX;
uniform float ScaleY;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec4 TexCoord;
in vec3 N;
in vec4 T;
in vec4 B;

out vec2 oUV;
out vec2 oUV2;
out vec3 oVDir;
out vec3 oN;
out vec3 oT;
out vec3 oB;
out vec3 oWorldPos;
out float v_pz;

void main()
{
	vec4 P = vec4(Pos, 1.0);	
#ifdef SHADOW_MAP
	vec4 finalPos = P * ShadowTM;
#else
	oVDir = normalize(Pos.xyz - g_ViewerPos);
	P.xyz+=oVDir*0.08;
	vec4 finalPos = P * g_WorldViewProjectionMatrix;
#endif	
	v_pz = finalPos.z;
	oUV  = TexCoord.xy;    //-float2(1.0/1024.0,1.0/1024.0);
	oUV.y = 1 - oUV.y;
	oUV2 = vec2( finalPos.x / finalPos.w * ScaleX + ShiftT, finalPos.y / finalPos.w * ScaleY - ShiftT );
	oN = N;
	oT = T.xyz * 2.0 - 1.0;
	oB = B.xyz * 2.0 - 1.0;
//#ifdef SHADOWS
//	oSPos = (P * ShadowTM).xyz;
//	oSPos.xy += vec2( 1.0 / 4096.0 , 1.0 / 4096.0);
//	oSPos.y = 1.0 - oSPos.y;
//#endif
	oWorldPos = Pos;
	gl_Position = finalPos;
}

// Fragment shader

/*
uniform sampler2D s_Sampler0;//Texture;
uniform sampler2D s_Sampler1;//Normals;
uniform sampler2D s_Sampler2;//Chess;
uniform sampler2D s_Sampler3;//Colored specular;
uniform sampler2D s_Sampler4;//Environment map;
*/
uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;
uniform sampler2D s_Sampler2;
uniform sampler2D s_Sampler3;
uniform sampler2D s_Sampler4;
uniform sampler2D s_Sampler5;
uniform sampler2D s_Sampler6;
uniform sampler2D Panorama;
uniform float PanoramaShift;

#ifdef SHADOWS
uniform sampler2D ShadowSampler;
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_NormalViewMatrix;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform float    LDiffuseC;
uniform float    LDiffuse22C;
uniform float    LAmbient;
uniform float    FreezeInv;
uniform float    RefShade;
uniform vec4   LightColor;
uniform mat3 WPanMatrix;
uniform vec4 Freshnel;
uniform vec4 mip_ref;
uniform float Denorm;
uniform float CutOutLevel;

in vec2 oUV;
in vec2 oUV2;
in vec3 oVDir;
in vec3 oN;
in vec3 oT;
in vec3 oB;
in float  v_pz;

out vec4 FragColor;

#line 100 200
#define oMPos oWorldPos
#define oSPos oWorldPos

#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"
void main() 
{


	vec4  color = vec4(1, 1, 1, 1);

	ioMTL[0] = texture(s_Sampler0,oUV);
	ioMTL[1] = texture(s_Sampler1,oUV);
	ioMTL[2] = texture(s_Sampler2,oUV);
	ioMTL[3] = texture(s_Sampler3,oUV);
	ioMTL[4] = texture(s_Sampler4,oUV);
	ioMTL[5] = texture(s_Sampler5,oUV);
	ioMTL[6] = texture(s_Sampler6,oUV);


	
//	float iEmissive = saturate(max(max(Albedo.r, Albedo.g),Albedo.b)*2.0-1.0);
	
//	float ClearCoat = saturate(Albedo.w*2.0-1.0);


	vec3 ViewDir=oVDir;
	
	float Freeze = 0;//nrm.z;
	vec4  Checker = vec4(0);//TODO Procedural //texture(s_Sampler2,oUV2);

//	float Gloss = saturate(nrm.w*2.0-1.0);
//	float Emissive = iEmissive;//sfSpecular.w;
	vec3 LightDir = LDir;
	vec3 objcolor = vec3(LDiffuse22C);


	vec3 dN = vec3(0);

	#define USE_NORMALMAP_PPP
	#define USE_NORMALMAP
	#define USE_SSSHADOW
//	#define REFRACTION
	#define ARTISTIC
	#define CLEAR_COAT
//	#define MICROPROTRUSIONS
//	#define FUZZ
	#define PPP

	vec3 N0 = oN;
	vec3  Normal = N0;

#ifdef NODE_CODE
			
	ioUV = vec4(oUV, 0,0);//meshPosition;
	ioNormal = vec4(N0,0);
//	ioTSNormal = vec4(NormalMap.xy,1,1);
#endif

float Emissive = 0.5;
vec3 sfColor = vec3(0,0,0);
vec3 GlobalNormal = Normal;
#include "/Templates/pbm_light_core.glsl"


//	if(color.w<CutOutLevel) discard; !!! TODO:


    if(ProjectorOpacity>0){
		vec4 pruv = vec4(oWorldPos,1.0) * ProjectorTM;
		pruv.y*=-1;
		vec4 prcl=texture(ProjectorSampler,pruv.xy/pruv.w)*2.0;
		color.xyz *= lerp(vec3(1.0,1.0,1.0),prcl.xyz,ProjectorOpacity);
	}

	
#ifdef SHADOW_MAP
//	if(color.w<0.5) discard;
	if(fract(CurrentIteration * 0.1) < (1.0-color.w * color.w)) {
		discard;
	}


    float Depth = v_pz;
    vec4 c = vec4(0.0, 0.0, 0.0, 1.0);
    float i = floor(Depth * 255.0);
    c.r = i / 255.0;
    Depth = (Depth - c.r) * 255.0;
    i = floor(Depth * 255.0);
    c.g = i / 255.0;
    FragColor = c;
	
#else
	FragColor = color;
#endif	
}

