// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_ViewerPos;
uniform float NDisplacement; 
uniform float ViewBias;


#ifdef SHADOWS 
uniform mat4 ShadowTM;
uniform float ShadowMapSize;
#endif //SHADOWS


in vec3 Pos;
in vec3 Normal;
in vec4 Color;

out vec3 v_Normal;
out vec3 v_Pos;
out vec4 v_Pos2;
out float v_DS;
#ifdef SHADOWS
out vec3 v_SPos;
#endif


void main() {
	vec3 nn = normalize(Color.xyz-vec3(0.5,0.5,0.5));	
	vec4 P = vec4(Pos+nn*NDisplacement, 1.0);
#ifdef SHADOWS
	v_SPos = (P * ShadowTM).xyz;
	v_SPos.y = 1.0 - v_SPos.y;
#endif //SHADOWS
	v_Pos2 = P * g_WorldViewProjectionMatrix;
	v_Pos2.z -= ViewBias * v_Pos2.z;
	gl_Position = v_Pos2;
	P = vec4(Normal, 0.0);
	vec4 N = P * g_WorldMatrix;	
	v_Normal=normalize(N.xyz);
	v_Pos=Pos;
	v_DS=Color.w;
}

// Fragment shader

in vec3 v_Normal;
in vec3 v_Pos;
in vec4 v_Pos2;
in float v_DS;
#ifdef SHADOWS
in vec3 v_SPos;
#endif

uniform float    LDiffuse;
uniform float    LAmbient;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform vec4   Color;

#ifdef SHADOWS
uniform sampler2D ShadowSampler;
uniform mat4 ShadowTM;
uniform float ShadowMapSize;
uniform float ShadowOpacity;
#endif //SHADOWS


uniform float g_ViewportWidth;
uniform float g_ViewportHeight;

out vec4 FragColor;
void main() {	
	vec3 N=normalize(v_Normal);
	float   D = LDiffuse*(0.5+dot(N,LDir));
#ifdef SHADOWS
	vec3 m = texture(ShadowSampler,v_SPos.xy).xyz;	
	float shadowBias = 0.02/ShadowMapSize;
	vec3 d = vec3(1.0,1.0/255.0,1.0/255.0/255.0);	
	float Multiplier = saturate(2.0-(v_SPos.z-dot(m,d)-shadowBias)*ShadowMapSize)*ShadowOpacity + (1.0-ShadowOpacity);
	D = saturate(D*Multiplier - Multiplier*0.33) + Multiplier*0.33;
#endif	
	vec4 C1 = Color*D;
	C1.w =Color.w;
	if(v_DS>0.0){
		vec4 p=v_Pos2;
		p/=p.w;
		float x=(1.0+p.x)*0.25*g_ViewportWidth+0.125;
		float y=(1.0+p.y)*0.25*g_ViewportHeight+0.125;
		float s=x+y;
		s-=floor(s);
		if(s>0.5){
			discard;
			C1.w=0.0;
		}		
	}
	FragColor = C1;//cos(v_Pos.x*20.0)*0.5+0.5,cos(v_Pos.y*20.0)*0.5+0.5,cos(v_Pos.z*20.0)*0.5+0.5,1);
}