// Vertex shader

uniform vec3 g_ViewerPos;
uniform mat4 g_WorldViewProjectionMatrix;

in vec3 Pos;
in vec4 Color;

out vec3 v_N;
out vec3 v_P;

void main( ) {
    vec4 P=vec4( Pos, 1.00000);
    gl_Position = ( P * g_WorldViewProjectionMatrix );
    v_P = Pos;
    v_N = Color.xyz;
    v_N *= 2.0;
    v_N -= vec3(1.0,1.0,1.0); 
}

// Fragment shader

uniform mat4 ScrToUVX;
uniform mat4 ScrToUVY;
uniform mat4 ScrToUVZ;

uniform float FreezeInv;
uniform vec4 LightColor;
uniform float LAmbient;
uniform float LDiffuse;
uniform vec3 LDir;
uniform vec3 LDir2;
uniform sampler2D s_Sampler0;
uniform sampler2D PanoramaDiffuse;
uniform float InvMask;
uniform mat3x3 WPanMatrix;
uniform float CubemapSharpness;
uniform vec3 Filling;

in vec3 v_N;
in vec3 v_P;


out vec4 FragColor;
void main( ) {
    vec4 texc1=vec4(-v_P.x,-v_P.y,0.0,1.0);
    vec4 texc2=vec4(-v_P.x, v_P.z,0.0,1.0);
    vec4 texc3=vec4( v_P.z,-v_P.y,0.0,1.0);
    texc1 = texc1 * ScrToUVZ;
    texc2 = texc2 * ScrToUVY;
    texc3 = texc3 * ScrToUVX;

    vec3 n2=normalize(vec3(v_N.x*exp(-Filling.x*4.0),v_N.y*exp(-Filling.y*4.0),v_N.z*exp(-Filling.z*4.0)));

    vec3 ws = vec3(n2.z*n2.z,n2.y*n2.y,n2.x*n2.x);

    ws.x = pow(ws.x,CubemapSharpness);
    ws.y = pow(ws.y,CubemapSharpness);
    ws.z = pow(ws.z,CubemapSharpness);

    float av = (ws.x + ws.y + ws.z)/6.0;
    ws-=vec3(av,av,av);
  
    ws.x = saturate(ws.x);
    ws.y = saturate(ws.y);
    ws.z = saturate(ws.z);

    texc1.y*=-1.0;
    texc2.y*=-1.0;
    texc3.y*=-1.0;

    vec4 tex = (texture( s_Sampler0, texc1.xy)*ws.x + texture( s_Sampler0, texc2.xy)*ws.y + texture( s_Sampler0, texc3.xy)*ws.z)/(ws.x+ws.y+ws.z);
    tex.xyz = (InvMask*vec3(1.0,1.0,1.0)+(1.0-2.0*InvMask)*tex.xyz);

    float D = LAmbient + (LDiffuse * dot( v_N, LDir));

    vec3 N1=v_N*WPanMatrix;
    float uu=atan(N1.z,N1.x)/6.2831853;
    float vv=0.5+asin(N1.y)/3.1415926*47.0/48.0;		
    vec4 diff=texture(PanoramaDiffuse,vec2(uu,vv));
    diff.xyz*=5.0-diff.w*4.0;

    vec4 Color;
    Color.xyz  = tex.xyz*diff.xyz;
    Color.w  = 1.0;
    FragColor = Color*LightColor;
}
