// Vertex shader

uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;

in vec3 Pos;
in vec2 TexCoord;

#ifdef SRC_CUBE
out vec3 v_Normal;
#else // !SRC_CUBE
out vec2 v_TexCoord;
#endif // SRC_CUBE

void main() {
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
	
#ifdef SRC_CUBE
	if(0.0 == TexCoord.x && 0.0 == TexCoord.y) {
		v_Normal = vec3(1.0, -1.0, -1.0);
	} else if(1.0 == TexCoord.x && 0.0 == TexCoord.y) {
		v_Normal = vec3(1.0, -1.0, 1.0);
	} else if(1.0 == TexCoord.x && 1.0 == TexCoord.y) {
		v_Normal = vec3(1.0, 1.0, 1.0);
	} else {
		v_Normal = vec3(1.0, 1.0, -1.0);
	}
#else // !SRC_CUBE
	v_TexCoord = TexCoord;
#endif // SRC_CUBE
}

// Fragment shader

#ifdef SRC_1D
uniform sampler1D s_Src;
#endif

#ifdef SRC_2D
uniform sampler2D s_Src;
#endif

#ifdef SRC_3D
uniform sampler3D s_Src;
#endif

#ifdef SRC_CUBE
uniform samplerCube s_Src;
#endif

#ifdef OVERRIDE_ALPHA
uniform float c_Alpha;
#endif

#ifdef SRC_CUBE
in vec3 v_Normal;
#else // !SRC_CUBE
in vec2 v_TexCoord;
#endif // SRC_CUBE

out vec4 FragColor;
void main() {
#ifdef SRC_1D
	vec4 Color = texture(s_Src, v_TexCoord.x);
#endif

#ifdef SRC_2D
	vec4 Color = texture(s_Src, v_TexCoord);
#endif

#ifdef SRC_3D
	vec4 Color = texture(s_Src, vec3(v_TexCoord.x, 0.0, 1.0 - v_TexCoord.y));
#endif

#ifdef SRC_CUBE
	vec4 Color = texture(s_Src, v_Normal);
#endif
	
#ifdef ALPHA_CHANNEL_AS_COLOR
	Color.rgb = vec3(Color.a);
#endif

#ifdef OVERRIDE_ALPHA
	Color.a = c_Alpha;
#endif
	
	FragColor = Color;
}