#line 1 300
/////////////////////////////////////////////////////////////
// Gloss          - glossness of the pixe
// PANORAMA SPACE VECTORS:
// Normal         - normal in panorama space
// ViewDir        - view direction  in panorama space
// ReflectionDir  - reflection direction in panorama space
//
// WORLD SPACE VECTORS
//
// GlobalNormal   - normal in world space
// LightDir       - light direction in world space
// GlobalViewDir  - view direction in world space
//
// OTHER STUFF:
//
// Freeze	  - freeze value
// Opacity        - texture opacity
// Emissive       - emissive
// Panorama       - environment sampler
//
// COLORS:
//
// LDiffuse22C    - gamma corrected light color
// LightColor2g   - gamma corrected color, (1,1,1) for panorama and (r,g,b) for colored light
// NOT GAMMA CORRECTED:
// sfSpecular.xyz - specular color
// sfColor.xyz    - texture color
// Checker        - checker (selection) color
// color          - resulting color
// IsExternalLight - 0 for panorama and 1 for extern lights
/////////////////////////////////////////////////////////////


{
#define RP_COMPOSITE 0
#define RP_DIFFUSE 1
#define RP_TRANSLUCENT 2
#define RP_LIGHT 3
#define RP_AO 4
#define RP_DEPTH 5
#define RP_REFLECTION 6
#define RP_REFRACTION 7
#define RP_CLEAR_COAT 8
#define RP_GLOSS 9
#define RP_FOG 10
#define RP_FOG_MASK 11
#define RP_FOG_LIGHT 12
#define RP_EMMISIVE 13
#define RP_FUZZ 14
#define RP_FUZZ_MASK 15
#define RP_FUZZ_LIGHT 16
#define RP_MICROPROTRUSIONS 17
#define RP_MICROPROTRUSIONS_MASK 18
#define RP_MICROPROTRUSIONS_LIGHT 19

#ifndef D_RRenderPass
#define D_RRenderPass 0
#endif


float Occlusion = clamp(Emissive*2.0, 0.0, 1.0);
float SpecOcclusion = Occlusion*Occlusion*Occlusion;

Emissive = clamp(Emissive*2.0-1.0, 0.0, 1.0);


#ifdef PROCEDURAL_ENV

	float LCuu = atan(LightDir.z,LightDir.x)/(3.1415926*2.0);
	float LCas = asin(LightDir.y);
	float LCvv = 0.5+LCas/3.14159;	
	
	vec4 LightColor = texture(Panorama, vec2(LCuu, LCvv));	
	LightColor.xyz *= 5.0-LightColor.w*4.0;//extra light range from the texture alpha channel
//	LightColor.xyz *= getmodf(LightColor.xyz);
//	LightColor.xyz = pow(LightColor.xyz,vec3(gamma));


#endif


	int iCurrentIteration = int(CurrentIteration);
	vec4 lightColor = lerp(LightColor, LightColor2g,IsExternalLight);
	float iIsExternalLight = 1;


	
	float pi = 3.1415926;
	float pi2 = 3.1415926*2;	
	


		
	
#ifdef ANISOTROPIC	
	float anisotropic = Anisotropic/1.5;
	float anisotropic05 = pow(anisotropic,0.7);
	float anisoAngle = AnisotropicAngle*3.6;
	
	float anisoRadAngle = anisoAngle * 0.017453;
	vec2 anisoDir;
	anisoDir.x = cos(anisoRadAngle);
	anisoDir.y = sin(anisoRadAngle);
	vec2 anisoDirI = -anisoDir;
	
	ioR_Gloss *= 1.0-anisotropic/4.0;

#endif

	const float gamma = 2.2; 
	const float igamma = 1.0/2.2; 

	vec3 Emiss = sfColor.xyz * Emissive;

	////////////////////////////////////////////////
/*	ioPM = vec4(tColor*0.5, sfColor.w);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(sfSpecular.xyz, 0.0);
	ioPQ3 = vec4(Emiss, 0.0)*0.5;
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, defMetall*0.5+0.5, Gloss*0.5+0.5);*/
	ioDisplacement = 0;
#ifdef MC_COVER
	ioDisplacement = nrm.z;
	ioPN.y = ioR_Gloss;
	ioPN.z = metl;
#endif
	ioNormal = vec4(GlobalNormal.xyz, 0.0);
	ioGlobalNormal = vec4(normalize(GlobalNormal.xyz*mat3(g_WorldMatrix)), 0.0);
	vec3 oRawPosSc = oRawPos*NGScale;
	ioPosition = vec4(oRawPos.xyz, 1.0);
	ioGlobalPosition = (ioPosition*g_WorldMatrix);
#ifdef NODE_CODE
	vec3 oMPosSc = oMPos*NGScale;
#ifndef HAS_IN_CAVITY
	#ifdef USE_CAVITY
		float icavity = -ca0*0.5+0.5;
		ioCavity = vec4(icavity, icavity, icavity, icavity);
	#else
		ioCavity = vec4(0.5,0.5,0.5,0.5);
	#endif
#endif	
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);                 // shader playback time (in seconds)
	ioMouse = vec4(MousePos.x, MousePos.y, MousePos.z, 0.0);                // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oRawPos*NGScale, 0.0);
	ioUV = ioFragCoord;
	

	ioFragCoord_DX = vec4(dFdx(oRawPosSc.xyz)*NGScale, 0.0);
	ioUV_DX = ioFragCoord_DX;
	ioNormal_DX = vec4(dFdx(oRawNormal.xyz), 0.0);
	ioPosition_DX = vec4(dFdx(oRawPos.xyz), 0.0)*NGScale;

	ioFragCoord_DY = vec4(dFdy(oRawPosSc.xyz), 0.0);
	ioUV_DY = ioFragCoord_DY;
	ioNormal_DY = vec4(dFdy(oRawNormal.xyz), 0.0);
	ioPosition_DY = vec4(dFdy(oRawPos.xyz), 0.0)*NGScale;

	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4(g_LocalViewPos.xyz, 0.0);
	ioIteration = vec4One * CurrentIteration;

	ioOcclusion = vec4(Occlusion);

	vec3 iNormalSm = GlobalNormal-normalize(cross(dFdx(oRawPos),dFdy(oRawPos)));

	vec3 Pxx=oRawPos+dFdx(oRawPos);
	vec3 Pyy=oRawPos+dFdy(oRawPos);//*IncSign;		
#ifdef NG_AFFECTS_NORMAL
	vec4 _origPM =  ioPM;
	vec4 _origPQ1 = ioPQ1;
	vec4 _origPQ2 = ioPQ2;
	vec4 _origPQ3 = ioPQ3;
	vec4 _origPQ4 = ioPQ4;
	vec4 _origPN =  ioPN; 
	float _origDisplacement = ioDisplacement;
	{
		ioPosition = vec4(Pxx, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
//		ioFragCoord = vec4(Pxx*0.005/(OverallScale+1e-10),0.0);
		NODE_CODE;
		Pxx = ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale;
	}
	ioPM =  _origPM;
	ioPQ1 = _origPQ1;
	ioPQ2 = _origPQ2;
	ioPQ3 = _origPQ3;
	ioPQ4 = _origPQ4;
	ioPN =  _origPN; 
	ioDisplacement = _origDisplacement;
	{
		ioPosition = vec4(Pyy, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
//		ioFragCoord = vec4(Pyy*0.005/(OverallScale+1e-10),0.0);
		NODE_CODE;
		Pyy = ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale;
	}
	ioPM =  _origPM;
	ioPQ1 = _origPQ1;
	ioPQ2 = _origPQ2;
	ioPQ3 = _origPQ3;
	ioPQ4 = _origPQ4;
	ioPN =  _origPN; 
	ioDisplacement = _origDisplacement;
#endif	
	{
		ioPosition = vec4(oRawPos, 1.0);
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
		NODE_CODE;
		
	}	

#ifdef NG_AFFECTS_NORMAL
	vec3 iPD = (ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale);
	vec3 iz = normalize(iPD-Pyy);
	vec3 ix = normalize(cross(normalize(Pxx-iPD), iz)); 
	ioNormal.xyz = -normalize(ix-iNormalSm);
#endif	
	
	Normal.xyz = normalize(ioNormal.xyz*WPanMatrix);
	GlobalNormal.xyz = ioNormal.xyz;
	ReflectionDir = oVDir - GlobalNormal * dot(oVDir, GlobalNormal) * 2.0;
	ReflectionDir = normalize(ReflectionDir*WPanMatrix);

	
#endif

#ifdef UNPACK_PBM
	UNPACK_PBM;
#endif


	ioPN.z = saturate(ioPN.z*2.0-1.0);

	ioR_Gloss = ioR_Gloss;
	ioR_AlbedoColor.xyz = pow(saturate(ioR_AlbedoColor.xyz), vec3(2.2));
	Emiss = /*max(ioR_EmissiveColor.xyz,*/ ioR_AlbedoColor.xyz*Emissive;//);


	vec4 iSSScolor = max(saturate(ioR_SubSurfaceColor), vec4(saturate(ioR_DiffuseSSS)))*0;

	float metall = ioR_Metalness;
	vec4  sfColor = ioR_AlbedoColor;
	sfColor.xyz *= 1.0-metall;

#if D_RRenderPass == RP_DIFFUSE
	vec4 flatColor = vec4(pow(tColor.xyz, vec3(igamma)), ioPM.w); 
	FragColor = lerp(flatColor,flatColor*0.5,Freeze*FreezeMod);
	return;
#endif
	
	vec4 sfSpecular = vec4(pow(saturate(ioR_ReflectionColor.xyz), vec3(2.2)), ioR_ReflectionColor.w);
	sfSpecular.xyz = mix(sfSpecular.xyz, ioR_AlbedoColor.xyz, metall);

	float alpha = 1.0-ioR_Refraction;
	alpha *= alpha;
	vec4 RefractionColor = vec4(1.0-alpha);
	
	vec4 SpecularFace = sfSpecular*(1.0-alpha);
	vec4 SpecularEdge = ioR_SpecularEdgeColor;//mix(sfSpecular,vec4(1.0),vec4(ioGloss));
	vec4 ClearCoatFace = vec4(ioR_ClearCoat);
	vec4 ClearCoatEdge = mix(vec4(saturate(ioR_ClearCoat*10.0)),vec4(ioR_ClearCoat),ioR_ClearCoatRoughness);
	float CCPaintReplace = 0;
	float CCFresnelExponent = 5.0;
	float Microprotrusions = ioR_Microprotrusions;
	float MicroprotrusionsTint = 0;
	float Fuzz = 0;
	float ialpha = 0.0;
	float FuzzPaintReplace = 1;
	vec4 FuzzColor = vec4(0);
	float FuzzTint = 0;
	float SSS_Degree = max(max(max(ioR_DiffuseSSS, ioR_SubSurfaceColor.x), ioR_SubSurfaceColor.y), ioR_SubSurfaceColor.z)*0;//0.75;
	float LightIntensity = 0;//max(max(Emissive.x,Emissive.y),Emissive.z);//iEmissive;
	float EmissionGain = 1.0;
	float SpecFresnelExp = 5.0;
	float RefractionIOR = 1.4;
	float RefractionRoughness = ioR_RefractionBlur;
	

	float sLightIntensity = LightIntensity;
#ifdef VOLUME
	sLightIntensity = 0;
#endif		

	#if D_RRenderPass == RP_GLOSS
		FragColor = vec4(ioR_Gloss,ioR_Gloss,ioR_Gloss,1); 
		return;
	#endif

#ifndef PPP

//	vec3 ReflectionDir = normalize(ViewDir-2.0*Normal*dot(ViewDir,Normal));
//	Normal = normalize(Normal*WPanMatrix);
	vec3 NormalSSS =  normalize(oRawNormal*WPanMatrix);

#endif
#ifdef PPP

#ifdef VIEW_ALL
#endif
#ifdef VIEW_ENV
	FragColor = LightColor;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_COLOR
	FragColor = sfColor;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_RELIEF
	sfColor.xyz = vec3(0.5,0.5,0.5);
	sfSpecular.xyz = vec3(0.15,0.15,0.15);
	SSS_Degree = 0;
//	sfColor.w = 1;
	Emiss.xyz *= 0;
	ioR_Gloss = 0.5;
#endif
#ifdef VIEW_SPECULAR
	FragColor.xyz = vec3(ioR_Gloss);
	FragColor.w = sfColor.w;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_ROUGH
	FragColor.xyz = vec3(1.0-ioR_Gloss);
	FragColor.w = sfColor.w;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_SPCOLOR
	FragColor = sfSpecular;
	FragColor.w = sfColor.w;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif

#endif

	sfSpecular = sfSpecular*alpha;

//	float ioRoughness = 1.0 - ioGloss;
	float RoughnessFadeE = ioR_Roughness*ioR_Roughness;
	float GlossFadeE = ioR_Gloss*ioR_Gloss;

	float dotNV = saturate(abs(dot(Normal,ViewDir)));
	vec3 br = texture(tBRDF,vec2(dotNV,pow(ioR_Gloss,0.88))).xyz*1.5;

	float opp = 0.85-GlossFadeE*0.85+(1.0-GlossFadeE*GlossFadeE)*0.15;
	float r_uu = atan(ReflectionDir.z,ReflectionDir.x)/6.2831853;
	float r_as = asin(ReflectionDir.y);
	float r_vv = 0.5+r_as/3.1415926*(2048.0-pow(2.0,opp*7.0))/2048;	

	vec4 ReflectionColor = vec4(0,0,0,0);
	vec4 SSReflection = vec4(0.0, 0.0, 0.0, 0.0);

#ifdef ANISOTROPIC

	vec3 vDir0A = normalize(oVDir);
	float awxy=GlobalNormal.z*GlobalNormal.z;
	float awyz=GlobalNormal.x*GlobalNormal.x;
	float awzx=GlobalNormal.y*GlobalNormal.y;
	
	dN=vec3(anisoDir.x-0.5,0.5-anisoDir.y,0.0)*awxy;
	dN+=vec3(0.0,anisoDir.x-0.5,0.5-anisoDir.y)*awyz;
	dN+=vec3(0.5-anisoDir.y,0.0,anisoDir.x-0.5)*awzx;
	dN*=anisotropic;
	vec3 WorldAnisoNorm1=normalize(GlobalNormal+dN);
	vec3 WorldAnisoDirG1 = vDir0A - WorldAnisoNorm1 * dot(vDir0A, WorldAnisoNorm1) * 2.0;
	vec3 WorldAnisoDir1 = normalize(WorldAnisoDirG1*WPanMatrix);

	dN=vec3(anisoDirI.x-0.5,0.5-anisoDirI.y,0.0)*awxy;
	dN+=vec3(0.0,anisoDirI.x-0.5,0.5-anisoDirI.y)*awyz;
	dN+=vec3(0.5-anisoDirI.y,0.0,anisoDirI.x-0.5)*awzx;
	dN*=anisotropic;
	vec3 WorldAnisoNorm2=normalize(GlobalNormal+dN);
	vec3 WorldAnisoDirG2 = vDir0A - WorldAnisoNorm2 * dot(vDir0A, WorldAnisoNorm2) * 2.0;
	vec3 WorldAnisoDir2 = normalize(WorldAnisoDirG2*WPanMatrix);

	
	
	float AnisoSteps = lerp(2,16,GlossFadeE*anisotropic05);
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		for(float ai = 0; ai < AnisoSteps; ai+=1.0){
			vec3 cAnisoDir = lerp(WorldAnisoDir1, WorldAnisoDir2, ai/AnisoSteps);
			
	//		float dotNV = saturate(abs(dot(Normal,ViewDir)));
	//		vec3 br = texture(tBRDF,vec2(dotNV,pow(ioGloss,0.88)))*1.5;

			float aopp = 0.85-GlossFadeE*0.85+(1.0-GlossFadeE*GlossFadeE)*0.15;
			float auu = atan(cAnisoDir.z,cAnisoDir.x)/6.2831853;
			float aas = asin(cAnisoDir.y);
			float avv = 0.5+aas/3.1415926*(2048.0-pow(2.0,aopp*7.0))/2048;	

			vec4 ResReflectionColor = textureLod(Panorama, vec2(auu, avv), aopp * 7.0);	
			
			ResReflectionColor.xyz *= 5.0-ResReflectionColor.w*4.0;//extra light range from the texture alpha channel
			ResReflectionColor.xyz *= getmodf(ResReflectionColor.xyz);
			
			ReflectionColor += ResReflectionColor*(1.0-cos(ai/AnisoSteps*pi2));
		}
		#ifdef SHADOWS
		#ifdef SSREFLECTIONS
			if(iCurrentIteration % 4 == 3){
				SSReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), ioR_Roughness, 24.0+64.0*ioR_Gloss*ioR_Gloss, 1.0, 0.1+ioR_Roughness*0.5, ioR_Roughness);
				ReflectionColor.xyz = lerp(ReflectionColor.xyz, SSReflection.xyz, saturate(SSReflection.w))*4.0;
				SSReflection.xyz *= 4.0;
			} else ReflectionColor.xyz *= 0.0;
		#endif
		#endif
		ReflectionColor = ReflectionColor/AnisoSteps*(1.0-anisotropic);
	#endif

#else	
	
	//reflection
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		ReflectionColor = textureLod(Panorama, vec2(r_uu, r_vv), opp * 7.0);	
		
		ReflectionColor.xyz *= 5.0-ReflectionColor.w*4.0;//extra light range from the texture alpha channel
		ReflectionColor.xyz *= getmodf(ReflectionColor.xyz);
		ReflectionColor.xyz = ReflectionColor.xyz;
		#ifdef SHADOWS
				
			#ifdef SSREFLECTIONS
				if(iCurrentIteration % 4 == 3){
					SSReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), ioR_Roughness, 24.0+64.0*ioR_Gloss*ioR_Gloss, 1.0, 0.1+ioR_Roughness*0.5, ioR_Roughness);
					ReflectionColor.xyz = lerp(ReflectionColor.xyz, SSReflection.xyz, saturate(SSReflection.w))*4.0;
					SSReflection.xyz *= 4.0;
				} else ReflectionColor.xyz *= 0.0;
			#endif
		#endif		
	#endif
#endif
	vec4 ReflectionColor0 = ReflectionColor;

	vec3 DNormal = Normal;
//#ifdef USE_NORMALMAP_PPP
	DNormal = mix(DNormal, NormalSSS, SSS_Degree);
//#endif

	float d_uu = atan(Normal.z,Normal.x)/6.2831853;
	float d_vv=0.5+asin(Normal.y)/3.1415926*(64.0-0.5)/64.0;	
	vec4 DiffuseColor1=texture(PanoramaDiffuse,vec2(d_uu,d_vv));


	d_uu = atan(DNormal.z,DNormal.x)/6.2831853;
	d_vv=0.5+asin(DNormal.y)/3.1415926*(64.0-0.5)/64.0;	
	vec4 DiffuseColor2=texture(PanoramaDiffuse,vec2(d_uu,d_vv));


	//vv=0.5+asin(Normal.y)/3.1415926*(64.0-0.5)/64.0;	
	//vec4 DiffuseColor=textureLod(Panorama, vec4(uu, vv, 0, 7.0));	

	DiffuseColor1.xyz *= 2.0-DiffuseColor1.w;
	DiffuseColor1.xyz *= getmodf(DiffuseColor1.xyz);
	DiffuseColor1.xyz = pow(DiffuseColor1.xyz, vec3(gamma)) * br.z;
	
	DiffuseColor2.xyz *= 2.0-DiffuseColor2.w;
	DiffuseColor2.xyz *= getmodf(DiffuseColor2.xyz);
	DiffuseColor2.xyz = pow(DiffuseColor2.xyz, vec3(gamma)) * br.z;
	

	
	vec4 DiffuseColor = DiffuseColor2*iSSScolor+DiffuseColor1*(vec4(1)-iSSScolor);
	vec3 Diff = Normal.xyz;
	

	ReflectionColor.xyz *= sfSpecular.xyz*br.x + br.yyy * saturate(pow(sfSpecular.x+sfSpecular.y+sfSpecular.z, 0.3)*3.0);
	
#ifdef SHADOWS
	vec3 H = normalize(LightDir-oVDir); 
	
	
	//GGX BRDF
//	float GGXalpha = lerp(pow(ioRoughness, 3.0), pow(ioRoughness, 1.8), ioRoughness) * 0.99 + 0.01;//) * (ioRoughness * 0.99 + 0.01);   // roughness offset for glossy surfaces
	float GGXalpha = saturate(ioR_Roughness * ioR_Roughness+LightScatter*0.25) * 0.995 + 0.005;   // roughness offset for glossy surfaces
	
	float dotNL = saturate(dot(GlobalNormal,LightDir));
	float dotNH = saturate(dot(GlobalNormal,H));
	float dotLH = saturate(dot(LightDir,H));
	
	float F, D, vis;

	float alphaSqr = GGXalpha * GGXalpha;
	
	#ifdef ANISOTROPIC	
		float Specular = 0;
		for(float ai = 0; ai < AnisoSteps; ai+=1.0){
			vec3 cAnisoNorm = lerp(WorldAnisoNorm1, WorldAnisoNorm2, ai/AnisoSteps);
			float dotNLA = saturate(dot(cAnisoNorm,LightDir));
			float dotNHA = saturate(dot(cAnisoNorm,H));
			
			float denom = dotNHA * dotNHA *(alphaSqr-1.0) + 1.0f;
			D = alphaSqr/(pi * denom * denom);
		
			float k = GGXalpha/2.0f;
			vis = 1.0f/(dotNLA*(1.0f - k) + k) * 1.0f/(dotNV*(1.0f - k) + k);
		
			Specular += dotNLA * D  * vis*(1.0-cos(ai/AnisoSteps*pi2));
		}
		Specular /= AnisoSteps;
		Specular /= (1.0-anisotropic);
		Specular /= (0.75-ioR_Gloss/4.0);
		
	#else

		float denom = dotNH * dotNH *(alphaSqr-1.0) + 1.0f;
		D = alphaSqr/(pi * denom * denom);
		
		// V
		float k = GGXalpha/2.0f;
		vis = 1.0f/(dotNL*(1.0f - k) + k) * 1.0f/(dotNV*(1.0f - k) + k);
		
		float Specular = dotNL * D  * vis;	
	#endif
	//Burley12 BRDF
	float BurleyF = dotLH * RoughnessFadeE;
	float Diffuse = dotNL * (1.0f + BurleyF * pow(1.0f - dotNL, 5.0f)) * ((1.0f + BurleyF * pow(1.0f - dotNV, 5.0f))+0.5)/1.5;

//#ifdef USE_NORMALMAP
//	float SSSLambLNV = saturate(dot(GlobalNormal,LightDir));
//	Diffuse = lerp(Diffuse,SSSLambLNV,SSS_Degree);
//#endif	
	
	//shading
	//shading
	float shd = (1.0 - RefShade)*0.25;
	float mshd = 1.0-shd;
	vec3 d = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	
	
	vec4 SPos4 = vec4(oWorldPos,1.0);
	SPos4 = SPos4*ShadowTM;
	SPos4.y = 1.0 - SPos4.y;
	vec3 SPos = SPos4.xyz;

	float shadowBias = 0.05;	
	
	vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
	
	float shadowZDist = SPos.z-dot(m,d);
	
	float shiftToLight = 2.0;
	float shadowGradientFade = WShadowMapSize;
	float Multiplier = 0;//saturate(shiftToLight-(shadowZDist)*shadowGradientFade*2.0)*mshd + shd;
	
	float iCircleShift = -2.0;
	
	vec3 laZ = GlobalNormal;
	laZ = normalize(laZ);
	vec3 laX = cross(LightDir, laZ); 
	laX = normalize(laX);
	vec3 laY = cross(laZ, laX);
	
	float iShadowMulCnt = 0.0;
	if(CurrentIteration < 128){
		for(float iy = -3.0; iy < 3.5; iy+=1.0){
			float iCS = max(0.0, abs(iCircleShift)-1.0);
			for(float ix = -3.0+iCS; ix < 3.5-iCS; ix+=1.0){
				float iShadowScatter = 500.0*abs(shadowZDist)*LightScatter*(saturate(1.0-(0.0078125*CurrentIteration))+0.1);
				
				vec4 pxSSPos4 = vec4(oWorldPos.xyz, 1.0) * g_WorldViewProjectionMatrix; 
				vec4 v4Random = fract(abs(cos(vec4((CurrentIteration+ix+pxSSPos4.x)*1335.2212, (CurrentIteration+pxSSPos4.y+iy)*1540.3813, (CurrentIteration+pxSSPos4.z+iy)*5140.381, (CurrentIteration+pxSSPos4.z+ix)*1335.221)))*112.0)*2.0-vec4(1.0,1.0,1.0,1.0);

				v4Random.x = (v4Random.x+v4Random.z)*0.5;
				v4Random.y = (v4Random.y+v4Random.w)*0.5;
				
				float yToCamera = abs(0.0-v4Random.y)*0.4;
				vec4 SPos4 = vec4(oWorldPos+((GlobalNormal*v4Random.y)+(laX*v4Random.x*2.0))*iShadowScatter,1.0);
				SPos4 = SPos4*ShadowTM;
				SPos4.y = 1.0 - SPos4.y;
				vec3 SPos = SPos4.xyz;
				
				vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
				
				float iShadowMul = 1.0-max(abs(v4Random.x),abs(v4Random.y));
				iShadowMul = iShadowMul;
				iShadowMulCnt += iShadowMul;
				float shadowZ = dot(m,d);
				float iShadowZDist = SPos.z-shadowZ;
				float iMultiplier = saturate((abs(v4Random.x)*iShadowScatter*2.0)+shiftToLight+(shadowZ*yToCamera)-(iShadowZDist)*shadowGradientFade*2.0)*mshd + shd;
				Multiplier +=iMultiplier*iShadowMul;
			}
			iCircleShift+= 1.0;
		}
		Multiplier = pow(Multiplier/iShadowMulCnt,0.5);
	} else Multiplier = saturate(shiftToLight-(shadowZDist)*shadowGradientFade*2.0)*mshd + shd;
	
	float dc = Multiplier * saturate(dot(GlobalNormal,LightDir));
	float dcc=dc;//shd + dc*mshd;
	float diffuseFade = pow(dotNV,0.5/pi)*GlossFadeE+(1.0-GlossFadeE);

	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass <= RP_AO
		DiffuseColor.xyz = diffuseFade * Diffuse * Multiplier*mshd + vec3(shd,shd,shd);
		DiffuseColor.xyz = DiffuseColor.xyz;
		DiffuseColor.xyz *= getmodf(DiffuseColor.xyz);
		DiffuseColor.xyz = DiffuseColor.xyz;
		Diff = DiffuseColor.xyz;
	#endif	
	
	vec3 EnvTexture = ReflectionColor.xyz * (1-iIsExternalLight) * lightColor.xyz;

	#ifdef SSREFLECTIONS
		vec3 EnvSpec = 0.8*lerp(sfSpecular.xyz, vec3(1.0,1.0,1.0), pow(lerp(pow(ioR_Gloss,0.2), ioR_Gloss, ioR_Gloss)*(1.0-dotNV),pi*1.3)) * (Specular * Multiplier * lightColor.xyz+SSReflection.xyz*SSReflection.w);// * (1-IsExternalLight);
	#else
		vec3 EnvSpec = 0.8*lerp(sfSpecular.xyz, vec3(1.0,1.0,1.0), pow(lerp(pow(ioR_Gloss,0.2), ioR_Gloss, ioR_Gloss)*(1.0-dotNV),pi*1.3)) * Specular * Multiplier * lightColor.xyz;// * (1-IsExternalLight);
	#endif	
	
	float EnvLerp = saturate((ioR_Roughness * 5.0f)-2.0f);
	
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		ReflectionColor.xyz = lerp(EnvTexture , EnvSpec , max(EnvLerp, iIsExternalLight))*alpha;
	#endif
#endif

#if D_RRenderPass == RP_LIGHT
	FragColor = vec4(lightColor.xyz,1.0);
#endif
#if D_RRenderPass <= RP_LIGHT
	DiffuseColor.xyz *= lightColor.xyz;
#endif
#if D_RRenderPass < RP_TRANSLUCENT
	#ifdef SSGI
	#ifdef SHADOWS
		if(iCurrentIteration % 2 == 1){
			vec4 IndirectLight = ScreenSpaceRayTrace(oWorldPos.xyz, GlobalNormal.xyz, 1.0, 16.0, 1.0, 1.0, ioR_Roughness);
			DiffuseColor.xyz += IndirectLight.xyz*IndirectLight.w*SecondLightIntensity*0.01;
//		}
	#endif
	#endif
#endif
#if D_RRenderPass < RP_TRANSLUCENT
	DiffuseColor.xyz *= sfColor.xyz;
#endif

#ifdef SHADOWS
	float iTranslucence = Translucence;
	#ifdef VOLUME	
		float VolSSSDens = max(max(1.0-transparentColor.x, 1.0-transparentColor.y), 1.0-transparentColor.z)*densityFloat;
		iTranslucence = 1.5-VolSSSDens;
		iSSScolor.xyz = transparentColor.xyz*vec3(VolSSSDens);
		DiffuseColor.xyz *= vec3(1.0-abs(anisotropy));
	#endif		
	#ifdef USE_SSSHADOW	
		//SSS
		#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_TRANSLUCENT
			float InvLambLightNV = saturate(dot(-GlobalNormal,LightDir));
			float SSSe = pow(saturate(1.0-(SPos.z-dot(m,d))*(1.0 - iTranslucence) * 100.0),3.0);
			vec3 SSS = vec3(SSSe);
			SSS = lerp(iSSScolor.xyz*sfColor.xyz, sfColor.xyz, max(pow(SSS,vec3(5,5,5)),pow(saturate(0.5-InvLambLightNV), 1.5))) * SSS*lightColor.xyz;
			SSS = lerp(DiffuseColor.xyz, SSS, (InvLambLightNV/2.0+0.5));
			#if D_RRenderPass == RP_TRANSLUCENT
				DiffuseColor.xyz = SSS - DiffuseColor.xyz;
			#else 
				DiffuseColor.xyz = SSS;	  //activation SSS
			#endif	
		#endif	
	#else	
		#if D_RRenderPass == RP_TRANSLUCENT
			DiffuseColor.xyz = vec3(0,0,0);
		#endif
	#endif
	
#endif

#if D_RRenderPass == RP_AO
	DiffuseColor.xyz *= 2.0;
#endif
#if D_RRenderPass > RP_AO
	DiffuseColor.xyz = vec3(0,0,0);
#endif

color.xyz = DiffuseColor.xyz + ReflectionColor.xyz;

#if D_RRenderPass == RP_EMMISIVE
	FragColor = vec4(Emiss.x, Emiss.y, Emiss.z, 1.0); 
	return;
#endif

#ifdef VOLUME	
	Emiss.xyz = ioR_AlbedoColor.xyz*emitColor.xyz;	
#endif
	
	/////////
///// EXT ///////
/////////////	


#ifdef SHADOWS
	float fInLight = saturate(2.0-(SPos.z-dot(m,d))*400);
#endif
	
	
////// REFRACTION ////////////////
#ifdef REFRACTION
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFRACTION
	float rrE = 1.0-pow((1.0-dotNV), SpecFresnelExp)*ioR_Gloss;

		
	vec3 RefractionDir = refract(normalize(ViewDir), normalize(Normal), 1.0-RefractionIOR);
	ReflectionDir = normalize(RefractionDir*WPanMatrix);

	float rrGloss = 1.0-RefractionRoughness;
	float rrGlossFadeE = rrGloss*rrGloss;
	float rropp = 0.85-rrGlossFadeE*0.85+(1.0-rrGlossFadeE*rrGlossFadeE)*0.15;
	
	float rruu = atan(RefractionDir.z,RefractionDir.x)/pi2;
	float rras = asin(RefractionDir.y);
	float rrvv = 0.5+rras/pi*(2048.0-pow(2.0,rropp*7.0))/2048;

	
	
	
	vec4 RefractionColorP = textureLod(Panorama, vec2(rruu, rrvv), rropp * 7.0);	
	RefractionColorP.xyz *= 5.0-RefractionColorP.w*4.0;//extra light range from the texture alpha channel
	RefractionColorP.xyz *= getmodf(RefractionColorP.xyz);
	RefractionColorP.xyz = RefractionColorP.xyz;

	
	vec3 iRefractionColor = RefractionColor.xyz*pow(1.0-alpha,0.5);
	vec3 RREnergyComp = 1.0-iRefractionColor;
#ifdef SHADOWS
/*
////////////////////////////////////////
	float ccRoughness = 1.0-ccGloss;
	float ccGGXalpha = lerp(pow(ccRoughness, 3.0), pow(ccRoughness, 1.8), ccRoughness) * 0.99 + 0.01;

	float ccalphaSqr = ccGGXalpha * ccGGXalpha;

	float ccdenom = dotNH * dotNH *(ccalphaSqr-1.0) + 1.0f;
	float ccD = ccalphaSqr/(pi * ccdenom * ccdenom);
	
	// V
	float cck = ccGGXalpha/2.0f;
	float ccvis = 1.0f/(dotNL*(1.0f - cck) + cck) * 1.0f/(dotNV*(1.0f - cck) + cck);
	
	float ccSpecular = dotNL * ccD  * ccvis;	

////////////////////////////////////////
	ccReflectionColor.xyz = ccReflectionColor.xyz * fInLight * lightColor.xyz * (1-IsExternalLight);
	float ccEnvLerp = saturate(-5.0f + (ccRoughness * 20.0f));
	ccReflectionColor.xyz = lerp(ccReflectionColor.xyz , ccSpecular * Multiplier * lightColor.xyz, max(ccEnvLerp, IsExternalLight));
	*/
#endif
	color.xyz = color.xyz*RREnergyComp+RefractionColorP.xyz*iRefractionColor*rrE;
#endif	
#endif	



/////// Reflection		
	
//	uu = atan(ReflectionDir.z,ReflectionDir.x)/pi2;
//	as = asin(ReflectionDir.y);
//	vv = 0.5+as/pi*(2048.0-pow(2.0,opp*7.0))/2048;	
	
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
	
////// ARTISTIC ////////////////////	
	vec3 gSpecularFace = SpecularFace.xyz;
	vec3 gSpecularEdge = SpecularEdge.xyz;
	
	vec3 spReflectionColor = ReflectionColor0.xyz;
	
	float SpecularE = 1.0;
	float spE = pow((1.0-dotNV)*SpecularE, SpecFresnelExp)*ioR_Gloss;

	vec3 iSpecularColor = lerp(gSpecularFace.xyz, gSpecularEdge.xyz, spE)*SpecularE;
//	SpecularColor = SpecularColor;
	vec3 spEnergyComp = (1.0-gSpecularFace);
#ifdef SHADOWS

	EnvLerp = saturate(-7.0f + (ioR_Roughness * 20.0f));
	spReflectionColor = lerp(spReflectionColor * fInLight * lightColor.xyz * (1-iIsExternalLight) , Specular * Multiplier * lightColor.xyz+SSReflection.xyz*SSReflection.w, max(EnvLerp, iIsExternalLight));

#endif
	color.xyz = color.xyz*spEnergyComp+spReflectionColor.xyz*iSpecularColor;
#endif


////// CLEAR COAT ////////////////
#ifdef CLEAR_COAT
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_CLEAR_COAT


		vec3 gClearCoatFace = ClearCoatFace.xyz;
		vec3 gClearCoatEdge = ClearCoatEdge.xyz;

		float ccGloss = 1.0-ioR_ClearCoatRoughness;
		float ccRoughness = 1.0-ccGloss;
		float ccGlossFadeE = ccGloss*ccGloss;
		float ccopp = 0.85-ccGlossFadeE*0.85+(1.0-ccGlossFadeE*ccGlossFadeE)*0.15;
		
		vec4 ccReflectionColor = textureLod(Panorama, vec2(r_uu, r_vv), ccopp * 7.0);	

		ccReflectionColor.xyz *= 5.0-ccReflectionColor.w*4.0;//extra light range from the texture alpha channel
		ccReflectionColor.xyz *= getmodf(ccReflectionColor.xyz);
		#ifdef SSREFLECTIONS
			#ifdef SHADOWS
				vec4 SSCCReflection = vec4(0.0, 0.0, 0.0, 0.0);
				if(iCurrentIteration % 4 == 1){
					SSCCReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), ccRoughness, 24.0+64.0*ccGloss*ccGloss, 1.0, 0.1+ccRoughness*0.5, ioR_Roughness);
					ccReflectionColor.xyz = lerp(ccReflectionColor.xyz, SSCCReflection.xyz, saturate(SSReflection.w))*4.0;
					SSCCReflection.xyz *= 4.0;
				} else ccReflectionColor.xyz *= 0.0;
			#endif
		#endif

		
		float ClearCoatE = lerp(1, ialpha, CCPaintReplace);
		float ccE = pow((1.0-dotNV)*ClearCoatE, CCFresnelExponent)*ccGloss;

		vec3 ClearCoatColor = lerp(gClearCoatFace.xyz, gClearCoatEdge.xyz, ccE)*ClearCoatE;
		vec3 CCEnergyComp = 1.0-ClearCoatColor;
		#ifdef SHADOWS

			////////////////////////////////////////
			//	float ccGGXalpha = lerp(pow(ccRoughness, 3.0), pow(ccRoughness, 1.8), ccRoughness) * 0.99 + 0.01;
			float ccGGXalpha = saturate(ccRoughness * ccRoughness+LightScatter*0.2) * 0.995 + 0.005;   // roughness offset for glossy surfaces

			float ccalphaSqr = ccGGXalpha * ccGGXalpha;

			float ccdenom = dotNH * dotNH *(ccalphaSqr-1.0) + 1.0f;
			float ccD = ccalphaSqr/(pi * ccdenom * ccdenom);
			
			// V
			float cck = ccGGXalpha/2.0f;
			float ccvis = 1.0f/(dotNL*(1.0f - cck) + cck) * 1.0f/(dotNV*(1.0f - cck) + cck);
			
			float ccSpecular = dotNL * ccD  * ccvis;	

			////////////////////////////////////////
			ccReflectionColor.xyz = ccReflectionColor.xyz * fInLight * lightColor.xyz * (1-iIsExternalLight);
			float ccEnvLerp = saturate(-5.0f + (ccRoughness * 20.0f));
			ccReflectionColor.xyz = lerp(ccReflectionColor.xyz , ccSpecular * Multiplier * lightColor.xyz, max(ccEnvLerp, iIsExternalLight));
			
			#ifdef SSREFLECTIONS
					ccReflectionColor.xyz += SSReflection.xyz*SSReflection.w;
			#endif	
			
		#endif
		color.xyz = color.xyz*CCEnergyComp+ccReflectionColor.xyz*ClearCoatColor.xyz;
	#endif	
#endif	


////// MICROPROTRUSIONS ///////////
#ifdef MICROPROTRUSIONS
#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_MICROPROTRUSIONS && D_RRenderPass <= RP_MICROPROTRUSIONS_LIGHT)
	float exPI = 3.1415926;
	float exPI2 = 6.2831853;

	vec3 FurNormal = Normal+ViewDir * dot(ViewDir, Normal) * 2.0;
	FurNormal = normalize(FurNormal*WPanMatrix);
	
	float MicroprotrusionsAm = Microprotrusions/100.0/**Microprotrusions_Modulator.w*/;
	float MicroprotrusionsAmExPI = pow(MicroprotrusionsAm, exPI);
	float MicroprotrusionsE = lerp(saturate(1.0-pow(dotNV,MicroprotrusionsAm*exPI)), 1.0, MicroprotrusionsAmExPI);
	#if D_RRenderPass == RP_MICROPROTRUSIONS_MASK
		FragColor = vec4(MicroprotrusionsE, MicroprotrusionsE, MicroprotrusionsE, 1.0);
		return;
	#endif
	vec4 rMicroprotrusionsColor;
	rMicroprotrusionsColor.xyz = lerp(ioR_MicroprotrusionsColor.xyz, ioR_AlbedoColor.xyz,MicroprotrusionsTint);
	vec3 McN = normalize(FurNormal);//*(1.0-dotNV));
	McN = normalize((McN*1.5+ViewDir*(1.0-dotNV)));
#ifdef SHADOWS
	vec3 SMcN = normalize((GlobalNormal+(oVDir+dN)*(1.0-dotNV)));

	float LambLightNVMP = max(0.0,dot(GlobalNormal,LightDir));
	float MLightNV = 1.0-(dot(SMcN,LightDir)*dot(GlobalNormal,LightDir));
	vec4 MGlobalIllumination = DiffuseColor*rMicroprotrusionsColor*(1.0-MicroprotrusionsAmExPI)+(rMicroprotrusionsColor+rMicroprotrusionsColor*lightColor*rMicroprotrusionsColor*MicroprotrusionsAmExPI)*LambLightNVMP/2.0;
	rMicroprotrusionsColor = (rMicroprotrusionsColor*MLightNV*lightColor+MGlobalIllumination)*fInLight*LambLightNVMP;
#else
	float m_uu = atan(GlobalNormal.z,GlobalNormal.x)/exPI2;
	float m_vv=0.5+asin(GlobalNormal.y)/exPI*(64.0-0.5)/64.0;	
	vec4 MicroprotrusionsLambColor=texture(PanoramaDiffuse,vec2(m_uu,m_vv));
	
	m_uu = atan(McN.z,McN.x)/exPI2;
	m_vv=0.5+asin(McN.y)/exPI*(64.0-0.5)/64.0;	
	vec4 MicroprotrusionsLColor=texture(PanoramaDiffuse,vec2(m_uu,m_vv));
	vec4 MGlobalIllumination = DiffuseColor*rMicroprotrusionsColor+rMicroprotrusionsColor*MicroprotrusionsLambColor*rMicroprotrusionsColor*MicroprotrusionsAm;
	rMicroprotrusionsColor = rMicroprotrusionsColor*MicroprotrusionsLColor/1.2+MGlobalIllumination;
#endif
	#if D_RRenderPass == RP_MICROPROTRUSIONS_LIGHT
		FragColor = vec4(rMicroprotrusionsColor.x, rMicroprotrusionsColor.y, rMicroprotrusionsColor.z, 4.0)/4.0; 
		return;
	#endif
	color.xyz = lerp(color.xyz, rMicroprotrusionsColor.xyz, MicroprotrusionsE);
#endif
#endif

//////////////////////////////////


////// Fuzz ///////////
#ifdef FUZZ
#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_FUZZ && D_RRenderPass <= RP_FUZZ_LIGHT)
	float FuzzAm = Fuzz/20.0;
	float FuzzE = saturate(max(1.0-pow(dotNV,FuzzAm),FuzzAm/pi));
	FuzzE = FuzzE*lerp(1, ialpha, FuzzPaintReplace);
	#if D_RRenderPass == RP_FUZZ_MASK
		FragColor = vec4(FuzzE, FuzzE, FuzzE, 0.25)*4.0; 
		return;
	#endif
	vec3 rFuzzColor = FuzzColor.xyz;
	rFuzzColor = lerp(rFuzzColor, rFuzzColor*color.xyz, FuzzTint);
#ifdef SHADOWS
	float LambLightNV = max(0.0,dot(GlobalNormal,LightDir));
	rFuzzColor = rFuzzColor*(pow(fInLight, 1.0-LambLightNV)*pow(LambLightNV,0.5))*lightColor.xyz;
#else
	float f_uu = atan(GlobalNormal.z,GlobalNormal.x)/pi2;
	float f_vv=0.5+asin(GlobalNormal.y)/pi*(64.0-0.5)/64.0;	
	vec3 FuzzLColor=texture(PanoramaDiffuse,vec2(f_uu,f_vv)).xyz;
	rFuzzColor = rFuzzColor*FuzzLColor;
#endif
	#if D_RRenderPass == RP_FUZZ_LIGHT
		FragColor = vec4(rFuzzColor.x, rFuzzColor.y, rFuzzColor.z, 8.0)/8.0; 
		return;
	#endif
	color.xyz = lerp(color.xyz, rFuzzColor, FuzzE);
#endif

#endif
	
////// OPACITY /////////	

	color.xyz  = color.xyz + Emiss;	
// FOG	
#ifdef IS_VOXEL_SHADER
	float Wde = saturate(pow((1.0/oExtra.w)*pow(WFogDensity/10000.0,2.0),WFogPower));
	
	#if D_RRenderPass == RP_DEPTH
		FragColor = vec4(Wde, Wde, Wde, 1.0); 
		return;
	#endif

#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_FOG && D_RRenderPass <= RP_FOG_LIGHT)
	
   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette*Wde)).xyz;
   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette/50.0-1.0)).xyz;

#ifdef SHADOWS	



	color.xyz = lerp(color.xyz,vec3(Multiplier,Multiplier,Multiplier),WLightSilhouette/100.0).xyz;

	// FOG
#ifdef SPOS_IN_PIXEL_SHADER
#ifdef D_WFogDensity
	#ifdef D_WVolumeFogSamples


#define FOG_STEPS 32
		vec3 WOldSVPos = SPos.xyz;
		float WOldFogWde = pow((1.0/oExtra.w)*(WFogDensity/10000.0,2.0),WFogPower);
		float WFogWde = 0;
		float WFogStep = 1.0/FOG_STEPS;
		float WFogLerpPos = 0.0;
		float VSWdeDeltaSum = 0.0;
		float VSWdeDeltaWOShadowSum = 0.0;
//		int iWVolumeFogSamples = max(3,WVolumeFogSamples);
		
		vec3 WFogVolumeColorResult = vec3(0,0,0);
		
		
		for(int iVSS = 0; iVSS < FOG_STEPS; iVSS++){
			WFogLerpPos += WFogStep;
			float WFogLerpPosRand = WFogLerpPos-(WFogStep*WFogRand);
			
			vec4 zP = vec4(lerp(oPos.xyz , g_LocalViewPos.xyz,WFogLerpPos), 1.0);
			vec4 zPC = zP * g_WorldViewProjectionMatrix;
			vec4 zExtra = vec4(0,0,0,0);
			zExtra.yz =  (1.0 + zPC.xy / zPC.w ) / 2.0;
			zExtra.z = (1.0 - zExtra.z);
			zExtra.yz += vec2(du/2,dv/2);
			zExtra.w=1.0/zPC.w;//In.Color2.x;
		
			float VSWde = pow((1.0/lerp(oExtra.w, 1.0, WFogLerpPosRand))*(WFogDensity/10000.0,2.0),WFogPower);
			float VSWdeDelta = saturate(WOldFogWde-VSWde);
				
			vec4 SPos4VS = vec4(lerp(oWorldPos.xyz, g_LocalViewPos.xyz, WFogLerpPosRand),1.0);
			SPos4VS = SPos4VS * ShadowTM;
			SPos4VS.xy += vec2(0.5/ShadowMapSide,0.5/ShadowMapSide);
			SPos4VS.y = 1.0 - SPos4VS.y;

			vec3 dVS = vec3(1.0,1.0/255.0,1.0/255.0/255.0);

			vec3 VSPos = SPos4VS.xyz;
			vec3 mVS = texture(ShadowSampler,VSPos.xy).xyz;	
				
			float MultiplierVS = saturate(2.0-(VSPos.z-dot(mVS,dVS)-shadowBias)*WShadowMapSize*2.0);
			WFogVolumeColorResult += WFogColor.zyx*lightColor.xyz*MultiplierVS*VSWdeDelta;
			WOldFogWde = VSWde;
			VSWdeDeltaSum += VSWdeDelta;
			VSWdeDeltaWOShadowSum += VSWdeDelta*MultiplierVS;
		}
		
		float fogMask = saturate(min(Wde, Wde*pow(VSWdeDeltaWOShadowSum/VSWdeDeltaSum, max(0.1,WFogShadows-1.0))));
		vec3 fogLight = WFogVolumeColorResult/VSWdeDeltaSum;
		color.xyz = lerp(color.xyz,lerp(WFogColor.zyx*lightColor.xyz, fogLight, min(1.0, WFogShadows)), fogMask).xyz;
		
		#if D_RRenderPass == RP_FOG_LIGHT 
			FragColor = saturate(vec4(fogLight.x/2.0, fogLight.y/2.0, fogLight.z/2.0, 1.0)); 
			return;
		#endif
		
		#if D_RRenderPass == RP_FOG_MASK
			FragColor = saturate(vec4(fogMask,fogMask,fogMask,1)*2.0); 
			return;
		#endif	
		
	#else
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif	
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx,Wde).xyz;
	#endif
#endif	
#endif			
#endif			
//// RR END ///

	vec3 ResColor = color.xyz;
	if(UseACES > 0.0){
#ifdef AOASS
		ResColor.xyz =  pow(color.xyz*LDiffuse22C,vec3(igamma));
		ResColor.y*=10;
#else
		ResColor.xyz =  pow(ndAcesTonemap(color.xyz*LDiffuse22C),vec3(igamma));
#endif
	} else {
		ResColor.xyz =  pow(color.xyz*LDiffuse22C,vec3(igamma));//+saturate(pow(1.0-dotNV,20.0)*15.0);
	}
	color.xyz = lerp(ResColor,ResColor*0.5,Freeze*FreezeMod);//+saturate(pow(1.0-dotNV,20.0)*15.0);
	color.w = mix(sfColor.w, max(sfColor.w*sfColor.w*sfColor.w, 1.0-dotNV), ioR_Gloss)*saturate(1.0-(1.0-sfColor.w)*(1.0-sfColor.w)*(1.0-sfColor.w));

#ifdef VOLUME	
	float rVolumeDens = max(max(1.0-transparentColor.x, 1.0-transparentColor.y), 1.0-transparentColor.z)*densityFloat;
	color.w = color.w*pow(dotNV, max(0.1, 2.0-rVolumeDens*2.5))*pow(rVolumeDens, 0.15);
#endif
	
#ifdef SHADOWS
#ifndef DEFERRED
	if(fract(CurrentIteration * 0.1) < (1.0-color.w * color.w)) {
		discard;
	}
	
	color.w = 1.0;
#endif	
#endif
}
