layout(triangles, fractional_odd_spacing, ccw) in;


 in vec4 toPos[];
 in vec3 toN[];
 in vec4 toC[];
 in vec4 toC2[];
 in vec3 toWorldPos[];
 in vec4 toExtra[];
 in vec3 toVDir[];
 in vec3 toMPos[];
 in vec3 toRawPos[];
 in vec3 toRawNormal[];

 in vec3 B210[];
 in vec3 B120[];
 in vec3 B021[];
 in vec3 B012[];
 in vec3 B102[];	
 in vec3 B201[];	

 in vec3 B111[];

 in vec3 N110[];
 in vec3 N011[];
 in vec3 N101[];

 out vec4 oPos;
 out vec3 oN;
 out vec4 oC;
 out vec4 oC2;
 out vec3 oWorldPos;
 out vec4 oExtra;
 out vec3 oVDir;
 out vec3 oMPos;
 out vec3 oRawPos;
 out vec3 oRawNormal;


uniform float WFogDensity;
uniform float WFogShadows;
uniform float WFogPower;
uniform vec4 WFogColor;
uniform float WVolumeFogSamples;
uniform float WLightSilhouette;
uniform float WSilhouette;
uniform float WShadowMapSize;
uniform float WFogRand;

uniform float NGScale;
uniform float RRenderPass;
uniform float du;
uniform float dv;

uniform sampler2D tBRDF;
uniform sampler2D PanoramaDiffuse;
uniform float Metalness;
uniform float ExtraGloss;
uniform float BasePlasticReflection;
uniform float MaxPlasticReflection;
uniform float PaintOpacity;
uniform float LightContrast;
uniform float IsExternalLight;
uniform vec3 ExtraGamma;
uniform vec4 LightColor2g;
uniform vec4 SSScolor;
uniform float Translucence;
uniform float FreezeMod;
uniform float Inverse;
#define GlobalViewDir (-oVDir)
#ifdef BAS_RELIEF
uniform vec3 BasReliefDir;
uniform vec3 BasReliefBase;
uniform float TaperingAngle;
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_LocalViewPos;
uniform vec4 Sphere;
uniform mat4 ShadowTM;
uniform float OverallScale;
uniform float ShadowStep;
uniform float ShadowMapSide;
uniform float Extrusion;

#ifdef USE_DEPTH
uniform float du;
uniform float dv;
#endif

uniform vec3 MousePos;
uniform float TimeSeconds;
uniform float CurrentIteration;
uniform vec3 LightDir;


#define BC4(aP) (aP[0] * gl_TessCoord.x + aP[1] * gl_TessCoord.y + aP[2] * gl_TessCoord.z)

#define BC3(aP) (aP[0] * gl_TessCoord.x + aP[1] * gl_TessCoord.y + aP[2] * gl_TessCoord.z) 
	

vec4 smPos()
{
	// The barycentric coordinates
	float u = gl_TessCoord.y;
	float v = gl_TessCoord.z;
	float w = gl_TessCoord.x;
	// Precompute squares and squares * 3 
	float uu = u * u;
	float vv = v * v;
	float ww = w * w;
	float uu3 = uu * 3.0f;
	float vv3 = vv * 3.0f;
	float ww3 = ww * 3.0f;
	// Compute position from cubic control points and barycentric coords
	vec3 position = toPos[0].xyz * ww * w +
	toPos[1].xyz * uu * u +
	toPos[2].xyz * vv * v +
	B210[0] * ww3 * u +
	B120[0] * w * uu3 +
	B201[0] * ww3 * v +
	B021[0] * uu3 * v +
	B102[0] * w * vv3 +
	B012[0] * u * vv3 +
	B111[0] * 6.0f * w * u * v;
	
	
	return vec4(position,1.0f);
}

vec3 smNorm()
{
	// The barycentric coordinates
	float u = gl_TessCoord.y;
	float v = gl_TessCoord.z;
	float w = gl_TessCoord.x;
	// Precompute squares and squares * 3 
	float uu = u * u;
	float vv = v * v;
	float ww = w * w;
	vec3 normal = toN[0] * ww +
	toN[1] * uu +
	toN[2] * vv +
	N110[0] * w * u +
	N011[0] * u * v +
	N101[0] * w * v;
	normal = normalize(normal+BC3(toN)*2.0);
	return normal;
}

void main()
{
	
	 oPos = smPos();//BC4(toPos);
	 oN = BC3(toN);//smNorm();
	 oC = BC4(toC);
	 oC2 = BC4(toC2);
	 oWorldPos = BC3(toWorldPos);
	 oExtra = BC4(toExtra);
	 oVDir = BC3(toVDir);
	 oMPos = BC3(toMPos);
	 oRawPos = BC3(toRawPos);
	 oRawNormal = BC3(toRawNormal);

	vec4 P = vec4(oRawPos, 1.0);

#ifdef NODE_CODE
	vec3 tColor = oC.xyz;
	vec3 tSpecular = oC2.xyz;
	float Gloss = oC2.w;
	vec3 Emiss = oC2.xyz;
	vec3 sfColor = oC2.xyz;
	
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);                 // shader playback time (in seconds)
	ioMouse = vec4(MousePos.x, MousePos.y, MousePos.z, 0.0);            // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oMPos.xyz, 0.0);
	ioUV = ioFragCoord;
	ioNormal = vec4(oRawNormal, 0.0);

	ioFragCoord_DX = vec4(0);
	ioUV_DX = vec4(0);
	ioNormal_DX = vec4(0);
	ioPosition_DX = vec4(0);

	ioFragCoord_DY = vec4(0);
	ioUV_DY = vec4(0);
	ioNormal_DY = vec4(0);
	ioPosition_DY = vec4(0);

//	ioAlbedoColor = oC;
//	ioReflectionColor = Color2;
//	ioGloss = vec4One * Color2.x;
//	ioEmissive = Color2;
//	ioOpacity = vec4One * Color.w;
	
	ioDisplacement = 0;
	
	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4(g_LocalViewPos.xyz, 0.0);
	ioIteration = vec4One * CurrentIteration;
	
	vec3 t; 	
	vec3 c1 = cross(-oN, vec3(0.0, 0.0, 1.0)); 
	vec3 c2 = cross(-oN, vec3(0.0, 1.0, 0.0)); 
	if (length(c1) > length(c2))
	  t = c1;	
	else
	  t = c2;	
	t = normalize(t);
	
/*	
	vec3 z = normalize(-oN);
	vec3 x = normalize(cross(t, z)); 
	vec3 y = normalize(cross(z, x));
	{
		ioPosition = P+vec4(x, 0.0)*0.001*NGScale;
		ioFragCoord = ioPosition*0.005/(OverallScale+0.001);
		ioUV = ioFragCoord;
		NODE_CODE;
		ioPosition+=ioNormal*ioDisplacement*NGScale;
	}
	vec3 iPosNormalBufX = ioPosition.xyz;
	{
		ioPosition = P*NGScale+vec4(y, 0.0)*0.001;
		ioFragCoord = ioPosition*0.005/(OverallScale+0.001);
		ioUV = ioFragCoord;
		NODE_CODE;	
		ioPosition+=ioNormal*ioDisplacement*NGScale;
	}
	vec3 iPosNormalBufY = ioPosition.xyz;*/
	{
		ioPosition = P*NGScale;
		ioFragCoord = ioPosition*0.005/(OverallScale+0.001);
		ioUV = ioFragCoord;
		NODE_CODE;	
		ioPosition+=ioNormal*ioDisplacement*NGScale;
		
		//vec3 iz = normalize(iPosNormalBufY-ioPosition.xyz);
		//vec3 ix = cross(normalize(iPosNormalBufX-ioPosition.xyz), iz); 
		//oN = normalize(-ix);//normalize(ioPosition.xyz-iPosNormalBuf.xyz);
	}
	
	oPos = vec4(ioPosition.xyz/NGScale, P.w);
	
#endif	


	gl_Position  = oPos*g_WorldViewProjectionMatrix;
}
