/////////////////////////////////////////////////////////////
// Gloss          - glossness of the pixe
// PANORAMA SPACE VECTORS:
// Normal         - normal in panorama space
// ViewDir        - view direction  in panorama space
// ReflectionDir  - reflection direction in panorama space
//
// WORLD SPACE VECTORS
//
// GlobalNormal   - normal in world space
// LightDir       - light direction in world space
// GlobalViewDir  - view direction in world space
//
// OTHER STUFF:
//
// Freeze	  - freeze value
// Opacity        - texture opacity
// Emissive       - emissive
// Panorama       - environment sampler
//
// COLORS:
//
// LDiffuse22C    - gamma corrected light color
// LightColor2g   - gamma corrected color, (1,1,1) for panorama and (r,g,b) for colored light
// NOT GAMMA CORRECTED:
// sfSpecular.xyz - specular color
// sfColor.xyz    - texture color
// Checker        - checker (selection) color
// color          - resulting color
// IsExternalLight - 0 for panorama and 1 for extern lights
/////////////////////////////////////////////////////////////
#define RP_COMPOSITE 0
#define RP_DIFFUSE 1
#define RP_TRANSLUCENT 2
#define RP_LIGHT 3
#define RP_AO 4
#define RP_DEPTH 5
#define RP_REFLECTION 6
#define RP_REFRACTION 7
#define RP_CLEAR_COAT 8
#define RP_GLOSS 9
#define RP_FOG 10
#define RP_FOG_MASK 11
#define RP_FOG_LIGHT 12
#define RP_EMMISIVE 13
#define RP_FUZZ 14
#define RP_FUZZ_MASK 15
#define RP_FUZZ_LIGHT 16
#define RP_MICROPROTRUSIONS 17
#define RP_MICROPROTRUSIONS_MASK 18
#define RP_MICROPROTRUSIONS_LIGHT 19

float Occlusion = clamp(Emissive*2.0, 0.0, 1.0);
float SpecOcclusion = Occlusion*Occlusion*Occlusion;

Emissive = clamp(Emissive*2.0-1.0, 0.0, 1.0);

#ifndef PBM_VARS

	vec4 ioPM;
	vec4 ioPQ1;
	vec4 ioPQ2;
	vec4 ioPQ3;
	vec4 ioPQ4;
	vec4 ioPN;
	float ioDisplacement;
	vec4 ioNormal;
	vec4 ioPosition;
	vec4 ioGlobalNormal;
	vec4 ioGlobalPosition;
#endif

// Error under macOS:
// ERROR: 0:xxx: '' : syntax error: incorrect preprocessor directive
// ERROR: 0:xxx: '' : syntax error: unexpected tokens following #if preprocessor directive - expected a newline
// Reason: "D_RRenderPass" is undefined. It should be replaced by preprocessor into some value.
#ifndef D_RRenderPass
#define D_RRenderPass 0
#endif

	const vec3 gamma = vec3(2.2); 
	const vec3 igamma = vec3(1.0/2.2); 

#ifdef PROCEDURAL_ENV

	float LCuu = atan(LightDir.z,LightDir.x)/(3.1415926*2.0);
	float LCas = asin(LightDir.y);
	float LCvv = 0.5+LCas/3.14159;	
	
	vec4 LightColor = texture(Panorama, vec2(LCuu, LCvv));	
	LightColor.xyz *= 5.0-LightColor.w*4.0;//extra light range from the texture alpha channel
//	LightColor.xyz *= getmodf(LightColor.xyz);
//	LightColor.xyz = pow(LightColor.xyz,vec3(gamma));


#endif


	int iCurrentIteration = int(CurrentIteration);

vec3 lightColor = mix(LightColor.xyz, LightColor2g.xyz,IsExternalLight);


#ifdef FragColor
#ifndef TC_DEFINED
	vec3 tColor = sfColor.xyz;
	vec3 tSpecular = sfSpecular.xyz;
#endif
#else
#ifndef TC_DEFINED
	vec3 tColor = pow(sfColor.xyz,gamma);
	vec3 tSpecular = pow(sfSpecular.xyz,gamma);
#endif
#endif
	vec3 Emiss = tColor.xyz * Emissive;

	////////////////////////////////////////////////
	ioPM = vec4(defAlbedo*0.5, sfColor.w);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(0.05, 0.05, 0.05, 0.0);
	ioPQ3 = vec4(Emiss, 0.0)*0.5;
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, defMetall*0.5+0.5, Gloss*0.5+0.5);
	ioDisplacement = 0;
#ifdef MC_COVER
	ioDisplacement = nrm.z;
	ioPN.y = Gloss;
	ioPN.z = metl;
#endif
	ioNormal = vec4(GlobalNormal.xyz, 0.0);
	ioGlobalNormal = vec4(normalize(GlobalNormal.xyz*mat3(g_WorldMatrix)), 0.0);
	vec3 oRawPosSc = oRawPos*NGScale;
	ioPosition = vec4(oRawPos.xyz, 1.0);
	ioGlobalPosition = (ioPosition*g_WorldMatrix);
#ifdef NODE_CODE
	vec3 oMPosSc = oMPos*NGScale;
#ifndef HAS_IN_CAVITY
	#ifdef USE_CAVITY
		float icavity = -ca0*0.5+0.5;
		ioCavity = vec4(icavity, icavity, icavity, icavity);
	#else
		ioCavity = vec4(0.5,0.5,0.5,0.5);
	#endif
#endif	
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);                 // shader playback time (in seconds)
	ioMouse = vec4(MousePos.x, MousePos.y, MousePos.z, 0.0);                // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oRawPos*NGScale, 0.0);
	ioUV = ioFragCoord;
	

	ioFragCoord_DX = vec4(dFdx(oRawPosSc.xyz)*NGScale, 0.0);
	ioUV_DX = ioFragCoord_DX;
	ioNormal_DX = vec4(dFdx(oRawNormal.xyz), 0.0);
	ioPosition_DX = vec4(dFdx(oRawPos.xyz), 0.0)*NGScale;

	ioFragCoord_DY = vec4(dFdy(oRawPosSc.xyz), 0.0);
	ioUV_DY = ioFragCoord_DY;
	ioNormal_DY = vec4(dFdy(oRawNormal.xyz), 0.0);
	ioPosition_DY = vec4(dFdy(oRawPos.xyz), 0.0)*NGScale;

	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4(g_LocalViewPos.xyz, 0.0);
	ioIteration = vec4One * CurrentIteration;

	ioOcclusion = vec4(Occlusion);

	vec3 iNormalSm = GlobalNormal-normalize(cross(dFdx(oRawPos),dFdy(oRawPos)));

	vec3 Pxx=oRawPos+dFdx(oRawPos);
	vec3 Pyy=oRawPos+dFdy(oRawPos);//*IncSign;		
#ifdef NG_AFFECTS_NORMAL
	vec4 _origPM =  ioPM;
	vec4 _origPQ1 = ioPQ1;
	vec4 _origPQ2 = ioPQ2;
	vec4 _origPQ3 = ioPQ3;
	vec4 _origPQ4 = ioPQ4;
	vec4 _origPN =  ioPN; 
	float _origDisplacement = ioDisplacement;
	{
		ioPosition = vec4(Pxx, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
//		ioFragCoord = vec4(Pxx*0.005/(OverallScale+1e-10),0.0);
		NODE_CODE;
		Pxx = ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale;
	}
	ioPM =  _origPM;
	ioPQ1 = _origPQ1;
	ioPQ2 = _origPQ2;
	ioPQ3 = _origPQ3;
	ioPQ4 = _origPQ4;
	ioPN =  _origPN; 
	ioDisplacement = _origDisplacement;
	{
		ioPosition = vec4(Pyy, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
//		ioFragCoord = vec4(Pyy*0.005/(OverallScale+1e-10),0.0);
		NODE_CODE;
		Pyy = ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale;
	}
	ioPM =  _origPM;
	ioPQ1 = _origPQ1;
	ioPQ2 = _origPQ2;
	ioPQ3 = _origPQ3;
	ioPQ4 = _origPQ4;
	ioPN =  _origPN; 
	ioDisplacement = _origDisplacement;
#endif	
	{
		ioPosition = vec4(oRawPos, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
		NODE_CODE;
		
	}	

	Gloss = saturate(ioPN.w*2.0-1.0);
	ioPN.z = saturate(ioPN.z*2.0-1.0);

	tColor = clamp(ioPM.xyz*2.0*(1.0-ioPN.z), vec3(0), vec3(1));
	sfColor.w = ioPM.w;
	tSpecular.xyz = mix(ioPQ2.xyz, ioPM.xyz*2.0, ioPN.z);
	Emiss = ioPQ3.xyz*2.0;
	
#if D_RRenderPass == RP_DIFFUSE
	vec4 flatColor = vec4(pow(tColor.xyz, vec3(igamma)), ioPM.w); 
	FragColor = lerp(flatColor,flatColor*0.5,Freeze*FreezeMod);
	return;
#endif
	
#ifdef UNPACK_PBM
	UNPACK_PBM;
#endif
#ifdef NG_AFFECTS_NORMAL
	vec3 iPD = (ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale);
	vec3 iz = normalize(iPD-Pyy);
	vec3 ix = normalize(cross(normalize(Pxx-iPD), iz)); 
	ioNormal.xyz = -normalize(ix-iNormalSm);
	
	
	Normal.xyz = mix(normalize(ioNormal.xyz*WPanMatrix), Normal.xyz, vec3(ioR_DiffuseSSS));
	GlobalNormal.xyz = ioNormal.xyz;
#endif	
	ReflectionDir = oVDir - GlobalNormal * dot(oVDir, GlobalNormal) * 2.0;
	ReflectionDir = normalize(ReflectionDir*WPanMatrix);
	
#endif


#ifdef FragColor
	GlobalNormal.xyz = normalize(GlobalNormal.xyz*mat3(g_WorldMatrix));	
//	ioPN.x = GlobalNormal.x*0.5+0.5;
//	ioPN.y = GlobalNormal.y*0.5+0.5;
//	ioPN.z = GlobalNormal.z*0.5+0.5;
	ioPN.y = ioPN.w;
	
#ifdef MC_COVER

	ioPM.w = Opacity*alp0;
	ioPQ1.w = Opacity*alp0;
	ioPQ2.w = Opacity*alp0;
	ioPQ3.w = Opacity*alp0;
	ioPQ4.w = Opacity*alp0;
	ioPN.w = Opacity*alp0;
//	ioDisplacement = vec4(nrm.z);
	//ioPN.y = Gloss;
//	ioPN.z = metl;
//ioPM.xyz = pow(ioPM.xyz,vec3(0.454545));
	FragData[6] = vec4((vec4(oRawPosSc.xyz+oRawNormal*(nrm.z-0.0)*4.0,1.0)*g_WorldMatrix).xyz,Opacity*alp0);//vec3(distance(oWorldPos.xyz, g_LocalViewPos.xyz)));//ioDisplacement;
	
#else
	ioPM.w = 1.0;
	ioPQ1.w = 1.0;
	ioPQ2.w = 1.0;
	ioPQ3.w = 1.0;
	ioPQ4.w = 1.0;
	ioPN.w = 1.0;
	FragData[6] = vec4((vec4(ioPosition.xyz, 1.0)*g_WorldMatrix).xyz,1.0);//vec3(distance(oWorldPos.xyz, g_LocalViewPos.xyz)));//ioDisplacement;
#endif
	FragData[0] = ioPM;
	FragData[1] = ioPQ1;
	FragData[2] = ioPQ2;
	FragData[3] = ioPQ3;
	FragData[4] = ioPQ4;
	FragData[5] = ioPN;	
	return;
#undef FragColor
#define FragColor FragData[0]
#else
	////////////////////////////////////////////////	

	#if D_RRenderPass == RP_GLOSS
		FragColor = vec4(Gloss,Gloss,Gloss,1); 
		return;
	#endif

	float Roughness = 1.0 - Gloss;
	float RoughnessFadeE = Roughness*Roughness;
	float GlossFadeE = Gloss*Gloss;
	
	
	float dotNV = saturate(abs(dot(Normal,ViewDir)))*0.99+0.005;
	vec3 br = texture(tBRDF,vec2(dotNV,pow(Gloss,0.88))).xyz*1.5;
	//float dotNL = saturate(dot(Normal,ReflectionDir));
	
	float opp = 0.85-GlossFadeE*0.85+(1.0-GlossFadeE*GlossFadeE)*0.15;
	float uu = atan(ReflectionDir.z,ReflectionDir.x)/6.2831853;
	float as = asin(ReflectionDir.y);
	float vv = 0.5+as/3.1415926*(2048.0-pow(2.0,opp*7.0))/2048;	

	//reflection
	vec4 ReflectionColor = vec4(0,0,0,0);
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		ReflectionColor = textureLod(Panorama, vec2(uu, vv), opp * 7.0);	
		
		ReflectionColor.xyz *= 5.0-ReflectionColor.w*4.0;//extra light range from the texture alpha channel
		ReflectionColor.xyz *= getmodf(ReflectionColor.xyz);
		ReflectionColor.xyz = pow(ReflectionColor.xyz,gamma);
		
	#ifdef SHADOWS
			
		#ifdef SSREFLECTIONS
			vec4 SSReflection = vec4(0.0, 0.0, 0.0, 0.0);
			if(iCurrentIteration % 4 == 3){
				SSReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), Roughness, 24.0+64.0*Gloss*Gloss, 1.0, 0.1+Roughness*0.5, Roughness);
				ReflectionColor.xyz = lerp(ReflectionColor.xyz, SSReflection.xyz, saturate(SSReflection.w))*4.0;
			} else ReflectionColor.xyz *= 0.0;
		#endif
	#endif
		
		ReflectionColor.xyz *= (tSpecular.xyz*br.x + br.yyy * saturate(pow(tSpecular.x+tSpecular.y+tSpecular.z, 0.3)*3.0) )*SpecOcclusion;
	#endif
	
	uu = atan(Normal.z,Normal.x)/6.2831853;
	vv=0.5+asin(Normal.y*0.9999)/3.1415926*(64.0-0.5)/64.0;	
	vec4 DiffuseColor = vec4(0,0,0,0);
	
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass <= RP_AO
	
		DiffuseColor=texture(PanoramaDiffuse,vec2(uu,vv));
		
		DiffuseColor.xyz *= 2.0-DiffuseColor.w;
		DiffuseColor.xyz *= getmodf(DiffuseColor.xyz)*pow(Occlusion, 0.3);
		DiffuseColor.xyz = pow(DiffuseColor.xyz,gamma) * br.z;
	
	#endif
	
	vec3 Diff = DiffuseColor.xyz;

	
#ifdef SHADOWS
	
	vec3 H = normalize(LightDir-oVDir);
	
	//GGX BRDF
	//float GGXalpha = lerp(pow(Roughness, 3.0), pow(Roughness, 1.8), Roughness) * 0.99 + 0.01;//) * (Roughness * 0.99 + 0.01);   // roughness offset for glossy surfaces
	float GGXalpha = saturate(Roughness * Roughness+LightScatter*0.25) * 0.995 + 0.005;   // roughness offset for glossy surfaces

	float dotNL = saturate(dot(GlobalNormal,LightDir));
	float dotNH = saturate(dot(GlobalNormal,H));
	float dotLH = saturate(dot(LightDir,H));
	
	float F, D, vis;
	
	// D
	float alphaSqr = GGXalpha * GGXalpha;
	float pi = 3.14159;
	float denom = dotNH * dotNH *(alphaSqr-1.0) + 1.0;
	D = alphaSqr/(pi * denom * denom);
	
	// V
	float k = GGXalpha/2.0;
	vis = 1.0/(dotNL*(1.0 - k) + k) * 1.0/(dotNV*(1.0 - k) + k);
	float Specular = dotNL * D  * vis;
	
	//Burley12 BRDF
	//float BurleyF = dotLH * RoughnessFadeE;
	//float Diffuse = dotNL * (1.0 + BurleyF * pow(1.0 - dotNL, 5.0)) * ((1.0 + BurleyF * pow(1.0 - dotNV, 5.0))+0.5)/1.5;
	//Diffuse = dotNL;
	
	
	float Burley_Roughness = Roughness * Roughness;
	
	float energy_factor = 1.0f - Burley_Roughness * 0.337748344f;
	float f90 = 2.0f * Burley_Roughness * (pow(dotLH, 2.0f) + 0.25f) - 1.0f;
	
	float light_scatter = f90 * pow(saturate(1.0f - dotNL), 5.0f) + 1.0f;
	float view_scatter  = f90 * pow(saturate(1.0f - dotNV), 5.0f) + 1.0f;
	
	float Diffuse = dotNL * energy_factor * light_scatter * view_scatter;
	//float Diffuse = dotNL * 0.1f;
	
	
	
	
	
	
	//shading
	float shd = (1.0 - RefShade)*0.25;
	float mshd = 1.0-shd;
	vec3 d = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	
	
	vec4 SPos4 = vec4(oWorldPos,1.0);
	SPos4 = SPos4*ShadowTM;
	SPos4.y = 1.0 - SPos4.y;
	vec3 SPos = SPos4.xyz;

	float shadowBias = 0.05;	
	
//#ifdef SPOS_IN_PIXEL_SHADER
//	vec4 SPos4 = vec4(oWorldPos,1.0);
//	SPos4 = SPos4*ShadowTM;
//	SPos4.y = 1.0 - SPos4.y;
//	vec3 SPos = SPos4.xyz;
	
	vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
	
	float shadowZDist = SPos.z-dot(m,d);
	
	float shiftToLight = 2.0;
	float shadowGradientFade = WShadowMapSize;
	float Multiplier = 0;//saturate(shiftToLight-(shadowZDist)*shadowGradientFade*2.0)*mshd + shd;
	
	float iCircleShift = -2.0;
	
	vec3 laZ = GlobalNormal;
	laZ = normalize(laZ);
	vec3 laX = cross(LightDir, laZ); 
	laX = normalize(laX);
	vec3 laY = cross(laZ, laX);
	
	float iShadowMulCnt = 0.0;
	if(CurrentIteration < 128){
		for(float iy = -3.0; iy < 3.5; iy+=1.0){
			float iCS = max(0.0, abs(iCircleShift)-1.0);
			for(float ix = -3.0+iCS; ix < 3.5-iCS; ix+=1.0){
				float iShadowScatter = 500.0*abs(shadowZDist)*LightScatter*(saturate(1.0-(0.0078125*CurrentIteration))+0.1);
				
				vec4 pxSSPos4 = vec4(oWorldPos.xyz, 1.0) * g_WorldViewProjectionMatrix; 
				vec4 v4Random = fract(abs(cos(vec4((CurrentIteration+ix+pxSSPos4.x)*1335.2212, (CurrentIteration+pxSSPos4.y+iy)*1540.3813, (CurrentIteration+pxSSPos4.z+iy)*5140.381, (CurrentIteration+pxSSPos4.z+ix)*1335.221)))*112.0)*2.0-vec4(1.0,1.0,1.0,1.0);

				v4Random.x = (v4Random.x+v4Random.z)*0.5;
				v4Random.y = (v4Random.y+v4Random.w)*0.5;
				
				float yToCamera = abs(0.0-v4Random.y)*0.4;
				vec4 SPos4 = vec4(oWorldPos+((GlobalNormal*v4Random.y)+(laX*v4Random.x*2.0))*iShadowScatter,1.0);
				SPos4 = SPos4*ShadowTM;
				SPos4.y = 1.0 - SPos4.y;
				vec3 SPos = SPos4.xyz;
				
				vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
				
				float iShadowMul = 1.0-max(abs(v4Random.x),abs(v4Random.y));
				iShadowMul = iShadowMul;
				iShadowMulCnt += iShadowMul;
				float shadowZ = dot(m,d);
				float iShadowZDist = SPos.z-shadowZ;
				float iMultiplier = saturate((abs(v4Random.x)*iShadowScatter*2.0)+shiftToLight+(shadowZ*yToCamera)-(iShadowZDist)*shadowGradientFade*2.0)*mshd + shd;
				Multiplier +=iMultiplier*iShadowMul;
			}
			iCircleShift+= 1.0;
		}
		Multiplier = pow(Multiplier/iShadowMulCnt,0.5);
	} else Multiplier = saturate(shiftToLight-(shadowZDist)*shadowGradientFade*2.0)*mshd + shd;
/*#else
	vec3 m = texture(ShadowSampler,SPos.xy+(vec2(-0.5,0.5)/WShadowMapSize)).xyz;	
	float shiftToLight = 10.0+WShadowMapSize*0.001;
	float shadowGradientFade = min(WShadowMapSize, 1024.0);
	float Multiplier = saturate(shiftToLight-(SPos.z-dot(m,d))*shadowGradientFade*2.0)*mshd + shd;
#endif*/
	
	
	float dc = Multiplier * saturate(dot(GlobalNormal,LightDir));
	float dcc=dc;//shd + dc*mshd;
	float diffuseFade = pow(dotNV,0.5/pi)*GlossFadeE+(1.0-GlossFadeE);

	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass <= RP_AO
		DiffuseColor.xyz = diffuseFade * Diffuse * Multiplier*mshd + vec3(shd,shd,shd);
		DiffuseColor.xyz = pow(DiffuseColor.xyz,igamma);
		DiffuseColor.xyz *= getmodf(DiffuseColor.xyz);
		DiffuseColor.xyz = pow(DiffuseColor.xyz,gamma);
		Diff = DiffuseColor.xyz;
	#endif
	
	//vec3 EnvTexture = ReflectionColor.xyz * (1-IsExternalLight) * lightColor.xyz;
	vec3 EnvTexture = ReflectionColor.xyz * max(max(lightColor.x, lightColor.y), lightColor.z) * 0.25;


#ifdef SSREFLECTIONS
	vec3 EnvSpec = 0.8*lerp(tSpecular, vec3(1.0,1.0,1.0), pow(lerp(pow(Gloss,0.2), Gloss, Gloss)*(1.0-dotNV),pi*1.3)) * (Specular * Multiplier * lightColor.xyz+SSReflection.xyz*SSReflection.w);// * (1-IsExternalLight);
#else
	vec3 EnvSpec = 0.8*lerp(tSpecular, vec3(1.0,1.0,1.0), pow(lerp(pow(Gloss,0.2), Gloss, Gloss)*(1.0-dotNV),pi*1.3)) * Specular * Multiplier * lightColor.xyz;// * (1-IsExternalLight);
#endif	
	
	//float EnvLerp = saturate((Roughness * 4.0f)-1.0f);        //coefficient of lerp between EnvTexture and EnvSpec
	float EnvLerp = saturate((Roughness - 0.2) * 9.0f);        //coefficient of lerp between EnvTexture and EnvSpec
	
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		ReflectionColor.xyz = lerp(EnvTexture , EnvSpec , max(EnvLerp, IsExternalLight));
	#endif
#ifdef USE_SSSHADOW	
	//SSS
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_TRANSLUCENT
		vec3 SSS = vec3(saturate(1.0-(SPos.z-dot(m,d))*(1.0 - Translucence) * 100));
		SSS = mix(SSScolor.xyz, vec3(1.0), pow(SSS,vec3(4.0))) * SSS;
		#if D_RRenderPass == RP_TRANSLUCENT
			DiffuseColor.xyz = SSS - DiffuseColor.xyz;
		#else 
			DiffuseColor.xyz = SSS;	  //activation SSS
		#endif
	#endif
/*	
	vec3 SSS = vec3(saturate(1.0-(oWorldPos.z-dot(m,d))*(1.0 - Translucence) * 100.0));//375
	SSS = mix(SSScolor.xyz, vec3(1.0), pow(SSS,vec3(4.0))) * SSS *mshd + vec3(shd,shd,shd);
	DiffuseColor.xyz = SSS;	  //activation SSS
	*/
#endif
	#if D_RRenderPass == RP_TRANSLUCENT
		DiffuseColor = vec4(0,0,0,1);
	#endif
#endif
	#if D_RRenderPass <= RP_LIGHT
		DiffuseColor.xyz *= lightColor.xyz;
	#endif
	#if D_RRenderPass < RP_TRANSLUCENT
		#ifdef SSGI
		#ifdef SHADOWS
//			if(iCurrentIteration % 2 == 1){
				vec4 IndirectLight = ScreenSpaceRayTrace(oWorldPos.xyz, GlobalNormal.xyz, 1.0, 16.0, 1.0, 1.0, Roughness);
				DiffuseColor.xyz += IndirectLight.xyz*IndirectLight.w*SecondLightIntensity*0.01;
	//		}
		#endif
		#endif
	#endif
	#if D_RRenderPass <= RP_TRANSLUCENT
		DiffuseColor.xyz *= tColor;
	#endif
	#if D_RRenderPass == RP_AO
		DiffuseColor.xyz *= 2.0;
	#endif	
	#if D_RRenderPass > RP_AO
		DiffuseColor = vec4(0,0,0,1);
	#endif	

	color.xyz = DiffuseColor.xyz + ReflectionColor.xyz;
//	vec3 Emiss = tColor.xyz*Emissive;
	#if D_RRenderPass == RP_EMMISIVE
		FragColor = vec4(Emiss.x, Emiss.y, Emiss.z, 1.0); 
		return;
	#endif
	
	color.xyz  = color.xyz + Emiss;	
	
////////////////	
// FOG	////////
#ifdef IS_VOXEL_SHADER
	float Wde = saturate(pow((1.0/oExtra.w)*pow(WFogDensity/10000.0,2.0),WFogPower));
	
	#if D_RRenderPass == RP_DEPTH
		FragColor = vec4(Wde, Wde, Wde, 1.0); 
		return;
	#endif

	#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_FOG && D_RRenderPass <= RP_FOG_LIGHT)
	
	   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette*Wde)).xyz;
	   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette/50.0-1.0)).xyz;

#ifdef SHADOWS	



	color.xyz = lerp(color.xyz,vec3(Multiplier,Multiplier,Multiplier),WLightSilhouette/100.0).xyz;

	// FOG
#ifdef SPOS_IN_PIXEL_SHADER
#ifdef D_WFogDensity
	#ifdef D_WVolumeFogSamples


#define FOG_STEPS 32
		vec3 WOldSVPos = SPos.xyz;
		float WOldFogWde = pow((1.0/oExtra.w)*(WFogDensity/10000.0,2.0),WFogPower);
		float WFogWde = 0;
		float WFogStep = 1.0/FOG_STEPS;
		float WFogLerpPos = 0.0;
		float VSWdeDeltaSum = 0.0;
		float VSWdeDeltaWOShadowSum = 0.0;
//		int iWVolumeFogSamples = max(3,WVolumeFogSamples);
		
		vec3 WFogVolumeColorResult = vec3(0,0,0);
		
		
		for(int iVSS = 0; iVSS < FOG_STEPS; iVSS++){
			WFogLerpPos += WFogStep;
			float WFogLerpPosRand = WFogLerpPos-(WFogStep*WFogRand);
			
			vec4 zP = vec4(lerp(oPos.xyz , g_LocalViewPos.xyz,WFogLerpPos), 1.0);
			vec4 zPC = zP * g_WorldViewProjectionMatrix;
			vec4 zExtra = vec4(0,0,0,0);
			zExtra.yz =  (1.0 + zPC.xy / zPC.w ) / 2.0;
			zExtra.z = (1.0 - zExtra.z);
			zExtra.yz += vec2(du/2,dv/2);
			zExtra.w=1.0/zPC.w;//In.Color2.x;
		
			float VSWde = pow((1.0/lerp(oExtra.w, 1.0, WFogLerpPosRand))*(WFogDensity/10000.0,2.0),WFogPower);
			float VSWdeDelta = saturate(WOldFogWde-VSWde);
				
			vec4 SPos4VS = vec4(lerp(oWorldPos.xyz, g_LocalViewPos.xyz, WFogLerpPosRand),1.0);
			SPos4VS = SPos4VS * ShadowTM;
			SPos4VS.xy += vec2(0.5/ShadowMapSide,0.5/ShadowMapSide);
			SPos4VS.y = 1.0 - SPos4VS.y;

			vec3 dVS = vec3(1.0,1.0/255.0,1.0/255.0/255.0);

			vec3 VSPos = SPos4VS.xyz;
			vec3 mVS = texture(ShadowSampler,VSPos.xy).xyz;	
				
			float MultiplierVS = saturate(2.0-(VSPos.z-dot(mVS,dVS)-shadowBias)*WShadowMapSize*2.0);
			WFogVolumeColorResult += WFogColor.zyx*lightColor.xyz*MultiplierVS*VSWdeDelta;
			WOldFogWde = VSWde;
			VSWdeDeltaSum += VSWdeDelta;
			VSWdeDeltaWOShadowSum += VSWdeDelta*MultiplierVS;
		}
		
		float fogMask = saturate(min(Wde, Wde*pow(VSWdeDeltaWOShadowSum/VSWdeDeltaSum, max(0.1,WFogShadows-1.0))));
		vec3 fogLight = WFogVolumeColorResult/VSWdeDeltaSum;
		color.xyz = lerp(color.xyz,lerp(WFogColor.zyx*lightColor.xyz, fogLight, min(1.0, WFogShadows)), fogMask).xyz;
		
		#if D_RRenderPass == RP_FOG_LIGHT
			FragColor = saturate(vec4(fogLight.x/2.0, fogLight.y/2.0, fogLight.z/2.0, 1.0)); 
			return;
		#endif
		#if D_RRenderPass == RP_FOG_MASK
			FragColor = saturate(vec4(fogMask,fogMask,fogMask,1)*2.0); 
			return;
		#endif
		
	#else
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx,Wde).xyz;
	#endif
#endif	
#endif	
#endif			
//// RR END ///
	
	if(UseACES > 0.0){
#ifdef AOASS
		color.xyz =  mix(pow(color.xyz*LDiffuse22C,igamma),Checker.xyz*Diff*2.0,Freeze*FreezeMod);
		color.y*=10;
#else
		color.xyz =  mix(pow(ndAcesTonemap(color.xyz*LDiffuse22C),igamma),Checker.xyz*Diff*2.0,Freeze*FreezeMod);
#endif
	} else {
		color.xyz =  mix(pow(color.xyz*LDiffuse22C,igamma),Checker.xyz*Diff*2.0,Freeze*FreezeMod);//+saturate(pow(1.0-dotNV,20.0)*15.0);
	}
#ifdef ALPHAPOWER 
	color.xyz*=pow(sfColor.w,AlphaPower);
#else
	color.xyz*=sfColor.w;
#endif
	color.w = sfColor.w;
	color *= SelectionColor;
#ifdef MODULATE_COLOR
        if(ProjectorOpacity>0){

#ifdef PRINTING
		vec3 wps = oMPos*8.0*LayerThickness;
#else
		vec3 wps = oMPos / 0.005*OverallScale;
		wps = (vec4(wps,1.0) * g_WorldMatrix).xyz;
#endif
		vec4 pruv = vec4(wps,1.0) * ProjectorTM;
		pruv.y*=-1;
		vec4 prcl=texture(ProjectorSampler,pruv.xy/pruv.w);
		color.xyz *= lerp(vec3(1.0,1.0,1.0),prcl.xyz,ProjectorOpacity);
	}
#endif //MODULATE_COLOR


#ifdef SHADOWS_CACHER
#ifdef SHADOWS
	color.w = saturate((1.0-Multiplier) * saturate(dot(GlobalNormal,LightDir))*color.w*8.0);
#endif
#endif

#ifdef SHADOWS
	if(fract(CurrentIteration * 0.1) < (1.0-color.w*color.w)) {
		discard;
	}
	color.w = 1.0;
#endif


#endif
