
// Vertex shader


uniform float TextureWidth;//, float(pModelPointsScope->Lx));
uniform float TextureHeight;//, float(pModelPointsScope->Ly));
uniform vec4 QuadPosition;//, Vector4D(aGPUQX / (pModelPointsScope->Lx / GPUQuadSize), aGPUQY / (pModelPointsScope->Ly / GPUQuadSize), aGPUQX, aGPUQY);


in vec3 Pos0;
in vec4 Pos1;
in vec4 Pos2;
in vec4 Pos3;
in vec4 Pos4;
in vec4 Pos5;
in vec4 Pos6;
in vec4 Pos7;
in vec4 Pos8;

//in vec3 Pos;
//in vec2 TexCoord;

out vec4 oColor;

#include "/Templates/layer_filters.glsl"

void main() {
	float GPUQuadSize = 256.0;


	gl_Position = vec4(Pos0*2.0-vec3(1.0, 1.0, 1.0), 1.0);
	
	vec2 pxSrc[16]; 
	pxSrc[0] = Pos1.xy;
	pxSrc[1] = Pos1.zw;
	pxSrc[2] = Pos2.xy;
	pxSrc[3] = Pos2.zw;
	pxSrc[4] = Pos3.xy;
	pxSrc[5] = Pos3.zw;
	pxSrc[6] = Pos4.xy;
	pxSrc[7] = Pos4.zw;
	pxSrc[8] = Pos5.xy;
	pxSrc[9] = Pos5.zw;
	pxSrc[10] = Pos6.xy;
	pxSrc[11] = Pos6.zw;
	pxSrc[12] = Pos7.xy;
	pxSrc[13] = Pos7.zw;
	pxSrc[14] = Pos8.xy;
	pxSrc[15] = Pos8.zw;
	
	vec4 iColor = vec4(0,0,0,0);
	float weightsSumm = 0;
	for(int i = 0; i < 16 && pxSrc[i].y > 1.0; i++){
		vec2 iUV = pxSrc[i];

		vec2 texCoord = vec2(fract(iUV.x), fract(iUV.y));

		float weight = (iUV.y-texCoord.y)*0.001;
		weightsSumm+=weight;


		float RTS_ID = floor(iUV.x * 0.001+0.1);
		int iRTS_ID = int(RTS_ID);
		
		float normalRotate = (iUV.x-texCoord.x-RTS_ID*1000)*0.5;

		texCoord = texCoord*2.0;

		RTS_SET;

		vec4 c = RTS[iRTS_ID];
		
#ifdef FLOATMAP
//		c = vec4(1,1,1,1)*RGBToFloat(c);
#endif
#ifdef NORMALMAP
		vec3 u=vec3(c.x*2.0-1.0,c.y*2.0-1.0, 0.0);
		u.z = 1.0-length(u);

		normalRotate = radians(normalRotate);
		float SinVal = sin(normalRotate);
		float CosVal = cos(normalRotate);
		float Nx = (u.x * CosVal) - (u.y * SinVal);
		float Ny = (u.y * CosVal) + (u.x * SinVal);
	  
		c.x = Nx;
		c.y = Ny;
	//	FragColor = c;//*oWeights.x;
	//		FragColor = c;

#endif
		
		iColor += c*weight;
//		iColor += vec4(RTS_ID,RTS_ID,RTS_ID,1.0)*weight;//iColor/weightsSumm;

	}
#ifdef NORMALMAP
		iColor.x = (iColor.x+1.0)*0.5;
		iColor.y = (iColor.y+1.0)*0.5;

#endif	
	oColor = iColor/weightsSumm;
}

// Fragment shader

in vec4 oColor;
out vec4 FragColor;


void main() {


	FragColor = oColor;
	
}


