// Vertex shader

uniform float Lx;
uniform float Ly;
uniform vec4 QuadPosition;//, Vector4D(aGPUQX / (pModelPointsScope->Lx / GPUQuadSize), aGPUQY / (pModelPointsScope->Ly / GPUQuadSize), aGPUQX, aGPUQY);

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;
in vec3 Tangent;
in vec3 BiTangent;
in vec4 Indices;
in vec4 Weights;

out vec4 oPos;
out vec2 oTexCoord;
out vec4 oqPos;
out vec4 oWeights;

void main() {
	float GPUQuadSize = 512.0;
	
	oTexCoord.x = (TexCoord.x-QuadPosition.x)*(Lx/GPUQuadSize);
	oTexCoord.y = (TexCoord.y-QuadPosition.y)*(Ly/GPUQuadSize);

	oWeights = Weights;

//	oTexCoord.x = TexCoord.x;
//	oTexCoord.y = TexCoord.y;
	

	oPos.x = TexCoord.x*2.0-1.0;
	oPos.y = TexCoord.y*2.0-1.0;
	oPos.z = 1.0;
	oPos.w = 1.0;

	oqPos.x = TexCoord.x;//Pos.x*0.5+0.5;
	oqPos.y = 1.0-TexCoord.y;//1.0-(Pos.y*0.5+0.5);
	oqPos.z = 1.0;
	oqPos.w = 1.0;
	
	gl_Position = oPos;
	
}
// Fragment shader


in vec4 oPos;
in vec2 oTexCoord;
in vec4 oqPos;
in vec4 oWeights;


uniform float Lx;
uniform float Ly;

uniform sampler2D s_BUMP;
uniform sampler2D s_NormalMap;


out vec4 FragColor;

vec4 MakeNormal(vec4 c, vec4 cR, vec4 cB) {
	
	float skx = oWeights.x*0.014;
	float sky = oWeights.y*0.014;
	
	vec3 pX = normalize(vec3(skx, cR.x-c.x, 0));
	vec3 pY = normalize(vec3(0, cB.x-c.x, sky));
	
	vec3 resultNormal = normalize(cross(pX, pY)); 
	
//	float xfVal = (zR-z) * skx;
//	float yfVal = (zB-z) * sky;
//	float d = 0.5/sqrt(xfVal*xfVal + yfVal*yfVal + 2.0);

	
	float nx = resultNormal.x*0.5 + 0.5;
	float ny = resultNormal.z*0.5 + 0.5;
	

	vec4 result;
	result.x = nx;
	result.y = ny;
	result.z = 1;
	result.w = 0;
	return result;
}

uniform float TimeSeconds;


void main(){
	if(oTexCoord.x < 0 || oTexCoord.y < 0 || oTexCoord.x > 1.0 || oTexCoord.y > 1.0) discard;
	
	float LSpecI = 0.2;
	vec4 zr4 = vec4(0,0,0,0);
	float LxE = 1.0/Lx;
	float LyE = 1.0/Ly;
	float LxEw = 0.5/Lx;
	float LyEh = 0.5/Ly;
	
	vec2 wPos = vec2(oqPos.x, 1.0-oqPos.y);	

	
	vec4 NormalSrc = texture(s_NormalMap, wPos);
	
	vec4 BumpSrc =  texture(s_BUMP, vec2(wPos.x, wPos.y));
	vec4 BumpSrcR = texture(s_BUMP, vec2(wPos.x+LxE, wPos.y));
	vec4 BumpSrcB = texture(s_BUMP, vec2(wPos.x, wPos.y+LyE));
	
	
	vec2 rNorm = MakeNormal(BumpSrc, BumpSrcR, BumpSrcB).xy + NormalSrc.xy-vec2(0.5);//, 0/*NormalSrc.z*/);// vec2(1.0-QCNormalMap.z,QCNormalMap.y);
	
	FragColor = vec4(rNorm, NormalSrc.z, NormalSrc.w);

	
}

