// Vertex shader

uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;

in vec3 Pos;

out vec4 v_ScreenPos;

void main() {
	v_ScreenPos = vec4(Pos, 1.0) * g_WorldMatrix;
	gl_Position = v_ScreenPos * g_ScreenMatrixInverse;
}

// Fragment shader

uniform vec2 c_Orig;
uniform vec4 c_Color0;
uniform vec4 c_Color1;

in vec4 v_ScreenPos;

out vec4 FragColor;
void main() {
	vec4 c = vec4(1.0, 1.0, 1.0, 1.0);
	
	float X = floor(v_ScreenPos.x - c_Orig.x);
	float Y = floor(v_ScreenPos.y - c_Orig.y);
	float F = fract((X + Y) / 2.0);
	if(0.0 == F) {
		c = c_Color0;
	} else {
		c = c_Color1;
	}
	FragColor = c;
}