/*-----------------------------------------------------------------*/
// Mission 7
// Purpose: Bool operations ( Subtract one layer from another layer).
// File: SubtractLayers.as
/*-----------------------------------------------------------------*/

Debug     dbg;
DebugLog  logger = dbg.log();

string orange_Color = "4292730333";
string mission_explain = "Subtract_Layers_Explain"; 
string mission_help = "Subtract_Layers_Help";
string mission_Abort = "Mission_Abort";

void GoToStartMission() {
	cmd("$SETPAGE_Sculpt");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
}

void main(){
  UI  ui;
  SculptLayer sl;
  SculptRoom  sculpt;
  Builder  builder;
  
  ui.enableWindow("STARTMENU", false);
  sculpt.clear();
  
  cmd ("$SETPAGE_Sculpt");
  cmd ("$PENOP0");
  
  sculpt.toSurface();
  
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
  
  int FontID = GetFontFileID("Fira_Sans_Condensed_16");
  
  ShowMessageWhilePressKey(XX, YY, mission_explain, orange_Color, 0x0D,"");
  
  const Vec3  pa( 0 );
  const Vec3  dir = Vec3( 0, 1, 0 );
  const Vec3  dir2 = Vec3( 0.5, 0.5, 0.5 );
  Vec3  shift = dir * 100;
    
  Mesh  a = builder.cuboid().side( Vec3( 200, 200, 200 ) ).position( pa + shift ).details( 0.1 ).build();
  sculpt += a;
  sl.rename( "Cuboid" );
  
  shift -= (dir2 * 150);
  
  Mesh  b = builder.sphere().radius( 100 ).position( pa + shift ).details( 0.1 ).build();
  sculpt += b;
  sl.rename( "Sphere" );
  
  cmd ("$SETPAGE_Sculpt");
  
  SetScriptMessage("reset","");
  SetFloatingMessageBox(XX, YY, mission_help, orange_Color,1);
  bool noExit = true; 
  bool bEscape = false;
  
  while(noExit) {
    Step(1); //Rendering cycle
	int Status = -1;
	if(LMBPressed()) {
		float x = GetMouseX();
		float y = GetMouseY();
		logger += "  X Y " + x + " " + y;
		Status = ScriptMessagePressButton(x,y);
		if (Status==0) {
			noExit = false;
			bEscape = true;
		}
	}
	if (IsPressKeyID(0x1B)) {
		noExit = false;
		bEscape = true;
	}
    if ( WasRecentlyPressed("$SubtractFrom_Cuboid", 5)) noExit = false;
	else if ( WasRecentlyPressed("$SubtractFrom_Sphere", 5)) noExit = false;
  }
  SetScriptMessage("reset","");
  if ( !bEscape ) {
	SetFloatingMessageBoxTime(XX, YY, "Excellent", orange_Color,0,5000);
	logger += "End Mission";
  } else {
	SetFloatingMessage(XX, YY, mission_Abort, orange_Color);
	logger += "abort";
	Wait( 3000 );
	SetScriptMessage("reset","");
 }
    SetShowModalDlg(false);
	GoToStartMission();
	SetShowModalDlg(true);
	sculpt.clear();
 }