//File: Export to UE5 
void main() 
{ 
	Coat coat;
	string currRoom = coat.room();
	RetopoRoom retopo;
	PaintRoom paint;
	UI ui;
	// Use fileName as path to obj file
	string fileName = GetExportMeshName();
	ui.file(fileName);
	string paintLayerNames = PaintLayerNames();
	// deactivate undo
	ui.skipUndo(true);
	// go to retopo
	coat.room("Retopo");
	// retopo clear
	retopo.clear();
	// go to paint
	coat.room("Paint");	
	// export to unreal
	ui.exportPreset("Unreal 5");
	// skip dialogs
	ui.skipDialog(true);
	// merge visible & decimate to retopo
	//DecimateToRetopo();
	// add temporary layer
	MergeVisibleSceneAndDecimateToRetopo();
	// go to retopo
	coat.room("Retopo");
	SelectFirstRetopoLayer(false);
	DeleteRetopoLayer();
	// go to tool "Mark Seams" 
	cmd("$TopToolMarkSeams");
	// do AutoMap
	cmd("$AutoMap");
	// Bake normal map PP
	cmd("$MergeForDPNM");
	// go to paint
	coat.room("Paint");	
	string pathTextures = GetExportPathTextures();
	// Here may be your path texture
	pathTextures = "UE5\\Textures2";
	ui.pathTextures(pathTextures); 
	
	// Export Objects & Textures to Unreal Engine
	ExportObjectsAndTextures(fileName);
	
	// go to pain layer and clear automatic layers
	coat.room("Paint");
	ClearIfNeedPaintLayers(paintLayerNames);
	// go to retopo & clear polymesh
	coat.room("Retopo");
	retopo.clear();
	// reset skip dialogs
	ui.skipDialog(false);
	// go to current room
	coat.room(currRoom);
	//activate undo
	ui.skipUndo(false);
}

void ClearIfNeedPaintLayers(string Names) {
	int layersCount = GetPaintLayersCount();
	for(int i = layersCount-1; i >= 0; i--){
		string layer = GetLayerName(i);
		if(Names.findFirst(layer)==-1){
			SelectPaintLayer(layer);
			DeletePaintLayer(-1);
		}	
	}
}

void MergeVisibleSceneAndDecimateToRetopo(){
	 Vox vox;
	 UI ui;
	 string currObjName = vox.name();
     
	 const string visVolumes = GetVisibleVolumes();

	 Vox v = vox.firstForRoot();
	// add temporary layer
	 v = v.appendToParent("volume00001");
	
    // set current volume to surface mode
	 v.toSurface();
    
	 string tempName  = v.name();
	
	 //merge visible volumes	
	 PlainMergeVisible(tempName);
	 
	 // hides all visible volumes 
	 SetVisibleVolumes(visVolumes,false);
	 
	 v.moveToIndex(tempName,0);
	 
	 Step(1);
	 Wait(1000);
	 
	 // decimate to retopo
	 DecimateToRetopo();
	 
	 // restore early visible volumes
	 SetVisibleVolumes(visVolumes,true);
	 
	 // to voxel mode
	 v.moveToIndex(tempName,0);
	 Step(1);
	 Wait(2000);
	 
	 v.toVoxel();
	 Wait(2000);
	 
     // delete temporary layer   
	 v.remove();
	 Step(1);
	 Wait(2000);
	 // set to current object
	 vox.moveToIndex(currObjName,0);
}

string GetVisibleVolumes(){
	Vox vox;
	string vnames;
	vox = vox.firstForRoot();
	string name = vox.name();
	if (vox.visible()) vnames += (name + ",");
	while (vox.next()) {
		string vname = vox.name();
		if (vox.visible()) vnames += (vname + ",");
	}
	string volumes = vnames.substr(0,vnames.length()-1);
	return volumes;
}

void SetVisibleVolumes(string volumes, bool v){
	Vox vox;
	vox = vox.firstForRoot();
	do {
		string vname = vox.name();
		if ( volumes.findFirst(vname,0) !=-1 ){
			vox.setVisible(v);
		}
	} while(vox.next());
} 

