from cTemplates.Rooms import reg_main_menu

import coat
from cTemplates.Structs import *
import cTemplates.MainMenu.File as FileMenu
import cTemplates.MainMenu.Edit as EditMenu
import cTemplates.MainMenu.View as ViewMenu
import cTemplates.MainMenu.Freeze as FreezeMenu
import cTemplates.MainMenu.Windows as WindowsMenu
import cTemplates.MainMenu.Scripts as ScriptsMenu
import cTemplates.MainMenu.Capture as CaptureMenu
import cTemplates.MainMenu.Help as HelpMenu
import cTemplates.MainMenu.Debug as DebugMenu
import cTemplates.MainMenu.Curves as CurvesMenu
import cTemplates.MainMenu.Symmetry as SymmetryMenu
import cTemplates.MainMenu.Geometry as GeometryMenu
import cTemplates.MainMenu.Addons as Addons
import cTemplates.menu

################
### File Manu
PrintFileMenu = MainMenu("FILE")

PrintFileMenu.Content.append(FileMenu.S_New)

@d_submenu("Install", PrintFileMenu)
def Install():
       coat.menu_item("InstallExtension") # Install Extension
       coat.menu_item("InstallQuixelAssetAsShader") # Install Quixel asset as Shader

PrintFileMenu.Content.append(FileMenu.S_CreateExtension)

@d_submenu("Browse", PrintFileMenu)
def Browse():
        coat.menu_item("DocsFolder")
        coat.menu_item("InstFolder") # Installation Folder
        coat.menu_item("PensFolder") # Alphas
        coat.menu_item("StripsFolder") # Strips
        coat.menu_item("MasksFolder") # Stencils
        coat.menu_item("UserDataFolder") # User Data
        coat.menu_item("ObjSamplesFolder") # Sample Objects
        coat.menu_item("ObjPensSamplesFolder") # Sample 3D Alphas
        coat.menu_item("StoredStatesFolder") # Stored States
        coat.menu_item("ShadersFolder") # Shaders
        coat.menu_item("TempFolder") # Temporary Folder


PrintFileMenu.Content.append(FileMenu.S_Save)


@d_submenu("Import", PrintFileMenu)
def Import():
    coat.menu_item("ImportSculptMesh")  # {CY}Import for Vertex Painting/Big reference
    coat.menu_item("ImportImageAsMesh") # {CY}Import Image as Mesh
    coat.menu_item("IMPORT_DICOM_OBJ")  # {CY}Import DICOM Slices

@d_submenu("Export", PrintFileMenu)
def Export():
    coat.menu_item("ExportForPrinting") # Export For 3D Printing
    coat.menu_item("ExportCura") 
    coat.menu_item("PrepareToPublish") 


PrintFileMenu.Content.append(FileMenu.S_Exit)


### File Menu        
##############
### Window Menu        

Popups = Submenu("Popups")
Popups.Content.append(WindowsMenu.Popups_S1)
Popups.Content.append(WindowsMenu.Popups_S_ProxySlider)
@d_menu_section(Popups)
def Popups_paint():
    coat.menu_item("Blending")
    coat.menu_item("Curves_Tree")
    coat.menu_item("CurvParamsPopup")
    coat.menu_item("Extensions")
    coat.menu_item("FPS_monitor")
    coat.menu_item("Joints")
    coat.menu_item("MASK")
    coat.menu_item("Models")
    coat.menu_item("MultiresControl")
    coat.menu_item("PanoramasList")
    coat.menu_item("Pen")
    coat.menu_item("PenOpt")
    coat.menu_item("PRESETS")
    coat.menu_item("PrimHistory")
    coat.menu_item("Projector")
    coat.menu_item("Shaders")
    coat.menu_item("Shapes")
    coat.menu_item("STRIPS")
    coat.menu_item("Splines")
    coat.menu_item("SYMMETRY")
    coat.menu_item("Transforms")
    coat.menu_item("VoxTree")
    coat.menu_item("TOOL_PARAMO")

WindowsMenu.WindowsMenu.Content.insert(0, Popups)
WindowsMenu.Popups.Enabled = False

### Window Menu        
##############

EditMenu.S_NodeGraph.Enabled = False
EditMenu.S_CalculateMaps.Enabled = False
EditMenu.S_Edit.Enabled = False
EditMenu.S_Project.Enabled = False

ViewMenu.View_S_Show.Implementation = ViewMenu.View_S_Show_Print.Implementation
ViewMenu.View_S_Texture.Enabled = False
ViewMenu.View_S_Displacement.Enabled = False

FreezeMenu.S2P.Enabled = False
FreezeMenu.S4P.Enabled = False

GeometryMenu.S_rooms.Enabled = False
GeometryMenu.AUTOPO.Enabled = False

@reg_main_menu
def PrintMainMenu():
    PrintFileMenu()

    EditMenu.CreateEditMenu()

    ViewMenu.CreateViewMenu()

    if not coat.is_new_scene():
        SymmetryMenu.SymmetryMenu()
        FreezeMenu.FreezeMenu()

    GeometryMenu.GeometryMenu()
    CurvesMenu.CurvesMenu()

    WindowsMenu.WindowsMenu()

    ScriptsMenu.ScriptsMenu()
    Addons.AddonsMenu()

    CaptureMenu.CaptureMenu()
    HelpMenu.HelpMenu()
    if coat.IsDebug():
        DebugMenu.DebugMenu()



cTemplates.menu.DefaultMenu.Implementation = PrintMainMenu.Implementation