#pragma once
struct VoxLayer {
	int LayerID;
	CompactArray<DWORD> Color;
	CompactArray<DWORD> Specular; //specular,metall,0,opacity[w]
	CompactArray<BYTE>  Emissive;
	CompactArray<BYTE>  resMetall;
	CompactArray<TexturedVertex> TexVerts;
	//displacement layers
	CompactArray<Vector3D> VertexDisplacement;
};
struct uvSculptVertex {
	cVec2		uv;
	Vector3D	N;
	Vector3D	T;
	Vector3D	B;
	DWORD		Color;
	DWORD		uvVertexID;
};
struct uvSculptTriangle {
	uvSculptVertex verts[3];
	word local_ids[3];
	short TextureRef;
};
struct vPosNorm {
	vPosNorm(){}
	vPosNorm(const Vector3D& p, const Vector3D& n) {
		pos = p;
		normal = n;
	}
	Vector3D pos;
	Vector3D normal;
};
/**
\brief Main brick in voxel / surface structure.
\details
It contains polygonal geometry, color layers if given cell of the surface
pointer to this structure kept in `VolumeCell`.
*/
class APICALL VolumeCellAttrib{
public:
	short RctX;
	short RctY;
	short RctW;
	short RctH; 
	AABoundBox VertsAB;
	//AABoundBox VertsABC;
    /**
    \brief Vertices of the mesh in the cell.
    \details
    Of course, same vertex may be present in neighbour cells and sometimes you need to
    identify that 2 vertices from different cells represent single global index.
    There are two ways. Using `Status` field in `MCVertex` that represents edge status.
    It has global index for every vertex in cell.
    */
	CompactArray<MCVertex>	Verts;
	CompactArray<MCVertex>	BackupVerts;
	CompactArray<vPosNorm>  LeakyPos;
    /**
    \brief Verticies and indicies before this change.
    \details
    Undo will get to this state when applied.
    */
    CompactArray<indtype>		BackupIds;
    /// Positions / normals of vertices before entering surface mode.
	CompactArray<MCVertex>	OldVerts;
    /**
    \brief Indices of mesh in the cell.
    \details
    They refer vertices in this cell.
    Each three indices represent triangle.
    */
	CompactArray<indtype>		Indices;
	CompactArray<MCVertex>  TempVerts;
	/**
	\brief GlobalVertIndices are references of global vertices indices.
	\details
	GlobalVertIndices corresponds to vertex list Verts. Each vertex in Verts corresponds to item in GlobalVertIndices. If GlobalVertIndices is empty - there are no global indexation in the mesh.
	Each value is DWORD. Highest bit (0x80000000) is set up if the vertex is on the edge of the cell. The global index itself is GlobalVertIndices[i]&0x7FFFFFFFFF
	*/
	CompactArray<DWORD>		GlobalVertIndices;	
	CompactArray<VoxLayer>  Layers;

	static bool CurLayerInvisible;
	static float CurLayerDepthMod;
	static bool UseLayerScale;
	static bool InvisLayerWarning;

	void SetVertexPos(int index, Vector3D newpos, bool inlayers = false);
	void IncVertexPos(int index, Vector3D add, bool inlayers = false);
	void EnsureLayerExists();
	//CompactArray<TexturedVertex> TVerts;//textured vertices

	void RemoveLayer(int LayerID);
	VoxLayer* Insertlayer(int LayerID, bool MandatoryDepth = false);
	VoxLayer* GetLayer(int LayerID);
	void AddVertexToLayers(int pv1=-1,int pv2=-1,float W=0.5);
	void AddVertexToLayers(int pv1, int pv2, int pv3, float u, float v);
	void AddTriVertexToLayers(VolumeCellAttrib *vcan[3], int pv[3],float W=0.5);
	void AddVertexToLayersFromParent(VolumeCellAttrib* vca,int pv);
	void AddDefaultVertexToLayers();
	void AddDefaultColorVertexToLayers(CompactArray<DWORD>& Colors);
	void UpdateLayersSumm(VolumeObject* vo);
	void UpdateLayersSumm2();
	void FreeLayers();
	void ValidateColor(VoxLayer* vl);
	void DrewDbgTri(int idx,const Matrix4D& m,DWORD Color=0,float coef=0.9);
	void DrawDbg(const Matrix4D& m=Matrix4D::Identity,DWORD Color=0,float coef=0.9);
	DWORD GetVertexColor(int p);
	Vector4D* Temp4D;
	
    /// For tracking persistent data.
	WORD Dirty;
	void CopyTo(VolumeCellAttrib* dest);
};