#pragma once

//RootWidget class is base class for all gizmos.
//The general logic of all derived gizmos:
//As soon as Gizmo->MakeVisible() called gizmo will be temporary registered in gizmos list and act as gizmo.
//No need to handle any acions ling LMB or Render. If MakeVisible is not called for 2 cycles or destructor called 
//the gizmo will be automaticallt unregistered.
//So to use any derived gizmo you need to make class exemplar, like 
//SomeGizmo G;
//and call each cycle
//G.MakeVisible();

//This header consists of rich set of different gizmos on any taste

class APICALL RootWidget :public BaseClass{
public:
	RootWidget();
	~RootWidget();
	static cList<RootWidget*> Registered;
	int Lifetime;
	bool Visible;
	void MakeVisible(int Lifetime=2,bool ForceVisibility=false);
	void Hide();
	static bool globalOnLMB();
	static bool globalOnKey(int KeyCode);
	static void globalRender();
	static void globalProcess();
	static bool anyHighlighted();
	static bool anyCaptured();

	virtual void Render();
	virtual bool OnLMB();
	virtual bool CheckHighlight();
	virtual bool OnKey(int KeyCode);
	virtual bool Captured();
	virtual bool WasCaptured();
	virtual void Process();
};

class APICALL WidgetsScheme :public RootWidget{
	Vector3D InitialCapturePos;
public:
	static bool SomethingCaptured;
	WidgetsScheme();

	Matrix4D	CurrTransform;
	Matrix4D	PrevTransform;
	Matrix4D	OverallTransform;
	Matrix4D	GlobalTransform;
	void InitTransform();
	virtual void InitGlobalTransform(){};
	virtual void _init(){};
	virtual void ApplySymm(){};
	virtual void PlaceIn(Vector3D pos,float Radius,const Vector3D& ax,const Vector3D& ay,const Vector3D& az){};
	virtual void Transform(const Matrix4D& m) {};

	WidgetsScheme* SubControls;
	cVec2 PrevMPos;
	bool AutoActive;
	bool AlwaysRenderCage;
	bool AllowSelection;
	bool ManuallyChanged;
	int  AutoCaptureCenter;///0-not captured, set 1 to capture, other values are used intrnally
	ClassArray<BaseDrawingPrim> PrimList;
	virtual void Render();
	virtual bool OnLMB();
	virtual bool CheckHighlight();
	virtual bool OnKey(int KeyCode);
	virtual bool Captured();
	virtual bool WasCaptured();
	virtual void Process(){}; 
	virtual void AutoSetParams(){};
	Vector3D GetCapturedPos();
	Vector3D GetInitialCapturedPos();

};


//sphere placer gizmo, used in primitives

class APICALL SpherePlacer:public WidgetsScheme{
public:
	SpherePlacer();
	Vector3D Pos;
	float Radius;

	void CreateControls();
	virtual void _init();
	
	void SetParams(Vector3D P,float Radius);
	void _Process();
	virtual void Process(); 	

	RingRadiusPrim* RadiusWidget;
	CircleBoundPrim* SphereWidget;
	ArrowPrim* XX;
	ArrowPrim* YY;
	ArrowPrim* ZZ;
	ActiveLineConnector* LX;
	ActiveLineConnector* LY;
	ActiveLineConnector* LZ;
	virtual void PlaceIn(Vector3D pos,float Radius,const Vector3D& ax,const Vector3D& ay,const Vector3D& az);
	void Transform(const Matrix4D& m);
};

class APICALL SpherePlacerSector:public SpherePlacer {
	public:
		SpherePlacerSector(){
			RotatorX = NULL;
			RotatorY = NULL;
			RotatorZ = NULL;
			Pos1  = Vector3D::AxisY*Radius;
			Axis1 = Vector3D::AxisZ;
			Axis2 = Vector3D::AxisX;
			Axis3 = Vector3D::AxisY;
		}
		virtual void _init();
		virtual void Process();

		void _Process();
		void SetParams(Vector3D P, Vector3D P1, float Radius);

		Vector3D Pos1;
		Vector3D Axis1; // Z
		Vector3D Axis2; // X
		Vector3D Axis3; // Y

		BoundSpherePrim *SphereWidget1; //
		RotatorPrim* RotatorX;  // rotation around Y axis
		RotatorPrim* RotatorY;	// rotation around Z axis
		RotatorPrim* RotatorZ;	// rotation around X axis
};

//cylinder placer gizmo for primitives tool

class APICALL CylinderPlacer:public WidgetsScheme{
public:
	CylinderPlacer();
	Vector3D Pos1;
	Vector3D Pos2;
	float Height;
	float Radius;//average of Radius1 & 2
	float Radius1;
	float Radius2;
	Vector3D Axis1;
	Vector3D Axis2;
	float Scale1;
	float Scale2;
	float MainScale;
	bool IsCone;

	void SetParams(Vector3D P1,Vector3D P2,float R1,float R2,float A1,float A2);
	void Transform(const Matrix4D& m);
	void _Process();
	virtual void Process(); 
	Matrix4D GetTransform(Matrix4D sc=Matrix4D::Identity);
	virtual void PlaceIn(Vector3D pos,float Radius,const Vector3D& ax,const Vector3D& ay,const Vector3D& az);

	RingRadiusPrim* RadiusWidget1;
	RingRadiusPrim* RadiusWidget2;
	RingRadiusPrim* RadiusWidgetM;
	BoundSpherePrim* SphereWidget1;
	BoundSpherePrim* SphereWidget2;	
	CubePrim* Cube1;
	CubePrim* Cube2;
	RotatorPrim* Rotator1;
	RotatorPrim* Rotator2;
	RotatorPrim* RotatorX;
	RotatorPrim* RotatorZ;
	CubePrim* MainAxis;
	CubePrim* OverallScale;
	ArrowPrim* AY;
	ArrowPrim* AX;
	ArrowPrim* AZ;

	PassiveLineConnector* LX;
	PassiveLineConnector* LY;
	PassiveLineConnector* LZ;
};

class APICALL CP_State{
public:
	Vector3D Pos;
	float    SideA;
	float    SideB;
	float    SideC;
	Vector3D AxisX;
	Vector3D AxisY;
	Vector3D AxisZ;
};

class APICALL GizmoUserSettings:public BaseClass {
public:
	static bool HidePlaneScalingElememts;
	static bool HideScreenSpaceMovementCircle;
	static bool HideScreenSpaceRotationCircle;
	static bool HideAxialRotationControls;
	static bool HideOverallScalingControl;
	static bool HideAxialScalingControls;
	static bool HideAxialTranslateBars;
	SERIALIZE() {
		REG_AUTO(HidePlaneScalingElememts);
		REG_AUTO(HideScreenSpaceMovementCircle);
		REG_AUTO(HideScreenSpaceRotationCircle);
		REG_AUTO(HideAxialRotationControls);
		REG_AUTO(HideOverallScalingControl);
		REG_AUTO(HideAxialScalingControls);
		REG_AUTO(HideAxialTranslateBars);
	}
};

//cube placer gizmo, used for primitives and as transform gizmo.
//To use as transform gizmo set
//ConstantReset=true
//Generally if you need whole set of gizmo controls in UI use CubPrim as gizmo

class APICALL CubePlacer:public WidgetsScheme{
	Vector3D P0;
	bool P0In;
public:
	CubePlacer();
	void CreateCubeControls();
	virtual void _init();
	CP_State last_cp;

	int	 TransformsMode;
	int	 pTransformsMode;

	Vector3D Pos;
	Vector3D AxisX;
	Vector3D AxisY;
	Vector3D AxisZ;

	float SideA;
	float SideB;
	float SideC;

	float vSideA;
	float vSideB;
	float vSideC;

	float pSideA;
	float pSideB;
	float pSideC;

	bool ConstantReset;
	bool MoveOnlyGizmo;
	bool LocalSpace;
	bool SkipCenterPan;
	bool IgnoreHiddenElements;

	bool AllowAxisX;
	bool AllowAxisY;
	bool AllowAxisZ;
	bool AllowScreenRotation;
	bool AllowScreenMoving;
	bool AllowRotationX;
	bool AllowRotationY;
	bool AllowRotationZ;
	bool AllowScaling;
	bool AllowScalingX;
	bool AllowScalingY;
	bool AllowScalingZ;
	bool AllowScalingXY;
	bool AllowScalingYZ;
	bool AllowScalingZX;
	float AxisScaleX;
	float AxisScaleY;
	float AxisScaleZ;
	bool ThickLine[3];

	int  PickType;
	BYTE WholeScaleMask;
	bool IntitExtrude;

	void Pick();

	void SetParams(Vector3D P,Vector3D AX,Vector3D AY,Vector3D AZ,float SX,float SY,float SZ);
	virtual void PlaceIn(Vector3D pos,float Radius,const Vector3D& ax,const Vector3D& ay,const Vector3D& az);
	void _Process();
	void SetupElementsVisibility();
	virtual void Process(); 
	void ProcessTransforms(CP_State* st,bool AcceptAnyway=false);
	void CreateCPState(CP_State* st);
	virtual void InitGlobalTransform();

	CircleBoundPrim* Center;

	ArrowPrim* ArrowX;
	ArrowPrim* ArrowY;
	ArrowPrim* ArrowZ;

	ArrowPrim* ArrowMX;
	ArrowPrim* ArrowMY;
	ArrowPrim* ArrowMZ;

	CubePrim* CubeX;
	CubePrim* CubeY;
	CubePrim* CubeZ;
	CubePrim* CubeMX;
	CubePrim* CubeMY;
	CubePrim* CubeMZ;
	CubePrim* CubeXY;
	CubePrim* CubeYZ;
	CubePrim* CubeZX;
	CubePrim* CubeXYZ;

	RotatorPrim* RotX;
	RotatorPrim* RotY;
	RotatorPrim* RotZ;

	RotatorPrim* RotMX;
	RotatorPrim* RotMY;
	RotatorPrim* RotMZ;

	RingScalePrim* SYZ;
	RingScalePrim* SZX;
	RingScalePrim* SXY;

	ActiveLineConnector* LX;
	ActiveLineConnector* MLX;
	ActiveLineConnector* LY;
	ActiveLineConnector* MLY;
	ActiveLineConnector* LZ;
	ActiveLineConnector* MLZ;

	CircleRotatorPrim* RotS;

	bool HandleKey(int code);
	/// 0 - general, 1 - move, 2 - scale, 3 - rotate
	void SetGizmoTransformsMode(int mode);
	virtual bool OnChangeMember(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName);
	virtual DWORD GetClassMask() override;
	void Transform(const Matrix4D& m);
	
	SERIALIZE() {
		NOSAVE REG_DROPLIST(TransformsMode, "$TransformsMode", "gAllControls|gMove|gRptate|gScale");
	}
};
enum PlacerObj2DType {
	Square=0,
	Plane=1,
	Circle,
	Disc,
	Ngon2,
	Tube2,
	Ellipse2,
	Triangle
};

class APICALL PlanePlacer:public CubePlacer {
public:
	PlanePlacer() { 
		CubeXYZ = NULL;
		CubeMX = NULL;
		CubeX = NULL;
		CubeY = NULL;
		CubeZ = NULL;
		otype = Plane; 
	}
	virtual void _init();
	virtual void PlaceIn(Vector3D pos, float Radius, const Vector3D& ax, const Vector3D& ay, const Vector3D& az);
	bool IsScaled() const;
	PlacerObj2DType otype;
};


class APICALL Pt3D:public BaseClass{
public:
	int Index;
	Vector3D Pt;
	SERIALIZE() {
		UI_LAYOUT("3");
		REG_AUTO(Pt.x,"%");
		REG_AUTO(Pt.y,"%");
		REG_AUTO(Pt.z,"%");
	} 
};

class APICALL Pt3D2:public BaseClass{
public:
	Vector3D Pt;
	SERIALIZE() {
		REG_AUTO(Pt.x);
		REG_AUTO(Pt.y);
		REG_AUTO(Pt.z);
	} 
};

class Pt4D :public BaseClass{
public:
	Vector4D Pt;
	SERIALIZE() {
		REG_AUTO(Pt.x);
		REG_AUTO(Pt.y);
		REG_AUTO(Pt.z);
		REG_AUTO(Pt.w);
	} 
};

//free form shapes placer

class APICALL FreeFormPlacer:public CubePlacer{
public:
	FreeFormPlacer(){
		Mesh=NULL;
		ResMesh=NULL;
		TempMesh=NULL;
		CageMesh=NULL;
		TempCageMesh=NULL;
		sm=NULL;
		TransformAsAWhole=false;
		SymX=SymY=SymZ=false;
		IsSurf=false;
		Thickness=4;
		InnerRadius = 0.5;
		OuterRadius = 1.0;
		Radius = SideA;
		UseInnerRadius=false;
		ParamChanged=false;
		ffNewDim[0]=-1;
		ffNewDim[1]=-1;
		ffNewDim[2]=-1;
		Smooth=true;
	}
	~FreeFormPlacer(){
		if(Mesh)delete(Mesh);
		if(CageMesh)delete(CageMesh);
		if(ResMesh)delete(ResMesh);
		if(TempMesh)delete(TempMesh);
		if(TempCageMesh)delete(TempCageMesh);
	}
	CubePlacer LocGizmo;
	ClassArray<Pt3D2> PStore;
	cStr MeshName;
	cStr objName;
	cVec3i ffDim;
	cVec3i ffNewDim;
	bool SymX;
	bool SymY;
	bool SymZ;
	bool TransformAsAWhole;
	bool IsSurf;
	bool UseInnerRadius;
	bool ParamChanged;
	bool Changed;
	bool Smooth;
	float InnerRadiusDef;
	float InnerRadius;
	float OuterRadiusDef;
	float OuterRadius;
	float Radius;

	float Thickness;
	virtual void Render();
	void Clear();
	cList<Vector3D> ffPosLocal;
	cList<BoundSpherePrim*> ffControls;
	cList<PassiveLineConnector*> ffConn;
	comms::cMeshContainer* Mesh;
	comms::cMeshContainer* CageMesh;
	comms::cMeshContainer* ResMesh;
	comms::cMeshContainer* TempMesh;
	comms::cMeshContainer* TempCageMesh;
	cList<Vector3D> CageLSP;
	cList<Vector3D> CageLSP0;
	cList<Vector3D> CageLSPP;
	cList<Vector3D> CageLSPP2;
	comms::VecArray LSP;
	ClassArray<SubdWeights> SW;
	StaticMesh* sm;
	void AssignMesh(const char* Name,int ForcedCageX=-1,int ForcedCageY=-1,int ForcedCageZ=-1);
	void SetParams(Vector3D P,Vector3D AX,Vector3D AY,Vector3D AZ,float SX,float SY,float SZ);
	void SetEnableGizmoCubePrims(CubePlacer* GizmoPlacer, int Flags);
	int CheckEnableGizmoCubePrims();
	virtual void ApplySymm();
	void ApplySymmIdx(int idx);
	void ToCenterPoints();
	virtual void PlaceIn(Vector3D pos,float Radius,const Vector3D& ax,const Vector3D& ay,const Vector3D& az);
};

//sheet of paper placer

class APICALL SheetPlacer:public WidgetsScheme{
public:
	SheetPlacer();
	void SetParams(Vector3D C,Vector3D D1,Vector3D D2,Vector3D D3,float SizeX,float SizeY);
	virtual void PlaceIn(Vector3D pos,float Radius,const Vector3D& ax,const Vector3D& ay,const Vector3D& az);
	virtual void Process(); 

	Vector3D Center;
	float SizeX;
	float SizeY;
	Vector3D MainDir;
	Vector3D Dir1;
	Vector3D Dir2;
	float dAngle;
	Vector3D dPos;
	Vector3D PivotShift;

	PlaneBoundPrim* Plane;
	BoundSpherePrim* C;
	BoundSpherePrim* LT;
	BoundSpherePrim* RT;
	BoundSpherePrim* LB;
	BoundSpherePrim* RB;
	BoundSpherePrim* Pivot;
	CubePrim*  R;
	ArrowPrim* MR;
	CubePrim*  L;
	ArrowPrim* ML;
	CubePrim*  T;
	ArrowPrim* MT;
	CubePrim*  B;
	ArrowPrim* MB;
	ArrowPrim* FW;
	ArrowPrim* BK;
	RotatorPrim* UpR;
	RotatorPrim* DnR;
};

APICALL void Discrete(float& p);
APICALL void DiscreteZ(float& p);