#pragma once

struct APICALL OneSelPoint{
	OneSelPoint();
	OneSelPoint(Vector3D vc);
	/// Position on screen
	cVec2 pt2D;
	/// Position in space
	Vector3D SpacePos;
	/// Normal direction in space
	Vector3D TempNormal;
	cVec2& ScrPos(){
		return *((cVec2*)(&pt2D));
	}
	///Radius used when you run brush along the curve
	float Radius;
	float Temp;
	/// Pressure used when you run brush along the curve
	float Pressure;
	/// should be true
	bool OnSurface;
	/// Point is sharp point
	bool Sharp;	
	/// Point is B-Spline similar point. If both Sharp and BSpline are true, tangents will be used. Othervice tangents will be generated automatically.
	bool BSpline; 
	/// The point is last point in curve chunk. Curve in general may consist of several discontinual chunks.
	bool LastPoint;
	
	/// Point is selected
	bool Selected;
	///This field used only if both Sharp and BSpline are true. 0, 1, 2 - not used, 1 - autospline, 2 - bspline, 3 - spline with inverse tangents, 4 - spline with parallel tangents, 5 - spline with independent tangents
	int NodeType;
	/// Directions of tangents. Used if both Sharp and BSpline are true.
	Vector3D Tangent1;
	/// ![Placement of tangents](CurvesTangents.png)
	Vector3D Tangent2;
	/// GUID of point, usually zero, if not zero - there may exist other point with same GUID, it means that points are joined and will be manipulated as one.
	DWORD PointGUID;
	///Previous position before manipulation, used to syncronize joined points 
	Vector3D PrevPos;
	void SeekForNodeType();///Fills NodeType in correspondence with Tangents. Use only if both Sharp and BSpline are true.
	///arrays manipulations
	///get average length of the chunks
	static float GetAverageLen(cList<OneSelPoint>& pts);
	///set unform division of chunks between sharp edges over the curve, sharpness defined by crease angle
	static void EqualizeLen(cList<OneSelPoint>& pts, float length, float CreaseAngle, float FirstLastChunkLengthModulator = 1.0, int MinSubChunks=1);
	///split curve into no-self-intersecting chunks
	static void Split2DIntersections(cList<OneSelPoint>& pts);
	static void Split2DIntersections1(cList<OneSelPoint>& pts);
	///relax curve
	static void Relax(cList<OneSelPoint>& pts, float degree, bool tangent, int ntimes, float maxangle = 90.0);
	///draw debug inforrmation
	static void DrawDbg(cList<OneSelPoint>& pts, DWORD Color);
	///flop curve
	static void Flip(cList<OneSelPoint>& pts);
	///get square of the projection, pt2D used
	static float Square2D(cList<OneSelPoint>& pts);
	///remove clusters with megative square
	static void RemoveNegativeSquareChunks2D(cList<OneSelPoint>& pts);
	///fill pt2D according to the current screen space
	static void AssignPts2D(cList<OneSelPoint>& pts);
	static void EnsureLastPoint(cList<OneSelPoint>& pts);
	static void EnsureClosed(cList<OneSelPoint>& pts);
	static void RefineSelPointsArray(cList<OneSelPoint>& pts);
	static void RemoveRepeatingPoints(cList<OneSelPoint>& pts);
	static void save(cList<OneSelPoint>& pts, const char* filename);
	static void load(cList<OneSelPoint>& pts, const char* filename);
	/// create the contour using the field in range (x0, y0, x1, y1). Contour is where field(x,y) == 0.
	/// Ensure that field never returs exactly 0!!! Othervice non manifold and unclosed contours are possible.
	static void CreateFromField(cList<OneSelPoint>& pts, int x0, int y0, int x1, int y1, std::function<float(int, int)> field);
	/// deploy the points set from the array to the curves set within the tree.
	static void ToCurves(const cList<OneSelPoint>& pts, OneCurveObject* CurvRoot, const char* namealias, std::function<void(OneCurveObject*)> forCurves);
	/// Creates list of previous and next items in points list. Result is array, [0] - previous, [1] - next, [2] - other item with same coordinate
	static void SetupPrevNext(const cList<OneSelPoint>& pts, cList<cVec3i>& prevnextcur);
	/// <summary>
	///  extract the chunks from the surce until the crease angle will be found or LastPoint 
	static void ExtractCurveChunk(cList<OneSelPoint>& source, cList<OneSelPoint>& dest, float dotp);
	/// very primitive and fast version of the curve simplication - just for the initial drafting
	static void PrimitiveSimplify(cList<OneSelPoint>& source, float degree);
	/// read the EPS file 
	static void ParseEps(const char* Name, cList<OneSelPoint>& List, const Rct& R);
	/// save as EPS 
	static void WriteEps(const char* Name, cList<OneSelPoint>& List, Rct& R);
	/// find non-closed parts of the curve and replace it with the line of the finite width (line width)
	static void CorrectDisclosedContours(cList<OneSelPoint>& points, float line_width);
	/// render the curve to the image, the curve should be closed
	static void RenderToImage(cList<OneSelPoint>& points, comms::cImage& img, DWORD color);
	/// fit the curve to rectangle
	static void FitSelPoint(cList<OneSelPoint>& points, float w);
};

class APICALL SplinePoint2 :public BaseClass {
public:
	SplinePoint2();
	SplinePoint2(OneSelPoint& sp);
	void ToOSP(OneSelPoint& sp);
	cVec2 pt2D;
	Vector3D SpacePos;
	bool Sharp;
	bool BSpline;
	bool LastPoint;
	bool OnSurface;
	float Radius;
	float Pressure;
	cStr id;
	DWORD GUID;
	SERIALIZE() {
		UI_LAYOUT("2 7 7 3 3");
		REG_AUTO(id, "!");
		REG_AUTO(pt2D.x, "");
		REG_AUTO(pt2D.y, "");
		REG_AUTO(Sharp, "");
		REG_AUTO(BSpline, "");
		INVISIBLE REG_AUTO(Radius, "");
		INVISIBLE REG_AUTO(OnSurface);
		INVISIBLE REG_AUTO(SpacePos.x, "sx");
		INVISIBLE REG_AUTO(SpacePos.y, "sy");
		INVISIBLE REG_AUTO(SpacePos.z, "sz");
		INVISIBLE REG_AUTO(Pressure);
		INVISIBLE REG_AUTO(GUID);
	}
};
class APICALL SplinePoint3 :public BaseClass {
public:
	SplinePoint3();
	SplinePoint3(OneSelPoint& sp);
	void ToOSP(OneSelPoint& sp);
	Vector3D Pos;
	float Radius;
	float Pressure;
	bool Sharp;
	bool BSpline;
	bool LastPoint;
	cStr id;
	SERIALIZE() {
		UI_LAYOUT("2 7 7 7 7 3 3 5");
		REG_AUTO(id, "!");
		REG_COORD(
			REG_AUTO(Pos.x, "%$x"),
			REG_AUTO(Pos.y, "%$y"),
			REG_AUTO(Pos.z, "%$z")
		);
		REG_AUTO(Radius, "");
		REG_AUTO(Sharp, "");
		REG_AUTO(BSpline, "");
		REG_AUTO(Pressure, "");
	}
};
class APICALL SplinePoint3D :public BaseClass {
public:
	SplinePoint3D();
	SplinePoint3D(const OneSelPoint& sp);
	void ToOSP(OneSelPoint& sp) const;
	Vector3D Pos;
	Vector3D Normal;
	float Radius;
	bool Sharp;
	bool BSpline;
	bool LastPoint;
	bool OnSurface;
	float Pressure;
	SERIALIZE() {
		REG_AUTO(Pos.x, "x");
		REG_AUTO(Pos.y, "y");
		REG_AUTO(Pos.z, "z");
		REG_AUTO(Normal.x, "nx");
		REG_AUTO(Normal.y, "ny");
		REG_AUTO(Normal.z, "nz");
		REG_AUTO(Radius);
		REG_AUTO(Sharp);
		REG_AUTO(BSpline);
		REG_AUTO(LastPoint);
		REG_AUTO(OnSurface);
		REG_AUTO(Pressure);
	}
};