#pragma once

struct APICALL PresetsSettings:public BaseClass{
	__constructor(PresetsSettings);

	bool StoreCurrentTool;
	bool StoreEMode;
	bool StorePenShape;
	bool StorePenSettings;
	bool StoreStrip;
	bool StoreRadius;
	bool StoreDepth;
	bool StoreFocal;
	bool StoreSmooth;	
	bool StoreColors;
	bool StoreOpacity;
	bool StoreSpecular;
	bool StoreSpeclOpacity;
	bool StoreMaterial;
	bool StoreFillPattern;
	bool StoreSymmetry;
	bool StoreCamera;
	bool StorePanorama;

	SERIALIZE() {
		REG_AUTO(StoreCurrentTool);
		REG_AUTO(StoreEMode);
		REG_AUTO(StorePenShape);
		REG_AUTO(StorePenSettings);
		REG_AUTO(StoreStrip);
		REG_AUTO(StoreRadius);
		REG_AUTO(StoreDepth);
		REG_AUTO(StoreFocal);
		REG_AUTO(StoreSmooth);
		REG_AUTO(StoreColors);
		REG_AUTO(StoreOpacity);
		REG_AUTO(StoreSpecular);
		REG_AUTO(StoreSpeclOpacity);
		REG_AUTO(StoreMaterial);
		REG_AUTO(StoreFillPattern);
		REG_AUTO(StoreSymmetry);
		REG_AUTO(StoreCamera);
		REG_AUTO(StorePanorama);
	} 
};
struct APICALL OneRandomPen:public BaseClass{
	cStr Name;
	cStr BrushSettings;
	int Peview;
	SERIALIZE() {
		REG_AUTO(Name);
	} 

};
struct APICALL OnePreset:public BaseClass{
	OnePreset(){
		UseTapering=false;
		TaperingLength=10;
		OrderIndex=0;
		Falloff=0;
		EModeHash=0;
		InvertToolAction=false;
		Interpolation=false;
		InterpValue=8;
		PrimIndex=-1;
		FlatternCurveChanged=false;
		RadiusCurveChanged=false;
		DepthCurveChanged=false;
		OpacityCurveChanged=false;
		TaperingCurveChanged=false;
		SpecCurveChanged=false;
		SmoothCurveChanged=false;
		HasExtraEOptions=false;
		StorePressureFlow=false;
		LastChosen=false;
		VoxelToolID=0;
		MaskIndex=-1;
		msSizeX=msSizeY=mtSizeX=mtSizeY=0;
		CustomIconID=-1;
		SkipVoxSurfTransition=false;
		JustPrimHistory=false;
		ModTapering=true;
		PanoRotation = 0;
		LockPanorama = false;
		PanoramaBlur = 0;
		GreyscalePanorama = false;
		Changed = false;
	}
	int OrderIndex;
	cStr Name;
	cStr FileName;
	const cStr& GetFileName();
	ClonesArray<OneRandomPen> RPens;
	PresetsSettings Sets;
	int ShapePreview;
	int StripPreview;	
	int MtlPreview;
	cStr MtlPreviewTexture;	
	cStr PensFolder;
	cStr MasksFolder;
	cStr StripsFolder;
	cStr MtlsFolder;
	cStr ShapeName;
	cStr StripName;
	cStr BrushSettings;
	cStr Hint;
	cStr CustomIcon;
	cStr SymmetryData;
	cStr CameraData;
	cStr Panorama;
	float PanoRotation;
	bool LockPanorama;
	bool GreyscalePanorama;
	bool Changed;
	float PanoramaBlur;

	int CustomIconID;
	float Radius;
	float Depth;
	float Focal;
	float Falloff;
	float Smooth;
	DWORD Color;
	DWORD Color2;	
	DWORD EModeHash;
	float Opacity;
	float SpecOpacity;
	float Specular;
	int   MtlIndex;
	int   MaskIndex;
	int	  MappingType;
	bool  IgnoreColor;
	bool  InvertToolAction;
	bool  SkipVoxSurfTransition;
	PenModeEnum   PenPressureType;
	SelModesEnum  SelectionMode;
	int   PrimIndex;
	cStr  PrimParam;
	bool  HasExtraEOptions;
	bool  IgnoreBackFaces;
	float EBorderWidth;
	bool  EAllowDepthLimit;
	float EDepthLimit;
	ClassArray<SplinePoint2> SelPoints;
	bool splTrnMode;
	bool splEditMode;
	bool splAddMode;
	bool LastChosen;


	cStr  CustomPrimModel;
	//cStr  SelectedModel;

	bool AllowRadiusVariation;
	bool AllowDepthVariation;
	bool AllowOpacityVariation;
	bool AllowSpecVariation;
	bool AllowSmoothVariation;

	bool UseTapering;
	bool ModTapering;
	bool TaperingCurveChanged;
	cStr TaperingCurve;
	float TaperingLength;
	bool FlatternCurveChanged;
	cStr FlatternCurve;
	bool RadiusCurveChanged;
	cStr RadiusCurve;
	bool DepthCurveChanged;
	cStr DepthCurve;
	bool OpacityCurveChanged;
	cStr OpacityCurve;
	bool SpecCurveChanged;
	cStr SpecCurve;
	bool SmoothCurveChanged;
	cStr SmoothCurve;
	bool StorePressureFlow;
	cStr PressureFlow;
	bool coBSplines;
	bool coClosedSpline;
	bool coSameRadius;
	bool coHideHelpers;

	bool Interpolation;
	float InterpValue;

	float mtSizeX;
	float mtSizeY;
	float mtdScale;
	float mtdAngle;
	Vector3D mtdShift;

	Matrix4D ScreenToUVSpace;	

	float msSizeX;
	float msSizeY;
	float msdScale;
	float msdAngle;
	Vector3D msdShift;

	Matrix4D ScreenToUVSpaceMask;	
	cStr ToolName;
	int  VoxelToolID;
	cStr SubTool;
	bool VoxSurfMode;
	cStr ToolParam;
	cStr ToolParam2;
		
	bool  EnableFillPattern;
	cStr Filler;

	bool JustPrimHistory;
	cStr GetShortPath();
	cStr GetFilePath();

	SERIALIZE() {
		REG_AUTO(Name);
		if (!JustPrimHistory) {
			REG_AUTO(JustPrimHistory);
			REG_CLASS(OneRandomPen);
			REG_AUTO(RPens);
			REG_AUTO(Sets);
			REG_AUTO(MtlPreviewTexture);
			REG_AUTO(PensFolder);
			REG_AUTO(StripsFolder);
			REG_AUTO(MtlsFolder);
			REG_AUTO(MasksFolder);
			REG_AUTO(ShapeName);
			REG_AUTO(StripName);
			REG_AUTO(BrushSettings);
			REG_AUTO(Hint);
			REG_AUTO(EModeHash);
			REG_AUTO(PenPressureType);

			REG_AUTO(FlatternCurveChanged);
			REG_AUTO(FlatternCurve);
			REG_AUTO(RadiusCurveChanged);
			REG_AUTO(RadiusCurve);
			REG_AUTO(DepthCurveChanged);
			REG_AUTO(DepthCurve);
			REG_AUTO(OpacityCurveChanged);
			REG_AUTO(OpacityCurve);
			REG_AUTO(TaperingCurveChanged);
			REG_AUTO(UseTapering);
			REG_AUTO(ModTapering);
			REG_AUTO(TaperingLength);
			REG_AUTO(TaperingCurve);
			REG_AUTO(SpecCurveChanged);
			REG_AUTO(SpecCurve);
			REG_AUTO(SmoothCurveChanged);
			REG_AUTO(SmoothCurve);

			REG_AUTO(SkipVoxSurfTransition);
			REG_AUTO(HasExtraEOptions);
			REG_AUTO(IgnoreBackFaces);
			REG_AUTO(EBorderWidth);
			REG_AUTO(EAllowDepthLimit);
			REG_AUTO(EDepthLimit);
			REG_AUTO(splTrnMode);
			REG_AUTO(splEditMode);
			REG_AUTO(splAddMode);

			REG_AUTO(SelectionMode);
			REG_AUTO(AllowRadiusVariation);
			REG_AUTO(AllowDepthVariation);
			REG_AUTO(AllowOpacityVariation);
			REG_AUTO(AllowSpecVariation);
			REG_AUTO(AllowSmoothVariation);
			REG_AUTO(Interpolation);
			REG_AUTO(InterpValue);

			REG_AUTO(StorePressureFlow);
			REG_AUTO(PressureFlow);
			REG_AUTO(coBSplines);
			REG_AUTO(coClosedSpline);
			REG_AUTO(coSameRadius);
			REG_AUTO(coHideHelpers);

			REG_AUTO(mtSizeX);
			REG_AUTO(mtSizeY);
			REG_AUTO(mtdScale);
			REG_AUTO(mtdAngle);
			REG_AUTO(mtdShift.x);
			REG_AUTO(mtdShift.y);
			REG_AUTO(mtdShift.z);

			REG_AUTO(msSizeX);
			REG_AUTO(msSizeY);
			REG_AUTO(msdScale);
			REG_AUTO(msdAngle);
			REG_AUTO(msdShift.x);
			REG_AUTO(msdShift.y);
			REG_AUTO(msdShift.z);
			REG_AUTO(Radius);
			REG_AUTO(Depth);
			REG_AUTO(Focal);
			REG_AUTO(Falloff);
			REG_AUTO(Smooth);
			REG_AUTO(Color);
			REG_AUTO(Color2);

			REG_AUTO(Opacity);
			REG_AUTO(SpecOpacity);
			REG_AUTO(Specular);
			REG_AUTO(MtlIndex);
			REG_AUTO(MappingType);
			REG_AUTO(MaskIndex);
			REG_AUTO(IgnoreColor);
			//REG_AUTO(SelectedModel);
			float* P = ScreenToUVSpace.ToFloatPtr();
			for (int i = 0; i < 4; i++) {
				for (int j = 0; j < 4; j++) {
					char c[4] = "M00";
					c[1] = '0' + i;
					c[2] = '0' + j;
					REG_MEMBER_EX2(_float, *P, c);
					P++;
				}
			}

			P = ScreenToUVSpaceMask.ToFloatPtr();
			for (int i = 0; i < 4; i++) {
				for (int j = 0; j < 4; j++) {
					char c[4] = "A00";
					c[1] = '0' + i;
					c[2] = '0' + j;
					REG_MEMBER_EX2(_float, *P, c);
					P++;
				}
			}

			REG_AUTO(EnableFillPattern);
			REG_AUTO(Filler);
			REG_AUTO(OrderIndex);
		}

		REG_AUTO(CustomIcon);
		REG_AUTO(VoxelToolID);
		REG_AUTO(VoxSurfMode);
		REG_AUTO(InvertToolAction);
		REG_AUTO(SymmetryData);
		REG_AUTO(SelPoints);
		REG_AUTO(PrimIndex);
		REG_AUTO(PrimParam);
		REG_AUTO(CustomPrimModel);
		REG_AUTO(ToolName);
		REG_AUTO(SubTool);
		REG_AUTO(ToolParam);
		REG_AUTO(ToolParam2);
		REG_AUTO(Panorama);
		REG_AUTO(PanoRotation);
		REG_AUTO(LockPanorama);
		REG_AUTO(PanoramaBlur);
		REG_AUTO(GreyscalePanorama);
		REG_AUTO(CameraData);
	} 
	int GetCategory();
	cStr GetCategoryStr();
	static int GetCurrentCategory();
	static cStr GetCurrentCategoryStr();

};