#pragma once

#include "unihash.h"
#include <gtest/gtest.h>
#include "../3D-Coat/Exception.h"


namespace test {
	namespace unihash {


class uni_hashTest :
	public ::testing::Test
{
protected:
	uni_hashTest() {}
	virtual ~uni_hashTest() {}
	virtual void SetUp() {}
	virtual void TearDown() {}
};




class dim_TypeTest :
	public ::testing::Test
{
protected:
	dim_TypeTest() {}
	virtual ~dim_TypeTest() {}
	virtual void SetUp() {}
	virtual void TearDown() {}
};




TEST_F( uni_hashTest, AddUnique ) {

	using namespace comms;

	uni_hash< int, int >  h;
	ASSERT_EQ( 0, h.size() );

	// size for undefined key
	ASSERT_EQ( 0, h.size( 12345678 ) );

	h.add_uniq( 100, -4 );
	ASSERT_EQ( 1, h.size() );
	ASSERT_EQ( 1, h.size( 100 ) );

	h.add_uniq( 100, -2 );
	ASSERT_EQ( 2, h.size() );
	ASSERT_EQ( 2, h.size( 100 ) );

	h.add_uniq( 100, -3 );
	ASSERT_EQ( 3, h.size() );
	ASSERT_EQ( 3, h.size( 100 ) );

	// added other key
	h.add_uniq( 200, -11 );
	ASSERT_EQ( 4, h.size() );
	ASSERT_EQ( 1, h.size( 200 ) );
	ASSERT_EQ( 3, h.size( 100 ) );

	// returned to old key
	h.add_uniq( 100, -1 );
	ASSERT_EQ( 5, h.size() );
	ASSERT_EQ( 4, h.size( 100 ) );

	// added dublicate element
	h.add_uniq( 100, -2 );
	ASSERT_EQ( 5, h.size() );
	ASSERT_EQ( 4, h.size( 100 ) );

	//std::cout << h;
}




TEST_F( dim_TypeTest, Construct ) {

	using namespace comms;

	{
		const dim_Type< 2, int >  d;
		ASSERT_EQ( 0,  d[ 0 ] );
		ASSERT_EQ( 0,  d[ 1 ] );
	}

	{
		const char  source[ 3 ] = { 10, -22, 33 };
		const dim_Type< 3, char >  d( source );
		ASSERT_EQ(  10,  d[ 0 ] );
		ASSERT_EQ( -22,  d[ 1 ] );
		ASSERT_EQ(  33,  d[ 2 ] );
	}
}




TEST_F( dim_TypeTest, Hash ) {

	using namespace comms;

	// bi_DWORD, hashes are equals
	{
		const DWORD  s[ 2 ] = { 30, 10 };
		const bi_DWORD  a( s[ 0 ], s[ 1 ] );
		const dim_Type< 2, DWORD >  b( s );
		ASSERT_EQ( a.V1,  b[ 0 ] );
		ASSERT_EQ( a.V2,  b[ 1 ] );
		ASSERT_EQ( static_cast< DWORD >( a ),  static_cast< DWORD >( b ) );
	}

	// tri_DWORD, hashes are equals
	{
		const DWORD  s[ 3 ] = { 30, 10, 500 };
		const tri_DWORD  a( s[ 0 ], s[ 1 ], s[ 2 ] );
		const dim_Type< 3, DWORD >  b( s );
		ASSERT_EQ( a.V1,  b[ 0 ] );
		ASSERT_EQ( a.V2,  b[ 1 ] );
		ASSERT_EQ( a.V3,  b[ 2 ] );
		ASSERT_EQ( static_cast< DWORD >( a ),  static_cast< DWORD >( b ) );
	}

	// quad_DWORD, hashes are equals
	{
		const DWORD  s[ 4 ] = { 301, 101, 5001, 11 };
		const quad_DWORD  a( s[ 0 ], s[ 1 ], s[ 2 ], s[ 3 ] );
		const dim_Type< 4, DWORD >  b( s );
		ASSERT_EQ( a.V1,  b[ 0 ] );
		ASSERT_EQ( a.V2,  b[ 1 ] );
		ASSERT_EQ( a.V3,  b[ 2 ] );
		ASSERT_EQ( a.V4,  b[ 3 ] );
		ASSERT_EQ( static_cast< DWORD >( a ),  static_cast< DWORD >( b ) );
	}
}


} }  //namespaces
