#pragma once

class BinStream;
//#define SAFE_ARRAY
template <class Elem,int DefElmCount=16>
class StackArray{
	Elem* Values;
	Elem* AllocElem;
	Elem StackValues[DefElmCount];
	int NValues;
	int MaxValues;
public:	

	typedef Elem* iterator;
	iterator begin() {
		return Values;
	}
	iterator end() {
		return Values + NValues;
	}

	StackArray(const StackArray& src);
	void operator = (const StackArray& src);
	void Check(int N);
	Elem* operator + (int idx);
	StackArray();
	StackArray(int Size, Elem Filling);
	~StackArray();
	int Add(const Elem& V);
	int Add(const Elem& V,int NTimes);
	void RemoveAt(int pos,int N);
	int find(const Elem& v);
	bool Insert(int pos,const Elem& V);
	bool Move(int from, int to);
	Elem& operator [](int pos);
	Elem operator [](int pos) const;
	void operator += (const StackArray& A);
	void operator += (Elem V);
	Elem* ToPtr()const;
	void AddRange(Elem* Data,int N);
	int Count()const;
	void Clear();
	void FastClear();
	void Fill(int Value);
	Elem& GetFirst();
	Elem& GetLast();
	Elem pop_back();
	void CopyTo(StackArray<Elem>& dest);
	void MoveArrayTo(StackArray<Elem>& dest);
	void pop_front();
	bool AddOnce(Elem V);
	void ToBS(BinStream& BS);
	void FromBS(BinStream& BS,int ne);
	void reverse(int start, int finish);
};

template <class Elem, int DefElmCount>
StackArray<Elem, DefElmCount>::StackArray(const StackArray& src) {
	Values = &StackValues[0];
	NValues = 0;
	MaxValues = DefElmCount;
	AllocElem = NULL;
	operator = (src);
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::operator=(const StackArray& src) {
	FastClear();
	Check(src.Count());
	for(int i=0;i<src.Count();i++) {
		Add(src[i]);
	}
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::Check(int N) {
	if(N>=MaxValues){
		MaxValues=N+DefElmCount+MaxValues/2;
		Elem* tmp=(Elem*)_ExMalloc(MaxValues*sizeof(Elem));
		if(NValues){
			memcpy(tmp,Values,NValues*sizeof(Elem));
		}
		if(AllocElem)_ExFree(AllocElem);
		Values=AllocElem=tmp;
	}
}

template <class Elem, int DefElmCount>
Elem* StackArray<Elem, DefElmCount>::operator+(int idx) {
	assert(idx>=0&&idx<NValues);
	assert(NValues);
	return Values+idx;
}

template <class Elem, int DefElmCount>
StackArray<Elem, DefElmCount>::StackArray() {
	Values=&StackValues[0];
	NValues=0;
	MaxValues=DefElmCount;
	AllocElem=NULL;
}

template <class Elem, int DefElmCount>
StackArray<Elem, DefElmCount>::StackArray(int Size, Elem Filling) {
	Values=&StackValues[0];
	NValues=0;
	MaxValues=DefElmCount;
	Add(Filling,Size);
}

template <class Elem, int DefElmCount>
StackArray<Elem, DefElmCount>::~StackArray() {
	Clear();		
}

template <class Elem, int DefElmCount>
int StackArray<Elem, DefElmCount>::Add(const Elem& V) {
	Check(NValues+1);
	Values[NValues]=V;
	NValues++;
	return NValues-1;
}

template <class Elem, int DefElmCount>
int StackArray<Elem, DefElmCount>::Add(const Elem& V, int NTimes) {
	Check(NValues+NTimes);
	for(int i=0;i<NTimes;i++){
		memcpy(&Values[NValues],&V,sizeof(Elem));
		NValues++;
	}
	return NValues-1;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::RemoveAt(int pos, int N) {
	if(pos<0){
		N+=pos;
		pos=0;
	}
	if(N<=0||pos>=NValues)return;
	if(pos+N>NValues)N=NValues-pos;
	if(pos+N<NValues)memcpy(Values+pos,Values+pos+N,(NValues-pos-N)*sizeof(Elem));
	NValues-=N;
}

template <class Elem, int DefElmCount>
int StackArray<Elem, DefElmCount>::find(const Elem& v) {
	for(int i=0;i<NValues;i++)if(v==Values[i])return i;
	return -1;
}

template <class Elem, int DefElmCount>
bool StackArray<Elem, DefElmCount>::Insert(int pos, const Elem& V) {
	if(pos<0||pos>NValues)return false;
	Check(NValues+1);
	if(pos<NValues)memmove(Values+pos+1,Values+pos,(NValues-pos)*sizeof(Elem));
	Values[pos]=V;
	NValues++;
	return true;
}

template <class Elem, int DefElmCount>
bool StackArray<Elem, DefElmCount>::Move(int from, int to) {		
	if(from>=NValues) from=NValues-1; else if(from<0) from=0;
	if(to>=NValues) to=NValues-1; else if(to<0) to=0;
	if(from==to) return false;		
	Elem t=Values[from];
	if(from<to){
		memcpy(Values+from,Values+from+1,(to-from)*sizeof(Elem));
	}else{
		memmove(Values+to+1,Values+to,(from-to)*sizeof(Elem));
	}		
	Values[to]=t;
	return true;
}

template <class Elem, int DefElmCount>
Elem& StackArray<Elem, DefElmCount>::operator[](int pos) {
	assert(pos>=0&&pos<NValues);
#ifdef SAFE_ARRAY
		if(pos<0||pos>=NValues)return Values[0];//DlaBitja
#endif //SAFE_ARRAY
	return Values[pos];
}

template <class Elem, int DefElmCount>
Elem StackArray<Elem, DefElmCount>::operator[](int pos) const {
	assert(pos>=0&&pos<NValues);
#ifdef SAFE_ARRAY
		if(pos<0||pos>=NValues)return Values[pos];//DlaBitja;
#endif //SAFE_ARRAY
	return Values[pos];
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::operator+=(const StackArray& A) {
	AddRange(A.Values,A.NValues);
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::operator+=(Elem V) {
	Add(V);
}

template <class Elem, int DefElmCount>
Elem* StackArray<Elem, DefElmCount>::ToPtr() const {//use only to save data!!!
	return Values;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::AddRange(Elem* Data, int N) {
	Check(NValues+N);
	memcpy(Values+NValues,Data,N*sizeof(Elem));
	NValues+=N;
}

template <class Elem, int DefElmCount>
int StackArray<Elem, DefElmCount>::Count() const {
	return NValues;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::Clear() {
	if(AllocElem)_ExFree(AllocElem);
	Values=&StackValues[0];
	NValues=0;
	MaxValues=DefElmCount;
	AllocElem=NULL;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::FastClear() {		
	NValues=0;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::Fill(int Value) {		
	memset(Values,Value,NValues*sizeof(Elem));
}

template <class Elem, int DefElmCount>
Elem& StackArray<Elem, DefElmCount>::GetFirst() {
	assert(NValues!=0);
#ifdef SAFE_ARRAY
		if(NValues==0)return Values[0];//DlaBitja;
#endif
	return Values[0];
}

template <class Elem, int DefElmCount>
Elem& StackArray<Elem, DefElmCount>::GetLast() {
	assert(NValues!=0);
	if(NValues==0){
#ifdef SAFE_ARRAY
			return Values[0];//DlaBitja;
#endif
	}
	return Values[NValues-1];
}

template <class Elem, int DefElmCount>
Elem StackArray<Elem, DefElmCount>::pop_back() {
	if(NValues>0){
		return Values[--NValues];
	}else return Values[0];
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::CopyTo(StackArray<Elem>& dest) {
	dest.Check(NValues);
	memcpy(dest.Values,Values,NValues*sizeof(Elem));
	dest.NValues=NValues;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::MoveArrayTo(StackArray<Elem>& dest) {
	dest.Clear();
	dest.Values=Values;
	dest.NValues=NValues;
	Values=NULL;
	NValues=0;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::pop_front() {
	RemoveAt(0,1);
}

template <class Elem, int DefElmCount>
bool StackArray<Elem, DefElmCount>::AddOnce(Elem V) {
	if(find(V)==-1){
		Add(V);
		return true;
	}
	return false;
}

template <class Elem, int DefElmCount>
void StackArray<Elem, DefElmCount>::reverse(int start, int finish) {
	if (start >= 0 && start < NValues && finish >= 0 && finish <= NValues) {
		if (start > finish)std::swap(start, finish);
		for (int i = start, j = finish; i < j; i++, j--) {
			std::swap(Values[i], Values[j]);
		}
	}
}

