// This example generates the surface figure that consists of spiral
#include <CoreAPI.h>
//@config: Debug
class SpiralPrim:public BaseClass {
public:
	SpiralPrim() {
		Radius = 50;
		ProfileRadius = 10;
		Step = 40;
		Turns = 8;
		height = 10;
		width = 10;
		ProfileType = coat::spiral::ProfileType::CIRCLE; 
	}
	float Radius;
	float ProfileRadius;
	float Step;
	float height;
	float width;
	int Turns;
	coat::spiral::ProfileType ProfileType;
	
	// this is class registration, look dialogs example
	SERIALIZE() {
		Enumerator* E = ENUM.Get("PROFILETYPE");
		if (E->GetAmount() == 0) {
			E->Add("circle");
			E->Add("rectangle");
		}
		REG_DROPLIST(ProfileType,"ProfileType","PROFILETYPE");
		FSLIDER(Radius, "%Radius", 10, 100, 20, false);
		FSLIDER(Step, "%Step", 5, 40, 8, false);
		SLIDER(Turns, "%Turns", 1, 10);
		DELIMITER;
		if (ProfileType == coat::spiral::ProfileType::RECTANGLE) {
			FSLIDER(width, "%Profile Width", 5, 30, 10, false);
			FSLIDER(height, "%Profile Height", 5, 30, 10, false);
		} else {
			FSLIDER(ProfileRadius, "%ProfileRadius", 2, 40, 20, false);
		} 
	}
	void build() {
		auto voxId = coat::Scene::sculptRoot().childCount();
		auto current = coat::Scene::sculptRoot().addChild("Spiral"+coat::str::ToString(voxId));
		auto volume = current.Volume();
		volume.toSurface();
		coat::spiral spiral;
		spiral.radius(Radius)
			.step(Step)
			.turns(Turns)
			.profile_type(ProfileType)
			.profile_radius(ProfileRadius)
			.profile_rect(width,height)
			.details(0.5)
			.add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	SpiralPrim spiralPrim;
	coat::dialog dlg;
	// load settings if exist
	spiralPrim.ReadFromFile("data/Temp/spiral.json");
	if(dlg.ok().cancel().params(&spiralPrim).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		spiralPrim.WriteToFile("data/Temp/spiral.json");
		// build the figure
		spiralPrim.build();
	};
	return 0;
}