// This example generates the surface figure that consists of ellipses
#include <CoreAPI.h>
//@config: Debug
class EllipsesPrim:public BaseClass {
public:
	EllipsesPrim() {
		Side = coat::vec3(100,40,100);
		SubDivisions = 2;
		Rings = 12;
		Slices = 24;
		DivMode = coat::sphere::DivisionMode::DIV_TRIANGLE;
	}
	int SubDivisions;
	int Rings;
	int Slices; 	
	coat::sphere::DivisionMode DivMode;
	coat::vec3 Side;
	// this is class registration, look dialogs example
	SERIALIZE() {
		Enumerator* E = ENUM.Get("DIVMODE");
		if (E->GetAmount() == 0) {
			E->Add("triangle");
			E->Add("meridian");
			E->Add("cube");
		}
		REG_DROPLIST(DivMode,"DivMode","DIVMODE");
		
		UI_LAYOUT("1 1 1 []");
		
		TEXTMSG2("*Size");
		
		REG_AUTO(Side.x, "$sa");
		REG_AUTO(Side.y, "$sb");
		REG_AUTO(Side.z, "$sc");
		
		if (DivMode == coat::sphere::DivisionMode::DIV_MERIDIAN){
			SLIDER(Slices, "Slices", 8, 60);
			SLIDER(Rings, "Rings", 6, 60);
		
		} 
		else if (DivMode == coat::sphere::DivisionMode::DIV_CUBE) {
			SLIDER(SubDivisions, "SubDivisions", 2, 20);	
		} 
		else {
			SLIDER(SubDivisions,"SubDivisions", 1, 10);	
		}
	}
	void build() {
		auto voxId = coat::Scene::sculptRoot().childCount();
		auto current = coat::Scene::sculptRoot().addChild("Ellipses"+coat::str::ToString(voxId));
		auto volume = current.Volume();
		volume.toSurface();
		coat::ellipse ellipse;
		//settings parameters to the ellipse primitive and add prim to the volume
		ellipse.size(Side).sub_div_mode(DivMode).sub_division(SubDivisions).rings(Rings).slices(Slices).add(volume);
		ellipse.size(Side/2).translate(coat::vec3(0,3*Side.y,0)).add(volume);
		ellipse.size(Side/4).translate(coat::vec3(0,4.5*Side.y,0)).add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	EllipsesPrim ellipses;
	coat::dialog dlg;
	// load generator settings if exist
	ellipses.ReadFromFile("data/Temp/EllipsesPrim.json");
	if(dlg.ok().cancel().params(&ellipses).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		ellipses.WriteToFile("data/Temp/EllipsesPrim.json");
		// build the figure
		ellipses.build();
	};
	return 0;
}