// Generate the surface figure "glass"
#include <CoreAPI.h>
//@config: Debug
using namespace coat;
EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// add new volume
	auto current = coat::Scene::sculptRoot().addChild("glass");
	auto volume = current.Volume();
	// turn to surface
	volume.toSurface();
	// add the solid glass using bezie points
	lathe().add_point(vec2(0.991,0.512),0)
		   .add_point(vec2(0.813,0.506),0)
		   .add_point(vec2(0.657,0.420),0)
		   .add_point(vec2(0.524,0.131),0)
		   .add_point(vec2(0.191,0.110),0)
		   .add_point(vec2(0.098,0.310),0)
		   .add_point(vec2(0.008,0.313),0)
		   .size(vec3(270,270,270))
		   .add(volume);
	// subtract sphere from solid glass 			 
	sphere().diameter(260).y(150.0).subtract(volume);			 
	return 0;
}