// This example generates the detail for the further 3D printing using the voxels. The CSG principles demonstrated.
#include <CoreAPI.h>
//@config: Debug
using namespace coat;

EXPORT
int main() {
	// create new volume and set 20x density - 20 voxels per 1 unit (mm)
	auto current = Scene::sculptRoot().addChild("Detail").density(20);
	// get the volume object to refer later
	auto volume = current.Volume();
	// turn to voxels
	volume.toVoxels();
	// add the sphere, diameter 16, dense (40 divisions)
	sphere().diameter(16).add(volume);
	// the cylinder that will be use to clip the top and bottom of the figure
	cylinder clip;
	clip.height(10).diameter(20);
	//move down 9mm and subtract
	clip.y(-9).subtract(volume);
	//move up 9mm (back) and additionally 7 mm up and subtract
	clip.y(9 + 7).subtract(volume);
	// add the base of the figure. pay attention, we create temporary object using the cylinder() and operate,
	// this is a bit different from the clip object that we used twice
	cylinder().height(1.25).diameterBottom(19.0).diameterTop(18.5).add(volume);
	// make hole at the top
	cylinder().height(8).diameter(6).y(4).subtract(volume);
	// make hole through all the object
	cylinder().height(8).diameter(3).y(-2).subtract(volume);
	// we relax once to improve sharp borders quality
	volume.relaxVoxels(1);
	return 0;
}