// This example generates the surface figure that consists of capsule
#include <CoreAPI.h>
//@config: Debug
class CapsulePrim:public BaseClass {
public:
	CapsulePrim() {
		Radius = 30;
		Height = 200;
	}
	float Radius;
	float Height;
	
	// this is class registration, look dialogs example
	SERIALIZE() {
		FSLIDER(Radius, "%Radius", 10, 100, 30, false);
		FSLIDER(Height, "%Height", 20, 200.0, 100, false);
	}
	void build() {
		auto voxId = coat::Scene::sculptRoot().childCount();
		auto current = coat::Scene::sculptRoot().addChild("Capsule"+coat::str::ToString(voxId));
		auto volume = current.Volume();
		volume.toSurface();
		coat::capsule capsule;
		capsule.height(Height)
			.radiusTop(Radius)
			.radiusBottom(Radius)
			.details(0.5)
			.add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	CapsulePrim capsulePrim;
	coat::dialog dlg;
	// load settings if exist
	capsulePrim.ReadFromFile("data/Temp/capsule.json");
	if(dlg.ok().cancel().params(&capsulePrim).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		capsulePrim.WriteToFile("data/Temp/capsule.json");
		// build the figure
		capsulePrim.build();
	};
	return 0;
}